/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.generic.service.thrift;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.callback.CallbackHandler;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.SaslRpcServer;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.sentry.SentryUserException;
import org.apache.sentry.core.common.ActiveRoleSet;
import org.apache.sentry.core.common.Authorizable;
import org.apache.sentry.provider.db.generic.service.thrift.SentryGenericPolicyService;
import org.apache.sentry.provider.db.generic.service.thrift.SentryGenericServiceClient;
import org.apache.sentry.provider.db.generic.service.thrift.TAlterSentryRoleAddGroupsRequest;
import org.apache.sentry.provider.db.generic.service.thrift.TAlterSentryRoleAddGroupsResponse;
import org.apache.sentry.provider.db.generic.service.thrift.TAlterSentryRoleDeleteGroupsRequest;
import org.apache.sentry.provider.db.generic.service.thrift.TAlterSentryRoleDeleteGroupsResponse;
import org.apache.sentry.provider.db.generic.service.thrift.TAlterSentryRoleGrantPrivilegeRequest;
import org.apache.sentry.provider.db.generic.service.thrift.TAlterSentryRoleGrantPrivilegeResponse;
import org.apache.sentry.provider.db.generic.service.thrift.TAlterSentryRoleRevokePrivilegeRequest;
import org.apache.sentry.provider.db.generic.service.thrift.TAlterSentryRoleRevokePrivilegeResponse;
import org.apache.sentry.provider.db.generic.service.thrift.TAuthorizable;
import org.apache.sentry.provider.db.generic.service.thrift.TCreateSentryRoleRequest;
import org.apache.sentry.provider.db.generic.service.thrift.TCreateSentryRoleResponse;
import org.apache.sentry.provider.db.generic.service.thrift.TDropPrivilegesRequest;
import org.apache.sentry.provider.db.generic.service.thrift.TDropPrivilegesResponse;
import org.apache.sentry.provider.db.generic.service.thrift.TDropSentryRoleRequest;
import org.apache.sentry.provider.db.generic.service.thrift.TDropSentryRoleResponse;
import org.apache.sentry.provider.db.generic.service.thrift.TListSentryPrivilegesForProviderRequest;
import org.apache.sentry.provider.db.generic.service.thrift.TListSentryPrivilegesForProviderResponse;
import org.apache.sentry.provider.db.generic.service.thrift.TListSentryPrivilegesRequest;
import org.apache.sentry.provider.db.generic.service.thrift.TListSentryPrivilegesResponse;
import org.apache.sentry.provider.db.generic.service.thrift.TListSentryRolesRequest;
import org.apache.sentry.provider.db.generic.service.thrift.TListSentryRolesResponse;
import org.apache.sentry.provider.db.generic.service.thrift.TRenamePrivilegesRequest;
import org.apache.sentry.provider.db.generic.service.thrift.TRenamePrivilegesResponse;
import org.apache.sentry.provider.db.generic.service.thrift.TSentryActiveRoleSet;
import org.apache.sentry.provider.db.generic.service.thrift.TSentryPrivilege;
import org.apache.sentry.provider.db.generic.service.thrift.TSentryRole;
import org.apache.sentry.service.thrift.ServiceConstants;
import org.apache.sentry.service.thrift.Status;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TMultiplexedProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TSaslClientTransport;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SentryGenericServiceClientDefaultImpl
implements SentryGenericServiceClient {
    private final Configuration conf;
    private final InetSocketAddress serverAddress;
    private final boolean kerberos;
    private final String[] serverPrincipalParts;
    private SentryGenericPolicyService.Client client;
    private TTransport transport;
    private int connectionTimeout;
    private static final Logger LOGGER = LoggerFactory.getLogger(SentryGenericServiceClientDefaultImpl.class);
    private static final String THRIFT_EXCEPTION_MESSAGE = "Thrift exception occured ";

    public SentryGenericServiceClientDefaultImpl(Configuration conf) throws IOException {
        this.conf = conf;
        Preconditions.checkNotNull((Object)this.conf, (Object)"Configuration object cannot be null");
        this.serverAddress = NetUtils.createSocketAddr((String)((String)Preconditions.checkNotNull((Object)conf.get("sentry.service.client.server.rpc-address"), (Object)"Config key sentry.service.client.server.rpc-address is required")), (int)conf.getInt("sentry.service.client.server.rpc-port", 8038));
        this.connectionTimeout = conf.getInt("sentry.service.client.server.rpc-connection-timeout", 200000);
        this.kerberos = "kerberos".equalsIgnoreCase(conf.get("sentry.service.security.mode", "kerberos").trim());
        this.transport = new TSocket(this.serverAddress.getHostName(), this.serverAddress.getPort(), this.connectionTimeout);
        if (this.kerberos) {
            String serverPrincipal = (String)Preconditions.checkNotNull((Object)conf.get("sentry.service.server.principal"), (Object)"sentry.service.server.principal is required");
            serverPrincipal = SecurityUtil.getServerPrincipal((String)serverPrincipal, (InetAddress)this.serverAddress.getAddress());
            LOGGER.debug("Using server kerberos principal: " + serverPrincipal);
            this.serverPrincipalParts = SaslRpcServer.splitKerberosName((String)serverPrincipal);
            Preconditions.checkArgument((this.serverPrincipalParts.length == 3 ? 1 : 0) != 0, (Object)("Kerberos principal should have 3 parts: " + serverPrincipal));
            boolean wrapUgi = "true".equalsIgnoreCase(conf.get("sentry.service.security.use.ugi", "true"));
            this.transport = new UgiSaslClientTransport(SaslRpcServer.AuthMethod.KERBEROS.getMechanismName(), null, this.serverPrincipalParts[0], this.serverPrincipalParts[1], (Map<String, String>)ServiceConstants.ClientConfig.SASL_PROPERTIES, null, this.transport, wrapUgi);
        } else {
            this.serverPrincipalParts = null;
        }
        try {
            this.transport.open();
        }
        catch (TTransportException e) {
            throw new IOException("Transport exception while opening transport: " + e.getMessage(), e);
        }
        LOGGER.debug("Successfully opened transport: " + this.transport + " to " + this.serverAddress);
        TMultiplexedProtocol protocol = new TMultiplexedProtocol((TProtocol)new TBinaryProtocol(this.transport), "SentryGenericPolicyService");
        this.client = new SentryGenericPolicyService.Client((TProtocol)protocol);
        LOGGER.debug("Successfully created client");
    }

    @Override
    public synchronized void createRole(String requestorUserName, String roleName, String component) throws SentryUserException {
        TCreateSentryRoleRequest request = new TCreateSentryRoleRequest();
        request.setProtocol_version(2);
        request.setRequestorUserName(requestorUserName);
        request.setRoleName(roleName);
        request.setComponent(component);
        try {
            TCreateSentryRoleResponse response = this.client.create_sentry_role(request);
            Status.throwIfNotOk(response.getStatus());
        }
        catch (TException e) {
            throw new SentryUserException(THRIFT_EXCEPTION_MESSAGE, (Throwable)e);
        }
    }

    @Override
    public void createRoleIfNotExist(String requestorUserName, String roleName, String component) throws SentryUserException {
        TCreateSentryRoleRequest request = new TCreateSentryRoleRequest();
        request.setProtocol_version(2);
        request.setRequestorUserName(requestorUserName);
        request.setRoleName(roleName);
        request.setComponent(component);
        try {
            TCreateSentryRoleResponse response = this.client.create_sentry_role(request);
            Status status = Status.fromCode(response.getStatus().getValue());
            if (status == Status.ALREADY_EXISTS) {
                return;
            }
            Status.throwIfNotOk(response.getStatus());
        }
        catch (TException e) {
            throw new SentryUserException(THRIFT_EXCEPTION_MESSAGE, (Throwable)e);
        }
    }

    @Override
    public void dropRole(String requestorUserName, String roleName, String component) throws SentryUserException {
        this.dropRole(requestorUserName, roleName, component, false);
    }

    @Override
    public void dropRoleIfExists(String requestorUserName, String roleName, String component) throws SentryUserException {
        this.dropRole(requestorUserName, roleName, component, true);
    }

    private void dropRole(String requestorUserName, String roleName, String component, boolean ifExists) throws SentryUserException {
        TDropSentryRoleRequest request = new TDropSentryRoleRequest();
        request.setProtocol_version(2);
        request.setRequestorUserName(requestorUserName);
        request.setRoleName(roleName);
        request.setComponent(component);
        try {
            TDropSentryRoleResponse response = this.client.drop_sentry_role(request);
            Status status = Status.fromCode(response.getStatus().getValue());
            if (ifExists && status == Status.NO_SUCH_OBJECT) {
                return;
            }
            Status.throwIfNotOk(response.getStatus());
        }
        catch (TException e) {
            throw new SentryUserException(THRIFT_EXCEPTION_MESSAGE, (Throwable)e);
        }
    }

    @Override
    public void addRoleToGroups(String requestorUserName, String roleName, String component, Set<String> groups) throws SentryUserException {
        TAlterSentryRoleAddGroupsRequest request = new TAlterSentryRoleAddGroupsRequest();
        request.setProtocol_version(2);
        request.setRequestorUserName(requestorUserName);
        request.setRoleName(roleName);
        request.setGroups(groups);
        request.setComponent(component);
        try {
            TAlterSentryRoleAddGroupsResponse response = this.client.alter_sentry_role_add_groups(request);
            Status.throwIfNotOk(response.getStatus());
        }
        catch (TException e) {
            throw new SentryUserException(THRIFT_EXCEPTION_MESSAGE, (Throwable)e);
        }
    }

    @Override
    public void deleteRoleToGroups(String requestorUserName, String roleName, String component, Set<String> groups) throws SentryUserException {
        TAlterSentryRoleDeleteGroupsRequest request = new TAlterSentryRoleDeleteGroupsRequest();
        request.setProtocol_version(2);
        request.setRequestorUserName(requestorUserName);
        request.setRoleName(roleName);
        request.setGroups(groups);
        request.setComponent(component);
        try {
            TAlterSentryRoleDeleteGroupsResponse response = this.client.alter_sentry_role_delete_groups(request);
            Status.throwIfNotOk(response.getStatus());
        }
        catch (TException e) {
            throw new SentryUserException(THRIFT_EXCEPTION_MESSAGE, (Throwable)e);
        }
    }

    @Override
    public void grantPrivilege(String requestorUserName, String roleName, String component, TSentryPrivilege privilege) throws SentryUserException {
        TAlterSentryRoleGrantPrivilegeRequest request = new TAlterSentryRoleGrantPrivilegeRequest();
        request.setProtocol_version(2);
        request.setComponent(component);
        request.setRoleName(roleName);
        request.setRequestorUserName(requestorUserName);
        request.setPrivilege(privilege);
        try {
            TAlterSentryRoleGrantPrivilegeResponse response = this.client.alter_sentry_role_grant_privilege(request);
            Status.throwIfNotOk(response.getStatus());
        }
        catch (TException e) {
            throw new SentryUserException(THRIFT_EXCEPTION_MESSAGE, (Throwable)e);
        }
    }

    @Override
    public void revokePrivilege(String requestorUserName, String roleName, String component, TSentryPrivilege privilege) throws SentryUserException {
        TAlterSentryRoleRevokePrivilegeRequest request = new TAlterSentryRoleRevokePrivilegeRequest();
        request.setProtocol_version(2);
        request.setComponent(component);
        request.setRequestorUserName(requestorUserName);
        request.setRoleName(roleName);
        request.setPrivilege(privilege);
        try {
            TAlterSentryRoleRevokePrivilegeResponse response = this.client.alter_sentry_role_revoke_privilege(request);
            Status.throwIfNotOk(response.getStatus());
        }
        catch (TException e) {
            throw new SentryUserException(THRIFT_EXCEPTION_MESSAGE, (Throwable)e);
        }
    }

    @Override
    public void dropPrivilege(String requestorUserName, String component, TSentryPrivilege privilege) throws SentryUserException {
        TDropPrivilegesRequest request = new TDropPrivilegesRequest();
        request.setProtocol_version(2);
        request.setComponent(component);
        request.setRequestorUserName(requestorUserName);
        request.setPrivilege(privilege);
        try {
            TDropPrivilegesResponse response = this.client.drop_sentry_privilege(request);
            Status.throwIfNotOk(response.getStatus());
        }
        catch (TException e) {
            throw new SentryUserException(THRIFT_EXCEPTION_MESSAGE, (Throwable)e);
        }
    }

    @Override
    public void renamePrivilege(String requestorUserName, String component, String serviceName, List<? extends Authorizable> oldAuthorizables, List<? extends Authorizable> newAuthorizables) throws SentryUserException {
        if (oldAuthorizables == null || oldAuthorizables.size() == 0 || newAuthorizables == null || newAuthorizables.size() == 0) {
            throw new SentryUserException("oldAuthorizables and newAuthorizables can't be null or empty");
        }
        TRenamePrivilegesRequest request = new TRenamePrivilegesRequest();
        request.setProtocol_version(2);
        request.setComponent(component);
        request.setRequestorUserName(requestorUserName);
        request.setServiceName(serviceName);
        ArrayList oldTAuthorizables = Lists.newArrayList();
        ArrayList newTAuthorizables = Lists.newArrayList();
        for (Authorizable authorizable : oldAuthorizables) {
            oldTAuthorizables.add(new TAuthorizable(authorizable.getTypeName(), authorizable.getName()));
            request.setOldAuthorizables(oldTAuthorizables);
        }
        for (Authorizable authorizable : newAuthorizables) {
            newTAuthorizables.add(new TAuthorizable(authorizable.getTypeName(), authorizable.getName()));
            request.setNewAuthorizables(newTAuthorizables);
        }
        try {
            TRenamePrivilegesResponse response = this.client.rename_sentry_privilege(request);
            Status.throwIfNotOk(response.getStatus());
        }
        catch (TException e) {
            throw new SentryUserException(THRIFT_EXCEPTION_MESSAGE, (Throwable)e);
        }
    }

    @Override
    public synchronized Set<TSentryRole> listRolesByGroupName(String requestorUserName, String groupName, String component) throws SentryUserException {
        TListSentryRolesRequest request = new TListSentryRolesRequest();
        request.setProtocol_version(2);
        request.setRequestorUserName(requestorUserName);
        request.setGroupName(groupName);
        request.setComponent(component);
        try {
            TListSentryRolesResponse response = this.client.list_sentry_roles_by_group(request);
            Status.throwIfNotOk(response.getStatus());
            return response.getRoles();
        }
        catch (TException e) {
            throw new SentryUserException(THRIFT_EXCEPTION_MESSAGE, (Throwable)e);
        }
    }

    @Override
    public Set<TSentryRole> listUserRoles(String requestorUserName, String component) throws SentryUserException {
        return this.listRolesByGroupName(requestorUserName, "*", component);
    }

    @Override
    public Set<TSentryRole> listAllRoles(String requestorUserName, String component) throws SentryUserException {
        return this.listRolesByGroupName(requestorUserName, null, component);
    }

    @Override
    public Set<TSentryPrivilege> listPrivilegesByRoleName(String requestorUserName, String roleName, String component, String serviceName, List<? extends Authorizable> authorizables) throws SentryUserException {
        TListSentryPrivilegesResponse response;
        TListSentryPrivilegesRequest request = new TListSentryPrivilegesRequest();
        request.setProtocol_version(2);
        request.setComponent(component);
        request.setServiceName(serviceName);
        request.setRequestorUserName(requestorUserName);
        request.setRoleName(roleName);
        if (authorizables != null && authorizables.size() > 0) {
            ArrayList tAuthorizables = Lists.newArrayList();
            for (Authorizable authorizable : authorizables) {
                tAuthorizables.add(new TAuthorizable(authorizable.getTypeName(), authorizable.getName()));
            }
            request.setAuthorizables(tAuthorizables);
        }
        try {
            response = this.client.list_sentry_privileges_by_role(request);
            Status.throwIfNotOk(response.getStatus());
        }
        catch (TException e) {
            throw new SentryUserException(THRIFT_EXCEPTION_MESSAGE, (Throwable)e);
        }
        return response.getPrivileges();
    }

    @Override
    public Set<TSentryPrivilege> listPrivilegesByRoleName(String requestorUserName, String roleName, String component, String serviceName) throws SentryUserException {
        return this.listPrivilegesByRoleName(requestorUserName, roleName, component, serviceName, null);
    }

    @Override
    public Set<String> listPrivilegesForProvider(String component, String serviceName, ActiveRoleSet roleSet, Set<String> groups, List<? extends Authorizable> authorizables) throws SentryUserException {
        TSentryActiveRoleSet thriftRoleSet = new TSentryActiveRoleSet(roleSet.isAll(), roleSet.getRoles());
        TListSentryPrivilegesForProviderRequest request = new TListSentryPrivilegesForProviderRequest();
        request.setProtocol_version(2);
        request.setComponent(component);
        request.setServiceName(serviceName);
        request.setRoleSet(thriftRoleSet);
        if (groups == null) {
            request.setGroups(new HashSet<String>());
        } else {
            request.setGroups(groups);
        }
        ArrayList tAuthoriables = Lists.newArrayList();
        if (authorizables != null && authorizables.size() > 0) {
            for (Authorizable authorizable : authorizables) {
                tAuthoriables.add(new TAuthorizable(authorizable.getTypeName(), authorizable.getName()));
            }
            request.setAuthorizables(tAuthoriables);
        }
        try {
            TListSentryPrivilegesForProviderResponse response = this.client.list_sentry_privileges_for_provider(request);
            Status.throwIfNotOk(response.getStatus());
            return response.getPrivileges();
        }
        catch (TException e) {
            throw new SentryUserException(THRIFT_EXCEPTION_MESSAGE, (Throwable)e);
        }
    }

    @Override
    public void close() {
        if (this.transport != null) {
            this.transport.close();
        }
    }

    public static class UgiSaslClientTransport
    extends TSaslClientTransport {
        protected UserGroupInformation ugi = null;

        public UgiSaslClientTransport(String mechanism, String authorizationId, String protocol, String serverName, Map<String, String> props, CallbackHandler cbh, TTransport transport, boolean wrapUgi) throws IOException {
            super(mechanism, authorizationId, protocol, serverName, props, cbh, transport);
            if (wrapUgi) {
                this.ugi = UserGroupInformation.getLoginUser();
            }
        }

        public void open() throws TTransportException {
            if (this.ugi == null) {
                this.baseOpen();
            } else {
                try {
                    if (this.ugi.isFromKeytab()) {
                        this.ugi.checkTGTAndReloginFromKeytab();
                    }
                    this.ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                        @Override
                        public Void run() throws TTransportException {
                            UgiSaslClientTransport.this.baseOpen();
                            return null;
                        }
                    });
                }
                catch (IOException e) {
                    throw new TTransportException("Failed to open SASL transport", (Throwable)e);
                }
                catch (InterruptedException e) {
                    throw new TTransportException("Interrupted while opening underlying transport", (Throwable)e);
                }
            }
        }

        private void baseOpen() throws TTransportException {
            super.open();
        }
    }
}

