/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.generic.service.thrift;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.sentry.SentryUserException;
import org.apache.sentry.core.common.Authorizable;
import org.apache.sentry.provider.common.ProviderConstants;
import org.apache.sentry.provider.db.SentryAccessDeniedException;
import org.apache.sentry.provider.db.SentryAlreadyExistsException;
import org.apache.sentry.provider.db.SentryInvalidInputException;
import org.apache.sentry.provider.db.SentryNoSuchObjectException;
import org.apache.sentry.provider.db.SentryThriftAPIMismatchException;
import org.apache.sentry.provider.db.generic.service.persistent.PrivilegeObject;
import org.apache.sentry.provider.db.generic.service.persistent.SentryStoreLayer;
import org.apache.sentry.provider.db.generic.service.thrift.NotificationHandler;
import org.apache.sentry.provider.db.generic.service.thrift.NotificationHandlerInvoker;
import org.apache.sentry.provider.db.generic.service.thrift.SentryGenericPolicyService;
import org.apache.sentry.provider.db.generic.service.thrift.TAlterSentryRoleAddGroupsRequest;
import org.apache.sentry.provider.db.generic.service.thrift.TAlterSentryRoleAddGroupsResponse;
import org.apache.sentry.provider.db.generic.service.thrift.TAlterSentryRoleDeleteGroupsRequest;
import org.apache.sentry.provider.db.generic.service.thrift.TAlterSentryRoleDeleteGroupsResponse;
import org.apache.sentry.provider.db.generic.service.thrift.TAlterSentryRoleGrantPrivilegeRequest;
import org.apache.sentry.provider.db.generic.service.thrift.TAlterSentryRoleGrantPrivilegeResponse;
import org.apache.sentry.provider.db.generic.service.thrift.TAlterSentryRoleRevokePrivilegeRequest;
import org.apache.sentry.provider.db.generic.service.thrift.TAlterSentryRoleRevokePrivilegeResponse;
import org.apache.sentry.provider.db.generic.service.thrift.TAuthorizable;
import org.apache.sentry.provider.db.generic.service.thrift.TCreateSentryRoleRequest;
import org.apache.sentry.provider.db.generic.service.thrift.TCreateSentryRoleResponse;
import org.apache.sentry.provider.db.generic.service.thrift.TDropPrivilegesRequest;
import org.apache.sentry.provider.db.generic.service.thrift.TDropPrivilegesResponse;
import org.apache.sentry.provider.db.generic.service.thrift.TDropSentryRoleRequest;
import org.apache.sentry.provider.db.generic.service.thrift.TDropSentryRoleResponse;
import org.apache.sentry.provider.db.generic.service.thrift.TListSentryPrivilegesForProviderRequest;
import org.apache.sentry.provider.db.generic.service.thrift.TListSentryPrivilegesForProviderResponse;
import org.apache.sentry.provider.db.generic.service.thrift.TListSentryPrivilegesRequest;
import org.apache.sentry.provider.db.generic.service.thrift.TListSentryPrivilegesResponse;
import org.apache.sentry.provider.db.generic.service.thrift.TListSentryRolesRequest;
import org.apache.sentry.provider.db.generic.service.thrift.TListSentryRolesResponse;
import org.apache.sentry.provider.db.generic.service.thrift.TRenamePrivilegesRequest;
import org.apache.sentry.provider.db.generic.service.thrift.TRenamePrivilegesResponse;
import org.apache.sentry.provider.db.generic.service.thrift.TSentryGrantOption;
import org.apache.sentry.provider.db.generic.service.thrift.TSentryPrivilege;
import org.apache.sentry.provider.db.generic.service.thrift.TSentryRole;
import org.apache.sentry.provider.db.service.persistent.CommitContext;
import org.apache.sentry.provider.db.service.thrift.SentryConfigurationException;
import org.apache.sentry.provider.db.service.thrift.SentryPolicyStoreProcessor;
import org.apache.sentry.service.thrift.Status;
import org.apache.sentry.service.thrift.TSentryResponseStatus;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SentryGenericPolicyProcessor
implements SentryGenericPolicyService.Iface {
    private static final Logger LOGGER = LoggerFactory.getLogger(SentryGenericPolicyProcessor.class);
    private final Configuration conf;
    private final ImmutableSet<String> adminGroups;
    private final SentryStoreLayer store;
    private final NotificationHandlerInvoker handerInvoker;
    public static final String SENTRY_GENERIC_SERVICE_NAME = "SentryGenericPolicyService";

    public SentryGenericPolicyProcessor(Configuration conf) throws Exception {
        this.store = SentryGenericPolicyProcessor.createStore(conf);
        this.handerInvoker = new NotificationHandlerInvoker(SentryGenericPolicyProcessor.createHandlers(conf));
        this.conf = conf;
        this.adminGroups = ImmutableSet.copyOf(this.toTrimedLower(Sets.newHashSet((Object[])conf.getStrings("sentry.service.admin.group", new String[0]))));
    }

    @VisibleForTesting
    public SentryGenericPolicyProcessor(Configuration conf, SentryStoreLayer store) throws Exception {
        this.store = store;
        this.handerInvoker = new NotificationHandlerInvoker(SentryGenericPolicyProcessor.createHandlers(conf));
        this.conf = conf;
        this.adminGroups = ImmutableSet.copyOf(this.toTrimedLower(Sets.newHashSet((Object[])conf.getStrings("sentry.service.admin.group", new String[0]))));
    }

    private void authorize(String requestorUser, Set<String> requestorGroups) throws SentryAccessDeniedException {
        if (!this.inAdminGroups(requestorGroups)) {
            String msg = "User: " + requestorUser + " is part of " + requestorGroups + " which does not, intersect admin groups " + this.adminGroups;
            LOGGER.warn(msg);
            throw new SentryAccessDeniedException("Access denied to " + requestorUser);
        }
    }

    private Set<String> toTrimedLower(Set<String> s) {
        if (null == s) {
            return new HashSet<String>();
        }
        HashSet result = Sets.newHashSet();
        for (String v : s) {
            result.add(v.trim().toLowerCase());
        }
        return result;
    }

    private String toTrimedLower(String s) {
        if (Strings.isNullOrEmpty((String)s)) {
            return "";
        }
        return s.trim().toLowerCase();
    }

    public static Set<String> getRequestorGroups(Configuration conf, String userName) throws SentryUserException {
        return SentryPolicyStoreProcessor.getGroupsFromUserName(conf, userName);
    }

    private boolean inAdminGroups(Set<String> requestorGroups) {
        return !Sets.intersection(this.adminGroups, requestorGroups = this.toTrimedLower(requestorGroups)).isEmpty();
    }

    public static SentryStoreLayer createStore(Configuration conf) throws SentryConfigurationException {
        SentryStoreLayer storeLayer = null;
        String Store = conf.get("sentry.generic.policy.store", "org.apache.sentry.provider.db.generic.service.persistent.DelegateSentryStore");
        if (Strings.isNullOrEmpty((String)Store)) {
            throw new SentryConfigurationException("the parameter configuration for sentry.generic.policy.store can't be empty");
        }
        try {
            storeLayer = SentryGenericPolicyProcessor.createInstance(Store, conf, SentryStoreLayer.class);
        }
        catch (Exception e) {
            throw new SentryConfigurationException("Create sentryStore error: " + e.getMessage(), e);
        }
        return storeLayer;
    }

    public static List<NotificationHandler> createHandlers(Configuration conf) throws SentryConfigurationException {
        ArrayList handlers = Lists.newArrayList();
        Iterable notificationHandlers = Splitter.onPattern((String)"[\\s,]").trimResults().omitEmptyStrings().split((CharSequence)conf.get("sentry.generic.policy.notification", ""));
        try {
            for (String notificationHandler : notificationHandlers) {
                handlers.add(SentryGenericPolicyProcessor.createInstance(notificationHandler, conf, NotificationHandler.class));
            }
        }
        catch (Exception e) {
            throw new SentryConfigurationException("Create notificationHandlers error: " + e.getMessage(), e);
        }
        return handlers;
    }

    public static <T> T createInstance(String className, Configuration conf, Class<T> iface) throws Exception {
        Object result;
        try {
            Class<?> clazz = Class.forName(className);
            if (!iface.isAssignableFrom(clazz)) {
                throw new IllegalArgumentException("Class " + clazz + " is not a " + iface.getName());
            }
            Constructor<?> meth = clazz.getDeclaredConstructor(Configuration.class);
            meth.setAccessible(true);
            result = meth.newInstance(conf);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return (T)result;
    }

    private <T> Response<T> requestHandle(RequestHandler<T> handler) {
        Response response = new Response();
        try {
            response = handler.handle();
        }
        catch (SentryAccessDeniedException e) {
            LOGGER.error(e.getMessage(), (Throwable)((Object)e));
            response.status = Status.AccessDenied(e.getMessage(), (Throwable)((Object)e));
        }
        catch (SentryAlreadyExistsException e) {
            LOGGER.error(e.getMessage(), (Throwable)((Object)e));
            response.status = Status.AlreadyExists(e.getMessage(), (Throwable)((Object)e));
        }
        catch (SentryNoSuchObjectException e) {
            LOGGER.error(e.getMessage(), (Throwable)((Object)e));
            response.status = Status.NoSuchObject(e.getMessage(), (Throwable)((Object)e));
        }
        catch (SentryInvalidInputException e) {
            String msg = "Invalid input privilege object";
            LOGGER.error(msg, (Throwable)((Object)e));
            response.status = Status.InvalidInput(msg, (Throwable)((Object)e));
        }
        catch (SentryThriftAPIMismatchException e) {
            LOGGER.error(e.getMessage(), (Throwable)((Object)e));
            response.status = Status.THRIFT_VERSION_MISMATCH(e.getMessage(), (Throwable)((Object)e));
        }
        catch (Exception e) {
            String msg = "Unknown error:" + e.getMessage();
            LOGGER.error(msg, (Throwable)e);
            response.status = Status.RuntimeError(msg, e);
        }
        return response;
    }

    private PrivilegeObject toPrivilegeObject(TSentryPrivilege tSentryPrivilege) {
        Boolean grantOption = tSentryPrivilege.getGrantOption().equals((Object)TSentryGrantOption.TRUE) ? Boolean.valueOf(true) : (tSentryPrivilege.getGrantOption().equals((Object)TSentryGrantOption.FALSE) ? Boolean.valueOf(false) : null);
        return new PrivilegeObject.Builder().setComponent(tSentryPrivilege.getComponent()).setService(tSentryPrivilege.getServiceName()).setAuthorizables(this.toAuthorizables(tSentryPrivilege.getAuthorizables())).setAction(tSentryPrivilege.getAction()).withGrantOption(grantOption).build();
    }

    private TSentryPrivilege fromPrivilegeObject(PrivilegeObject privilege) {
        TSentryPrivilege tPrivilege = new TSentryPrivilege(privilege.getComponent(), privilege.getService(), this.fromAuthorizable(privilege.getAuthorizables()), privilege.getAction());
        if (privilege.getGrantOption() == null) {
            tPrivilege.setGrantOption(TSentryGrantOption.UNSET);
        } else if (privilege.getGrantOption().booleanValue()) {
            tPrivilege.setGrantOption(TSentryGrantOption.TRUE);
        } else {
            tPrivilege.setGrantOption(TSentryGrantOption.FALSE);
        }
        return tPrivilege;
    }

    private List<TAuthorizable> fromAuthorizable(List<? extends Authorizable> authorizables) {
        ArrayList tAuthorizables = Lists.newArrayList();
        for (Authorizable authorizable : authorizables) {
            tAuthorizables.add(new TAuthorizable(authorizable.getTypeName(), authorizable.getName()));
        }
        return tAuthorizables;
    }

    private List<? extends Authorizable> toAuthorizables(List<TAuthorizable> tAuthorizables) {
        ArrayList authorizables = Lists.newArrayList();
        if (tAuthorizables == null) {
            return authorizables;
        }
        for (final TAuthorizable tAuthorizable : tAuthorizables) {
            authorizables.add(new Authorizable(){

                public String getTypeName() {
                    return tAuthorizable.getType();
                }

                public String getName() {
                    return tAuthorizable.getName();
                }
            });
        }
        return authorizables;
    }

    private Set<String> buildPermissions(Set<PrivilegeObject> privileges) {
        HashSet permissions = Sets.newHashSet();
        for (PrivilegeObject privilege : privileges) {
            ArrayList hierarchy = Lists.newArrayList();
            if (this.hasComponentServerPrivilege(privilege.getComponent())) {
                hierarchy.add(ProviderConstants.KV_JOINER.join((Object)"server", (Object)privilege.getService(), new Object[0]));
            }
            for (Authorizable authorizable : privilege.getAuthorizables()) {
                hierarchy.add(ProviderConstants.KV_JOINER.join((Object)authorizable.getTypeName(), (Object)authorizable.getName(), new Object[0]));
            }
            hierarchy.add(ProviderConstants.KV_JOINER.join((Object)"action", (Object)privilege.getAction(), new Object[0]));
            permissions.add(ProviderConstants.AUTHORIZABLE_JOINER.join((Iterable)hierarchy));
        }
        return permissions;
    }

    private boolean hasComponentServerPrivilege(String component) {
        return "sqoop".equalsIgnoreCase(component);
    }

    @Override
    public TCreateSentryRoleResponse create_sentry_role(final TCreateSentryRoleRequest request) throws TException {
        Response<Void> respose = this.requestHandle(new RequestHandler<Void>(){

            @Override
            public Response<Void> handle() throws Exception {
                SentryGenericPolicyProcessor.validateClientVersion(request.getProtocol_version());
                SentryGenericPolicyProcessor.this.authorize(request.getRequestorUserName(), SentryGenericPolicyProcessor.getRequestorGroups(SentryGenericPolicyProcessor.this.conf, request.getRequestorUserName()));
                CommitContext context = SentryGenericPolicyProcessor.this.store.createRole(request.getComponent(), request.getRoleName(), request.getRequestorUserName());
                return new Response<CommitContext>(Status.OK(), context);
            }
        });
        TCreateSentryRoleResponse tResponse = new TCreateSentryRoleResponse(respose.status);
        if (Status.OK.getCode() == respose.status.getValue()) {
            this.handerInvoker.create_sentry_role(respose.context, request, tResponse);
        }
        return tResponse;
    }

    @Override
    public TDropSentryRoleResponse drop_sentry_role(final TDropSentryRoleRequest request) throws TException {
        Response<Void> respose = this.requestHandle(new RequestHandler<Void>(){

            @Override
            public Response<Void> handle() throws Exception {
                SentryGenericPolicyProcessor.validateClientVersion(request.getProtocol_version());
                SentryGenericPolicyProcessor.this.authorize(request.getRequestorUserName(), SentryGenericPolicyProcessor.getRequestorGroups(SentryGenericPolicyProcessor.this.conf, request.getRequestorUserName()));
                CommitContext context = SentryGenericPolicyProcessor.this.store.dropRole(request.getComponent(), request.getRoleName(), request.getRequestorUserName());
                return new Response<CommitContext>(Status.OK(), context);
            }
        });
        TDropSentryRoleResponse tResponse = new TDropSentryRoleResponse(respose.status);
        if (Status.OK.getCode() == respose.status.getValue()) {
            this.handerInvoker.drop_sentry_role(respose.context, request, tResponse);
        }
        return tResponse;
    }

    @Override
    public TAlterSentryRoleGrantPrivilegeResponse alter_sentry_role_grant_privilege(final TAlterSentryRoleGrantPrivilegeRequest request) throws TException {
        Response<Void> respose = this.requestHandle(new RequestHandler<Void>(){

            @Override
            public Response<Void> handle() throws Exception {
                SentryGenericPolicyProcessor.validateClientVersion(request.getProtocol_version());
                CommitContext context = SentryGenericPolicyProcessor.this.store.alterRoleGrantPrivilege(request.getComponent(), request.getRoleName(), SentryGenericPolicyProcessor.this.toPrivilegeObject(request.getPrivilege()), request.getRequestorUserName());
                return new Response<CommitContext>(Status.OK(), context);
            }
        });
        TAlterSentryRoleGrantPrivilegeResponse tResponse = new TAlterSentryRoleGrantPrivilegeResponse(respose.status);
        if (Status.OK.getCode() == respose.status.getValue()) {
            this.handerInvoker.alter_sentry_role_grant_privilege(respose.context, request, tResponse);
        }
        return tResponse;
    }

    @Override
    public TAlterSentryRoleRevokePrivilegeResponse alter_sentry_role_revoke_privilege(final TAlterSentryRoleRevokePrivilegeRequest request) throws TException {
        Response<Void> respose = this.requestHandle(new RequestHandler<Void>(){

            @Override
            public Response<Void> handle() throws Exception {
                SentryGenericPolicyProcessor.validateClientVersion(request.getProtocol_version());
                CommitContext context = SentryGenericPolicyProcessor.this.store.alterRoleRevokePrivilege(request.getComponent(), request.getRoleName(), SentryGenericPolicyProcessor.this.toPrivilegeObject(request.getPrivilege()), request.getRequestorUserName());
                return new Response<CommitContext>(Status.OK(), context);
            }
        });
        TAlterSentryRoleRevokePrivilegeResponse tResponse = new TAlterSentryRoleRevokePrivilegeResponse(respose.status);
        if (Status.OK.getCode() == respose.status.getValue()) {
            this.handerInvoker.alter_sentry_role_revoke_privilege(respose.context, request, tResponse);
        }
        return tResponse;
    }

    @Override
    public TAlterSentryRoleAddGroupsResponse alter_sentry_role_add_groups(final TAlterSentryRoleAddGroupsRequest request) throws TException {
        Response<Void> respose = this.requestHandle(new RequestHandler<Void>(){

            @Override
            public Response<Void> handle() throws Exception {
                SentryGenericPolicyProcessor.validateClientVersion(request.getProtocol_version());
                SentryGenericPolicyProcessor.this.authorize(request.getRequestorUserName(), SentryGenericPolicyProcessor.getRequestorGroups(SentryGenericPolicyProcessor.this.conf, request.getRequestorUserName()));
                CommitContext context = SentryGenericPolicyProcessor.this.store.alterRoleAddGroups(request.getComponent(), request.getRoleName(), request.getGroups(), request.getRequestorUserName());
                return new Response<CommitContext>(Status.OK(), context);
            }
        });
        TAlterSentryRoleAddGroupsResponse tResponse = new TAlterSentryRoleAddGroupsResponse(respose.status);
        if (Status.OK.getCode() == respose.status.getValue()) {
            this.handerInvoker.alter_sentry_role_add_groups(respose.context, request, tResponse);
        }
        return tResponse;
    }

    @Override
    public TAlterSentryRoleDeleteGroupsResponse alter_sentry_role_delete_groups(final TAlterSentryRoleDeleteGroupsRequest request) throws TException {
        Response<Void> respose = this.requestHandle(new RequestHandler<Void>(){

            @Override
            public Response<Void> handle() throws Exception {
                SentryGenericPolicyProcessor.validateClientVersion(request.getProtocol_version());
                SentryGenericPolicyProcessor.this.authorize(request.getRequestorUserName(), SentryGenericPolicyProcessor.getRequestorGroups(SentryGenericPolicyProcessor.this.conf, request.getRequestorUserName()));
                CommitContext context = SentryGenericPolicyProcessor.this.store.alterRoleDeleteGroups(request.getComponent(), request.getRoleName(), request.getGroups(), request.getRequestorUserName());
                return new Response<CommitContext>(Status.OK(), context);
            }
        });
        TAlterSentryRoleDeleteGroupsResponse tResponse = new TAlterSentryRoleDeleteGroupsResponse(respose.status);
        if (Status.OK.getCode() == respose.status.getValue()) {
            this.handerInvoker.alter_sentry_role_delete_groups(respose.context, request, tResponse);
        }
        return tResponse;
    }

    @Override
    public TListSentryRolesResponse list_sentry_roles_by_group(final TListSentryRolesRequest request) throws TException {
        Response<Set<TSentryRole>> respose = this.requestHandle(new RequestHandler<Set<TSentryRole>>(){

            @Override
            public Response<Set<TSentryRole>> handle() throws Exception {
                SentryGenericPolicyProcessor.validateClientVersion(request.getProtocol_version());
                Set<String> groups = SentryGenericPolicyProcessor.getRequestorGroups(SentryGenericPolicyProcessor.this.conf, request.getRequestorUserName());
                if (!"*".equalsIgnoreCase(request.getGroupName())) {
                    boolean admin = SentryGenericPolicyProcessor.this.inAdminGroups(groups);
                    if (!(admin || request.getGroupName() != null && groups.contains(request.getGroupName()))) {
                        throw new SentryAccessDeniedException("Access denied to " + request.getRequestorUserName());
                    }
                    groups.clear();
                    groups.add(request.getGroupName());
                }
                Set<String> roleNames = SentryGenericPolicyProcessor.this.store.getRolesByGroups(request.getComponent(), groups);
                HashSet tSentryRoles = Sets.newHashSet();
                for (String roleName : roleNames) {
                    Set<String> groupsForRoleName = SentryGenericPolicyProcessor.this.store.getGroupsByRoles(request.getComponent(), Sets.newHashSet((Object[])new String[]{roleName}));
                    tSentryRoles.add(new TSentryRole(roleName, groupsForRoleName));
                }
                return new Response<Set<TSentryRole>>(Status.OK(), tSentryRoles);
            }
        });
        TListSentryRolesResponse tResponse = new TListSentryRolesResponse();
        tResponse.setStatus(respose.status);
        tResponse.setRoles((Set)respose.content);
        return tResponse;
    }

    @Override
    public TListSentryPrivilegesResponse list_sentry_privileges_by_role(final TListSentryPrivilegesRequest request) throws TException {
        Response<Set<TSentryPrivilege>> respose = this.requestHandle(new RequestHandler<Set<TSentryPrivilege>>(){

            @Override
            public Response<Set<TSentryPrivilege>> handle() throws Exception {
                Set roleNamesForGroups;
                SentryGenericPolicyProcessor.validateClientVersion(request.getProtocol_version());
                Set<String> groups = SentryGenericPolicyProcessor.getRequestorGroups(SentryGenericPolicyProcessor.this.conf, request.getRequestorUserName());
                if (!SentryGenericPolicyProcessor.this.inAdminGroups(groups) && !(roleNamesForGroups = SentryGenericPolicyProcessor.this.toTrimedLower(SentryGenericPolicyProcessor.this.store.getRolesByGroups(request.getComponent(), groups))).contains(SentryGenericPolicyProcessor.this.toTrimedLower(request.getRoleName()))) {
                    throw new SentryAccessDeniedException("Access denied to " + request.getRequestorUserName());
                }
                Set<PrivilegeObject> privileges = SentryGenericPolicyProcessor.this.store.getPrivilegesByProvider(request.getComponent(), request.getServiceName(), Sets.newHashSet((Object[])new String[]{request.getRoleName()}), null, SentryGenericPolicyProcessor.this.toAuthorizables(request.getAuthorizables()));
                HashSet tSentryPrivileges = Sets.newHashSet();
                for (PrivilegeObject privilege : privileges) {
                    tSentryPrivileges.add(SentryGenericPolicyProcessor.this.fromPrivilegeObject(privilege));
                }
                return new Response<Set<TSentryPrivilege>>(Status.OK(), tSentryPrivileges);
            }
        });
        TListSentryPrivilegesResponse tResponse = new TListSentryPrivilegesResponse();
        tResponse.setStatus(respose.status);
        tResponse.setPrivileges((Set)respose.content);
        return tResponse;
    }

    @Override
    public TListSentryPrivilegesForProviderResponse list_sentry_privileges_for_provider(final TListSentryPrivilegesForProviderRequest request) throws TException {
        Response<Set<String>> respose = this.requestHandle(new RequestHandler<Set<String>>(){

            @Override
            public Response<Set<String>> handle() throws Exception {
                SentryGenericPolicyProcessor.validateClientVersion(request.getProtocol_version());
                Set activeRoleNames = SentryGenericPolicyProcessor.this.toTrimedLower(request.getRoleSet().getRoles());
                Sets.SetView roleNamesForGroups = SentryGenericPolicyProcessor.this.store.getRolesByGroups(request.getComponent(), request.getGroups());
                Sets.SetView rolesToQuery = request.getRoleSet().isAll() ? roleNamesForGroups : Sets.intersection((Set)activeRoleNames, roleNamesForGroups);
                Set<PrivilegeObject> privileges = SentryGenericPolicyProcessor.this.store.getPrivilegesByProvider(request.getComponent(), request.getServiceName(), (Set<String>)rolesToQuery, null, SentryGenericPolicyProcessor.this.toAuthorizables(request.getAuthorizables()));
                return new Response<Set<String>>(Status.OK(), SentryGenericPolicyProcessor.this.buildPermissions(privileges));
            }
        });
        TListSentryPrivilegesForProviderResponse tResponse = new TListSentryPrivilegesForProviderResponse();
        tResponse.setStatus(respose.status);
        tResponse.setPrivileges((Set)respose.content);
        return tResponse;
    }

    @Override
    public TDropPrivilegesResponse drop_sentry_privilege(final TDropPrivilegesRequest request) throws TException {
        Response<Void> respose = this.requestHandle(new RequestHandler<Void>(){

            @Override
            public Response<Void> handle() throws Exception {
                SentryGenericPolicyProcessor.validateClientVersion(request.getProtocol_version());
                SentryGenericPolicyProcessor.this.authorize(request.getRequestorUserName(), SentryGenericPolicyProcessor.getRequestorGroups(SentryGenericPolicyProcessor.this.conf, request.getRequestorUserName()));
                CommitContext context = SentryGenericPolicyProcessor.this.store.dropPrivilege(request.getComponent(), SentryGenericPolicyProcessor.this.toPrivilegeObject(request.getPrivilege()), request.getRequestorUserName());
                return new Response<CommitContext>(Status.OK(), context);
            }
        });
        TDropPrivilegesResponse tResponse = new TDropPrivilegesResponse(respose.status);
        if (Status.OK.getCode() == respose.status.getValue()) {
            this.handerInvoker.drop_sentry_privilege(respose.context, request, tResponse);
        }
        return tResponse;
    }

    @Override
    public TRenamePrivilegesResponse rename_sentry_privilege(final TRenamePrivilegesRequest request) throws TException {
        Response<Void> respose = this.requestHandle(new RequestHandler<Void>(){

            @Override
            public Response<Void> handle() throws Exception {
                SentryGenericPolicyProcessor.validateClientVersion(request.getProtocol_version());
                SentryGenericPolicyProcessor.this.authorize(request.getRequestorUserName(), SentryGenericPolicyProcessor.getRequestorGroups(SentryGenericPolicyProcessor.this.conf, request.getRequestorUserName()));
                CommitContext context = SentryGenericPolicyProcessor.this.store.renamePrivilege(request.getComponent(), request.getServiceName(), SentryGenericPolicyProcessor.this.toAuthorizables(request.getOldAuthorizables()), SentryGenericPolicyProcessor.this.toAuthorizables(request.getNewAuthorizables()), request.getRequestorUserName());
                return new Response<Void>(Status.OK(), context);
            }
        });
        TRenamePrivilegesResponse tResponse = new TRenamePrivilegesResponse(respose.status);
        if (Status.OK.getCode() == respose.status.getValue()) {
            this.handerInvoker.rename_sentry_privilege(respose.context, request, tResponse);
        }
        return tResponse;
    }

    private static void validateClientVersion(int protocol_version) throws SentryThriftAPIMismatchException {
        if (2 != protocol_version) {
            String msg = "Sentry thrift API protocol version mismatch: Client thrift version is: " + protocol_version + " , server thrift verion " + "is " + 2;
            throw new SentryThriftAPIMismatchException(msg);
        }
    }

    private static interface RequestHandler<T> {
        public Response<T> handle() throws Exception;
    }

    private static class Response<T> {
        TSentryResponseStatus status;
        CommitContext context;
        T content;

        Response() {
        }

        Response(TSentryResponseStatus status, CommitContext context) {
            this(status, context, null);
        }

        Response(TSentryResponseStatus status, T content) {
            this(status, null, content);
        }

        Response(TSentryResponseStatus status, CommitContext context, T content) {
            this.status = status;
            this.context = context;
            this.content = content;
        }
    }
}

