/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.generic.service.persistent;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jdo.PersistenceManager;
import javax.jdo.Query;
import org.apache.sentry.SentryUserException;
import org.apache.sentry.core.common.Authorizable;
import org.apache.sentry.core.common.BitFieldAction;
import org.apache.sentry.core.common.BitFieldActionFactory;
import org.apache.sentry.core.model.search.SearchActionFactory;
import org.apache.sentry.core.model.sqoop.SqoopActionFactory;
import org.apache.sentry.provider.db.generic.service.persistent.PrivilegeObject;
import org.apache.sentry.provider.db.service.model.MSentryGMPrivilege;
import org.apache.sentry.provider.db.service.model.MSentryRole;

public class PrivilegeOperatePersistence {
    private static final Map<String, BitFieldActionFactory> actionFactories = Maps.newHashMap();

    public boolean checkPrivilegeOption(Set<MSentryRole> roles, PrivilegeObject privilege, PersistenceManager pm) {
        MSentryGMPrivilege requestPrivilege = this.convertToPrivilege(privilege);
        boolean hasGrant = false;
        Query query = pm.newQuery(MSentryGMPrivilege.class);
        StringBuilder filters = new StringBuilder();
        if (roles != null && roles.size() > 0) {
            query.declareVariables("org.apache.sentry.provider.db.service.model.MSentryRole role");
            LinkedList<String> rolesFiler = new LinkedList<String>();
            for (MSentryRole role : roles) {
                rolesFiler.add("role.roleName == \"" + role.getRoleName() + "\" ");
            }
            filters.append("roles.contains(role) && (" + Joiner.on((String)" || ").join(rolesFiler) + ")");
        }
        query.setFilter(filters.toString());
        List tPrivileges = (List)query.execute();
        for (MSentryGMPrivilege tPrivilege : tPrivileges) {
            if (!tPrivilege.getGrantOption().booleanValue() || !tPrivilege.implies(requestPrivilege)) continue;
            hasGrant = true;
            break;
        }
        return hasGrant;
    }

    public void grantPrivilege(PrivilegeObject privilege, MSentryRole role, PersistenceManager pm) throws SentryUserException {
        MSentryGMPrivilege mPrivilege = this.convertToPrivilege(privilege);
        this.grantRolePartial(mPrivilege, role, pm);
    }

    private void grantRolePartial(MSentryGMPrivilege grantPrivilege, MSentryRole role, PersistenceManager pm) {
        BitFieldAction allAction;
        String component = grantPrivilege.getComponentName();
        BitFieldAction action = PrivilegeOperatePersistence.getAction(component, grantPrivilege.getAction());
        if (action.implies(allAction = PrivilegeOperatePersistence.getAction(component, "*"))) {
            List actions = PrivilegeOperatePersistence.getActionFactory(component).getActionsByCode(allAction.getActionCode());
            for (BitFieldAction ac : actions) {
                grantPrivilege.setAction(ac.getValue());
                MSentryGMPrivilege existPriv = this.getPrivilege(grantPrivilege, pm);
                if (existPriv == null || !role.getGmPrivileges().contains(existPriv)) continue;
                pm.retrieve((Object)existPriv);
                existPriv.removeRole(role);
                pm.makePersistent((Object)existPriv);
            }
        } else {
            grantPrivilege.setAction(allAction.getValue());
            MSentryGMPrivilege allPrivilege = this.getPrivilege(grantPrivilege, pm);
            if (allPrivilege != null && role.getGmPrivileges().contains(allPrivilege)) {
                return;
            }
        }
        grantPrivilege.setAction(action.getValue());
        MSentryGMPrivilege mPrivilege = this.getPrivilege(grantPrivilege, pm);
        if (mPrivilege == null) {
            mPrivilege = grantPrivilege;
        }
        mPrivilege.appendRole(role);
        pm.makePersistent((Object)mPrivilege);
    }

    public void revokePrivilege(PrivilegeObject privilege, MSentryRole role, PersistenceManager pm) throws SentryUserException {
        MSentryGMPrivilege mPrivilege = this.getPrivilege(this.convertToPrivilege(privilege), pm);
        mPrivilege = mPrivilege == null ? this.convertToPrivilege(privilege) : (MSentryGMPrivilege)pm.detachCopy((Object)mPrivilege);
        HashSet privilegeGraph = Sets.newHashSet();
        privilegeGraph.addAll(this.populateIncludePrivileges(Sets.newHashSet((Object[])new MSentryRole[]{role}), mPrivilege, pm));
        for (MSentryGMPrivilege persistedPriv : privilegeGraph) {
            this.revokeRolePartial(mPrivilege, persistedPriv, role, pm);
        }
        pm.makePersistent((Object)role);
    }

    private Set<MSentryGMPrivilege> populateIncludePrivileges(Set<MSentryRole> roles, MSentryGMPrivilege parent, PersistenceManager pm) {
        HashSet childrens = Sets.newHashSet();
        Query query = pm.newQuery(MSentryGMPrivilege.class);
        StringBuilder filters = new StringBuilder();
        filters.append(MSentryGMPrivilege.populateIncludePrivilegesQuery(parent));
        if (roles != null && roles.size() > 0) {
            query.declareVariables("org.apache.sentry.provider.db.service.model.MSentryRole role");
            LinkedList<String> rolesFiler = new LinkedList<String>();
            for (MSentryRole role : roles) {
                rolesFiler.add("role.roleName == \"" + role.getRoleName() + "\" ");
            }
            filters.append("&& roles.contains(role) && (" + Joiner.on((String)" || ").join(rolesFiler) + ")");
        }
        query.setFilter(filters.toString());
        List privileges = (List)query.execute();
        childrens.addAll(privileges);
        return childrens;
    }

    private void revokeRolePartial(MSentryGMPrivilege revokePrivilege, MSentryGMPrivilege persistedPriv, MSentryRole role, PersistenceManager pm) {
        String component = revokePrivilege.getComponentName();
        BitFieldAction revokeaction = PrivilegeOperatePersistence.getAction(component, revokePrivilege.getAction());
        BitFieldAction persistedAction = PrivilegeOperatePersistence.getAction(component, persistedPriv.getAction());
        BitFieldAction allAction = PrivilegeOperatePersistence.getAction(component, "*");
        if (revokeaction.implies(allAction)) {
            persistedPriv.removeRole(role);
            pm.makePersistent((Object)persistedPriv);
        } else if (persistedAction.implies(allAction)) {
            persistedPriv.removeRole(role);
            pm.makePersistent((Object)persistedPriv);
            List actions = PrivilegeOperatePersistence.getActionFactory(component).getActionsByCode(allAction.getActionCode());
            for (BitFieldAction ac : actions) {
                if (ac.getActionCode() == revokeaction.getActionCode()) continue;
                MSentryGMPrivilege tmpPriv = new MSentryGMPrivilege(persistedPriv);
                tmpPriv.setAction(ac.getValue());
                MSentryGMPrivilege leftPersistedPriv = this.getPrivilege(tmpPriv, pm);
                if (leftPersistedPriv == null) {
                    leftPersistedPriv = tmpPriv;
                    role.appendGMPrivilege(leftPersistedPriv);
                }
                leftPersistedPriv.appendRole(role);
                pm.makePersistent((Object)leftPersistedPriv);
            }
        } else if (revokeaction.implies(persistedAction)) {
            persistedPriv.removeRole(role);
            pm.makePersistent((Object)persistedPriv);
        }
    }

    public void dropPrivilege(PrivilegeObject privilege, PersistenceManager pm) {
        MSentryGMPrivilege requestPrivilege = this.convertToPrivilege(privilege);
        if (Strings.isNullOrEmpty((String)privilege.getAction())) {
            requestPrivilege.setAction(PrivilegeOperatePersistence.getAction(privilege.getComponent(), "*").getValue());
        }
        HashSet privilegeGraph = Sets.newHashSet();
        privilegeGraph.addAll(this.populateIncludePrivileges(null, requestPrivilege, pm));
        for (MSentryGMPrivilege mPrivilege : privilegeGraph) {
            pm.retrieve((Object)mPrivilege);
            Set<MSentryRole> roles = mPrivilege.getRoles();
            for (MSentryRole role : roles) {
                this.revokeRolePartial(requestPrivilege, mPrivilege, role, pm);
            }
        }
    }

    private MSentryGMPrivilege convertToPrivilege(PrivilegeObject privilege) {
        return new MSentryGMPrivilege(privilege.getComponent(), privilege.getService(), privilege.getAuthorizables(), privilege.getAction(), privilege.getGrantOption());
    }

    private MSentryGMPrivilege getPrivilege(MSentryGMPrivilege privilege, PersistenceManager pm) {
        Query query = pm.newQuery(MSentryGMPrivilege.class);
        query.setFilter(MSentryGMPrivilege.toQuery(privilege));
        query.setUnique(true);
        return (MSentryGMPrivilege)query.execute();
    }

    public Set<PrivilegeObject> getPrivilegesByRole(Set<MSentryRole> roles, PersistenceManager pm) {
        HashSet privileges = Sets.newHashSet();
        if (roles == null || roles.size() == 0) {
            return privileges;
        }
        Query query = pm.newQuery(MSentryGMPrivilege.class);
        StringBuilder filters = new StringBuilder();
        query.declareVariables("org.apache.sentry.provider.db.service.model.MSentryRole role");
        LinkedList<String> rolesFiler = new LinkedList<String>();
        for (MSentryRole role : roles) {
            rolesFiler.add("role.roleName == \"" + role.getRoleName() + "\" ");
        }
        filters.append("roles.contains(role) && (" + Joiner.on((String)" || ").join(rolesFiler) + ")");
        query.setFilter(filters.toString());
        List mPrivileges = (List)query.execute();
        if (mPrivileges == null || mPrivileges.size() == 0) {
            return privileges;
        }
        for (MSentryGMPrivilege mPrivilege : mPrivileges) {
            privileges.add(new PrivilegeObject.Builder().setComponent(mPrivilege.getComponentName()).setService(mPrivilege.getServiceName()).setAction(mPrivilege.getAction()).setAuthorizables(mPrivilege.getAuthorizables()).withGrantOption(mPrivilege.getGrantOption()).build());
        }
        return privileges;
    }

    public Set<PrivilegeObject> getPrivilegesByProvider(String component, String service, Set<MSentryRole> roles, List<? extends Authorizable> authorizables, PersistenceManager pm) {
        HashSet privileges = Sets.newHashSet();
        if (roles == null || roles.size() == 0) {
            return privileges;
        }
        MSentryGMPrivilege parentPrivilege = new MSentryGMPrivilege(component, service, authorizables, null, null);
        HashSet privilegeGraph = Sets.newHashSet();
        privilegeGraph.addAll(this.populateIncludePrivileges(roles, parentPrivilege, pm));
        for (MSentryGMPrivilege mPrivilege : privilegeGraph) {
            privileges.add(new PrivilegeObject.Builder().setComponent(mPrivilege.getComponentName()).setService(mPrivilege.getServiceName()).setAction(mPrivilege.getAction()).setAuthorizables(mPrivilege.getAuthorizables()).withGrantOption(mPrivilege.getGrantOption()).build());
        }
        return privileges;
    }

    public void renamePrivilege(String component, String service, List<? extends Authorizable> oldAuthorizables, List<? extends Authorizable> newAuthorizables, String grantorPrincipal, PersistenceManager pm) throws SentryUserException {
        MSentryGMPrivilege oldPrivilege = new MSentryGMPrivilege(component, service, oldAuthorizables, null, null);
        oldPrivilege.setAction(PrivilegeOperatePersistence.getAction(component, "*").getValue());
        HashSet privilegeGraph = Sets.newHashSet();
        privilegeGraph.addAll(this.populateIncludePrivileges(null, oldPrivilege, pm));
        for (MSentryGMPrivilege dropPrivilege : privilegeGraph) {
            ArrayList<? extends Authorizable> authorizables = new ArrayList<Authorizable>(dropPrivilege.getAuthorizables());
            for (int i = 0; i < newAuthorizables.size(); ++i) {
                authorizables.set(i, (Authorizable)newAuthorizables.get(i));
            }
            MSentryGMPrivilege newPrivilge = new MSentryGMPrivilege(component, service, authorizables, dropPrivilege.getAction(), dropPrivilege.getGrantOption());
            pm.retrieve((Object)dropPrivilege);
            Set<MSentryRole> roles = dropPrivilege.getRoles();
            for (MSentryRole role : roles) {
                this.revokeRolePartial(oldPrivilege, dropPrivilege, role, pm);
                this.grantRolePartial(newPrivilge, role, pm);
            }
        }
    }

    public static BitFieldAction getAction(String component, String name) {
        BitFieldActionFactory actionFactory = PrivilegeOperatePersistence.getActionFactory(component);
        BitFieldAction action = actionFactory.getActionByName(name);
        if (action == null) {
            throw new RuntimeException("can't get BitFieldAction for name:" + name);
        }
        return action;
    }

    public static BitFieldActionFactory getActionFactory(String component) {
        BitFieldActionFactory actionFactory = actionFactories.get(component.toLowerCase());
        if (actionFactory == null) {
            throw new RuntimeException("can't get actionFactory for component:" + component);
        }
        return actionFactory;
    }

    static {
        actionFactories.put("solr", (BitFieldActionFactory)new SearchActionFactory());
        actionFactories.put("sqoop", (BitFieldActionFactory)new SqoopActionFactory());
    }
}

