/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.generic.service.persistent;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.jdo.PersistenceManager;
import javax.jdo.Query;
import org.apache.hadoop.conf.Configuration;
import org.apache.sentry.SentryUserException;
import org.apache.sentry.core.common.Authorizable;
import org.apache.sentry.provider.db.SentryAccessDeniedException;
import org.apache.sentry.provider.db.SentryAlreadyExistsException;
import org.apache.sentry.provider.db.SentryGrantDeniedException;
import org.apache.sentry.provider.db.SentryInvalidInputException;
import org.apache.sentry.provider.db.SentryNoSuchObjectException;
import org.apache.sentry.provider.db.generic.service.persistent.PrivilegeObject;
import org.apache.sentry.provider.db.generic.service.persistent.PrivilegeOperatePersistence;
import org.apache.sentry.provider.db.generic.service.persistent.SentryStoreLayer;
import org.apache.sentry.provider.db.service.model.MSentryGMPrivilege;
import org.apache.sentry.provider.db.service.model.MSentryGroup;
import org.apache.sentry.provider.db.service.model.MSentryRole;
import org.apache.sentry.provider.db.service.persistent.CommitContext;
import org.apache.sentry.provider.db.service.persistent.SentryStore;
import org.apache.sentry.provider.db.service.thrift.SentryConfigurationException;
import org.apache.sentry.provider.db.service.thrift.SentryPolicyStoreProcessor;
import org.apache.sentry.provider.db.service.thrift.TSentryGroup;
import org.apache.sentry.provider.db.service.thrift.TSentryRole;

public class DelegateSentryStore
implements SentryStoreLayer {
    private SentryStore delegate;
    private Configuration conf;
    private Set<String> adminGroups;
    private PrivilegeOperatePersistence privilegeOperator = new PrivilegeOperatePersistence();

    public DelegateSentryStore(Configuration conf) throws SentryNoSuchObjectException, SentryAccessDeniedException, SentryConfigurationException, IOException {
        conf.set("sentry.store.orphaned.privilege.removal", "false");
        this.conf = conf;
        this.delegate = new SentryStore(conf);
        this.adminGroups = ImmutableSet.copyOf(this.toTrimedLower(Sets.newHashSet((Object[])conf.getStrings("sentry.service.admin.group", new String[0]))));
    }

    private PersistenceManager openTransaction() {
        return this.delegate.openTransaction();
    }

    private CommitContext commitUpdateTransaction(PersistenceManager pm) {
        return this.delegate.commitUpdateTransaction(pm);
    }

    private void rollbackTransaction(PersistenceManager pm) {
        this.delegate.rollbackTransaction(pm);
    }

    private void commitTransaction(PersistenceManager pm) {
        this.delegate.commitTransaction(pm);
    }

    private MSentryRole getRole(String roleName, PersistenceManager pm) {
        return this.delegate.getMSentryRole(pm, roleName);
    }

    @Override
    public CommitContext createRole(String component, String role, String requestor) throws SentryAlreadyExistsException {
        return this.delegate.createSentryRole(role);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommitContext dropRole(String component, String role, String requestor) throws SentryNoSuchObjectException {
        boolean rollbackTransaction = true;
        PersistenceManager pm = null;
        role = this.toTrimedLower(role);
        try {
            pm = this.openTransaction();
            Query query = pm.newQuery(MSentryRole.class);
            query.setFilter("this.roleName == t");
            query.declareParameters("java.lang.String t");
            query.setUnique(true);
            MSentryRole sentryRole = (MSentryRole)query.execute((Object)role);
            if (sentryRole == null) {
                throw new SentryNoSuchObjectException("Role " + role);
            }
            pm.retrieve((Object)sentryRole);
            sentryRole.removeGMPrivileges();
            sentryRole.removePrivileges();
            pm.deletePersistent((Object)sentryRole);
            CommitContext commit = this.commitUpdateTransaction(pm);
            rollbackTransaction = false;
            CommitContext commitContext = commit;
            return commitContext;
        }
        finally {
            if (rollbackTransaction) {
                this.rollbackTransaction(pm);
            }
        }
    }

    @Override
    public CommitContext alterRoleAddGroups(String component, String role, Set<String> groups, String requestor) throws SentryNoSuchObjectException {
        return this.delegate.alterSentryRoleAddGroups(requestor, role, this.toTSentryGroups(groups));
    }

    @Override
    public CommitContext alterRoleDeleteGroups(String component, String role, Set<String> groups, String requestor) throws SentryNoSuchObjectException {
        return this.delegate.alterSentryRoleDeleteGroups(role, this.toTSentryGroups(groups));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommitContext alterRoleGrantPrivilege(String component, String role, PrivilegeObject privilege, String grantorPrincipal) throws SentryUserException {
        role = this.toTrimedLower(role);
        PersistenceManager pm = null;
        boolean rollbackTransaction = true;
        try {
            pm = this.openTransaction();
            MSentryRole mRole = this.getRole(role, pm);
            if (mRole == null) {
                throw new SentryNoSuchObjectException("role:" + role + " isn't exist");
            }
            this.grantOptionCheck(privilege, grantorPrincipal, pm);
            this.privilegeOperator.grantPrivilege(privilege, mRole, pm);
            CommitContext commitContext = this.delegate.commitUpdateTransaction(pm);
            rollbackTransaction = false;
            CommitContext commitContext2 = commitContext;
            return commitContext2;
        }
        finally {
            if (rollbackTransaction) {
                this.rollbackTransaction(pm);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommitContext alterRoleRevokePrivilege(String component, String role, PrivilegeObject privilege, String grantorPrincipal) throws SentryUserException {
        role = this.toTrimedLower(role);
        PersistenceManager pm = null;
        boolean rollbackTransaction = true;
        try {
            pm = this.openTransaction();
            MSentryRole mRole = this.getRole(role, pm);
            if (mRole == null) {
                throw new SentryNoSuchObjectException("role:" + role + " isn't exist");
            }
            this.grantOptionCheck(privilege, grantorPrincipal, pm);
            this.privilegeOperator.revokePrivilege(privilege, mRole, pm);
            CommitContext commitContext = this.commitUpdateTransaction(pm);
            rollbackTransaction = false;
            CommitContext commitContext2 = commitContext;
            return commitContext2;
        }
        finally {
            if (rollbackTransaction) {
                this.rollbackTransaction(pm);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommitContext renamePrivilege(String component, String service, List<? extends Authorizable> oldAuthorizables, List<? extends Authorizable> newAuthorizables, String requestor) throws SentryUserException {
        Preconditions.checkNotNull((Object)component);
        Preconditions.checkNotNull((Object)service);
        Preconditions.checkNotNull(oldAuthorizables);
        Preconditions.checkNotNull(newAuthorizables);
        if (oldAuthorizables.size() != newAuthorizables.size()) {
            throw new SentryAccessDeniedException("rename privilege denied: the size of oldAuthorizables must equals the newAuthorizables oldAuthorizables:" + Arrays.toString(oldAuthorizables.toArray()) + " " + "newAuthorizables:" + Arrays.toString(newAuthorizables.toArray()));
        }
        PersistenceManager pm = null;
        boolean rollbackTransaction = true;
        try {
            pm = this.openTransaction();
            this.privilegeOperator.renamePrivilege(this.toTrimedLower(component), this.toTrimedLower(service), oldAuthorizables, newAuthorizables, requestor, pm);
            CommitContext commitContext = this.commitUpdateTransaction(pm);
            rollbackTransaction = false;
            CommitContext commitContext2 = commitContext;
            return commitContext2;
        }
        finally {
            if (rollbackTransaction) {
                this.rollbackTransaction(pm);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommitContext dropPrivilege(String component, PrivilegeObject privilege, String requestor) throws SentryUserException {
        Preconditions.checkNotNull((Object)requestor);
        PersistenceManager pm = null;
        boolean rollbackTransaction = true;
        try {
            pm = this.openTransaction();
            this.privilegeOperator.dropPrivilege(privilege, pm);
            CommitContext commitContext = this.commitUpdateTransaction(pm);
            rollbackTransaction = false;
            CommitContext commitContext2 = commitContext;
            return commitContext2;
        }
        finally {
            if (rollbackTransaction) {
                this.rollbackTransaction(pm);
            }
        }
    }

    private void grantOptionCheck(PrivilegeObject requestPrivilege, String grantorPrincipal, PersistenceManager pm) throws SentryUserException {
        if (Strings.isNullOrEmpty((String)grantorPrincipal)) {
            throw new SentryInvalidInputException("grantorPrincipal should not be null or empty");
        }
        Set<String> groups = this.getRequestorGroups(grantorPrincipal);
        if (groups == null || groups.isEmpty()) {
            throw new SentryGrantDeniedException(grantorPrincipal + " has no grant!");
        }
        if (!Sets.intersection(this.adminGroups, this.toTrimedLower(groups)).isEmpty()) {
            return;
        }
        Set<MSentryRole> mRoles = this.delegate.getRolesForGroups(pm, groups);
        if (!this.privilegeOperator.checkPrivilegeOption(mRoles, requestPrivilege, pm)) {
            throw new SentryGrantDeniedException(grantorPrincipal + " has no grant!");
        }
    }

    @Override
    public Set<String> getRolesByGroups(String component, Set<String> groups) throws SentryUserException {
        HashSet roles = Sets.newHashSet();
        if (groups == null) {
            return roles;
        }
        for (TSentryRole tSentryRole : this.delegate.getTSentryRolesByGroupName(groups, true)) {
            roles.add(tSentryRole.getRoleName());
        }
        return roles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getGroupsByRoles(String component, Set<String> roles) throws SentryUserException {
        roles = this.toTrimedLower(roles);
        HashSet groupNames = Sets.newHashSet();
        if (roles.size() == 0) {
            return groupNames;
        }
        PersistenceManager pm = null;
        try {
            pm = this.openTransaction();
            Query query = pm.newQuery(MSentryGroup.class);
            StringBuilder filters = new StringBuilder();
            query.declareVariables("org.apache.sentry.provider.db.service.model.MSentryRole role");
            LinkedList<String> rolesFiler = new LinkedList<String>();
            for (String hashSet : roles) {
                rolesFiler.add("role.roleName == \"" + hashSet + "\" ");
            }
            filters.append("roles.contains(role) && (" + Joiner.on((String)" || ").join(rolesFiler) + ")");
            query.setFilter(filters.toString());
            List groups = (List)query.execute();
            if (groups == null) {
                HashSet hashSet = groupNames;
                return hashSet;
            }
            for (MSentryGroup group : groups) {
                groupNames.add(group.getGroupName());
            }
            HashSet hashSet = groupNames;
            return hashSet;
        }
        finally {
            this.commitTransaction(pm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<PrivilegeObject> getPrivilegesByRole(String component, Set<String> roles) throws SentryUserException {
        Preconditions.checkNotNull(roles);
        HashSet privileges = Sets.newHashSet();
        if (roles.isEmpty()) {
            return privileges;
        }
        PersistenceManager pm = null;
        try {
            pm = this.openTransaction();
            HashSet mRoles = Sets.newHashSet();
            for (String role : roles) {
                MSentryRole mRole = this.getRole(this.toTrimedLower(role), pm);
                if (mRole == null) continue;
                mRoles.add(mRole);
            }
            privileges.addAll(this.privilegeOperator.getPrivilegesByRole(mRoles, pm));
        }
        finally {
            this.commitTransaction(pm);
        }
        return privileges;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<PrivilegeObject> getPrivilegesByProvider(String component, String service, Set<String> roles, Set<String> groups, List<? extends Authorizable> authorizables) throws SentryUserException {
        Preconditions.checkNotNull((Object)component);
        Preconditions.checkNotNull((Object)service);
        component = this.toTrimedLower(component);
        service = this.toTrimedLower(service);
        HashSet privileges = Sets.newHashSet();
        PersistenceManager pm = null;
        try {
            pm = this.openTransaction();
            roles = this.toTrimedLower(roles);
            if (groups != null) {
                roles.addAll(this.delegate.getRoleNamesForGroups(groups));
            }
            if (roles.size() == 0) {
                HashSet hashSet = privileges;
                return hashSet;
            }
            HashSet mRoles = Sets.newHashSet();
            for (String role : roles) {
                MSentryRole mRole = this.getRole(role, pm);
                if (mRole == null) continue;
                mRoles.add(mRole);
            }
            privileges.addAll(this.privilegeOperator.getPrivilegesByProvider(component, service, mRoles, authorizables, pm));
        }
        finally {
            this.commitTransaction(pm);
        }
        return privileges;
    }

    @Override
    public void close() {
        this.delegate.stop();
    }

    private Set<TSentryGroup> toTSentryGroups(Set<String> groups) {
        HashSet tSentryGroups = Sets.newHashSet();
        for (String group : this.toTrimedLower(groups)) {
            tSentryGroups.add(new TSentryGroup(group));
        }
        return tSentryGroups;
    }

    private Set<String> toTrimedLower(Set<String> s) {
        if (s == null) {
            return new HashSet<String>();
        }
        HashSet result = Sets.newHashSet();
        for (String v : s) {
            result.add(v.trim().toLowerCase());
        }
        return result;
    }

    private String toTrimedLower(String s) {
        if (s == null) {
            return "";
        }
        return s.trim().toLowerCase();
    }

    private Set<String> getRequestorGroups(String userName) throws SentryUserException {
        return SentryPolicyStoreProcessor.getGroupsFromUserName(this.conf, userName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void clearAllTables() {
        boolean rollbackTransaction = true;
        PersistenceManager pm = null;
        try {
            pm = this.openTransaction();
            pm.newQuery(MSentryRole.class).deletePersistentAll();
            pm.newQuery(MSentryGroup.class).deletePersistentAll();
            pm.newQuery(MSentryGMPrivilege.class).deletePersistentAll();
            this.commitUpdateTransaction(pm);
            rollbackTransaction = false;
        }
        finally {
            if (rollbackTransaction) {
                this.rollbackTransaction(pm);
            }
        }
    }
}

