/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.sentry.core.common.ActiveRoleSet;
import org.apache.sentry.core.common.Authorizable;
import org.apache.sentry.core.common.SentryConfigurationException;
import org.apache.sentry.provider.common.ProviderBackend;
import org.apache.sentry.provider.common.ProviderBackendContext;
import org.apache.sentry.provider.db.service.thrift.SentryPolicyServiceClient;
import org.apache.sentry.service.thrift.SentryServiceClientFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleDBProviderBackend
implements ProviderBackend {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleDBProviderBackend.class);
    private SentryPolicyServiceClient policyServiceClient;
    private volatile boolean initialized = false;
    private Configuration conf;

    public SimpleDBProviderBackend(Configuration conf, String resourcePath) throws Exception {
        this(conf);
    }

    public SimpleDBProviderBackend(Configuration conf) throws Exception {
        this(SentryServiceClientFactory.create(conf));
        this.initialized = false;
        this.conf = conf;
    }

    @VisibleForTesting
    public SimpleDBProviderBackend(SentryPolicyServiceClient policyServiceClient) throws IOException {
        this.policyServiceClient = policyServiceClient;
    }

    public void initialize(ProviderBackendContext context) {
        if (this.initialized) {
            throw new IllegalStateException("Backend has already been initialized, cannot be initialized twice");
        }
        this.initialized = true;
    }

    public ImmutableSet<String> getPrivileges(Set<String> groups, ActiveRoleSet roleSet, Authorizable ... authorizableHierarchy) {
        return this.getPrivileges(1, groups, roleSet, authorizableHierarchy);
    }

    private ImmutableSet<String> getPrivileges(int retryCount, Set<String> groups, ActiveRoleSet roleSet, Authorizable ... authorizableHierarchy) {
        if (!this.initialized) {
            throw new IllegalStateException("Backend has not been properly initialized");
        }
        try {
            return ImmutableSet.copyOf(this.getSentryClient().listPrivilegesForProvider(groups, roleSet, authorizableHierarchy));
        }
        catch (Exception e) {
            this.policyServiceClient = null;
            if (retryCount > 0) {
                return this.getPrivileges(retryCount - 1, groups, roleSet, authorizableHierarchy);
            }
            String msg = "Unable to obtain privileges from server: " + e.getMessage();
            LOGGER.error(msg, (Throwable)e);
            try {
                this.policyServiceClient.close();
            }
            catch (Exception ex2) {
                // empty catch block
            }
            return ImmutableSet.of();
        }
    }

    public ImmutableSet<String> getRoles(Set<String> groups, ActiveRoleSet roleSet) {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    public void close() {
        if (this.policyServiceClient != null) {
            this.policyServiceClient.close();
        }
    }

    private SentryPolicyServiceClient getSentryClient() {
        if (this.policyServiceClient == null) {
            try {
                this.policyServiceClient = SentryServiceClientFactory.create(this.conf);
            }
            catch (Exception e) {
                LOGGER.error("Error connecting to Sentry ['{}'] !!", (Object)e.getMessage());
                this.policyServiceClient = null;
                return null;
            }
        }
        return this.policyServiceClient;
    }

    public void validatePolicy(boolean strictValidation) throws SentryConfigurationException {
        if (!this.initialized) {
            throw new IllegalStateException("Backend has not been properly initialized");
        }
    }
}

