/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.service.thrift;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import java.io.File;
import java.security.PrivilegedExceptionAction;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.login.LoginContext;
import org.apache.commons.io.FileUtils;
import org.apache.curator.test.TestingServer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.minikdc.MiniKdc;
import org.apache.hadoop.net.NetUtils;
import org.apache.sentry.provider.db.service.thrift.SentryMiniKdcTestcase;
import org.apache.sentry.provider.db.service.thrift.SentryPolicyServiceClient;
import org.apache.sentry.provider.db.service.thrift.TSentryRole;
import org.apache.sentry.provider.file.PolicyFile;
import org.apache.sentry.service.thrift.JaasConfiguration;
import org.apache.sentry.service.thrift.KerberosConfiguration;
import org.apache.sentry.service.thrift.SentryService;
import org.apache.sentry.service.thrift.SentryServiceClientFactory;
import org.apache.sentry.service.thrift.SentryServiceFactory;
import org.apache.sentry.service.thrift.Status;
import org.apache.sentry.service.thrift.TSentryResponseStatus;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SentryServiceIntegrationBase
extends SentryMiniKdcTestcase {
    private static final Logger LOGGER = LoggerFactory.getLogger(SentryServiceIntegrationBase.class);
    protected static final String SERVER_HOST;
    protected static final String REALM = "EXAMPLE.COM";
    protected static final String SERVER_PRINCIPAL;
    protected static String SERVER_KERBEROS_NAME;
    protected static final String HTTP_PRINCIPAL;
    protected static final String CLIENT_PRINCIPAL;
    protected static final String CLIENT_KERBEROS_SHORT_NAME = "hive";
    protected static final String CLIENT_KERBEROS_NAME;
    protected static final String ADMIN_USER = "admin_user";
    protected static final String ADMIN_GROUP = "admin_group";
    protected static SentryService server;
    protected SentryPolicyServiceClient client;
    protected static MiniKdc kdc;
    protected static File kdcWorkDir;
    protected static File dbDir;
    protected static File serverKeytab;
    protected static File httpKeytab;
    protected static File clientKeytab;
    protected static Subject clientSubject;
    protected static LoginContext clientLoginContext;
    protected static boolean kerberos;
    protected static final Configuration conf;
    protected PolicyFile policyFile;
    protected File policyFilePath;
    protected static Properties kdcConfOverlay;
    protected static boolean haEnabled;
    protected static final String ZK_SERVER_PRINCIPAL;
    protected static TestingServer zkServer;
    private static File ZKKeytabFile;
    protected static boolean webServerEnabled;
    protected static int webServerPort;
    protected static boolean webSecurity;
    protected static boolean pooled;

    @BeforeClass
    public static void setup() throws Exception {
        kerberos = true;
        pooled = true;
        SentryServiceIntegrationBase.beforeSetup();
        SentryServiceIntegrationBase.setupConf();
        SentryServiceIntegrationBase.startSentryService();
        SentryServiceIntegrationBase.afterSetup();
    }

    private static void setupKdc() throws Exception {
        SentryServiceIntegrationBase.startMiniKdc(kdcConfOverlay);
    }

    public static void startSentryService() throws Exception {
        server.start();
        long start = System.currentTimeMillis();
        while (!server.isRunning()) {
            Thread.sleep(1000L);
            if (System.currentTimeMillis() - start <= 60000L) continue;
            throw new TimeoutException("Server did not start after 60 seconds");
        }
    }

    public void stopSentryService() throws Exception {
        server.stop();
        Thread.sleep(30000L);
    }

    public static void setupConf() throws Exception {
        if (kerberos) {
            SentryServiceIntegrationBase.setupKdc();
            kdc = SentryServiceIntegrationBase.getKdc();
            kdcWorkDir = SentryServiceIntegrationBase.getWorkDir();
            serverKeytab = new File(kdcWorkDir, "server.keytab");
            clientKeytab = new File(kdcWorkDir, "client.keytab");
            kdc.createPrincipal(serverKeytab, new String[]{SERVER_PRINCIPAL});
            kdc.createPrincipal(clientKeytab, new String[]{CLIENT_PRINCIPAL});
            conf.set("sentry.service.server.principal", SentryServiceIntegrationBase.getServerKerberosName());
            conf.set("sentry.service.server.keytab", serverKeytab.getPath());
            conf.set("sentry.service.allow.connect", CLIENT_KERBEROS_SHORT_NAME);
            conf.set("sentry.zookeeper.client.principal", SentryServiceIntegrationBase.getServerKerberosName());
            conf.set("sentry.zookeeper.client.keytab", serverKeytab.getPath());
            conf.set("sentry.service.security.use.ugi", "false");
            clientSubject = new Subject(false, Sets.newHashSet((Object[])new KerberosPrincipal[]{new KerberosPrincipal(CLIENT_KERBEROS_NAME)}), new HashSet(), new HashSet());
            clientLoginContext = new LoginContext("", clientSubject, null, KerberosConfiguration.createClientConfig((String)CLIENT_KERBEROS_NAME, (File)clientKeytab));
            clientLoginContext.login();
            clientSubject = clientLoginContext.getSubject();
        } else {
            LOGGER.info("Stopped KDC");
            conf.set("sentry.service.security.mode", "none");
        }
        if (haEnabled) {
            zkServer = SentryServiceIntegrationBase.getZKServer();
            conf.set("sentry.ha.enabled", "true");
            conf.set("sentry.ha.zookeeper.quorum", zkServer.getConnectString());
            conf.set("sentry.ha.zookeeper.namespace", "sentry-test-case");
            if (kerberos) {
                conf.set("sentry.ha.zookeeper.security", "true");
            }
        }
        if (webServerEnabled) {
            conf.set("sentry.service.web.enable", "true");
            conf.set("sentry.service.web.port", String.valueOf(webServerPort));
            if (webSecurity) {
                httpKeytab = new File(kdcWorkDir, "http.keytab");
                kdc.createPrincipal(httpKeytab, new String[]{HTTP_PRINCIPAL});
                conf.set("sentry.service.web.authentication.type", "KERBEROS");
                conf.set("sentry.service.web.authentication.kerberos.principal", HTTP_PRINCIPAL);
                conf.set("sentry.service.web.authentication.kerberos.keytab", httpKeytab.getPath());
            } else {
                conf.set("sentry.service.web.authentication.type", "NONE");
            }
        } else {
            conf.set("sentry.service.web.enable", "false");
        }
        if (pooled) {
            conf.set("sentry.service.client.connection.pool.enabled", "true");
        }
        conf.set("sentry.verify.schema.version", "false");
        conf.set("sentry.service.admin.group", ADMIN_GROUP);
        conf.set("sentry.service.server.rpc-address", SERVER_HOST);
        conf.set("sentry.service.server.rpc-port", String.valueOf(0));
        dbDir = new File(Files.createTempDir(), "sentry_policy_db");
        conf.set("sentry.store.jdbc.url", "jdbc:derby:;databaseName=" + dbDir.getPath() + ";create=true");
        conf.set("sentry.store.jdbc.password", "dummy");
        server = new SentryServiceFactory().create(conf);
        conf.set("sentry.service.client.server.rpc-address", server.getAddress().getHostName());
        conf.set("sentry.service.client.server.rpc-port", String.valueOf(server.getAddress().getPort()));
        conf.set("sentry.store.group.mapping", "org.apache.sentry.provider.file.LocalGroupMappingService");
    }

    @Before
    public void before() throws Exception {
        this.policyFilePath = new File(dbDir, "local_policy_file.ini");
        conf.set("sentry.store.group.mapping.resource", this.policyFilePath.getPath());
        this.policyFile = new PolicyFile();
        this.connectToSentryService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void after() {
        try {
            this.runTestAsSubject(new TestOperation(){

                @Override
                public void runTestAsSubject() throws Exception {
                    if (SentryServiceIntegrationBase.this.client != null) {
                        Set tRoles = SentryServiceIntegrationBase.this.client.listRoles(SentryServiceIntegrationBase.ADMIN_USER);
                        if (tRoles != null) {
                            for (TSentryRole tRole : tRoles) {
                                SentryServiceIntegrationBase.this.client.dropRole(SentryServiceIntegrationBase.ADMIN_USER, tRole.getRoleName());
                            }
                        }
                        SentryServiceIntegrationBase.this.client.close();
                    }
                }
            });
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        finally {
            this.policyFilePath.delete();
        }
    }

    public void connectToSentryService() throws Exception {
        this.client = kerberos ? Subject.doAs(clientSubject, new PrivilegedExceptionAction<SentryPolicyServiceClient>(){

            @Override
            public SentryPolicyServiceClient run() throws Exception {
                return SentryServiceClientFactory.create((Configuration)conf);
            }
        }) : SentryServiceClientFactory.create((Configuration)conf);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        SentryServiceIntegrationBase.beforeTeardown();
        if (clientLoginContext != null) {
            try {
                clientLoginContext.logout();
            }
            catch (Exception e) {
                LOGGER.warn("Error logging client out", (Throwable)e);
            }
        }
        if (server != null) {
            server.stop();
        }
        if (dbDir != null) {
            FileUtils.deleteQuietly((File)dbDir);
        }
        SentryServiceIntegrationBase.stopMiniKdc();
        SentryServiceIntegrationBase.afterTeardown();
    }

    public static String getServerKerberosName() {
        return SERVER_KERBEROS_NAME;
    }

    public static void beforeSetup() throws Exception {
    }

    public static void afterSetup() throws Exception {
    }

    public static void beforeTeardown() throws Exception {
    }

    public static void afterTeardown() throws Exception {
    }

    protected static void assertOK(TSentryResponseStatus resp) {
        SentryServiceIntegrationBase.assertStatus(Status.OK, resp);
    }

    protected static void assertStatus(Status status, TSentryResponseStatus resp) {
        if (resp.getValue() != status.getCode()) {
            String message = "Expected: " + status + ", Response: " + Status.fromCode((int)resp.getValue()) + ", Code: " + resp.getValue() + ", Message: " + resp.getMessage();
            String stackTrace = Strings.nullToEmpty((String)resp.getStack()).trim();
            if (!stackTrace.isEmpty()) {
                message = message + ", StackTrace: " + stackTrace;
            }
            Assert.fail((String)message);
        }
    }

    protected void setLocalGroupMapping(String user, Set<String> groupSet) {
        for (String group : groupSet) {
            this.policyFile.addGroupsToUser(user, new String[]{group});
        }
    }

    protected void writePolicyFile() throws Exception {
        this.policyFile.write(this.policyFilePath);
    }

    protected static TestingServer getZKServer() throws Exception {
        if (!kerberos) {
            LOGGER.info("Creating a non-security ZooKeeper Server.");
            return new TestingServer();
        }
        LOGGER.info("Creating a security ZooKeeper Server.");
        System.setProperty("javax.security.auth.useSubjectCredsOnly", "false");
        kdc = SentryServiceIntegrationBase.getKdc();
        ZKKeytabFile = new File(kdcWorkDir, "test.keytab");
        kdc.createPrincipal(ZKKeytabFile, new String[]{ZK_SERVER_PRINCIPAL});
        System.setProperty("zookeeper.authProvider.1", "org.apache.zookeeper.server.auth.SASLAuthenticationProvider");
        System.setProperty("zookeeper.kerberos.removeHostFromPrincipal", "true");
        System.setProperty("zookeeper.kerberos.removeRealmFromPrincipal", "true");
        JaasConfiguration.addEntryForKeytab((String)"Server", (String)ZK_SERVER_PRINCIPAL, (String)ZKKeytabFile.getAbsolutePath());
        JaasConfiguration.addEntryForKeytab((String)"SentryClient", (String)SERVER_KERBEROS_NAME, (String)serverKeytab.getAbsolutePath());
        javax.security.auth.login.Configuration.setConfiguration(JaasConfiguration.getInstance());
        System.setProperty("zookeeper.sasl.serverconfig", "Server");
        return new TestingServer();
    }

    protected void runTestAsSubject(final TestOperation test) throws Exception {
        if (kerberos) {
            Subject.doAs(clientSubject, new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    test.runTestAsSubject();
                    return null;
                }
            });
        } else {
            test.runTestAsSubject();
        }
    }

    static {
        if (System.getProperty("sun.security.krb5.debug", "").trim().isEmpty()) {
            System.setProperty("sun.security.krb5.debug", String.valueOf("true"));
        }
        SERVER_HOST = NetUtils.createSocketAddr((String)"localhost:80").getAddress().getCanonicalHostName();
        SERVER_PRINCIPAL = "sentry/" + SERVER_HOST;
        SERVER_KERBEROS_NAME = "sentry/" + SERVER_HOST + "@" + REALM;
        HTTP_PRINCIPAL = "HTTP/" + SERVER_HOST;
        CLIENT_PRINCIPAL = "hive/" + SERVER_HOST;
        CLIENT_KERBEROS_NAME = "hive/" + SERVER_HOST + "@" + REALM;
        conf = new Configuration(false);
        kdcConfOverlay = new Properties();
        haEnabled = false;
        ZK_SERVER_PRINCIPAL = "zookeeper/" + SERVER_HOST;
        webServerEnabled = false;
        webServerPort = 51000;
        webSecurity = false;
        pooled = false;
    }

    protected static interface TestOperation {
        public void runTestAsSubject() throws Exception;
    }
}

