/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.service.thrift;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.sentry.core.common.ActiveRoleSet;
import org.apache.sentry.core.model.db.AccessURI;
import org.apache.sentry.core.model.db.DBModelAuthorizable;
import org.apache.sentry.core.model.db.Database;
import org.apache.sentry.core.model.db.Server;
import org.apache.sentry.core.model.db.Table;
import org.apache.sentry.provider.db.SentryAccessDeniedException;
import org.apache.sentry.provider.db.service.thrift.SentryPolicyServiceClientDefaultImpl;
import org.apache.sentry.provider.db.service.thrift.TSentryGroup;
import org.apache.sentry.provider.db.service.thrift.TSentryPrivilege;
import org.apache.sentry.provider.db.service.thrift.TSentryPrivilegeMap;
import org.apache.sentry.provider.db.service.thrift.TSentryRole;
import org.apache.sentry.service.thrift.SentryServiceIntegrationBase;
import org.junit.Assert;
import org.junit.Test;

public class TestSentryServiceIntegration
extends SentryServiceIntegrationBase {
    @Test
    public void testCreateDropShowRole() throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            @Override
            public void runTestAsSubject() throws Exception {
                String requestorUserName = "admin_user";
                HashSet requestorUserGroupNames = Sets.newHashSet((Object[])new String[]{"admin_group"});
                String roleName = "admin_r";
                TestSentryServiceIntegration.this.setLocalGroupMapping(requestorUserName, requestorUserGroupNames);
                TestSentryServiceIntegration.this.writePolicyFile();
                TestSentryServiceIntegration.this.client.dropRoleIfExists(requestorUserName, roleName);
                TestSentryServiceIntegration.this.client.createRole(requestorUserName, roleName);
                Set roles = TestSentryServiceIntegration.this.client.listRoles(requestorUserName);
                junit.framework.Assert.assertEquals((String)"Incorrect number of roles", (int)1, (int)roles.size());
                for (TSentryRole role : roles) {
                    Assert.assertTrue((String)role.getRoleName(), (boolean)role.getRoleName().equalsIgnoreCase(roleName));
                }
                TestSentryServiceIntegration.this.client.dropRole(requestorUserName, roleName);
            }
        });
    }

    @Test
    public void testGranRevokePrivilegeOnTableForRole() throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            @Override
            public void runTestAsSubject() throws Exception {
                String requestorUserName = "admin_user";
                HashSet requestorUserGroupNames = Sets.newHashSet((Object[])new String[]{"admin_group"});
                TestSentryServiceIntegration.this.setLocalGroupMapping(requestorUserName, requestorUserGroupNames);
                TestSentryServiceIntegration.this.writePolicyFile();
                String roleName1 = "admin_r1";
                String roleName2 = "admin_r2";
                TestSentryServiceIntegration.this.client.dropRoleIfExists(requestorUserName, roleName1);
                TestSentryServiceIntegration.this.client.createRole(requestorUserName, roleName1);
                TestSentryServiceIntegration.this.client.grantTablePrivilege(requestorUserName, roleName1, "server", "db1", "table1", "ALL");
                TestSentryServiceIntegration.this.client.grantTablePrivilege(requestorUserName, roleName1, "server", "db1", "table2", "ALL");
                TestSentryServiceIntegration.this.client.grantTablePrivilege(requestorUserName, roleName1, "server", "db2", "table3", "ALL");
                TestSentryServiceIntegration.this.client.grantTablePrivilege(requestorUserName, roleName1, "server", "db2", "table4", "ALL");
                TestSentryServiceIntegration.this.client.dropRoleIfExists(requestorUserName, roleName2);
                TestSentryServiceIntegration.this.client.createRole(requestorUserName, roleName2);
                TestSentryServiceIntegration.this.client.grantTablePrivilege(requestorUserName, roleName2, "server", "db1", "table1", "ALL");
                TestSentryServiceIntegration.this.client.grantTablePrivilege(requestorUserName, roleName2, "server", "db1", "table2", "ALL");
                TestSentryServiceIntegration.this.client.grantTablePrivilege(requestorUserName, roleName2, "server", "db2", "table3", "ALL");
                TestSentryServiceIntegration.this.client.grantTablePrivilege(requestorUserName, roleName2, "server", "db2", "table4", "ALL");
                Set listPrivilegesByRoleName = TestSentryServiceIntegration.this.client.listAllPrivilegesByRoleName(requestorUserName, roleName1);
                junit.framework.Assert.assertEquals((String)"Privilege not assigned to role1 !!", (int)4, (int)listPrivilegesByRoleName.size());
                listPrivilegesByRoleName = TestSentryServiceIntegration.this.client.listAllPrivilegesByRoleName(requestorUserName, roleName2);
                junit.framework.Assert.assertEquals((String)"Privilege not assigned to role2 !!", (int)4, (int)listPrivilegesByRoleName.size());
                TestSentryServiceIntegration.this.client.revokeTablePrivilege(requestorUserName, roleName1, "server", "db1", "table1", "ALL");
                listPrivilegesByRoleName = TestSentryServiceIntegration.this.client.listAllPrivilegesByRoleName(requestorUserName, roleName1);
                Assert.assertTrue((String)"Privilege not correctly revoked !!", (listPrivilegesByRoleName.size() == 3 ? 1 : 0) != 0);
                listPrivilegesByRoleName = TestSentryServiceIntegration.this.client.listAllPrivilegesByRoleName(requestorUserName, roleName2);
                Assert.assertTrue((String)"Privilege not correctly revoked !!", (listPrivilegesByRoleName.size() == 4 ? 1 : 0) != 0);
                TestSentryServiceIntegration.this.client.revokeTablePrivilege(requestorUserName, roleName2, "server", "db1", "table1", "ALL");
                listPrivilegesByRoleName = TestSentryServiceIntegration.this.client.listAllPrivilegesByRoleName(requestorUserName, roleName2);
                Assert.assertTrue((String)"Privilege not correctly revoked !!", (listPrivilegesByRoleName.size() == 3 ? 1 : 0) != 0);
                listPrivilegesByRoleName = TestSentryServiceIntegration.this.client.listAllPrivilegesByRoleName(requestorUserName, roleName1);
                Assert.assertTrue((String)"Privilege not correctly revoked !!", (listPrivilegesByRoleName.size() == 3 ? 1 : 0) != 0);
                TestSentryServiceIntegration.this.client.revokeTablePrivilege(requestorUserName, roleName1, "server", "db1", "table2", "ALL");
                TestSentryServiceIntegration.this.client.revokeTablePrivilege(requestorUserName, roleName1, "server", "db2", "table3", "ALL");
                TestSentryServiceIntegration.this.client.revokeTablePrivilege(requestorUserName, roleName1, "server", "db2", "table4", "ALL");
                listPrivilegesByRoleName = TestSentryServiceIntegration.this.client.listAllPrivilegesByRoleName(requestorUserName, roleName1);
                Assert.assertTrue((String)"Privilege not correctly revoked !!", (listPrivilegesByRoleName.size() == 0 ? 1 : 0) != 0);
                TestSentryServiceIntegration.this.client.revokeTablePrivilege(requestorUserName, roleName2, "server", "db1", "table2", "ALL");
                TestSentryServiceIntegration.this.client.revokeTablePrivilege(requestorUserName, roleName2, "server", "db2", "table3", "ALL");
                TestSentryServiceIntegration.this.client.revokeTablePrivilege(requestorUserName, roleName2, "server", "db2", "table4", "ALL");
                listPrivilegesByRoleName = TestSentryServiceIntegration.this.client.listAllPrivilegesByRoleName(requestorUserName, roleName2);
                Assert.assertTrue((String)"Privilege not correctly revoked !!", (listPrivilegesByRoleName.size() == 0 ? 1 : 0) != 0);
            }
        });
    }

    @Test
    public void testMultipleRolesSamePrivilege() throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            @Override
            public void runTestAsSubject() throws Exception {
                String requestorUserName = "admin_user";
                HashSet requestorUserGroupNames = Sets.newHashSet((Object[])new String[]{"admin_group"});
                TestSentryServiceIntegration.this.setLocalGroupMapping(requestorUserName, requestorUserGroupNames);
                TestSentryServiceIntegration.this.writePolicyFile();
                String roleName1 = "admin_r1";
                String roleName2 = "admin_r2";
                TestSentryServiceIntegration.this.client.dropRoleIfExists(requestorUserName, roleName1);
                TestSentryServiceIntegration.this.client.createRole(requestorUserName, roleName1);
                TestSentryServiceIntegration.this.client.dropRoleIfExists(requestorUserName, roleName2);
                TestSentryServiceIntegration.this.client.createRole(requestorUserName, roleName2);
                TestSentryServiceIntegration.this.client.grantTablePrivilege(requestorUserName, roleName1, "server", "db", "table", "ALL");
                Set listPrivilegesByRoleName = TestSentryServiceIntegration.this.client.listAllPrivilegesByRoleName(requestorUserName, roleName1);
                Assert.assertTrue((String)"Privilege not assigned to role1 !!", (listPrivilegesByRoleName.size() == 1 ? 1 : 0) != 0);
                TestSentryServiceIntegration.this.client.grantTablePrivilege(requestorUserName, roleName2, "server", "db", "table", "ALL");
                listPrivilegesByRoleName = TestSentryServiceIntegration.this.client.listAllPrivilegesByRoleName(requestorUserName, roleName2);
                Assert.assertTrue((String)"Privilege not assigned to role2 !!", (listPrivilegesByRoleName.size() == 1 ? 1 : 0) != 0);
            }
        });
    }

    @Test
    public void testShowRoleGrant() throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            @Override
            public void runTestAsSubject() throws Exception {
                String requestorUserName = "admin_user";
                HashSet requestorUserGroupNames = Sets.newHashSet((Object[])new String[]{"admin_group"});
                String roleName = "admin_testdb";
                String groupName = "group1";
                TestSentryServiceIntegration.this.setLocalGroupMapping(requestorUserName, requestorUserGroupNames);
                TestSentryServiceIntegration.this.writePolicyFile();
                TestSentryServiceIntegration.this.client.dropRoleIfExists(requestorUserName, roleName);
                TestSentryServiceIntegration.this.client.createRole(requestorUserName, roleName);
                Set roles = TestSentryServiceIntegration.this.client.listRoles(requestorUserName);
                junit.framework.Assert.assertEquals((String)"Incorrect number of roles", (int)1, (int)roles.size());
                TestSentryServiceIntegration.this.client.grantRoleToGroup(requestorUserName, groupName, roleName);
                Set groupRoles = TestSentryServiceIntegration.this.client.listRolesByGroupName(requestorUserName, groupName);
                Assert.assertTrue((groupRoles.size() == 1 ? 1 : 0) != 0);
                for (TSentryRole role : groupRoles) {
                    Assert.assertTrue((String)role.getRoleName(), (boolean)role.getRoleName().equalsIgnoreCase(roleName));
                    Assert.assertTrue((role.getGroups().size() == 1 ? 1 : 0) != 0);
                    for (TSentryGroup group : role.getGroups()) {
                        Assert.assertTrue((String)group.getGroupName(), (boolean)group.getGroupName().equalsIgnoreCase(groupName));
                    }
                }
                TestSentryServiceIntegration.this.client.dropRole(requestorUserName, roleName);
            }
        });
    }

    @Test
    public void testShowGrant() throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            @Override
            public void runTestAsSubject() throws Exception {
                String requestorUserName = "admin_user";
                HashSet requestorUserGroupNames = Sets.newHashSet((Object[])new String[]{"admin_group"});
                String roleName = "admin_testdb";
                String server = "server1";
                String db = "testDB";
                TestSentryServiceIntegration.this.setLocalGroupMapping(requestorUserName, requestorUserGroupNames);
                TestSentryServiceIntegration.this.writePolicyFile();
                TestSentryServiceIntegration.this.client.dropRoleIfExists(requestorUserName, roleName);
                TestSentryServiceIntegration.this.client.createRole(requestorUserName, roleName);
                Set roles = TestSentryServiceIntegration.this.client.listRoles(requestorUserName);
                junit.framework.Assert.assertEquals((String)"Incorrect number of roles", (int)1, (int)roles.size());
                TestSentryServiceIntegration.this.client.grantDatabasePrivilege(requestorUserName, roleName, server, db, "*");
                Set privileges = TestSentryServiceIntegration.this.client.listAllPrivilegesByRoleName(requestorUserName, roleName);
                Assert.assertTrue((privileges.size() == 1 ? 1 : 0) != 0);
                TestSentryServiceIntegration.this.client.revokeDatabasePrivilege(requestorUserName, roleName, server, db, "*");
                TestSentryServiceIntegration.this.client.dropRole(requestorUserName, roleName);
            }
        });
    }

    @Test
    public void testUriWithEquals() throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            @Override
            public void runTestAsSubject() throws Exception {
                String requestorUserName = "admin_user";
                HashSet requestorUserGroupNames = Sets.newHashSet((Object[])new String[]{"admin_group"});
                String roleName = "admin_testdb";
                String server = "server1";
                String uri = "file://u/w/h/t/partition=value/";
                TestSentryServiceIntegration.this.setLocalGroupMapping(requestorUserName, requestorUserGroupNames);
                TestSentryServiceIntegration.this.writePolicyFile();
                TestSentryServiceIntegration.this.client.dropRoleIfExists(requestorUserName, roleName);
                TestSentryServiceIntegration.this.client.createRole(requestorUserName, roleName);
                Set roles = TestSentryServiceIntegration.this.client.listRoles(requestorUserName);
                junit.framework.Assert.assertEquals((String)"Incorrect number of roles", (int)1, (int)roles.size());
                TestSentryServiceIntegration.this.client.grantURIPrivilege(requestorUserName, roleName, server, uri);
                Set privileges = TestSentryServiceIntegration.this.client.listAllPrivilegesByRoleName(requestorUserName, roleName);
                Assert.assertTrue((privileges.size() == 1 ? 1 : 0) != 0);
                TestSentryServiceIntegration.this.client.revokeURIPrivilege(requestorUserName, roleName, server, uri);
                privileges = TestSentryServiceIntegration.this.client.listAllPrivilegesByRoleName(requestorUserName, roleName);
                Assert.assertTrue((privileges.size() == 0 ? 1 : 0) != 0);
                TestSentryServiceIntegration.this.client.dropRole(requestorUserName, roleName);
            }
        });
    }

    @Test
    public void testSameGrantTwice() throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            @Override
            public void runTestAsSubject() throws Exception {
                String requestorUserName = "admin_user";
                HashSet requestorUserGroupNames = Sets.newHashSet((Object[])new String[]{"admin_group"});
                TestSentryServiceIntegration.this.setLocalGroupMapping(requestorUserName, requestorUserGroupNames);
                TestSentryServiceIntegration.this.writePolicyFile();
                String roleName = "admin_r1";
                TestSentryServiceIntegration.this.client.createRole(requestorUserName, roleName);
                TestSentryServiceIntegration.this.client.grantTablePrivilege(requestorUserName, roleName, "server", "db1", "table1", "ALL");
                TestSentryServiceIntegration.this.client.grantTablePrivilege(requestorUserName, roleName, "server", "db1", "table1", "ALL");
                junit.framework.Assert.assertEquals((int)1, (int)TestSentryServiceIntegration.this.client.listAllPrivilegesByRoleName(requestorUserName, roleName).size());
            }
        });
    }

    @Test
    public void testGrantRevokeWithGrantOption() throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            @Override
            public void runTestAsSubject() throws Exception {
                String requestorUserName = "admin_user";
                HashSet requestorUserGroupNames = Sets.newHashSet((Object[])new String[]{"admin_group"});
                TestSentryServiceIntegration.this.setLocalGroupMapping(requestorUserName, requestorUserGroupNames);
                TestSentryServiceIntegration.this.writePolicyFile();
                String roleName = "admin_r1";
                boolean grantOption = true;
                boolean withoutGrantOption = false;
                TestSentryServiceIntegration.this.client.dropRoleIfExists(requestorUserName, roleName);
                TestSentryServiceIntegration.this.client.createRole(requestorUserName, roleName);
                TestSentryServiceIntegration.this.client.grantTablePrivilege(requestorUserName, roleName, "server", "db1", "table1", "ALL", Boolean.valueOf(grantOption));
                junit.framework.Assert.assertEquals((int)1, (int)TestSentryServiceIntegration.this.client.listAllPrivilegesByRoleName(requestorUserName, roleName).size());
                TestSentryServiceIntegration.this.client.revokeTablePrivilege(requestorUserName, roleName, "server", "db1", "table1", "ALL", Boolean.valueOf(withoutGrantOption));
                junit.framework.Assert.assertEquals((int)1, (int)TestSentryServiceIntegration.this.client.listAllPrivilegesByRoleName(requestorUserName, roleName).size());
                TestSentryServiceIntegration.this.client.revokeTablePrivilege(requestorUserName, roleName, "server", "db1", "table1", "ALL", Boolean.valueOf(grantOption));
                junit.framework.Assert.assertEquals((int)0, (int)TestSentryServiceIntegration.this.client.listAllPrivilegesByRoleName(requestorUserName, roleName).size());
            }
        });
    }

    @Test
    public void testGrantTwoPrivilegeDiffInGrantOption() throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            @Override
            public void runTestAsSubject() throws Exception {
                String requestorUserName = "admin_user";
                HashSet requestorUserGroupNames = Sets.newHashSet((Object[])new String[]{"admin_group"});
                TestSentryServiceIntegration.this.setLocalGroupMapping(requestorUserName, requestorUserGroupNames);
                TestSentryServiceIntegration.this.writePolicyFile();
                String roleName = "admin_r1";
                boolean grantOption = true;
                boolean withoutGrantOption = false;
                TestSentryServiceIntegration.this.client.dropRoleIfExists(requestorUserName, roleName);
                TestSentryServiceIntegration.this.client.createRole(requestorUserName, roleName);
                TestSentryServiceIntegration.this.client.grantTablePrivilege(requestorUserName, roleName, "server", "db1", "table1", "ALL", Boolean.valueOf(grantOption));
                junit.framework.Assert.assertEquals((int)1, (int)TestSentryServiceIntegration.this.client.listAllPrivilegesByRoleName(requestorUserName, roleName).size());
                TestSentryServiceIntegration.this.client.grantTablePrivilege(requestorUserName, roleName, "server", "db1", "table1", "ALL", Boolean.valueOf(withoutGrantOption));
                junit.framework.Assert.assertEquals((int)2, (int)TestSentryServiceIntegration.this.client.listAllPrivilegesByRoleName(requestorUserName, roleName).size());
                TestSentryServiceIntegration.this.client.revokeTablePrivilege(requestorUserName, roleName, "server", "db1", "table1", "ALL", null);
                junit.framework.Assert.assertEquals((int)0, (int)TestSentryServiceIntegration.this.client.listAllPrivilegesByRoleName(requestorUserName, roleName).size());
            }
        });
    }

    @Test
    public void testGranRevokePrivilegeOnColumnForRole() throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            @Override
            public void runTestAsSubject() throws Exception {
                String requestorUserName = "admin_user";
                HashSet requestorUserGroupNames = Sets.newHashSet((Object[])new String[]{"admin_group"});
                TestSentryServiceIntegration.this.setLocalGroupMapping(requestorUserName, requestorUserGroupNames);
                TestSentryServiceIntegration.this.writePolicyFile();
                String roleName1 = "admin_r1";
                String roleName2 = "admin_r2";
                TestSentryServiceIntegration.this.client.dropRoleIfExists(requestorUserName, roleName1);
                TestSentryServiceIntegration.this.client.createRole(requestorUserName, roleName1);
                TestSentryServiceIntegration.this.client.grantColumnPrivilege(requestorUserName, roleName1, "server", "db1", "table1", "col1", "ALL");
                TestSentryServiceIntegration.this.client.grantColumnPrivilege(requestorUserName, roleName1, "server", "db1", "table1", "col2", "ALL");
                TestSentryServiceIntegration.this.client.grantColumnPrivilege(requestorUserName, roleName1, "server", "db1", "table2", "col1", "ALL");
                TestSentryServiceIntegration.this.client.grantColumnPrivilege(requestorUserName, roleName1, "server", "db1", "table2", "col2", "ALL");
                TestSentryServiceIntegration.this.client.grantColumnPrivilege(requestorUserName, roleName1, "server", "db2", "table1", "col1", "ALL");
                TestSentryServiceIntegration.this.client.grantColumnPrivilege(requestorUserName, roleName1, "server", "db2", "table2", "col1", "ALL");
                TestSentryServiceIntegration.this.client.dropRoleIfExists(requestorUserName, roleName2);
                TestSentryServiceIntegration.this.client.createRole(requestorUserName, roleName2);
                TestSentryServiceIntegration.this.client.grantColumnPrivilege(requestorUserName, roleName2, "server", "db1", "table1", "col1", "ALL");
                TestSentryServiceIntegration.this.client.grantColumnPrivilege(requestorUserName, roleName2, "server", "db1", "table1", "col2", "ALL");
                TestSentryServiceIntegration.this.client.grantColumnPrivilege(requestorUserName, roleName2, "server", "db1", "table2", "col1", "ALL");
                TestSentryServiceIntegration.this.client.grantColumnPrivilege(requestorUserName, roleName2, "server", "db1", "table2", "col2", "ALL");
                TestSentryServiceIntegration.this.client.grantColumnPrivilege(requestorUserName, roleName2, "server", "db2", "table1", "col1", "ALL");
                TestSentryServiceIntegration.this.client.grantColumnPrivilege(requestorUserName, roleName2, "server", "db2", "table2", "col1", "ALL");
                Set listPrivilegesByRoleName = TestSentryServiceIntegration.this.client.listAllPrivilegesByRoleName(requestorUserName, roleName1);
                junit.framework.Assert.assertEquals((String)"Privilege not assigned to role1 !!", (int)6, (int)listPrivilegesByRoleName.size());
                listPrivilegesByRoleName = TestSentryServiceIntegration.this.client.listAllPrivilegesByRoleName(requestorUserName, roleName2);
                junit.framework.Assert.assertEquals((String)"Privilege not assigned to role2 !!", (int)6, (int)listPrivilegesByRoleName.size());
                TestSentryServiceIntegration.this.client.revokeColumnPrivilege(requestorUserName, roleName1, "server", "db1", "table1", "col1", "ALL");
                listPrivilegesByRoleName = TestSentryServiceIntegration.this.client.listAllPrivilegesByRoleName(requestorUserName, roleName1);
                Assert.assertTrue((String)"Privilege not correctly revoked !!", (listPrivilegesByRoleName.size() == 5 ? 1 : 0) != 0);
                listPrivilegesByRoleName = TestSentryServiceIntegration.this.client.listAllPrivilegesByRoleName(requestorUserName, roleName2);
                Assert.assertTrue((String)"Privilege not correctly revoked !!", (listPrivilegesByRoleName.size() == 6 ? 1 : 0) != 0);
                TestSentryServiceIntegration.this.client.revokeTablePrivilege(requestorUserName, roleName2, "server", "db1", "table1", "ALL");
                listPrivilegesByRoleName = TestSentryServiceIntegration.this.client.listAllPrivilegesByRoleName(requestorUserName, roleName2);
                Assert.assertTrue((String)"Privilege not correctly revoked !!", (listPrivilegesByRoleName.size() == 4 ? 1 : 0) != 0);
                listPrivilegesByRoleName = TestSentryServiceIntegration.this.client.listAllPrivilegesByRoleName(requestorUserName, roleName1);
                Assert.assertTrue((String)"Privilege not correctly revoked !!", (listPrivilegesByRoleName.size() == 5 ? 1 : 0) != 0);
                TestSentryServiceIntegration.this.client.revokeDatabasePrivilege(requestorUserName, roleName1, "server", "db1", "ALL");
                listPrivilegesByRoleName = TestSentryServiceIntegration.this.client.listAllPrivilegesByRoleName(requestorUserName, roleName1);
                Assert.assertTrue((String)"Privilege not correctly revoked !!", (listPrivilegesByRoleName.size() == 2 ? 1 : 0) != 0);
                TestSentryServiceIntegration.this.client.revokeColumnPrivilege(requestorUserName, roleName1, "server", "db2", "table1", "col1", "ALL");
                TestSentryServiceIntegration.this.client.revokeColumnPrivilege(requestorUserName, roleName1, "server", "db2", "table2", "col1", "ALL");
                listPrivilegesByRoleName = TestSentryServiceIntegration.this.client.listAllPrivilegesByRoleName(requestorUserName, roleName1);
                Assert.assertTrue((String)"Privilege not correctly revoked !!", (listPrivilegesByRoleName.size() == 0 ? 1 : 0) != 0);
                TestSentryServiceIntegration.this.client.revokeColumnPrivilege(requestorUserName, roleName2, "server", "db1", "table2", "col1", "ALL");
                TestSentryServiceIntegration.this.client.revokeColumnPrivilege(requestorUserName, roleName2, "server", "db1", "table2", "col2", "ALL");
                TestSentryServiceIntegration.this.client.revokeColumnPrivilege(requestorUserName, roleName2, "server", "db2", "table1", "col1", "ALL");
                TestSentryServiceIntegration.this.client.revokeColumnPrivilege(requestorUserName, roleName2, "server", "db2", "table2", "col1", "ALL");
                listPrivilegesByRoleName = TestSentryServiceIntegration.this.client.listAllPrivilegesByRoleName(requestorUserName, roleName2);
                Assert.assertTrue((String)"Privilege not correctly revoked !!", (listPrivilegesByRoleName.size() == 0 ? 1 : 0) != 0);
            }
        });
    }

    @Test
    public void testListByAuthDB() throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            @Override
            public void runTestAsSubject() throws Exception {
                String requestorUserName = "admin_user";
                HashSet requestorUserGroupNames = Sets.newHashSet((Object[])new String[]{"admin_group"});
                String roleName1 = "role1";
                String roleName2 = "role2";
                HashSet testRoleSet = Sets.newHashSet((Object[])new String[]{roleName1, roleName2});
                String group1 = "group1";
                String group2 = "group2";
                HashSet testGroupSet = Sets.newHashSet((Object[])new String[]{group1, group2});
                String server = "server1";
                String db = "testDB";
                String db2 = "testDB2";
                String tab = "testTab";
                TestSentryServiceIntegration.this.setLocalGroupMapping(requestorUserName, requestorUserGroupNames);
                String group1user = "group1user";
                TestSentryServiceIntegration.this.setLocalGroupMapping(group1user, Sets.newHashSet((Object[])new String[]{group1}));
                String group2user = "group2user";
                TestSentryServiceIntegration.this.setLocalGroupMapping(group2user, Sets.newHashSet((Object[])new String[]{group2}));
                TestSentryServiceIntegration.this.setLocalGroupMapping("random", Sets.newHashSet((Object[])new String[]{"foo"}));
                TestSentryServiceIntegration.this.writePolicyFile();
                TestSentryServiceIntegration.this.client.dropRoleIfExists(requestorUserName, roleName1);
                TestSentryServiceIntegration.this.client.createRole(requestorUserName, roleName1);
                TestSentryServiceIntegration.this.client.dropRoleIfExists(requestorUserName, roleName2);
                TestSentryServiceIntegration.this.client.createRole(requestorUserName, roleName2);
                TSentryPrivilege role1db1 = TestSentryServiceIntegration.this.client.grantDatabasePrivilege(requestorUserName, roleName1, server, db, "select");
                TestSentryServiceIntegration.this.client.grantTablePrivilege(requestorUserName, roleName1, server, db, tab, "*");
                TestSentryServiceIntegration.this.client.grantTablePrivilege(requestorUserName, roleName1, server, db2, tab, "select");
                TestSentryServiceIntegration.this.client.grantURIPrivilege(requestorUserName, roleName1, server, "hdfs:///fooUri");
                TestSentryServiceIntegration.this.client.grantRoleToGroup(requestorUserName, group1, roleName1);
                TSentryPrivilege role2db1 = TestSentryServiceIntegration.this.client.grantDatabasePrivilege(requestorUserName, roleName2, server, db, "*");
                TestSentryServiceIntegration.this.client.grantDatabasePrivilege(requestorUserName, roleName2, server, db2, "select");
                TestSentryServiceIntegration.this.client.grantTablePrivilege(requestorUserName, roleName2, server, db2, tab, "*");
                TestSentryServiceIntegration.this.client.grantRoleToGroup(requestorUserName, group2, roleName2);
                TSentryPrivilegeMap db1RoleToPrivMap = new TSentryPrivilegeMap(new TreeMap());
                db1RoleToPrivMap.getPrivilegeMap().put(roleName1, Sets.newHashSet((Object[])new TSentryPrivilege[]{role1db1}));
                db1RoleToPrivMap.getPrivilegeMap().put(roleName2, Sets.newHashSet((Object[])new TSentryPrivilege[]{role2db1}));
                TreeMap expectedResults = Maps.newTreeMap();
                ArrayList db1Authrizable = Lists.newArrayList((Object[])new DBModelAuthorizable[]{new Server(server), new Database(db)});
                expectedResults.put(SentryPolicyServiceClientDefaultImpl.setupSentryAuthorizable((List)db1Authrizable), db1RoleToPrivMap);
                HashSet authorizableSet = Sets.newHashSet();
                authorizableSet.add(db1Authrizable);
                Map authPrivMap = TestSentryServiceIntegration.this.client.listPrivilegsbyAuthorizable(requestorUserName, (Set)authorizableSet, null, null);
                junit.framework.Assert.assertEquals((Object)expectedResults, (Object)authPrivMap);
                authPrivMap = TestSentryServiceIntegration.this.client.listPrivilegsbyAuthorizable(requestorUserName, (Set)authorizableSet, null, new ActiveRoleSet((Set)testRoleSet));
                junit.framework.Assert.assertEquals((Object)expectedResults, (Object)authPrivMap);
                authPrivMap = TestSentryServiceIntegration.this.client.listPrivilegsbyAuthorizable(requestorUserName, (Set)authorizableSet, null, ActiveRoleSet.ALL);
                junit.framework.Assert.assertEquals((Object)expectedResults, (Object)authPrivMap);
                authPrivMap = TestSentryServiceIntegration.this.client.listPrivilegsbyAuthorizable(requestorUserName, (Set)authorizableSet, (Set)testGroupSet, null);
                junit.framework.Assert.assertEquals((Object)expectedResults, (Object)authPrivMap);
                authPrivMap = TestSentryServiceIntegration.this.client.listPrivilegsbyAuthorizable(requestorUserName, (Set)authorizableSet, (Set)testGroupSet, new ActiveRoleSet((Set)testRoleSet));
                junit.framework.Assert.assertEquals((Object)expectedResults, (Object)authPrivMap);
                authPrivMap = TestSentryServiceIntegration.this.client.listPrivilegsbyAuthorizable(requestorUserName, (Set)authorizableSet, (Set)testGroupSet, ActiveRoleSet.ALL);
                junit.framework.Assert.assertEquals((Object)expectedResults, (Object)authPrivMap);
                authPrivMap = TestSentryServiceIntegration.this.client.listPrivilegsbyAuthorizable("random", (Set)authorizableSet, new HashSet(), ActiveRoleSet.ALL);
                expectedResults.clear();
                expectedResults.put(SentryPolicyServiceClientDefaultImpl.setupSentryAuthorizable((List)db1Authrizable), new TSentryPrivilegeMap(new HashMap()));
                junit.framework.Assert.assertEquals((Object)expectedResults, (Object)authPrivMap);
            }
        });
    }

    @Test
    public void testListByAuthTab() throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            @Override
            public void runTestAsSubject() throws Exception {
                String requestorUserName = "admin_user";
                HashSet requestorUserGroupNames = Sets.newHashSet((Object[])new String[]{"admin_group"});
                String roleName1 = "role1";
                String roleName2 = "role2";
                String server = "server1";
                String db = "testDB";
                String db2 = "testDB2";
                String tab = "testTab";
                TestSentryServiceIntegration.this.setLocalGroupMapping(requestorUserName, requestorUserGroupNames);
                TestSentryServiceIntegration.this.writePolicyFile();
                TestSentryServiceIntegration.this.client.dropRoleIfExists(requestorUserName, roleName1);
                TestSentryServiceIntegration.this.client.createRole(requestorUserName, roleName1);
                TestSentryServiceIntegration.this.client.dropRoleIfExists(requestorUserName, roleName2);
                TestSentryServiceIntegration.this.client.createRole(requestorUserName, roleName2);
                TestSentryServiceIntegration.this.client.grantDatabasePrivilege(requestorUserName, roleName1, server, db, "select");
                TestSentryServiceIntegration.this.client.grantTablePrivilege(requestorUserName, roleName1, server, db, tab, "*");
                TSentryPrivilege role1db2tab = TestSentryServiceIntegration.this.client.grantTablePrivilege(requestorUserName, roleName1, server, db2, tab, "select");
                TestSentryServiceIntegration.this.client.grantDatabasePrivilege(requestorUserName, roleName2, server, db, "*");
                TestSentryServiceIntegration.this.client.grantDatabasePrivilege(requestorUserName, roleName2, server, db2, "select");
                TSentryPrivilege role2db2tab = TestSentryServiceIntegration.this.client.grantTablePrivilege(requestorUserName, roleName2, server, db2, tab, "*");
                TestSentryServiceIntegration.this.client.grantURIPrivilege(requestorUserName, roleName1, server, "hdfs:///fooUri");
                TSentryPrivilegeMap db1RoleToPrivMap = new TSentryPrivilegeMap(new TreeMap());
                db1RoleToPrivMap.getPrivilegeMap().put(roleName1, Sets.newHashSet((Object[])new TSentryPrivilege[]{role1db2tab}));
                db1RoleToPrivMap.getPrivilegeMap().put(roleName2, Sets.newHashSet((Object[])new TSentryPrivilege[]{role2db2tab}));
                TreeMap expectedResults = Maps.newTreeMap();
                ArrayList db2TabAuthrizable = Lists.newArrayList((Object[])new DBModelAuthorizable[]{new Server(server), new Database(db2), new Table(tab)});
                expectedResults.put(SentryPolicyServiceClientDefaultImpl.setupSentryAuthorizable((List)db2TabAuthrizable), db1RoleToPrivMap);
                HashSet authorizableSet = Sets.newHashSet();
                authorizableSet.add(db2TabAuthrizable);
                Map authPrivMap = TestSentryServiceIntegration.this.client.listPrivilegsbyAuthorizable(requestorUserName, (Set)authorizableSet, null, null);
                junit.framework.Assert.assertEquals((Object)expectedResults, (Object)authPrivMap);
            }
        });
    }

    @Test
    public void testListByAuthUri() throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            @Override
            public void runTestAsSubject() throws Exception {
                String requestorUserName = "admin_user";
                HashSet requestorUserGroupNames = Sets.newHashSet((Object[])new String[]{"admin_group"});
                String roleName1 = "role1";
                String roleName2 = "role2";
                String server = "server1";
                String db = "testDB";
                String db2 = "testDB2";
                String tab = "testTab";
                String uri1 = "hdfs:///fooUri";
                TestSentryServiceIntegration.this.setLocalGroupMapping(requestorUserName, requestorUserGroupNames);
                TestSentryServiceIntegration.this.writePolicyFile();
                TestSentryServiceIntegration.this.client.dropRoleIfExists(requestorUserName, roleName1);
                TestSentryServiceIntegration.this.client.createRole(requestorUserName, roleName1);
                TestSentryServiceIntegration.this.client.dropRoleIfExists(requestorUserName, roleName2);
                TestSentryServiceIntegration.this.client.createRole(requestorUserName, roleName2);
                TestSentryServiceIntegration.this.client.grantDatabasePrivilege(requestorUserName, roleName1, server, db, "select");
                TestSentryServiceIntegration.this.client.grantTablePrivilege(requestorUserName, roleName1, server, db, tab, "*");
                TestSentryServiceIntegration.this.client.grantTablePrivilege(requestorUserName, roleName1, server, db2, tab, "select");
                TSentryPrivilege role1uri1 = TestSentryServiceIntegration.this.client.grantURIPrivilege(requestorUserName, roleName1, server, uri1);
                TestSentryServiceIntegration.this.client.grantDatabasePrivilege(requestorUserName, roleName2, server, db, "*");
                TestSentryServiceIntegration.this.client.grantDatabasePrivilege(requestorUserName, roleName2, server, db2, "select");
                TestSentryServiceIntegration.this.client.grantTablePrivilege(requestorUserName, roleName2, server, db2, tab, "*");
                TSentryPrivilege role2uri2 = TestSentryServiceIntegration.this.client.grantURIPrivilege(requestorUserName, roleName2, server, uri1);
                TSentryPrivilegeMap db1RoleToPrivMap = new TSentryPrivilegeMap(new TreeMap());
                db1RoleToPrivMap.getPrivilegeMap().put(roleName1, Sets.newHashSet((Object[])new TSentryPrivilege[]{role1uri1}));
                db1RoleToPrivMap.getPrivilegeMap().put(roleName2, Sets.newHashSet((Object[])new TSentryPrivilege[]{role2uri2}));
                TreeMap expectedResults = Maps.newTreeMap();
                ArrayList uri1Authrizable = Lists.newArrayList((Object[])new DBModelAuthorizable[]{new Server(server), new AccessURI(uri1)});
                expectedResults.put(SentryPolicyServiceClientDefaultImpl.setupSentryAuthorizable((List)uri1Authrizable), db1RoleToPrivMap);
                HashSet authorizableSet = Sets.newHashSet();
                authorizableSet.add(uri1Authrizable);
                Map authPrivMap = TestSentryServiceIntegration.this.client.listPrivilegsbyAuthorizable(requestorUserName, (Set)authorizableSet, null, null);
                junit.framework.Assert.assertEquals((Object)expectedResults, (Object)authPrivMap);
            }
        });
    }

    @Test
    public void testListByAuthTabForNonAdmin() throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            @Override
            public void runTestAsSubject() throws Exception {
                String requestorUserName = "admin_user";
                String user1 = "user1";
                String group1 = "group1";
                String group2 = "group2";
                HashSet requestorUserGroupNames = Sets.newHashSet((Object[])new String[]{"admin_group"});
                HashSet userGroupNames1 = Sets.newHashSet((Object[])new String[]{group1});
                HashSet userGroupNames2 = Sets.newHashSet((Object[])new String[]{group2});
                String roleName1 = "role1";
                String roleName2 = "role2";
                String server = "server1";
                String db = "testDB";
                String db2 = "testDB2";
                String tab = "testTab";
                TestSentryServiceIntegration.this.setLocalGroupMapping(requestorUserName, requestorUserGroupNames);
                TestSentryServiceIntegration.this.setLocalGroupMapping(user1, userGroupNames1);
                TestSentryServiceIntegration.this.writePolicyFile();
                TestSentryServiceIntegration.this.client.dropRoleIfExists(requestorUserName, roleName1);
                TestSentryServiceIntegration.this.client.createRole(requestorUserName, roleName1);
                TestSentryServiceIntegration.this.client.dropRoleIfExists(requestorUserName, roleName2);
                TestSentryServiceIntegration.this.client.createRole(requestorUserName, roleName2);
                TestSentryServiceIntegration.this.client.grantDatabasePrivilege(requestorUserName, roleName1, server, db, "select");
                TestSentryServiceIntegration.this.client.grantTablePrivilege(requestorUserName, roleName1, server, db, tab, "*");
                TSentryPrivilege role1db2tab = TestSentryServiceIntegration.this.client.grantTablePrivilege(requestorUserName, roleName1, server, db2, tab, "select");
                TestSentryServiceIntegration.this.client.grantRoleToGroup(requestorUserName, group1, roleName1);
                TestSentryServiceIntegration.this.client.grantDatabasePrivilege(requestorUserName, roleName2, server, db, "*");
                TestSentryServiceIntegration.this.client.grantDatabasePrivilege(requestorUserName, roleName2, server, db2, "select");
                TestSentryServiceIntegration.this.client.grantTablePrivilege(requestorUserName, roleName2, server, db2, tab, "*");
                TestSentryServiceIntegration.this.client.grantURIPrivilege(requestorUserName, roleName1, server, "hdfs:///fooUri");
                TSentryPrivilegeMap db1RoleToPrivMap = new TSentryPrivilegeMap(new TreeMap());
                db1RoleToPrivMap.getPrivilegeMap().put(roleName1, Sets.newHashSet((Object[])new TSentryPrivilege[]{role1db2tab}));
                TreeMap expectedResults = Maps.newTreeMap();
                ArrayList db2TabAuthorizable = Lists.newArrayList((Object[])new DBModelAuthorizable[]{new Server(server), new Database(db2), new Table(tab)});
                expectedResults.put(SentryPolicyServiceClientDefaultImpl.setupSentryAuthorizable((List)db2TabAuthorizable), db1RoleToPrivMap);
                HashSet authorizableSet = Sets.newHashSet();
                authorizableSet.add(db2TabAuthorizable);
                Map authPrivMap = TestSentryServiceIntegration.this.client.listPrivilegsbyAuthorizable(user1, (Set)authorizableSet, null, null);
                junit.framework.Assert.assertEquals((Object)expectedResults, (Object)authPrivMap);
                authPrivMap = TestSentryServiceIntegration.this.client.listPrivilegsbyAuthorizable(user1, (Set)authorizableSet, new HashSet(), null);
                junit.framework.Assert.assertEquals((Object)expectedResults, (Object)authPrivMap);
                authPrivMap = TestSentryServiceIntegration.this.client.listPrivilegsbyAuthorizable(user1, (Set)authorizableSet, null, new ActiveRoleSet(true));
                junit.framework.Assert.assertEquals((Object)expectedResults, (Object)authPrivMap);
                authPrivMap = TestSentryServiceIntegration.this.client.listPrivilegsbyAuthorizable(user1, (Set)authorizableSet, (Set)userGroupNames1, null);
                junit.framework.Assert.assertEquals((Object)expectedResults, (Object)authPrivMap);
                authPrivMap = TestSentryServiceIntegration.this.client.listPrivilegsbyAuthorizable(user1, (Set)authorizableSet, (Set)userGroupNames1, new ActiveRoleSet(true));
                junit.framework.Assert.assertEquals((Object)expectedResults, (Object)authPrivMap);
                authPrivMap = TestSentryServiceIntegration.this.client.listPrivilegsbyAuthorizable(user1, (Set)authorizableSet, null, new ActiveRoleSet((Set)Sets.newHashSet((Object[])new String[]{roleName1.toUpperCase()})));
                junit.framework.Assert.assertEquals((Object)expectedResults, (Object)authPrivMap);
                try {
                    TestSentryServiceIntegration.this.client.listPrivilegsbyAuthorizable(user1, (Set)authorizableSet, (Set)userGroupNames2, null);
                    Assert.fail((String)("listPrivilegsbyAuthorizable() should fail for user1 accessing " + group2));
                }
                catch (SentryAccessDeniedException e) {
                    // empty catch block
                }
                ActiveRoleSet roleSet2 = new ActiveRoleSet((Set)Sets.newHashSet((Object[])new String[]{roleName2}));
                try {
                    TestSentryServiceIntegration.this.client.listPrivilegsbyAuthorizable(user1, (Set)authorizableSet, null, roleSet2);
                    Assert.fail((String)("listPrivilegsbyAuthorizable() should fail for user1 accessing " + roleName2));
                }
                catch (SentryAccessDeniedException e) {
                    // empty catch block
                }
            }
        });
    }

    private void checkBannedConfigVal(final String configVal, final String defaultVal) throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            @Override
            public void runTestAsSubject() throws Exception {
                try {
                    TestSentryServiceIntegration.this.client.getConfigValue(configVal, defaultVal);
                    Assert.fail((String)("Attempt to access " + configVal + " succeeded"));
                }
                catch (SentryAccessDeniedException e) {
                    Assert.assertTrue((boolean)e.toString().contains("was denied"));
                    Assert.assertTrue((boolean)e.toString().contains(configVal));
                }
            }
        });
    }

    @Test
    public void testGetConfigVal() throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            @Override
            public void runTestAsSubject() throws Exception {
                String requestorUserName = "admin_user";
                HashSet requestorUserGroupNames = Sets.newHashSet((Object[])new String[]{"admin_group"});
                TestSentryServiceIntegration.this.setLocalGroupMapping(requestorUserName, requestorUserGroupNames);
                TestSentryServiceIntegration.this.writePolicyFile();
                String val = TestSentryServiceIntegration.this.client.getConfigValue("sentry.service.admin.group", "xxx");
                junit.framework.Assert.assertEquals((String)val, (String)"admin_group");
                val = TestSentryServiceIntegration.this.client.getConfigValue("sentry.this.is.not.defined", "hello");
                junit.framework.Assert.assertEquals((String)val, (String)"hello");
                val = TestSentryServiceIntegration.this.client.getConfigValue("sentry.this.is.not.defined", null);
                junit.framework.Assert.assertEquals((String)val, null);
                val = TestSentryServiceIntegration.this.client.getConfigValue("sentry.service.admin.group", null);
                junit.framework.Assert.assertEquals((String)val, (String)"admin_group");
                TestSentryServiceIntegration.this.checkBannedConfigVal("notsentry", "xxx");
                TestSentryServiceIntegration.this.checkBannedConfigVal("notsentry", null);
                TestSentryServiceIntegration.this.checkBannedConfigVal("sentry.xxx.jdbc.xxx", null);
                TestSentryServiceIntegration.this.checkBannedConfigVal("sentry.xxx.password", null);
                TestSentryServiceIntegration.this.checkBannedConfigVal("sentry.service.server.keytab", null);
            }
        });
    }

    @Test
    public void testGranRevokePrivilegeOnServerForRole() throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            @Override
            public void runTestAsSubject() throws Exception {
                String requestorUserName = "admin_user";
                HashSet requestorUserGroupNames = Sets.newHashSet((Object[])new String[]{"admin_group"});
                TestSentryServiceIntegration.this.setLocalGroupMapping(requestorUserName, requestorUserGroupNames);
                TestSentryServiceIntegration.this.writePolicyFile();
                String roleName1 = "admin_r1";
                TestSentryServiceIntegration.this.client.dropRoleIfExists(requestorUserName, roleName1);
                TestSentryServiceIntegration.this.client.createRole(requestorUserName, roleName1);
                TestSentryServiceIntegration.this.client.grantServerPrivilege(requestorUserName, roleName1, "server", Boolean.valueOf(false));
                Set listPrivs = TestSentryServiceIntegration.this.client.listAllPrivilegesByRoleName(requestorUserName, roleName1);
                Assert.assertTrue((String)"Privilege should be all:", (boolean)((TSentryPrivilege)listPrivs.iterator().next()).getAction().equals("*"));
                TestSentryServiceIntegration.this.client.revokeServerPrivilege(requestorUserName, roleName1, "server", false);
                listPrivs = TestSentryServiceIntegration.this.client.listAllPrivilegesByRoleName(requestorUserName, roleName1);
                Assert.assertTrue((String)"Privilege not correctly revoked !!", (listPrivs.size() == 0 ? 1 : 0) != 0);
            }
        });
    }
}

