/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.service.thrift;

import com.google.common.collect.Sets;
import java.io.File;
import java.util.HashSet;
import org.apache.sentry.provider.file.PolicyFile;
import org.apache.sentry.service.thrift.SentryServiceIntegrationBase;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestSentryServiceForHAWithKerberos
extends SentryServiceIntegrationBase {
    @BeforeClass
    public static void setup() throws Exception {
        kerberos = true;
        haEnabled = true;
        SERVER_KERBEROS_NAME = "sentry/_HOST@EXAMPLE.COM";
        TestSentryServiceForHAWithKerberos.beforeSetup();
        TestSentryServiceForHAWithKerberos.setupConf();
        TestSentryServiceForHAWithKerberos.startSentryService();
        TestSentryServiceForHAWithKerberos.afterSetup();
    }

    @Override
    @Before
    public void before() throws Exception {
        this.policyFilePath = new File(dbDir, "local_policy_file.ini");
        conf.set("sentry.store.group.mapping.resource", this.policyFilePath.getPath());
        this.policyFile = new PolicyFile();
        this.connectToSentryService();
    }

    @Test
    public void testCreateRole() throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            @Override
            public void runTestAsSubject() throws Exception {
                String requestorUserName = "admin_user";
                HashSet requestorUserGroupNames = Sets.newHashSet((Object[])new String[]{"admin_group"});
                TestSentryServiceForHAWithKerberos.this.setLocalGroupMapping(requestorUserName, requestorUserGroupNames);
                TestSentryServiceForHAWithKerberos.this.writePolicyFile();
                String roleName = "admin_r";
                TestSentryServiceForHAWithKerberos.this.client.dropRoleIfExists(requestorUserName, roleName);
                TestSentryServiceForHAWithKerberos.this.client.createRole(requestorUserName, roleName);
                TestSentryServiceForHAWithKerberos.this.client.dropRole(requestorUserName, roleName);
            }
        });
    }
}

