/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.service.thrift;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import junit.framework.Assert;
import org.apache.sentry.core.common.ActiveRoleSet;
import org.apache.sentry.core.common.Authorizable;
import org.apache.sentry.core.model.db.DBModelAuthorizable;
import org.apache.sentry.core.model.db.Database;
import org.apache.sentry.core.model.db.Server;
import org.apache.sentry.core.model.db.Table;
import org.apache.sentry.service.thrift.SentryServiceIntegrationBase;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestSentryServerWithoutKerberos
extends SentryServiceIntegrationBase {
    @BeforeClass
    public static void setup() throws Exception {
        kerberos = false;
        TestSentryServerWithoutKerberos.beforeSetup();
        TestSentryServerWithoutKerberos.setupConf();
        TestSentryServerWithoutKerberos.startSentryService();
        TestSentryServerWithoutKerberos.afterSetup();
    }

    @Test
    public void testCreateRole() throws Exception {
        String requestorUserName = "admin_user";
        HashSet requestorUserGroupNames = Sets.newHashSet((Object[])new String[]{"admin_group"});
        this.setLocalGroupMapping(requestorUserName, requestorUserGroupNames);
        this.writePolicyFile();
        String roleName = "admin_r";
        this.client.dropRoleIfExists(requestorUserName, roleName);
        this.client.createRole(requestorUserName, roleName);
        this.client.dropRole(requestorUserName, roleName);
    }

    @Test
    public void testQueryPushDown() throws Exception {
        String requestorUserName = "admin_user";
        HashSet requestorUserGroupNames = Sets.newHashSet((Object[])new String[]{"admin_group"});
        this.setLocalGroupMapping(requestorUserName, requestorUserGroupNames);
        this.writePolicyFile();
        String roleName1 = "admin_r1";
        String roleName2 = "admin_r2";
        String group1 = "g1";
        String group2 = "g2";
        this.client.dropRoleIfExists(requestorUserName, roleName1);
        this.client.createRole(requestorUserName, roleName1);
        this.client.grantRoleToGroup(requestorUserName, group1, roleName1);
        this.client.grantTablePrivilege(requestorUserName, roleName1, "server", "db1", "table1", "ALL");
        this.client.grantTablePrivilege(requestorUserName, roleName1, "server", "db1", "table2", "ALL");
        this.client.grantTablePrivilege(requestorUserName, roleName1, "server", "db2", "table3", "ALL");
        this.client.grantTablePrivilege(requestorUserName, roleName1, "server", "db2", "table4", "ALL");
        this.client.dropRoleIfExists(requestorUserName, roleName2);
        this.client.createRole(requestorUserName, roleName2);
        this.client.grantRoleToGroup(requestorUserName, group1, roleName2);
        this.client.grantRoleToGroup(requestorUserName, group2, roleName2);
        this.client.grantTablePrivilege(requestorUserName, roleName2, "server", "db1", "table1", "ALL");
        this.client.grantTablePrivilege(requestorUserName, roleName2, "server", "db1", "table2", "ALL");
        this.client.grantTablePrivilege(requestorUserName, roleName2, "server", "db2", "table3", "ALL");
        this.client.grantTablePrivilege(requestorUserName, roleName2, "server", "db2", "table4", "ALL");
        this.client.grantTablePrivilege(requestorUserName, roleName2, "server", "db3", "table5", "ALL");
        Set listPrivilegesByRoleName = this.client.listPrivilegesByRoleName(requestorUserName, roleName2, null);
        Assert.assertEquals((String)"Privilege not assigned to role2 !!", (int)5, (int)listPrivilegesByRoleName.size());
        listPrivilegesByRoleName = this.client.listPrivilegesByRoleName(requestorUserName, roleName2, new ArrayList());
        Assert.assertEquals((String)"Privilege not assigned to role2 !!", (int)5, (int)listPrivilegesByRoleName.size());
        listPrivilegesByRoleName = this.client.listPrivilegesByRoleName(requestorUserName, roleName2, (List)Lists.newArrayList((Object[])new DBModelAuthorizable[]{new Server("server"), new Database("db1")}));
        Assert.assertEquals((String)"Privilege not assigned to role2 !!", (int)2, (int)listPrivilegesByRoleName.size());
        listPrivilegesByRoleName = this.client.listPrivilegesByRoleName(requestorUserName, roleName2, (List)Lists.newArrayList((Object[])new DBModelAuthorizable[]{new Server("server"), new Database("db2"), new Table("table1")}));
        Assert.assertEquals((String)"Privilege not assigned to role2 !!", (int)0, (int)listPrivilegesByRoleName.size());
        listPrivilegesByRoleName = this.client.listPrivilegesByRoleName(requestorUserName, roleName2, (List)Lists.newArrayList((Object[])new DBModelAuthorizable[]{new Server("server"), new Database("db1"), new Table("table1")}));
        Assert.assertEquals((String)"Privilege not assigned to role2 !!", (int)1, (int)listPrivilegesByRoleName.size());
        listPrivilegesByRoleName = this.client.listPrivilegesByRoleName(requestorUserName, roleName2, (List)Lists.newArrayList((Object[])new DBModelAuthorizable[]{new Server("server"), new Database("db3")}));
        Assert.assertEquals((String)"Privilege not assigned to role2 !!", (int)1, (int)listPrivilegesByRoleName.size());
        Set listPrivilegesForProvider = this.client.listPrivilegesForProvider((Set)Sets.newHashSet((Object[])new String[]{group1, group2}), ActiveRoleSet.ALL, new Authorizable[]{new Server("server"), new Database("db2")});
        Assert.assertEquals((String)"Privilege not correctly assigned to roles !!", (Object)Sets.newHashSet((Object[])new String[]{"server=server->db=db2->table=table4->action=all", "server=server->db=db2->table=table3->action=all"}), (Object)listPrivilegesForProvider);
        listPrivilegesForProvider = this.client.listPrivilegesForProvider((Set)Sets.newHashSet((Object[])new String[]{group1, group2}), ActiveRoleSet.ALL, new Authorizable[]{new Server("server"), new Database("db3")});
        Assert.assertEquals((String)"Privilege not correctly assigned to roles !!", (Object)Sets.newHashSet((Object[])new String[]{"server=server->db=db3->table=table5->action=all"}), (Object)listPrivilegesForProvider);
        listPrivilegesForProvider = this.client.listPrivilegesForProvider((Set)Sets.newHashSet((Object[])new String[]{group1, group2}), new ActiveRoleSet((Set)Sets.newHashSet((Object[])new String[]{roleName1})), new Authorizable[]{new Server("server"), new Database("db3")});
        Assert.assertEquals((String)"Privilege not correctly assigned to roles !!", (Object)Sets.newHashSet((Object[])new String[]{"server=+"}), (Object)listPrivilegesForProvider);
        listPrivilegesForProvider = this.client.listPrivilegesForProvider((Set)Sets.newHashSet((Object[])new String[]{group1, group2}), new ActiveRoleSet((Set)Sets.newHashSet((Object[])new String[]{roleName1})), new Authorizable[]{new Server("server1")});
        Assert.assertEquals((String)"Privilege not correctly assigned to roles !!", new HashSet(), (Object)listPrivilegesForProvider);
    }

    @Test
    public void testDropRole() throws Exception {
        String requestorUserName = "admin_user";
        HashSet requestorUserGroupNames = Sets.newHashSet((Object[])new String[]{"admin_group"});
        this.setLocalGroupMapping(requestorUserName, requestorUserGroupNames);
        this.writePolicyFile();
        String roleName = "admin_r";
        this.client.dropRoleIfExists(requestorUserName, roleName);
        this.client.createRole(requestorUserName, roleName);
        this.client.grantRoleToGroup(requestorUserName, "admin_group", roleName);
        this.client.grantDatabasePrivilege(requestorUserName, roleName, "server1", "db2", "*");
        this.client.grantTablePrivilege(requestorUserName, roleName, "server1", "db3", "tab3", "ALL");
        Assert.assertEquals((int)2, (int)this.client.listPrivilegesForProvider((Set)requestorUserGroupNames, ActiveRoleSet.ALL, new Authorizable[0]).size());
        this.client.dropRole(requestorUserName, roleName);
        Assert.assertEquals((int)0, (int)this.client.listPrivilegesForProvider((Set)requestorUserGroupNames, ActiveRoleSet.ALL, new Authorizable[0]).size());
        this.client.createRole(requestorUserName, roleName);
        this.client.grantRoleToGroup(requestorUserName, "admin_group", roleName);
        Assert.assertEquals((int)0, (int)this.client.listPrivilegesForProvider((Set)requestorUserGroupNames, ActiveRoleSet.ALL, new Authorizable[0]).size());
        this.client.grantDatabasePrivilege(requestorUserName, roleName, "server1", "db2", "*");
        Assert.assertEquals((int)1, (int)this.client.listPrivilegesForProvider((Set)requestorUserGroupNames, ActiveRoleSet.ALL, new Authorizable[0]).size());
        this.client.dropRole(requestorUserName, roleName);
        Assert.assertEquals((int)0, (int)this.client.listPrivilegesForProvider((Set)requestorUserGroupNames, ActiveRoleSet.ALL, new Authorizable[0]).size());
        Assert.assertEquals((int)0, (int)this.client.listPrivilegesForProvider((Set)requestorUserGroupNames, ActiveRoleSet.ALL, new Authorizable[0]).size());
    }
}

