/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.service.thrift;

import junit.framework.Assert;
import org.apache.hadoop.conf.Configuration;
import org.apache.sentry.provider.db.SentryThriftAPIMismatchException;
import org.apache.sentry.provider.db.service.thrift.NotificationHandler;
import org.apache.sentry.provider.db.service.thrift.SentryConfigurationException;
import org.apache.sentry.provider.db.service.thrift.SentryPolicyStoreProcessor;
import org.junit.Before;
import org.junit.Test;

public class TestSentryPolicyStoreProcessor {
    private Configuration conf;

    @Before
    public void setup() {
        this.conf = new Configuration(false);
    }

    @Test(expected=SentryConfigurationException.class)
    public void testConfigNotNotificationHandler() throws Exception {
        this.conf.set("sentry.policy.store.notification.handlers", Object.class.getName());
        SentryPolicyStoreProcessor.createHandlers((Configuration)this.conf);
    }

    @Test(expected=SentryConfigurationException.class)
    public void testConfigCannotCreateNotificationHandler() throws Exception {
        this.conf.set("sentry.policy.store.notification.handlers", ExceptionInConstructorNotificationHandler.class.getName());
        SentryPolicyStoreProcessor.createHandlers((Configuration)this.conf);
    }

    @Test(expected=SentryConfigurationException.class)
    public void testConfigNotAClassNotificationHandler() throws Exception {
        this.conf.set("sentry.policy.store.notification.handlers", "junk");
        SentryPolicyStoreProcessor.createHandlers((Configuration)this.conf);
    }

    @Test
    public void testConfigMultipleNotificationHandlers() throws Exception {
        this.conf.set("sentry.policy.store.notification.handlers", NoopNotificationHandler.class.getName() + "," + NoopNotificationHandler.class.getName() + " " + NoopNotificationHandler.class.getName());
        Assert.assertEquals((int)3, (int)SentryPolicyStoreProcessor.createHandlers((Configuration)this.conf).size());
    }

    @Test(expected=SentryThriftAPIMismatchException.class)
    public void testSentryThriftAPIMismatch() throws Exception {
        SentryPolicyStoreProcessor.validateClientVersion((int)1);
    }

    @Test
    public void testSentryThriftAPIMatchVersion() throws Exception {
        SentryPolicyStoreProcessor.validateClientVersion((int)2);
    }

    public static class NoopNotificationHandler
    extends NotificationHandler {
        public NoopNotificationHandler(Configuration config) throws Exception {
            super(config);
        }
    }

    public static class ExceptionInConstructorNotificationHandler
    extends NotificationHandler {
        public ExceptionInConstructorNotificationHandler(Configuration config) throws Exception {
            super(config);
            throw new Exception();
        }
    }
}

