/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.service.thrift;

import java.io.File;
import java.util.Properties;
import org.apache.hadoop.minikdc.MiniKdc;

public class SentryMiniKdcTestcase {
    private static File workDir;
    private static Properties conf;
    private static MiniKdc kdc;

    public static void startMiniKdc(Properties confOverlay) throws Exception {
        SentryMiniKdcTestcase.createTestDir();
        SentryMiniKdcTestcase.createMiniKdcConf(confOverlay);
        kdc = new MiniKdc(conf, workDir);
        kdc.start();
    }

    private static void createMiniKdcConf(Properties confOverlay) {
        conf = MiniKdc.createConf();
        for (Object property : confOverlay.keySet()) {
            conf.put(property, confOverlay.get(property));
        }
    }

    private static void createTestDir() {
        workDir = new File(System.getProperty("test.dir", "target"));
    }

    public static void stopMiniKdc() {
        if (kdc != null) {
            kdc.stop();
        }
    }

    public static MiniKdc getKdc() {
        return kdc;
    }

    public static File getWorkDir() {
        return workDir;
    }

    public Properties getConf() {
        return conf;
    }
}

