/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.service.persistent;

import com.google.common.io.Files;
import java.io.File;
import junit.framework.Assert;
import org.apache.hadoop.conf.Configuration;
import org.apache.sentry.provider.db.SentryNoSuchObjectException;
import org.apache.sentry.provider.db.service.persistent.SentryStore;
import org.apache.sentry.provider.db.service.persistent.SentryStoreSchemaInfo;
import org.junit.Before;
import org.junit.Test;

public class TestSentryVersion {
    private File dataDir;
    private Configuration conf;

    @Before
    public void setup() throws Exception {
        this.dataDir = new File(Files.createTempDir(), "sentry_policy_db");
        this.conf = new Configuration(false);
        this.conf.set("sentry.store.jdbc.url", "jdbc:derby:;databaseName=" + this.dataDir.getPath() + ";create=true");
        this.conf.set("sentry.store.jdbc.password", "dummy");
    }

    @Test
    public void testVerifySentryVersionCheck() throws Exception {
        this.conf.set("sentry.verify.schema.version", "false");
        SentryStore sentryStore = new SentryStore(this.conf);
        sentryStore.stop();
        this.conf.set("sentry.verify.schema.version", "true");
        sentryStore = new SentryStore(this.conf);
    }

    @Test(expected=SentryNoSuchObjectException.class)
    public void testNegSentrySchemaDefault() throws Exception {
        SentryStore sentryStore = new SentryStore(this.conf);
    }

    @Test
    public void testSentryImplicitVersion() throws Exception {
        this.conf.set("sentry.verify.schema.version", "false");
        SentryStore sentryStore = new SentryStore(this.conf);
        Assert.assertEquals((String)SentryStoreSchemaInfo.getSentryVersion(), (String)sentryStore.getSentryVersion());
    }
}

