/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.service.persistent;

import junit.framework.Assert;
import org.apache.sentry.provider.db.service.model.MSentryPrivilege;
import org.apache.sentry.provider.db.service.persistent.SentryStore;
import org.junit.Test;

public class TestSentryStoreToAuthorizable {
    private MSentryPrivilege privilege;

    @Test
    public void testServer() {
        this.privilege = new MSentryPrivilege(null, null, "server1", null, null, null, null, null);
        Assert.assertEquals((String)"server=server1", (String)SentryStore.toAuthorizable((MSentryPrivilege)this.privilege));
        this.privilege = new MSentryPrivilege(null, null, "server1", null, null, null, null, "*");
        Assert.assertEquals((String)"server=server1", (String)SentryStore.toAuthorizable((MSentryPrivilege)this.privilege));
    }

    @Test
    public void testTable() {
        this.privilege = new MSentryPrivilege(null, null, "server1", "db1", "tbl1", null, null, null);
        Assert.assertEquals((String)"server=server1->db=db1->table=tbl1", (String)SentryStore.toAuthorizable((MSentryPrivilege)this.privilege));
        this.privilege = new MSentryPrivilege(null, null, "server1", "db1", "tbl1", null, null, "insert");
        Assert.assertEquals((String)"server=server1->db=db1->table=tbl1->action=insert", (String)SentryStore.toAuthorizable((MSentryPrivilege)this.privilege));
        this.privilege = new MSentryPrivilege(null, null, "server1", "db1", "tbl1", null, null, "select");
        Assert.assertEquals((String)"server=server1->db=db1->table=tbl1->action=select", (String)SentryStore.toAuthorizable((MSentryPrivilege)this.privilege));
        this.privilege = new MSentryPrivilege(null, null, "server1", "db1", "tbl1", null, null, "*");
        Assert.assertEquals((String)"server=server1->db=db1->table=tbl1", (String)SentryStore.toAuthorizable((MSentryPrivilege)this.privilege));
    }

    @Test
    public void testDb() {
        this.privilege = new MSentryPrivilege(null, null, "server1", "db1", null, null, null, null);
        Assert.assertEquals((String)"server=server1->db=db1", (String)SentryStore.toAuthorizable((MSentryPrivilege)this.privilege));
        this.privilege = new MSentryPrivilege(null, null, "server1", "db1", null, null, null, "*");
        Assert.assertEquals((String)"server=server1->db=db1", (String)SentryStore.toAuthorizable((MSentryPrivilege)this.privilege));
    }

    @Test
    public void testUri() {
        this.privilege = new MSentryPrivilege(null, null, "server1", null, null, null, "file:///", null);
        Assert.assertEquals((String)"server=server1->uri=file:///", (String)SentryStore.toAuthorizable((MSentryPrivilege)this.privilege));
        this.privilege = new MSentryPrivilege(null, null, "server1", null, null, null, "file:///", "select");
        Assert.assertEquals((String)"server=server1->uri=file:///->action=select", (String)SentryStore.toAuthorizable((MSentryPrivilege)this.privilege));
        this.privilege = new MSentryPrivilege(null, null, "server1", null, null, null, "file:///", "*");
        Assert.assertEquals((String)"server=server1->uri=file:///", (String)SentryStore.toAuthorizable((MSentryPrivilege)this.privilege));
    }
}

