/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.service.persistent;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.Assert;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.sentry.provider.db.service.model.MSentryGroup;
import org.apache.sentry.provider.db.service.model.MSentryPrivilege;
import org.apache.sentry.provider.db.service.model.MSentryRole;
import org.apache.sentry.provider.db.service.persistent.SentryStore;
import org.apache.sentry.provider.db.service.thrift.TSentryGrantOption;
import org.apache.sentry.provider.db.service.thrift.TSentryMappingData;
import org.apache.sentry.provider.db.service.thrift.TSentryPrivilege;
import org.apache.sentry.provider.file.PolicyFile;
import org.apache.sentry.service.thrift.ServiceConstants;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestSentryStoreImportExport {
    private static File dataDir;
    private static SentryStore sentryStore;
    private static String[] adminGroups;
    private static PolicyFile policyFile;
    private static File policyFilePath;
    private TSentryPrivilege tSentryPrivilege1;
    private TSentryPrivilege tSentryPrivilege2;
    private TSentryPrivilege tSentryPrivilege3;
    private TSentryPrivilege tSentryPrivilege4;
    private TSentryPrivilege tSentryPrivilege5;
    private TSentryPrivilege tSentryPrivilege6;
    private TSentryPrivilege tSentryPrivilege7;
    private TSentryPrivilege tSentryPrivilege8;

    @BeforeClass
    public static void setupEnv() throws Exception {
        dataDir = new File(Files.createTempDir(), "sentry_policy_db");
        Configuration conf = new Configuration(false);
        conf.set("sentry.verify.schema.version", "false");
        conf.set("sentry.store.jdbc.url", "jdbc:derby:;databaseName=" + dataDir.getPath() + ";create=true");
        conf.set("sentry.store.jdbc.password", "sentry");
        conf.setStrings("sentry.service.admin.group", adminGroups);
        conf.set("sentry.store.group.mapping", "org.apache.sentry.provider.file.LocalGroupMappingService");
        policyFilePath = new File(dataDir, "local_policy_file.ini");
        conf.set("sentry.store.group.mapping.resource", policyFilePath.getPath());
        policyFile = new PolicyFile();
        sentryStore = new SentryStore(conf);
        String adminUser = "g1";
        TestSentryStoreImportExport.addGroupsToUser(adminUser, adminGroups);
        TestSentryStoreImportExport.writePolicyFile();
    }

    @Before
    public void setupPrivilege() {
        this.preparePrivilege();
    }

    @After
    public void clearStore() {
        sentryStore.clearAllTables();
    }

    private void preparePrivilege() {
        this.tSentryPrivilege1 = this.createTSentryPrivilege(ServiceConstants.PrivilegeScope.SERVER.name(), "server1", "", "", "", "", "", TSentryGrantOption.UNSET);
        this.tSentryPrivilege2 = this.createTSentryPrivilege(ServiceConstants.PrivilegeScope.SERVER.name(), "server1", "", "", "", "", "select", TSentryGrantOption.FALSE);
        this.tSentryPrivilege3 = this.createTSentryPrivilege(ServiceConstants.PrivilegeScope.DATABASE.name(), "server1", "db2", "", "", "", "insert", TSentryGrantOption.TRUE);
        this.tSentryPrivilege4 = this.createTSentryPrivilege(ServiceConstants.PrivilegeScope.TABLE.name(), "server1", "db1", "tbl1", "", "", "insert", TSentryGrantOption.FALSE);
        this.tSentryPrivilege5 = this.createTSentryPrivilege(ServiceConstants.PrivilegeScope.COLUMN.name(), "server1", "db1", "tbl2", "col1", "", "insert", TSentryGrantOption.FALSE);
        this.tSentryPrivilege6 = this.createTSentryPrivilege(ServiceConstants.PrivilegeScope.COLUMN.name(), "server1", "db1", "tbl3", "col1", "", "*", TSentryGrantOption.TRUE);
        this.tSentryPrivilege7 = this.createTSentryPrivilege(ServiceConstants.PrivilegeScope.COLUMN.name(), "server1", "db1", "tbl4", "col1", "", "ALL", TSentryGrantOption.TRUE);
        this.tSentryPrivilege8 = this.createTSentryPrivilege(ServiceConstants.PrivilegeScope.URI.name(), "server1", "", "", "", "hdfs://testserver:9999/path1", "insert", TSentryGrantOption.FALSE);
    }

    @AfterClass
    public static void teardown() {
        if (sentryStore != null) {
            sentryStore.stop();
        }
        if (dataDir != null) {
            FileUtils.deleteQuietly((File)dataDir);
        }
    }

    protected static void addGroupsToUser(String user, String ... groupNames) {
        policyFile.addGroupsToUser(user, groupNames);
    }

    protected static void writePolicyFile() throws Exception {
        policyFile.write(policyFilePath);
    }

    @Test
    public void testImportExportPolicy1() throws Exception {
        TSentryMappingData tSentryMappingData = new TSentryMappingData();
        HashMap sentryGroupRolesMap = Maps.newHashMap();
        HashMap sentryRolePrivilegesMap = Maps.newHashMap();
        sentryGroupRolesMap.put("group1", Sets.newHashSet((Object[])new String[]{"Role1", "role2", "role3"}));
        sentryGroupRolesMap.put("group2", Sets.newHashSet((Object[])new String[]{"Role1", "role2", "role3"}));
        sentryGroupRolesMap.put("group3", Sets.newHashSet((Object[])new String[]{"Role1", "role2", "role3"}));
        sentryRolePrivilegesMap.put("Role1", Sets.newHashSet((Object[])new TSentryPrivilege[]{this.tSentryPrivilege1, this.tSentryPrivilege2, this.tSentryPrivilege3, this.tSentryPrivilege4, this.tSentryPrivilege5, this.tSentryPrivilege6, this.tSentryPrivilege7, this.tSentryPrivilege8}));
        sentryRolePrivilegesMap.put("role2", Sets.newHashSet((Object[])new TSentryPrivilege[]{this.tSentryPrivilege1, this.tSentryPrivilege2, this.tSentryPrivilege3, this.tSentryPrivilege4, this.tSentryPrivilege5, this.tSentryPrivilege6, this.tSentryPrivilege7, this.tSentryPrivilege8}));
        sentryRolePrivilegesMap.put("role3", Sets.newHashSet((Object[])new TSentryPrivilege[]{this.tSentryPrivilege1, this.tSentryPrivilege2, this.tSentryPrivilege3, this.tSentryPrivilege4, this.tSentryPrivilege5, this.tSentryPrivilege6, this.tSentryPrivilege7, this.tSentryPrivilege8}));
        tSentryMappingData.setGroupRolesMap((Map)sentryGroupRolesMap);
        tSentryMappingData.setRolePrivilegesMap((Map)sentryRolePrivilegesMap);
        sentryStore.importSentryMetaData(tSentryMappingData, false);
        Map rolesMap = sentryStore.getRolesMap();
        Map groupsMap = sentryStore.getGroupNameTGroupMap();
        List privilegesList = sentryStore.getPrivilegesList();
        this.verifyRoles(rolesMap, Sets.newHashSet((Object[])new String[]{"role1", "role2", "role3"}));
        this.verifyGroups(groupsMap, Sets.newHashSet((Object[])new String[]{"group1", "group2", "group3"}));
        this.verifyPrivileges(privilegesList, Sets.newHashSet((Object[])new TSentryPrivilege[]{this.tSentryPrivilege1, this.tSentryPrivilege2, this.tSentryPrivilege3, this.tSentryPrivilege4, this.tSentryPrivilege5, this.tSentryPrivilege6, this.tSentryPrivilege7, this.tSentryPrivilege8}));
        Map actualGroupRolesMap = sentryStore.getGroupNameRoleNamesMap();
        HashMap exceptedGroupRolesMap = Maps.newHashMap();
        exceptedGroupRolesMap.put("group1", Sets.newHashSet((Object[])new String[]{"role1", "role2", "role3"}));
        exceptedGroupRolesMap.put("group2", Sets.newHashSet((Object[])new String[]{"role1", "role2", "role3"}));
        exceptedGroupRolesMap.put("group3", Sets.newHashSet((Object[])new String[]{"role1", "role2", "role3"}));
        this.verifyGroupRolesMap(actualGroupRolesMap, exceptedGroupRolesMap);
        Map actualRolePrivilegesMap = sentryStore.getRoleNameTPrivilegesMap();
        HashMap exceptedRolePrivilegesMap = Maps.newHashMap();
        exceptedRolePrivilegesMap.put("role1", Sets.newHashSet((Object[])new TSentryPrivilege[]{this.tSentryPrivilege1, this.tSentryPrivilege2, this.tSentryPrivilege3, this.tSentryPrivilege4, this.tSentryPrivilege5, this.tSentryPrivilege6, this.tSentryPrivilege7, this.tSentryPrivilege8}));
        exceptedRolePrivilegesMap.put("role2", Sets.newHashSet((Object[])new TSentryPrivilege[]{this.tSentryPrivilege1, this.tSentryPrivilege2, this.tSentryPrivilege3, this.tSentryPrivilege4, this.tSentryPrivilege5, this.tSentryPrivilege6, this.tSentryPrivilege7, this.tSentryPrivilege8}));
        exceptedRolePrivilegesMap.put("role3", Sets.newHashSet((Object[])new TSentryPrivilege[]{this.tSentryPrivilege1, this.tSentryPrivilege2, this.tSentryPrivilege3, this.tSentryPrivilege4, this.tSentryPrivilege5, this.tSentryPrivilege6, this.tSentryPrivilege7, this.tSentryPrivilege8}));
        this.verifyRolePrivilegesMap(actualRolePrivilegesMap, exceptedRolePrivilegesMap);
    }

    @Test
    public void testImportExportPolicy2() throws Exception {
        TSentryMappingData tSentryMappingData1 = new TSentryMappingData();
        HashMap sentryGroupRolesMap1 = Maps.newHashMap();
        HashMap sentryRolePrivilegesMap1 = Maps.newHashMap();
        sentryGroupRolesMap1.put("group1", Sets.newHashSet((Object[])new String[]{"role1"}));
        sentryRolePrivilegesMap1.put("role1", Sets.newHashSet((Object[])new TSentryPrivilege[]{this.tSentryPrivilege1, this.tSentryPrivilege2, this.tSentryPrivilege3, this.tSentryPrivilege4}));
        tSentryMappingData1.setGroupRolesMap((Map)sentryGroupRolesMap1);
        tSentryMappingData1.setRolePrivilegesMap((Map)sentryRolePrivilegesMap1);
        sentryStore.importSentryMetaData(tSentryMappingData1, false);
        TSentryMappingData tSentryMappingData2 = new TSentryMappingData();
        HashMap sentryGroupRolesMap2 = Maps.newHashMap();
        HashMap sentryRolePrivilegesMap2 = Maps.newHashMap();
        sentryGroupRolesMap2.put("group2", Sets.newHashSet((Object[])new String[]{"role2", "role3"}));
        sentryGroupRolesMap2.put("group3", Sets.newHashSet((Object[])new String[]{"role2", "role3"}));
        sentryRolePrivilegesMap2.put("role2", Sets.newHashSet((Object[])new TSentryPrivilege[]{this.tSentryPrivilege5, this.tSentryPrivilege6, this.tSentryPrivilege7, this.tSentryPrivilege8}));
        sentryRolePrivilegesMap2.put("role3", Sets.newHashSet((Object[])new TSentryPrivilege[]{this.tSentryPrivilege5, this.tSentryPrivilege6, this.tSentryPrivilege7, this.tSentryPrivilege8}));
        tSentryMappingData2.setGroupRolesMap((Map)sentryGroupRolesMap2);
        tSentryMappingData2.setRolePrivilegesMap((Map)sentryRolePrivilegesMap2);
        sentryStore.importSentryMetaData(tSentryMappingData2, false);
        Map rolesMap = sentryStore.getRolesMap();
        Map groupsMap = sentryStore.getGroupNameTGroupMap();
        List privilegesList = sentryStore.getPrivilegesList();
        this.verifyRoles(rolesMap, Sets.newHashSet((Object[])new String[]{"role1", "role2", "role3"}));
        this.verifyGroups(groupsMap, Sets.newHashSet((Object[])new String[]{"group1", "group2", "group3"}));
        this.verifyPrivileges(privilegesList, Sets.newHashSet((Object[])new TSentryPrivilege[]{this.tSentryPrivilege1, this.tSentryPrivilege2, this.tSentryPrivilege3, this.tSentryPrivilege4, this.tSentryPrivilege5, this.tSentryPrivilege6, this.tSentryPrivilege7, this.tSentryPrivilege8}));
        Map actualGroupRolesMap = sentryStore.getGroupNameRoleNamesMap();
        HashMap exceptedGroupRolesMap = Maps.newHashMap();
        exceptedGroupRolesMap.put("group1", Sets.newHashSet((Object[])new String[]{"role1"}));
        exceptedGroupRolesMap.put("group2", Sets.newHashSet((Object[])new String[]{"role2", "role3"}));
        exceptedGroupRolesMap.put("group3", Sets.newHashSet((Object[])new String[]{"role2", "role3"}));
        this.verifyGroupRolesMap(actualGroupRolesMap, exceptedGroupRolesMap);
        Map actualRolePrivilegesMap = sentryStore.getRoleNameTPrivilegesMap();
        HashMap exceptedRolePrivilegesMap = Maps.newHashMap();
        exceptedRolePrivilegesMap.put("role1", Sets.newHashSet((Object[])new TSentryPrivilege[]{this.tSentryPrivilege1, this.tSentryPrivilege2, this.tSentryPrivilege3, this.tSentryPrivilege4}));
        exceptedRolePrivilegesMap.put("role2", Sets.newHashSet((Object[])new TSentryPrivilege[]{this.tSentryPrivilege5, this.tSentryPrivilege6, this.tSentryPrivilege7, this.tSentryPrivilege8}));
        exceptedRolePrivilegesMap.put("role3", Sets.newHashSet((Object[])new TSentryPrivilege[]{this.tSentryPrivilege5, this.tSentryPrivilege6, this.tSentryPrivilege7, this.tSentryPrivilege8}));
        this.verifyRolePrivilegesMap(actualRolePrivilegesMap, exceptedRolePrivilegesMap);
    }

    @Test
    public void testImportExportPolicy3() throws Exception {
        TSentryMappingData tSentryMappingData1 = new TSentryMappingData();
        HashMap sentryGroupRolesMap1 = Maps.newHashMap();
        HashMap sentryRolePrivilegesMap1 = Maps.newHashMap();
        sentryGroupRolesMap1.put("group1", Sets.newHashSet((Object[])new String[]{"role1", "role2"}));
        sentryGroupRolesMap1.put("group2", Sets.newHashSet((Object[])new String[]{"role1", "role2"}));
        sentryGroupRolesMap1.put("group3", Sets.newHashSet((Object[])new String[]{"role1", "role2"}));
        sentryRolePrivilegesMap1.put("role1", Sets.newHashSet((Object[])new TSentryPrivilege[]{this.tSentryPrivilege1, this.tSentryPrivilege2, this.tSentryPrivilege3, this.tSentryPrivilege4, this.tSentryPrivilege5}));
        sentryRolePrivilegesMap1.put("role2", Sets.newHashSet((Object[])new TSentryPrivilege[]{this.tSentryPrivilege1, this.tSentryPrivilege2, this.tSentryPrivilege3, this.tSentryPrivilege4, this.tSentryPrivilege5}));
        tSentryMappingData1.setGroupRolesMap((Map)sentryGroupRolesMap1);
        tSentryMappingData1.setRolePrivilegesMap((Map)sentryRolePrivilegesMap1);
        sentryStore.importSentryMetaData(tSentryMappingData1, false);
        TSentryMappingData tSentryMappingData2 = new TSentryMappingData();
        HashMap sentryGroupRolesMap2 = Maps.newHashMap();
        HashMap sentryRolePrivilegesMap2 = Maps.newHashMap();
        sentryGroupRolesMap2.put("group1", Sets.newHashSet((Object[])new String[]{"role2", "role3"}));
        sentryGroupRolesMap2.put("group2", Sets.newHashSet((Object[])new String[]{"role2", "role3"}));
        sentryGroupRolesMap2.put("group3", Sets.newHashSet((Object[])new String[]{"role2", "role3"}));
        sentryRolePrivilegesMap2.put("role2", Sets.newHashSet((Object[])new TSentryPrivilege[]{this.tSentryPrivilege4, this.tSentryPrivilege5, this.tSentryPrivilege6, this.tSentryPrivilege7, this.tSentryPrivilege8}));
        sentryRolePrivilegesMap2.put("role3", Sets.newHashSet((Object[])new TSentryPrivilege[]{this.tSentryPrivilege4, this.tSentryPrivilege5, this.tSentryPrivilege6, this.tSentryPrivilege7, this.tSentryPrivilege8}));
        tSentryMappingData2.setGroupRolesMap((Map)sentryGroupRolesMap2);
        tSentryMappingData2.setRolePrivilegesMap((Map)sentryRolePrivilegesMap2);
        sentryStore.importSentryMetaData(tSentryMappingData2, false);
        Map rolesMap = sentryStore.getRolesMap();
        Map groupsMap = sentryStore.getGroupNameTGroupMap();
        List privilegesList = sentryStore.getPrivilegesList();
        this.verifyRoles(rolesMap, Sets.newHashSet((Object[])new String[]{"role1", "role2", "role3"}));
        this.verifyGroups(groupsMap, Sets.newHashSet((Object[])new String[]{"group1", "group2", "group3"}));
        this.verifyPrivileges(privilegesList, Sets.newHashSet((Object[])new TSentryPrivilege[]{this.tSentryPrivilege1, this.tSentryPrivilege2, this.tSentryPrivilege3, this.tSentryPrivilege4, this.tSentryPrivilege5, this.tSentryPrivilege6, this.tSentryPrivilege7, this.tSentryPrivilege8}));
        Map actualGroupRolesMap = sentryStore.getGroupNameRoleNamesMap();
        HashMap exceptedGroupRolesMap = Maps.newHashMap();
        exceptedGroupRolesMap.put("group1", Sets.newHashSet((Object[])new String[]{"role1", "role2", "role3"}));
        exceptedGroupRolesMap.put("group2", Sets.newHashSet((Object[])new String[]{"role1", "role2", "role3"}));
        exceptedGroupRolesMap.put("group3", Sets.newHashSet((Object[])new String[]{"role1", "role2", "role3"}));
        this.verifyGroupRolesMap(actualGroupRolesMap, exceptedGroupRolesMap);
        Map actualRolePrivilegesMap = sentryStore.getRoleNameTPrivilegesMap();
        HashMap exceptedRolePrivilegesMap = Maps.newHashMap();
        exceptedRolePrivilegesMap.put("role1", Sets.newHashSet((Object[])new TSentryPrivilege[]{this.tSentryPrivilege1, this.tSentryPrivilege2, this.tSentryPrivilege3, this.tSentryPrivilege4, this.tSentryPrivilege5}));
        exceptedRolePrivilegesMap.put("role2", Sets.newHashSet((Object[])new TSentryPrivilege[]{this.tSentryPrivilege1, this.tSentryPrivilege2, this.tSentryPrivilege3, this.tSentryPrivilege4, this.tSentryPrivilege5, this.tSentryPrivilege6, this.tSentryPrivilege7, this.tSentryPrivilege8}));
        exceptedRolePrivilegesMap.put("role3", Sets.newHashSet((Object[])new TSentryPrivilege[]{this.tSentryPrivilege4, this.tSentryPrivilege5, this.tSentryPrivilege6, this.tSentryPrivilege7, this.tSentryPrivilege8}));
        this.verifyRolePrivilegesMap(actualRolePrivilegesMap, exceptedRolePrivilegesMap);
    }

    @Test
    public void testImportExportPolicy4() throws Exception {
        TSentryMappingData tSentryMappingData1 = new TSentryMappingData();
        HashMap sentryGroupRolesMap1 = Maps.newHashMap();
        HashMap sentryRolePrivilegesMap1 = Maps.newHashMap();
        sentryGroupRolesMap1.put("group1", Sets.newHashSet((Object[])new String[]{"role1", "role2"}));
        sentryRolePrivilegesMap1.put("role1", Sets.newHashSet((Object[])new TSentryPrivilege[]{this.tSentryPrivilege1, this.tSentryPrivilege2}));
        sentryRolePrivilegesMap1.put("role2", Sets.newHashSet((Object[])new TSentryPrivilege[]{this.tSentryPrivilege3, this.tSentryPrivilege4}));
        tSentryMappingData1.setGroupRolesMap((Map)sentryGroupRolesMap1);
        tSentryMappingData1.setRolePrivilegesMap((Map)sentryRolePrivilegesMap1);
        sentryStore.importSentryMetaData(tSentryMappingData1, false);
        TSentryMappingData tSentryMappingData2 = new TSentryMappingData();
        HashMap sentryGroupRolesMap2 = Maps.newHashMap();
        HashMap sentryRolePrivilegesMap2 = Maps.newHashMap();
        sentryGroupRolesMap2.put("group2", Sets.newHashSet((Object[])new String[]{"role2"}));
        sentryRolePrivilegesMap2.put("role2", Sets.newHashSet((Object[])new TSentryPrivilege[]{this.tSentryPrivilege5, this.tSentryPrivilege6}));
        sentryRolePrivilegesMap2.put("role3", Sets.newHashSet((Object[])new TSentryPrivilege[]{this.tSentryPrivilege7, this.tSentryPrivilege8}));
        tSentryMappingData2.setGroupRolesMap((Map)sentryGroupRolesMap2);
        tSentryMappingData2.setRolePrivilegesMap((Map)sentryRolePrivilegesMap2);
        sentryStore.importSentryMetaData(tSentryMappingData2, false);
        Map rolesMap = sentryStore.getRolesMap();
        Map groupsMap = sentryStore.getGroupNameTGroupMap();
        List privilegesList = sentryStore.getPrivilegesList();
        this.verifyRoles(rolesMap, Sets.newHashSet((Object[])new String[]{"role1", "role2", "role3"}));
        this.verifyGroups(groupsMap, Sets.newHashSet((Object[])new String[]{"group1", "group2"}));
        this.verifyPrivileges(privilegesList, Sets.newHashSet((Object[])new TSentryPrivilege[]{this.tSentryPrivilege1, this.tSentryPrivilege2, this.tSentryPrivilege3, this.tSentryPrivilege4, this.tSentryPrivilege5, this.tSentryPrivilege6, this.tSentryPrivilege7, this.tSentryPrivilege8}));
        Map actualGroupRolesMap = sentryStore.getGroupNameRoleNamesMap();
        HashMap exceptedGroupRolesMap = Maps.newHashMap();
        exceptedGroupRolesMap.put("group1", Sets.newHashSet((Object[])new String[]{"role1", "role2"}));
        exceptedGroupRolesMap.put("group2", Sets.newHashSet((Object[])new String[]{"role2"}));
        this.verifyGroupRolesMap(actualGroupRolesMap, exceptedGroupRolesMap);
        Map actualRolePrivilegesMap = sentryStore.getRoleNameTPrivilegesMap();
        HashMap exceptedRolePrivilegesMap = Maps.newHashMap();
        exceptedRolePrivilegesMap.put("role1", Sets.newHashSet((Object[])new TSentryPrivilege[]{this.tSentryPrivilege1, this.tSentryPrivilege2}));
        exceptedRolePrivilegesMap.put("role2", Sets.newHashSet((Object[])new TSentryPrivilege[]{this.tSentryPrivilege3, this.tSentryPrivilege4, this.tSentryPrivilege5, this.tSentryPrivilege6}));
        exceptedRolePrivilegesMap.put("role3", Sets.newHashSet((Object[])new TSentryPrivilege[]{this.tSentryPrivilege7, this.tSentryPrivilege8}));
        this.verifyRolePrivilegesMap(actualRolePrivilegesMap, exceptedRolePrivilegesMap);
    }

    @Test
    public void testImportExportPolicy5() throws Exception {
        TSentryMappingData tSentryMappingData1 = new TSentryMappingData();
        HashMap sentryGroupRolesMap1 = Maps.newHashMap();
        HashMap sentryRolePrivilegesMap1 = Maps.newHashMap();
        sentryGroupRolesMap1.put("group1", Sets.newHashSet((Object[])new String[]{"role1", "role2"}));
        tSentryMappingData1.setGroupRolesMap((Map)sentryGroupRolesMap1);
        tSentryMappingData1.setRolePrivilegesMap((Map)sentryRolePrivilegesMap1);
        sentryStore.importSentryMetaData(tSentryMappingData1, false);
        Map rolesMap = sentryStore.getRolesMap();
        Map groupsMap = sentryStore.getGroupNameTGroupMap();
        List privilegesList = sentryStore.getPrivilegesList();
        this.verifyRoles(rolesMap, Sets.newHashSet((Object[])new String[]{"role1", "role2"}));
        this.verifyGroups(groupsMap, Sets.newHashSet((Object[])new String[]{"group1"}));
        Assert.assertTrue((boolean)privilegesList.isEmpty());
        Map actualGroupRolesMap = sentryStore.getGroupNameRoleNamesMap();
        HashMap exceptedGroupRolesMap = Maps.newHashMap();
        exceptedGroupRolesMap.put("group1", Sets.newHashSet((Object[])new String[]{"role1", "role2"}));
        this.verifyGroupRolesMap(actualGroupRolesMap, exceptedGroupRolesMap);
        Map actualRolePrivilegesMap = sentryStore.getRoleNameTPrivilegesMap();
        Assert.assertTrue((boolean)actualRolePrivilegesMap.isEmpty());
    }

    @Test
    public void testImportExportPolicy6() throws Exception {
        TSentryMappingData tSentryMappingData1 = new TSentryMappingData();
        HashMap sentryGroupRolesMap1 = Maps.newHashMap();
        HashMap sentryRolePrivilegesMap1 = Maps.newHashMap();
        sentryGroupRolesMap1.put("group1", Sets.newHashSet((Object[])new String[]{"role1", "role2"}));
        sentryGroupRolesMap1.put("group2", Sets.newHashSet((Object[])new String[]{"role2"}));
        tSentryMappingData1.setGroupRolesMap((Map)sentryGroupRolesMap1);
        tSentryMappingData1.setRolePrivilegesMap((Map)sentryRolePrivilegesMap1);
        sentryStore.importSentryMetaData(tSentryMappingData1, false);
        sentryStore.dropSentryRole("role2");
        Map rolesMap = sentryStore.getRolesMap();
        Map groupsMap = sentryStore.getGroupNameTGroupMap();
        List privilegesList = sentryStore.getPrivilegesList();
        this.verifyRoles(rolesMap, Sets.newHashSet((Object[])new String[]{"role1"}));
        this.verifyGroups(groupsMap, Sets.newHashSet((Object[])new String[]{"group1", "group2"}));
        Assert.assertTrue((boolean)privilegesList.isEmpty());
        Map actualGroupRolesMap = sentryStore.getGroupNameRoleNamesMap();
        HashMap exceptedGroupRolesMap = Maps.newHashMap();
        exceptedGroupRolesMap.put("group1", Sets.newHashSet((Object[])new String[]{"role1"}));
        this.verifyGroupRolesMap(actualGroupRolesMap, exceptedGroupRolesMap);
        Map actualRolePrivilegesMap = sentryStore.getRoleNameTPrivilegesMap();
        Assert.assertTrue((boolean)actualRolePrivilegesMap.isEmpty());
    }

    @Test
    public void testImportExportPolicy7() throws Exception {
        TSentryMappingData tSentryMappingData1 = new TSentryMappingData();
        HashMap sentryGroupRolesMap1 = Maps.newHashMap();
        HashMap sentryRolePrivilegesMap1 = Maps.newHashMap();
        sentryGroupRolesMap1.put("group1", Sets.newHashSet((Object[])new String[]{"role1"}));
        sentryRolePrivilegesMap1.put("role1", Sets.newHashSet((Object[])new TSentryPrivilege[]{this.tSentryPrivilege1}));
        tSentryMappingData1.setGroupRolesMap((Map)sentryGroupRolesMap1);
        tSentryMappingData1.setRolePrivilegesMap((Map)sentryRolePrivilegesMap1);
        sentryStore.importSentryMetaData(tSentryMappingData1, true);
        TSentryMappingData tSentryMappingData2 = new TSentryMappingData();
        HashMap sentryGroupRolesMap2 = Maps.newHashMap();
        HashMap sentryRolePrivilegesMap2 = Maps.newHashMap();
        sentryGroupRolesMap2.put("group2", Sets.newHashSet((Object[])new String[]{"role2", "role3"}));
        sentryGroupRolesMap2.put("group3", Sets.newHashSet((Object[])new String[]{"role2", "role3"}));
        sentryRolePrivilegesMap2.put("role2", Sets.newHashSet((Object[])new TSentryPrivilege[]{this.tSentryPrivilege2}));
        sentryRolePrivilegesMap2.put("role3", Sets.newHashSet((Object[])new TSentryPrivilege[]{this.tSentryPrivilege2}));
        tSentryMappingData2.setGroupRolesMap((Map)sentryGroupRolesMap2);
        tSentryMappingData2.setRolePrivilegesMap((Map)sentryRolePrivilegesMap2);
        sentryStore.importSentryMetaData(tSentryMappingData2, true);
        Map rolesMap = sentryStore.getRolesMap();
        Map groupsMap = sentryStore.getGroupNameTGroupMap();
        List privilegesList = sentryStore.getPrivilegesList();
        this.verifyRoles(rolesMap, Sets.newHashSet((Object[])new String[]{"role1", "role2", "role3"}));
        this.verifyGroups(groupsMap, Sets.newHashSet((Object[])new String[]{"group1", "group2", "group3"}));
        this.verifyPrivileges(privilegesList, Sets.newHashSet((Object[])new TSentryPrivilege[]{this.tSentryPrivilege1, this.tSentryPrivilege2}));
        Map actualGroupRolesMap = sentryStore.getGroupNameRoleNamesMap();
        HashMap exceptedGroupRolesMap = Maps.newHashMap();
        exceptedGroupRolesMap.put("group1", Sets.newHashSet((Object[])new String[]{"role1"}));
        exceptedGroupRolesMap.put("group2", Sets.newHashSet((Object[])new String[]{"role2", "role3"}));
        exceptedGroupRolesMap.put("group3", Sets.newHashSet((Object[])new String[]{"role2", "role3"}));
        this.verifyGroupRolesMap(actualGroupRolesMap, exceptedGroupRolesMap);
        Map actualRolePrivilegesMap = sentryStore.getRoleNameTPrivilegesMap();
        HashMap exceptedRolePrivilegesMap = Maps.newHashMap();
        exceptedRolePrivilegesMap.put("role1", Sets.newHashSet((Object[])new TSentryPrivilege[]{this.tSentryPrivilege1}));
        exceptedRolePrivilegesMap.put("role2", Sets.newHashSet((Object[])new TSentryPrivilege[]{this.tSentryPrivilege2}));
        exceptedRolePrivilegesMap.put("role3", Sets.newHashSet((Object[])new TSentryPrivilege[]{this.tSentryPrivilege2}));
        this.verifyRolePrivilegesMap(actualRolePrivilegesMap, exceptedRolePrivilegesMap);
    }

    @Test
    public void testImportExportPolicy8() throws Exception {
        TSentryMappingData tSentryMappingData1 = new TSentryMappingData();
        HashMap sentryGroupRolesMap1 = Maps.newHashMap();
        HashMap sentryRolePrivilegesMap1 = Maps.newHashMap();
        sentryGroupRolesMap1.put("group1", Sets.newHashSet((Object[])new String[]{"role1", "role2"}));
        sentryGroupRolesMap1.put("group2", Sets.newHashSet((Object[])new String[]{"role1", "role2"}));
        sentryGroupRolesMap1.put("group3", Sets.newHashSet((Object[])new String[]{"role1", "role2"}));
        sentryRolePrivilegesMap1.put("role1", Sets.newHashSet((Object[])new TSentryPrivilege[]{this.tSentryPrivilege1, this.tSentryPrivilege2, this.tSentryPrivilege3, this.tSentryPrivilege4, this.tSentryPrivilege5}));
        sentryRolePrivilegesMap1.put("role2", Sets.newHashSet((Object[])new TSentryPrivilege[]{this.tSentryPrivilege1, this.tSentryPrivilege2, this.tSentryPrivilege3, this.tSentryPrivilege4, this.tSentryPrivilege5}));
        tSentryMappingData1.setGroupRolesMap((Map)sentryGroupRolesMap1);
        tSentryMappingData1.setRolePrivilegesMap((Map)sentryRolePrivilegesMap1);
        sentryStore.importSentryMetaData(tSentryMappingData1, true);
        TSentryMappingData tSentryMappingData2 = new TSentryMappingData();
        HashMap sentryGroupRolesMap2 = Maps.newHashMap();
        HashMap sentryRolePrivilegesMap2 = Maps.newHashMap();
        sentryGroupRolesMap2.put("group1", Sets.newHashSet((Object[])new String[]{"role2", "role3"}));
        sentryGroupRolesMap2.put("group2", Sets.newHashSet((Object[])new String[]{"role2", "role3"}));
        sentryGroupRolesMap2.put("group3", Sets.newHashSet((Object[])new String[]{"role2", "role3"}));
        sentryRolePrivilegesMap2.put("role2", Sets.newHashSet((Object[])new TSentryPrivilege[]{this.tSentryPrivilege4, this.tSentryPrivilege5, this.tSentryPrivilege6, this.tSentryPrivilege7, this.tSentryPrivilege8}));
        sentryRolePrivilegesMap2.put("role3", Sets.newHashSet((Object[])new TSentryPrivilege[]{this.tSentryPrivilege4, this.tSentryPrivilege5, this.tSentryPrivilege6, this.tSentryPrivilege7, this.tSentryPrivilege8}));
        tSentryMappingData2.setGroupRolesMap((Map)sentryGroupRolesMap2);
        tSentryMappingData2.setRolePrivilegesMap((Map)sentryRolePrivilegesMap2);
        sentryStore.importSentryMetaData(tSentryMappingData2, true);
        Map rolesMap = sentryStore.getRolesMap();
        Map groupsMap = sentryStore.getGroupNameTGroupMap();
        List privilegesList = sentryStore.getPrivilegesList();
        this.verifyRoles(rolesMap, Sets.newHashSet((Object[])new String[]{"role1", "role2", "role3"}));
        this.verifyGroups(groupsMap, Sets.newHashSet((Object[])new String[]{"group1", "group2", "group3"}));
        this.verifyPrivileges(privilegesList, Sets.newHashSet((Object[])new TSentryPrivilege[]{this.tSentryPrivilege1, this.tSentryPrivilege2, this.tSentryPrivilege3, this.tSentryPrivilege4, this.tSentryPrivilege5, this.tSentryPrivilege6, this.tSentryPrivilege7, this.tSentryPrivilege8}));
        Map actualGroupRolesMap = sentryStore.getGroupNameRoleNamesMap();
        HashMap exceptedGroupRolesMap = Maps.newHashMap();
        exceptedGroupRolesMap.put("group1", Sets.newHashSet((Object[])new String[]{"role1", "role2", "role3"}));
        exceptedGroupRolesMap.put("group2", Sets.newHashSet((Object[])new String[]{"role1", "role2", "role3"}));
        exceptedGroupRolesMap.put("group3", Sets.newHashSet((Object[])new String[]{"role1", "role2", "role3"}));
        this.verifyGroupRolesMap(actualGroupRolesMap, exceptedGroupRolesMap);
        Map actualRolePrivilegesMap = sentryStore.getRoleNameTPrivilegesMap();
        HashMap exceptedRolePrivilegesMap = Maps.newHashMap();
        exceptedRolePrivilegesMap.put("role1", Sets.newHashSet((Object[])new TSentryPrivilege[]{this.tSentryPrivilege1, this.tSentryPrivilege2, this.tSentryPrivilege3, this.tSentryPrivilege4, this.tSentryPrivilege5}));
        exceptedRolePrivilegesMap.put("role2", Sets.newHashSet((Object[])new TSentryPrivilege[]{this.tSentryPrivilege4, this.tSentryPrivilege5, this.tSentryPrivilege6, this.tSentryPrivilege7, this.tSentryPrivilege8}));
        exceptedRolePrivilegesMap.put("role3", Sets.newHashSet((Object[])new TSentryPrivilege[]{this.tSentryPrivilege4, this.tSentryPrivilege5, this.tSentryPrivilege6, this.tSentryPrivilege7, this.tSentryPrivilege8}));
        this.verifyRolePrivilegesMap(actualRolePrivilegesMap, exceptedRolePrivilegesMap);
    }

    @Test
    public void testImportExportPolicy9() throws Exception {
        TSentryPrivilege testPrivilege1 = this.createTSentryPrivilege(ServiceConstants.PrivilegeScope.TABLE.name(), "server1", "db1", "tbl1", "", "", "select", TSentryGrantOption.TRUE);
        TSentryPrivilege testPrivilege2 = this.createTSentryPrivilege(ServiceConstants.PrivilegeScope.TABLE.name(), "server1", "db1", "tbl1", "", "", "insert", TSentryGrantOption.FALSE);
        TSentryPrivilege testPrivilege3 = this.createTSentryPrivilege(ServiceConstants.PrivilegeScope.TABLE.name(), "server1", "db1", "tbl1", "", "", "ALL", TSentryGrantOption.TRUE);
        TSentryPrivilege testPrivilege4 = this.createTSentryPrivilege(ServiceConstants.PrivilegeScope.TABLE.name(), "server1", "db1", "tbl1", "", "", "insert", TSentryGrantOption.TRUE);
        TSentryPrivilege testPrivilege5 = this.createTSentryPrivilege(ServiceConstants.PrivilegeScope.TABLE.name(), "server1", "db1", "tbl2", "", "", "select", TSentryGrantOption.TRUE);
        TSentryPrivilege testPrivilege6 = this.createTSentryPrivilege(ServiceConstants.PrivilegeScope.TABLE.name(), "server1", "db1", "tbl2", "", "", "insert", TSentryGrantOption.FALSE);
        TSentryPrivilege testPrivilege7 = this.createTSentryPrivilege(ServiceConstants.PrivilegeScope.TABLE.name(), "server1", "db1", "tbl2", "", "", "*", TSentryGrantOption.TRUE);
        TSentryPrivilege testPrivilege8 = this.createTSentryPrivilege(ServiceConstants.PrivilegeScope.TABLE.name(), "server1", "db1", "tbl2", "", "", "insert", TSentryGrantOption.TRUE);
        TSentryMappingData tSentryMappingData1 = new TSentryMappingData();
        HashMap sentryGroupRolesMap1 = Maps.newHashMap();
        HashMap sentryRolePrivilegesMap1 = Maps.newHashMap();
        sentryGroupRolesMap1.put("group1", Sets.newHashSet((Object[])new String[]{"role1", "role2"}));
        sentryRolePrivilegesMap1.put("role1", Sets.newHashSet((Object[])new TSentryPrivilege[]{testPrivilege1, testPrivilege2, testPrivilege3, testPrivilege4}));
        sentryRolePrivilegesMap1.put("role2", Sets.newHashSet((Object[])new TSentryPrivilege[]{testPrivilege5, testPrivilege6, testPrivilege7, testPrivilege8}));
        tSentryMappingData1.setGroupRolesMap((Map)sentryGroupRolesMap1);
        tSentryMappingData1.setRolePrivilegesMap((Map)sentryRolePrivilegesMap1);
        sentryStore.importSentryMetaData(tSentryMappingData1, true);
        Map rolesMap = sentryStore.getRolesMap();
        Map groupsMap = sentryStore.getGroupNameTGroupMap();
        this.verifyRoles(rolesMap, Sets.newHashSet((Object[])new String[]{"role1", "role2"}));
        this.verifyGroups(groupsMap, Sets.newHashSet((Object[])new String[]{"group1"}));
        Map actualGroupRolesMap = sentryStore.getGroupNameRoleNamesMap();
        HashMap exceptedGroupRolesMap = Maps.newHashMap();
        exceptedGroupRolesMap.put("group1", Sets.newHashSet((Object[])new String[]{"role1", "role2"}));
        this.verifyGroupRolesMap(actualGroupRolesMap, exceptedGroupRolesMap);
        Map actualRolePrivilegesMap = sentryStore.getRoleNameTPrivilegesMap();
        HashMap exceptedRolePrivilegesMap = Maps.newHashMap();
        exceptedRolePrivilegesMap.put("role1", Sets.newHashSet((Object[])new TSentryPrivilege[]{testPrivilege2, testPrivilege3}));
        exceptedRolePrivilegesMap.put("role2", Sets.newHashSet((Object[])new TSentryPrivilege[]{testPrivilege6, testPrivilege7}));
        this.verifyRolePrivilegesMap(actualRolePrivilegesMap, exceptedRolePrivilegesMap);
    }

    private void verifyRoles(Map<String, MSentryRole> actualRoleMap, Set<String> expectedRoleNameSet) {
        Assert.assertEquals((int)expectedRoleNameSet.size(), (int)actualRoleMap.keySet().size());
        for (String roleName : actualRoleMap.keySet()) {
            Assert.assertTrue((boolean)expectedRoleNameSet.contains(roleName));
        }
    }

    private void verifyGroups(Map<String, MSentryGroup> actualGroupsMap, Set<String> expectedGroupNameSet) {
        Assert.assertEquals((int)expectedGroupNameSet.size(), (int)actualGroupsMap.keySet().size());
        for (String groupName : actualGroupsMap.keySet()) {
            Assert.assertTrue((boolean)expectedGroupNameSet.contains(groupName));
        }
    }

    private void verifyPrivileges(List<MSentryPrivilege> actualPrivileges, Set<TSentryPrivilege> expectedTSentryPrivilegeSet) {
        Assert.assertEquals((int)expectedTSentryPrivilegeSet.size(), (int)actualPrivileges.size());
        for (MSentryPrivilege mSentryPrivilege : actualPrivileges) {
            boolean isFound = false;
            for (TSentryPrivilege tSentryPrivilege : expectedTSentryPrivilegeSet) {
                isFound = this.compareTSentryPrivilege(sentryStore.convertToTSentryPrivilege(mSentryPrivilege), tSentryPrivilege);
                if (!isFound) continue;
                break;
            }
            Assert.assertTrue((boolean)isFound);
        }
    }

    private void verifyGroupRolesMap(Map<String, Set<String>> actualGroupRolesMap, Map<String, Set<String>> exceptedGroupRolesMap) {
        Assert.assertEquals((int)exceptedGroupRolesMap.keySet().size(), (int)actualGroupRolesMap.keySet().size());
        for (String groupName : actualGroupRolesMap.keySet()) {
            Set<String> exceptedRoles = exceptedGroupRolesMap.get(groupName);
            Set<String> actualRoles = actualGroupRolesMap.get(groupName);
            Assert.assertEquals((int)actualRoles.size(), (int)exceptedRoles.size());
            Assert.assertTrue((boolean)actualRoles.equals(exceptedRoles));
        }
    }

    private void verifyRolePrivilegesMap(Map<String, Set<TSentryPrivilege>> actualRolePrivilegesMap, Map<String, Set<TSentryPrivilege>> expectedRolePrivilegesMap) {
        Assert.assertEquals((int)expectedRolePrivilegesMap.keySet().size(), (int)actualRolePrivilegesMap.keySet().size());
        for (String roleName : expectedRolePrivilegesMap.keySet()) {
            Set<TSentryPrivilege> exceptedTSentryPrivileges = expectedRolePrivilegesMap.get(roleName);
            Set<TSentryPrivilege> actualTSentryPrivileges = actualRolePrivilegesMap.get(roleName);
            Assert.assertEquals((int)exceptedTSentryPrivileges.size(), (int)actualTSentryPrivileges.size());
            for (TSentryPrivilege actualPrivilege : actualTSentryPrivileges) {
                TSentryPrivilege expectedPrivilege;
                boolean isFound = false;
                Iterator<TSentryPrivilege> i$ = exceptedTSentryPrivileges.iterator();
                while (i$.hasNext() && !(isFound = this.compareTSentryPrivilege(expectedPrivilege = i$.next(), actualPrivilege))) {
                }
                Assert.assertTrue((boolean)isFound);
            }
        }
    }

    private TSentryPrivilege createTSentryPrivilege(String scope, String server, String dbName, String tableName, String columnName, String uri, String action, TSentryGrantOption grantOption) {
        TSentryPrivilege tSentryPrivilege = new TSentryPrivilege();
        tSentryPrivilege.setPrivilegeScope(scope);
        tSentryPrivilege.setServerName(server);
        tSentryPrivilege.setDbName(dbName);
        tSentryPrivilege.setTableName(tableName);
        tSentryPrivilege.setColumnName(columnName);
        tSentryPrivilege.setURI(uri);
        tSentryPrivilege.setAction(action);
        tSentryPrivilege.setGrantOption(grantOption);
        return tSentryPrivilege;
    }

    private boolean compareTSentryPrivilege(TSentryPrivilege tSentryPrivilege1, TSentryPrivilege tSentryPrivilege2) {
        if (tSentryPrivilege1 == null) {
            return tSentryPrivilege2 == null;
        }
        if (tSentryPrivilege2 == null) {
            return false;
        }
        boolean this_present_privilegeScope = tSentryPrivilege1.isSetPrivilegeScope();
        boolean that_present_privilegeScope = tSentryPrivilege2.isSetPrivilegeScope();
        if (this_present_privilegeScope || that_present_privilegeScope) {
            if (!this_present_privilegeScope || !that_present_privilegeScope) {
                return false;
            }
            if (!tSentryPrivilege1.getPrivilegeScope().equalsIgnoreCase(tSentryPrivilege2.getPrivilegeScope())) {
                return false;
            }
        }
        boolean this_present_serverName = tSentryPrivilege1.isSetServerName();
        boolean that_present_serverName = tSentryPrivilege2.isSetServerName();
        if (this_present_serverName || that_present_serverName) {
            if (!this_present_serverName || !that_present_serverName) {
                return false;
            }
            if (!tSentryPrivilege1.getServerName().equalsIgnoreCase(tSentryPrivilege2.getServerName())) {
                return false;
            }
        }
        boolean this_present_dbName = tSentryPrivilege1.isSetDbName();
        boolean that_present_dbName = tSentryPrivilege2.isSetDbName();
        if (this_present_dbName || that_present_dbName) {
            if (!this_present_dbName || !that_present_dbName) {
                return false;
            }
            if (!tSentryPrivilege1.getDbName().equalsIgnoreCase(tSentryPrivilege2.getDbName())) {
                return false;
            }
        }
        boolean this_present_tableName = tSentryPrivilege1.isSetTableName();
        boolean that_present_tableName = tSentryPrivilege2.isSetTableName();
        if (this_present_tableName || that_present_tableName) {
            if (!this_present_tableName || !that_present_tableName) {
                return false;
            }
            if (!tSentryPrivilege1.getTableName().equalsIgnoreCase(tSentryPrivilege2.getTableName())) {
                return false;
            }
        }
        boolean this_present_URI = tSentryPrivilege1.isSetURI();
        boolean that_present_URI = tSentryPrivilege2.isSetURI();
        if (this_present_URI || that_present_URI) {
            if (!this_present_URI || !that_present_URI) {
                return false;
            }
            if (!tSentryPrivilege1.getURI().equalsIgnoreCase(tSentryPrivilege2.getURI())) {
                return false;
            }
        }
        boolean this_present_action = tSentryPrivilege1.isSetAction();
        boolean that_present_action = tSentryPrivilege2.isSetAction();
        if (this_present_action || that_present_action) {
            if (!this_present_action || !that_present_action) {
                return false;
            }
            if (!tSentryPrivilege1.getAction().equalsIgnoreCase(tSentryPrivilege2.getAction())) {
                return false;
            }
        }
        boolean this_present_grantOption = tSentryPrivilege1.isSetGrantOption();
        boolean that_present_grantOption = tSentryPrivilege2.isSetGrantOption();
        if (this_present_grantOption || that_present_grantOption) {
            if (!this_present_grantOption || !that_present_grantOption) {
                return false;
            }
            if (!tSentryPrivilege1.getGrantOption().equals((Object)tSentryPrivilege2.getGrantOption())) {
                return false;
            }
        }
        boolean this_present_columnName = tSentryPrivilege1.isSetColumnName();
        boolean that_present_columnName = tSentryPrivilege2.isSetColumnName();
        if (this_present_columnName || that_present_columnName) {
            if (!this_present_columnName || !that_present_columnName) {
                return false;
            }
            if (!tSentryPrivilege1.getColumnName().equalsIgnoreCase(tSentryPrivilege2.getColumnName())) {
                return false;
            }
        }
        return true;
    }

    static {
        adminGroups = new String[]{"adminGroup1"};
    }
}

