/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.service.persistent;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.alias.CredentialProvider;
import org.apache.hadoop.security.alias.CredentialProviderFactory;
import org.apache.sentry.provider.db.SentryAlreadyExistsException;
import org.apache.sentry.provider.db.SentryGrantDeniedException;
import org.apache.sentry.provider.db.SentryNoSuchObjectException;
import org.apache.sentry.provider.db.service.model.MSentryPrivilege;
import org.apache.sentry.provider.db.service.model.MSentryRole;
import org.apache.sentry.provider.db.service.persistent.SentryStore;
import org.apache.sentry.provider.db.service.thrift.TSentryActiveRoleSet;
import org.apache.sentry.provider.db.service.thrift.TSentryAuthorizable;
import org.apache.sentry.provider.db.service.thrift.TSentryGrantOption;
import org.apache.sentry.provider.db.service.thrift.TSentryGroup;
import org.apache.sentry.provider.db.service.thrift.TSentryPrivilege;
import org.apache.sentry.provider.file.PolicyFile;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class TestSentryStore {
    private static File dataDir;
    private static SentryStore sentryStore;
    private static String[] adminGroups;
    private static PolicyFile policyFile;
    private static File policyFilePath;
    final long NUM_PRIVS = 60L;
    private static Configuration conf;
    private static char[] passwd;

    @BeforeClass
    public static void setup() throws Exception {
        conf = new Configuration(false);
        String ourUrl = "user:///";
        conf.set("hadoop.security.credential.provider.path", "user:///");
        CredentialProvider provider = (CredentialProvider)CredentialProviderFactory.getProviders((Configuration)conf).get(0);
        provider.createCredentialEntry("sentry.store.jdbc.password", passwd);
        provider.flush();
        dataDir = new File(Files.createTempDir(), "sentry_policy_db");
        conf.set("sentry.verify.schema.version", "false");
        conf.set("sentry.store.jdbc.url", "jdbc:derby:;databaseName=" + dataDir.getPath() + ";create=true");
        conf.set("sentry.store.jdbc.password", "dummy");
        conf.setStrings("sentry.service.admin.group", adminGroups);
        conf.set("sentry.store.group.mapping", "org.apache.sentry.provider.file.LocalGroupMappingService");
        policyFilePath = new File(dataDir, "local_policy_file.ini");
        conf.set("sentry.store.group.mapping.resource", policyFilePath.getPath());
        sentryStore = new SentryStore(conf);
    }

    @Before
    public void before() throws Exception {
        policyFile = new PolicyFile();
        String adminUser = "g1";
        TestSentryStore.addGroupsToUser(adminUser, adminGroups);
        TestSentryStore.writePolicyFile();
    }

    @After
    public void after() {
        sentryStore.clearAllTables();
    }

    @AfterClass
    public static void teardown() {
        if (sentryStore != null) {
            sentryStore.stop();
        }
        if (dataDir != null) {
            FileUtils.deleteQuietly((File)dataDir);
        }
    }

    @Test
    public void testCredentialProvider() throws Exception {
        Assert.assertArrayEquals((char[])passwd, (char[])conf.getPassword("sentry.store.jdbc.password"));
    }

    @Test
    public void testCaseInsensitiveRole() throws Exception {
        String roleName = "newRole";
        String grantor = "g1";
        HashSet groups = Sets.newHashSet();
        TSentryGroup group = new TSentryGroup();
        group.setGroupName("test-groups-g1");
        groups.add(group);
        TSentryPrivilege privilege = new TSentryPrivilege();
        privilege.setPrivilegeScope("TABLE");
        privilege.setServerName("server1");
        privilege.setDbName("default");
        privilege.setTableName("table1");
        privilege.setAction("*");
        privilege.setCreateTime(System.currentTimeMillis());
        long seqId = sentryStore.createSentryRole(roleName).getSequenceId();
        junit.framework.Assert.assertEquals((long)(seqId + 1L), (long)sentryStore.alterSentryRoleAddGroups(grantor, roleName, (Set)groups).getSequenceId());
        junit.framework.Assert.assertEquals((long)(seqId + 2L), (long)sentryStore.alterSentryRoleDeleteGroups(roleName, (Set)groups).getSequenceId());
        junit.framework.Assert.assertEquals((long)(seqId + 3L), (long)sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName, privilege).getSequenceId());
        junit.framework.Assert.assertEquals((long)(seqId + 4L), (long)sentryStore.alterSentryRoleRevokePrivilege(grantor, roleName, privilege).getSequenceId());
    }

    @Test
    public void testURI() throws Exception {
        String roleName = "test-dup-role";
        String grantor = "g1";
        String uri = "file:///var/folders/dt/9zm44z9s6bjfxbrm4v36lzdc0000gp/T/1401860678102-0/data/kv1.dat";
        sentryStore.createSentryRole(roleName);
        TSentryPrivilege tSentryPrivilege = new TSentryPrivilege("URI", "server1", "ALL");
        tSentryPrivilege.setURI(uri);
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName, tSentryPrivilege);
        TSentryAuthorizable tSentryAuthorizable = new TSentryAuthorizable();
        tSentryAuthorizable.setUri(uri);
        tSentryAuthorizable.setServer("server1");
        Set privileges = sentryStore.getTSentryPrivileges(new HashSet<String>(Arrays.asList(roleName)), tSentryAuthorizable);
        junit.framework.Assert.assertTrue((privileges.size() == 1 ? 1 : 0) != 0);
        HashSet<TSentryGroup> tSentryGroups = new HashSet<TSentryGroup>();
        tSentryGroups.add(new TSentryGroup("group1"));
        sentryStore.alterSentryRoleAddGroups(grantor, roleName, tSentryGroups);
        TSentryActiveRoleSet thriftRoleSet = new TSentryActiveRoleSet(true, new HashSet<String>(Arrays.asList(roleName)));
        Set privs = sentryStore.listSentryPrivilegesForProvider(new HashSet<String>(Arrays.asList("group1")), thriftRoleSet, tSentryAuthorizable);
        junit.framework.Assert.assertTrue((privs.size() == 1 ? 1 : 0) != 0);
        junit.framework.Assert.assertTrue((boolean)privs.contains("server=server1->uri=" + uri + "->action=all"));
    }

    @Test
    public void testCreateDuplicateRole() throws Exception {
        String roleName = "test-dup-role";
        sentryStore.createSentryRole(roleName);
        try {
            sentryStore.createSentryRole(roleName);
            junit.framework.Assert.fail((String)"Expected SentryAlreadyExistsException");
        }
        catch (SentryAlreadyExistsException sentryAlreadyExistsException) {
            // empty catch block
        }
    }

    @Test
    public void testCaseSensitiveScope() throws Exception {
        String roleName = "role1";
        String grantor = "g1";
        long seqId = sentryStore.createSentryRole(roleName).getSequenceId();
        TSentryPrivilege sentryPrivilege = new TSentryPrivilege("Database", "server1", "all");
        sentryPrivilege.setDbName("db1");
        junit.framework.Assert.assertEquals((long)(seqId + 1L), (long)sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName, sentryPrivilege).getSequenceId());
    }

    @Test
    public void testCreateDropRole() throws Exception {
        String roleName = "test-drop-role";
        long seqId = sentryStore.createSentryRole(roleName).getSequenceId();
        junit.framework.Assert.assertEquals((long)(seqId + 1L), (long)sentryStore.dropSentryRole(roleName).getSequenceId());
    }

    @Test(expected=SentryNoSuchObjectException.class)
    public void testAddDeleteGroupsNonExistantRole() throws Exception {
        String roleName = "non-existant-role";
        String grantor = "g1";
        HashSet groups = Sets.newHashSet();
        sentryStore.alterSentryRoleAddGroups(grantor, roleName, (Set)groups);
    }

    @Test
    public void testAddDeleteGroups() throws Exception {
        String roleName = "test-groups";
        String grantor = "g1";
        long seqId = sentryStore.createSentryRole(roleName).getSequenceId();
        HashSet groups = Sets.newHashSet();
        TSentryGroup group = new TSentryGroup();
        group.setGroupName("test-groups-g1");
        groups.add(group);
        group = new TSentryGroup();
        group.setGroupName("test-groups-g2");
        groups.add(group);
        junit.framework.Assert.assertEquals((long)(seqId + 1L), (long)sentryStore.alterSentryRoleAddGroups(grantor, roleName, (Set)groups).getSequenceId());
        junit.framework.Assert.assertEquals((long)(seqId + 2L), (long)sentryStore.alterSentryRoleDeleteGroups(roleName, (Set)groups).getSequenceId());
        MSentryRole role = sentryStore.getMSentryRoleByName(roleName);
        junit.framework.Assert.assertEquals(Collections.emptySet(), (Object)role.getGroups());
    }

    @Test
    public void testGrantRevokePrivilege() throws Exception {
        String roleName = "test-privilege";
        String grantor = "g1";
        String server = "server1";
        String db = "db1";
        String table = "tbl1";
        long seqId = sentryStore.createSentryRole(roleName).getSequenceId();
        TSentryPrivilege privilege = new TSentryPrivilege();
        privilege.setPrivilegeScope("TABLE");
        privilege.setServerName(server);
        privilege.setDbName(db);
        privilege.setTableName(table);
        privilege.setAction("*");
        privilege.setCreateTime(System.currentTimeMillis());
        junit.framework.Assert.assertEquals((long)(seqId + 1L), (long)sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName, privilege).getSequenceId());
        MSentryRole role = sentryStore.getMSentryRoleByName(roleName);
        Set privileges = role.getPrivileges();
        junit.framework.Assert.assertEquals((String)privileges.toString(), (int)1, (int)privileges.size());
        privilege.setAction("select");
        junit.framework.Assert.assertEquals((long)(seqId + 2L), (long)sentryStore.alterSentryRoleRevokePrivilege(grantor, roleName, privilege).getSequenceId());
        role = sentryStore.getMSentryRoleByName(roleName);
        privileges = role.getPrivileges();
        junit.framework.Assert.assertEquals((String)privileges.toString(), (int)1, (int)privileges.size());
        MSentryPrivilege mPrivilege = (MSentryPrivilege)Iterables.get((Iterable)privileges, (int)0);
        junit.framework.Assert.assertEquals((String)server, (String)mPrivilege.getServerName());
        junit.framework.Assert.assertEquals((String)db, (String)mPrivilege.getDbName());
        junit.framework.Assert.assertEquals((String)table, (String)mPrivilege.getTableName());
        junit.framework.Assert.assertEquals((String)"insert", (String)mPrivilege.getAction());
        junit.framework.Assert.assertFalse((boolean)mPrivilege.getGrantOption());
    }

    private void verifyOrphanCleanup() throws Exception {
        boolean success = false;
        for (int iterations = 30; !success && iterations > 0; --iterations) {
            Thread.sleep(1000L);
            long numDBPrivs = sentryStore.countMSentryPrivileges();
            if (numDBPrivs >= 60L) continue;
            junit.framework.Assert.assertEquals((long)0L, (long)numDBPrivs);
            success = true;
        }
        junit.framework.Assert.assertTrue((String)"Failed to cleanup orphaned privileges", (boolean)success);
    }

    @Ignore(value="Disabled with SENTRY-545 following SENTRY-140 problems")
    @Test
    public void testPrivilegeCleanup() throws Exception {
        String roleName = "test-priv-cleanup";
        String grantor = "g1";
        String server = "server";
        String dBase = "db";
        String table = "table-";
        sentryStore.createSentryRole("test-priv-cleanup");
        int i = 0;
        while ((long)i < 60L) {
            TSentryPrivilege priv = new TSentryPrivilege();
            priv.setPrivilegeScope("TABLE");
            priv.setServerName("server");
            priv.setAction("*");
            priv.setCreateTime(System.currentTimeMillis());
            priv.setTableName("table-" + i);
            priv.setDbName("db");
            sentryStore.alterSentryRoleGrantPrivilege("g1", "test-priv-cleanup", priv);
            ++i;
        }
        junit.framework.Assert.assertEquals((long)sentryStore.countMSentryPrivileges(), (long)60L);
        sentryStore.dropSentryRole("test-priv-cleanup");
        this.verifyOrphanCleanup();
    }

    @Ignore(value="Disabled with SENTRY-545 following SENTRY-140 problems")
    @Test
    public void testPrivilegeCleanup2() throws Exception {
        String roleName = "test-priv-cleanup";
        String grantor = "g1";
        String server = "server";
        String dBase = "db";
        String table = "table-";
        sentryStore.createSentryRole("test-priv-cleanup");
        int i = 0;
        while ((long)i < 60L) {
            TSentryPrivilege priv = new TSentryPrivilege();
            priv.setPrivilegeScope("DATABASE");
            priv.setServerName("server");
            priv.setAction("*");
            priv.setCreateTime(System.currentTimeMillis());
            priv.setTableName("table-" + i);
            priv.setDbName("db");
            priv.setGrantOption(TSentryGrantOption.TRUE);
            sentryStore.alterSentryRoleGrantPrivilege("g1", "test-priv-cleanup", priv);
            priv.setAction("select");
            priv.setGrantOption(TSentryGrantOption.UNSET);
            sentryStore.alterSentryRoleRevokePrivilege("g1", "test-priv-cleanup", priv);
            MSentryRole role = sentryStore.getMSentryRoleByName("test-priv-cleanup");
            Set privileges = role.getPrivileges();
            junit.framework.Assert.assertEquals((String)privileges.toString(), (int)(i + 1), (int)privileges.size());
            MSentryPrivilege mPrivilege = (MSentryPrivilege)Iterables.get((Iterable)privileges, (int)0);
            junit.framework.Assert.assertEquals((String)"insert", (String)mPrivilege.getAction());
            ++i;
        }
        sentryStore.dropSentryRole("test-priv-cleanup");
        this.verifyOrphanCleanup();
    }

    @Test
    public void testGrantRevokeMultiPrivileges() throws Exception {
        String roleName = "test-privilege";
        String grantor = "g1";
        String server = "server1";
        String db = "db1";
        String table = "tbl1";
        String[] columns = new String[]{"c1", "c2", "c3", "c4"};
        long seqId = sentryStore.createSentryRole(roleName).getSequenceId();
        HashSet tPrivileges = Sets.newHashSet();
        for (String column : columns) {
            TSentryPrivilege privilege = new TSentryPrivilege();
            privilege.setPrivilegeScope("Column");
            privilege.setServerName(server);
            privilege.setDbName(db);
            privilege.setTableName(table);
            privilege.setColumnName(column);
            privilege.setAction("select");
            privilege.setCreateTime(System.currentTimeMillis());
            tPrivileges.add(privilege);
        }
        junit.framework.Assert.assertEquals((long)(seqId + 1L), (long)sentryStore.alterSentryRoleGrantPrivileges(grantor, roleName, (Set)tPrivileges).getSequenceId());
        MSentryRole role = sentryStore.getMSentryRoleByName(roleName);
        Set privileges = role.getPrivileges();
        junit.framework.Assert.assertEquals((String)privileges.toString(), (int)4, (int)privileges.size());
        tPrivileges = Sets.newHashSet();
        for (int i = 0; i < 2; ++i) {
            TSentryPrivilege privilege = new TSentryPrivilege();
            privilege.setPrivilegeScope("Column");
            privilege.setServerName(server);
            privilege.setDbName(db);
            privilege.setTableName(table);
            privilege.setColumnName(columns[i]);
            privilege.setAction("select");
            privilege.setCreateTime(System.currentTimeMillis());
            tPrivileges.add(privilege);
        }
        junit.framework.Assert.assertEquals((long)(seqId + 2L), (long)sentryStore.alterSentryRoleRevokePrivileges(grantor, roleName, (Set)tPrivileges).getSequenceId());
        role = sentryStore.getMSentryRoleByName(roleName);
        privileges = role.getPrivileges();
        junit.framework.Assert.assertEquals((String)privileges.toString(), (int)2, (int)privileges.size());
        TSentryPrivilege privilege = new TSentryPrivilege();
        privilege.setPrivilegeScope("Table");
        privilege.setServerName(server);
        privilege.setDbName(db);
        privilege.setTableName(table);
        privilege.setAction("select");
        privilege.setCreateTime(System.currentTimeMillis());
        junit.framework.Assert.assertEquals((long)(seqId + 3L), (long)sentryStore.alterSentryRoleRevokePrivilege(grantor, roleName, privilege).getSequenceId());
        role = sentryStore.getMSentryRoleByName(roleName);
        privileges = role.getPrivileges();
        junit.framework.Assert.assertEquals((String)privileges.toString(), (int)0, (int)privileges.size());
    }

    @Test
    public void testGrantRevokePrivilegeWithColumn() throws Exception {
        String roleName = "test-col-privilege";
        String grantor = "g1";
        String server = "server1";
        String db = "db1";
        String table = "tbl1";
        String column1 = "c1";
        String column2 = "c2";
        long seqId = sentryStore.createSentryRole(roleName).getSequenceId();
        TSentryPrivilege privilege = new TSentryPrivilege();
        privilege.setPrivilegeScope("COLUMN");
        privilege.setServerName(server);
        privilege.setDbName(db);
        privilege.setTableName(table);
        privilege.setColumnName(column1);
        privilege.setAction("*");
        privilege.setCreateTime(System.currentTimeMillis());
        junit.framework.Assert.assertEquals((long)(seqId + 1L), (long)sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName, privilege).getSequenceId());
        privilege.setColumnName(column2);
        junit.framework.Assert.assertEquals((long)(seqId + 2L), (long)sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName, privilege).getSequenceId());
        MSentryRole role = sentryStore.getMSentryRoleByName(roleName);
        Set privileges = role.getPrivileges();
        junit.framework.Assert.assertEquals((String)privileges.toString(), (int)2, (int)privileges.size());
        privilege.setAction("select");
        junit.framework.Assert.assertEquals((long)(seqId + 3L), (long)sentryStore.alterSentryRoleRevokePrivilege(grantor, roleName, privilege).getSequenceId());
        role = sentryStore.getMSentryRoleByName(roleName);
        privileges = role.getPrivileges();
        junit.framework.Assert.assertEquals((String)privileges.toString(), (int)2, (int)privileges.size());
        for (MSentryPrivilege mPrivilege : privileges) {
            junit.framework.Assert.assertEquals((String)server, (String)mPrivilege.getServerName());
            junit.framework.Assert.assertEquals((String)db, (String)mPrivilege.getDbName());
            junit.framework.Assert.assertEquals((String)table, (String)mPrivilege.getTableName());
            junit.framework.Assert.assertFalse((boolean)mPrivilege.getGrantOption());
            if (mPrivilege.getColumnName().equals(column1)) {
                junit.framework.Assert.assertEquals((String)"*", (String)mPrivilege.getAction());
                continue;
            }
            if (mPrivilege.getColumnName().equals(column2)) {
                junit.framework.Assert.assertEquals((String)"insert", (String)mPrivilege.getAction());
                continue;
            }
            junit.framework.Assert.fail((String)("Unexpected column name: " + mPrivilege.getColumnName()));
        }
        privilege = new TSentryPrivilege();
        privilege.setPrivilegeScope("TABLE");
        privilege.setServerName(server);
        privilege.setDbName(db);
        privilege.setTableName(table);
        privilege.setAction("insert");
        privilege.setCreateTime(System.currentTimeMillis());
        junit.framework.Assert.assertEquals((long)(seqId + 4L), (long)sentryStore.alterSentryRoleRevokePrivilege(grantor, roleName, privilege).getSequenceId());
        role = sentryStore.getMSentryRoleByName(roleName);
        privileges = role.getPrivileges();
        junit.framework.Assert.assertEquals((String)privileges.toString(), (int)1, (int)privileges.size());
        junit.framework.Assert.assertEquals((String)column1, (String)((MSentryPrivilege)Iterables.get((Iterable)privileges, (int)0)).getColumnName());
        junit.framework.Assert.assertEquals((String)"select", (String)((MSentryPrivilege)Iterables.get((Iterable)privileges, (int)0)).getAction());
        privilege.setAction("*");
        privilege.setCreateTime(System.currentTimeMillis());
        junit.framework.Assert.assertEquals((long)(seqId + 5L), (long)sentryStore.alterSentryRoleRevokePrivilege(grantor, roleName, privilege).getSequenceId());
        role = sentryStore.getMSentryRoleByName(roleName);
        privileges = role.getPrivileges();
        junit.framework.Assert.assertEquals((String)privileges.toString(), (int)0, (int)privileges.size());
    }

    @Test
    public void testGrantRevokeTablePrivilegeDowngradeByDb() throws Exception {
        String roleName = "test-table-db-downgrade-privilege";
        String grantor = "g1";
        String server = "server1";
        String db = "db1";
        String table1 = "tbl1";
        String table2 = "tbl2";
        long seqId = sentryStore.createSentryRole(roleName).getSequenceId();
        TSentryPrivilege privilegeTable1 = new TSentryPrivilege();
        privilegeTable1.setPrivilegeScope("TABLE");
        privilegeTable1.setServerName(server);
        privilegeTable1.setDbName(db);
        privilegeTable1.setTableName(table1);
        privilegeTable1.setAction("*");
        privilegeTable1.setCreateTime(System.currentTimeMillis());
        TSentryPrivilege privilegeTable2 = privilegeTable1.deepCopy();
        privilegeTable2.setTableName(table2);
        junit.framework.Assert.assertEquals((long)(seqId + 1L), (long)sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName, privilegeTable1).getSequenceId());
        junit.framework.Assert.assertEquals((long)(seqId + 2L), (long)sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName, privilegeTable2).getSequenceId());
        MSentryRole role = sentryStore.getMSentryRoleByName(roleName);
        Set privileges = role.getPrivileges();
        junit.framework.Assert.assertEquals((String)privileges.toString(), (int)2, (int)privileges.size());
        privilegeTable2.setAction("select");
        junit.framework.Assert.assertEquals((long)(seqId + 3L), (long)sentryStore.alterSentryRoleRevokePrivilege(grantor, roleName, privilegeTable2).getSequenceId());
        role = sentryStore.getMSentryRoleByName(roleName);
        privileges = role.getPrivileges();
        junit.framework.Assert.assertEquals((String)privileges.toString(), (int)2, (int)privileges.size());
        role = sentryStore.getMSentryRoleByName(roleName);
        privileges = role.getPrivileges();
        junit.framework.Assert.assertEquals((String)privileges.toString(), (int)2, (int)privileges.size());
        for (MSentryPrivilege mPrivilege : privileges) {
            junit.framework.Assert.assertEquals((String)server, (String)mPrivilege.getServerName());
            junit.framework.Assert.assertEquals((String)db, (String)mPrivilege.getDbName());
            junit.framework.Assert.assertFalse((boolean)mPrivilege.getGrantOption());
            if (mPrivilege.getTableName().equals(table1)) {
                junit.framework.Assert.assertEquals((String)"*", (String)mPrivilege.getAction());
                continue;
            }
            if (mPrivilege.getTableName().equals(table2)) {
                junit.framework.Assert.assertEquals((String)"insert", (String)mPrivilege.getAction());
                continue;
            }
            junit.framework.Assert.fail((String)("Unexpected table name: " + mPrivilege.getTableName()));
        }
        privilegeTable2.setAction("insert");
        privilegeTable2.setPrivilegeScope("DATABASE");
        privilegeTable2.unsetTableName();
        junit.framework.Assert.assertEquals((long)(seqId + 4L), (long)sentryStore.alterSentryRoleRevokePrivilege(grantor, roleName, privilegeTable2).getSequenceId());
        role = sentryStore.getMSentryRoleByName(roleName);
        privileges = role.getPrivileges();
        junit.framework.Assert.assertEquals((String)privileges.toString(), (int)1, (int)privileges.size());
        MSentryPrivilege mPrivilege = (MSentryPrivilege)Iterables.get((Iterable)privileges, (int)0);
        junit.framework.Assert.assertEquals((String)server, (String)mPrivilege.getServerName());
        junit.framework.Assert.assertEquals((String)db, (String)mPrivilege.getDbName());
        junit.framework.Assert.assertEquals((String)table1, (String)mPrivilege.getTableName());
        junit.framework.Assert.assertEquals((String)"select", (String)mPrivilege.getAction());
        junit.framework.Assert.assertFalse((boolean)mPrivilege.getGrantOption());
    }

    @Test
    public void testGrantRevokeColumnPrivilegeDowngradeByDb() throws Exception {
        String roleName = "test-column-db-downgrade-privilege";
        String grantor = "g1";
        String server = "server1";
        String db = "db1";
        String table = "tbl1";
        String column1 = "c1";
        String column2 = "c2";
        long seqId = sentryStore.createSentryRole(roleName).getSequenceId();
        TSentryPrivilege privilegeCol1 = new TSentryPrivilege();
        privilegeCol1.setPrivilegeScope("COLUMN");
        privilegeCol1.setServerName(server);
        privilegeCol1.setDbName(db);
        privilegeCol1.setTableName(table);
        privilegeCol1.setColumnName(column1);
        privilegeCol1.setAction("*");
        privilegeCol1.setCreateTime(System.currentTimeMillis());
        TSentryPrivilege privilegeCol2 = privilegeCol1.deepCopy();
        privilegeCol2.setColumnName(column2);
        junit.framework.Assert.assertEquals((long)(seqId + 1L), (long)sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName, privilegeCol1).getSequenceId());
        junit.framework.Assert.assertEquals((long)(seqId + 2L), (long)sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName, privilegeCol2).getSequenceId());
        MSentryRole role = sentryStore.getMSentryRoleByName(roleName);
        Set privileges = role.getPrivileges();
        junit.framework.Assert.assertEquals((String)privileges.toString(), (int)2, (int)privileges.size());
        privilegeCol2.setAction("select");
        junit.framework.Assert.assertEquals((long)(seqId + 3L), (long)sentryStore.alterSentryRoleRevokePrivilege(grantor, roleName, privilegeCol2).getSequenceId());
        role = sentryStore.getMSentryRoleByName(roleName);
        privileges = role.getPrivileges();
        junit.framework.Assert.assertEquals((String)privileges.toString(), (int)2, (int)privileges.size());
        role = sentryStore.getMSentryRoleByName(roleName);
        privileges = role.getPrivileges();
        junit.framework.Assert.assertEquals((String)privileges.toString(), (int)2, (int)privileges.size());
        for (MSentryPrivilege mPrivilege : privileges) {
            junit.framework.Assert.assertEquals((String)server, (String)mPrivilege.getServerName());
            junit.framework.Assert.assertEquals((String)db, (String)mPrivilege.getDbName());
            junit.framework.Assert.assertEquals((String)table, (String)mPrivilege.getTableName());
            junit.framework.Assert.assertFalse((boolean)mPrivilege.getGrantOption());
            if (mPrivilege.getColumnName().equals(column1)) {
                junit.framework.Assert.assertEquals((String)"*", (String)mPrivilege.getAction());
                continue;
            }
            if (mPrivilege.getColumnName().equals(column2)) {
                junit.framework.Assert.assertEquals((String)"insert", (String)mPrivilege.getAction());
                continue;
            }
            junit.framework.Assert.fail((String)("Unexpected column name: " + mPrivilege.getColumnName()));
        }
        privilegeCol2.setAction("insert");
        privilegeCol2.setPrivilegeScope("DATABASE");
        privilegeCol2.unsetTableName();
        privilegeCol2.unsetColumnName();
        junit.framework.Assert.assertEquals((long)(seqId + 4L), (long)sentryStore.alterSentryRoleRevokePrivilege(grantor, roleName, privilegeCol2).getSequenceId());
        role = sentryStore.getMSentryRoleByName(roleName);
        privileges = role.getPrivileges();
        junit.framework.Assert.assertEquals((String)privileges.toString(), (int)1, (int)privileges.size());
        MSentryPrivilege mPrivilege = (MSentryPrivilege)Iterables.get((Iterable)privileges, (int)0);
        junit.framework.Assert.assertEquals((String)server, (String)mPrivilege.getServerName());
        junit.framework.Assert.assertEquals((String)db, (String)mPrivilege.getDbName());
        junit.framework.Assert.assertEquals((String)table, (String)mPrivilege.getTableName());
        junit.framework.Assert.assertEquals((String)column1, (String)mPrivilege.getColumnName());
        junit.framework.Assert.assertEquals((String)"select", (String)mPrivilege.getAction());
        junit.framework.Assert.assertFalse((boolean)mPrivilege.getGrantOption());
    }

    @Test
    public void testGrantRevokePrivilegeWithGrantOption() throws Exception {
        String roleName = "test-grantOption-table";
        String grantor = "g1";
        String server = "server1";
        String db = "db1";
        String table = "tbl1";
        TSentryGrantOption grantOption = TSentryGrantOption.TRUE;
        long seqId = sentryStore.createSentryRole(roleName).getSequenceId();
        TSentryPrivilege privilege = new TSentryPrivilege();
        privilege.setPrivilegeScope("TABLE");
        privilege.setServerName(server);
        privilege.setDbName(db);
        privilege.setTableName(table);
        privilege.setAction("*");
        privilege.setCreateTime(System.currentTimeMillis());
        privilege.setGrantOption(grantOption);
        junit.framework.Assert.assertEquals((long)(seqId + 1L), (long)sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName, privilege).getSequenceId());
        MSentryRole role = sentryStore.getMSentryRoleByName(roleName);
        Set privileges = role.getPrivileges();
        junit.framework.Assert.assertEquals((String)privileges.toString(), (int)1, (int)privileges.size());
        junit.framework.Assert.assertEquals((Object)Boolean.valueOf(privilege.getGrantOption().toString()), (Object)((MSentryPrivilege)Iterables.get((Iterable)privileges, (int)0)).getGrantOption());
        junit.framework.Assert.assertEquals((long)(seqId + 2L), (long)sentryStore.alterSentryRoleRevokePrivilege(grantor, roleName, privilege).getSequenceId());
        role = sentryStore.getMSentryRoleByName(roleName);
        privileges = role.getPrivileges();
        junit.framework.Assert.assertEquals((int)0, (int)privileges.size());
        roleName = "test-grantOption-db";
        sentryStore.createSentryRole(roleName);
        privilege = new TSentryPrivilege();
        privilege.setPrivilegeScope("DATABASE");
        privilege.setServerName(server);
        privilege.setDbName(db);
        privilege.setAction("*");
        privilege.setGrantOption(TSentryGrantOption.TRUE);
        privilege.setCreateTime(System.currentTimeMillis());
        privilege.setGrantOption(grantOption);
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName, privilege);
        role = sentryStore.getMSentryRoleByName(roleName);
        privileges = role.getPrivileges();
        junit.framework.Assert.assertEquals((String)privileges.toString(), (int)1, (int)privileges.size());
        privilege.setAction("select");
        privilege.setGrantOption(TSentryGrantOption.UNSET);
        sentryStore.alterSentryRoleRevokePrivilege(grantor, roleName, privilege);
        role = sentryStore.getMSentryRoleByName(roleName);
        privileges = role.getPrivileges();
        junit.framework.Assert.assertEquals((String)privileges.toString(), (int)1, (int)privileges.size());
        MSentryPrivilege mPrivilege = (MSentryPrivilege)Iterables.get((Iterable)privileges, (int)0);
        junit.framework.Assert.assertEquals((String)server, (String)mPrivilege.getServerName());
        junit.framework.Assert.assertEquals((String)db, (String)mPrivilege.getDbName());
        junit.framework.Assert.assertEquals((String)"insert", (String)mPrivilege.getAction());
    }

    @Test
    public void testGrantCheckWithGrantOption() throws Exception {
        String grantor = "g1";
        String[] users = new String[]{"user0", "user1", "user2", "user3", "user4"};
        String[] roles = new String[]{"role0", "role1", "role2", "role3", "role4"};
        String[] groups = new String[]{"group0", "group1", "group2", "group3", "group4"};
        for (int i = 0; i < users.length; ++i) {
            TestSentryStore.addGroupsToUser(users[i], groups[i]);
            sentryStore.createSentryRole(roles[i]);
            HashSet tGroups = Sets.newHashSet();
            TSentryGroup tGroup = new TSentryGroup(groups[i]);
            tGroups.add(tGroup);
            sentryStore.alterSentryRoleAddGroups(grantor, roles[i], (Set)tGroups);
        }
        TestSentryStore.writePolicyFile();
        String server = "server1";
        String db = "db1";
        String table = "tbl1";
        String roleName = roles[0];
        grantor = "g1";
        TSentryPrivilege privilege1 = new TSentryPrivilege();
        privilege1.setPrivilegeScope("DATABASE");
        privilege1.setServerName(server);
        privilege1.setDbName(db);
        privilege1.setAction("*");
        privilege1.setCreateTime(System.currentTimeMillis());
        privilege1.setGrantOption(TSentryGrantOption.TRUE);
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName, privilege1);
        MSentryRole role = sentryStore.getMSentryRoleByName(roleName);
        Set privileges = role.getPrivileges();
        junit.framework.Assert.assertEquals((String)privileges.toString(), (int)1, (int)privileges.size());
        roleName = roles[1];
        grantor = users[0];
        TSentryPrivilege privilege2 = new TSentryPrivilege();
        privilege2.setPrivilegeScope("DATABASE");
        privilege2.setServerName(server);
        privilege2.setDbName(db);
        privilege2.setAction("select");
        privilege2.setCreateTime(System.currentTimeMillis());
        privilege2.setGrantOption(TSentryGrantOption.TRUE);
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName, privilege2);
        roleName = roles[2];
        grantor = users[0];
        TSentryPrivilege privilege3 = new TSentryPrivilege();
        privilege3.setPrivilegeScope("TABLE");
        privilege3.setServerName(server);
        privilege3.setDbName(db);
        privilege3.setTableName(table);
        privilege3.setAction("*");
        privilege3.setCreateTime(System.currentTimeMillis());
        privilege3.setGrantOption(TSentryGrantOption.FALSE);
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName, privilege3);
        roleName = roles[3];
        grantor = users[1];
        TSentryPrivilege privilege4 = new TSentryPrivilege();
        privilege4.setPrivilegeScope("DATABASE");
        privilege4.setServerName(server);
        privilege4.setDbName(db);
        privilege4.setAction("insert");
        privilege4.setCreateTime(System.currentTimeMillis());
        privilege4.setGrantOption(TSentryGrantOption.FALSE);
        boolean isGrantOptionException = false;
        try {
            sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName, privilege4);
        }
        catch (SentryGrantDeniedException e) {
            isGrantOptionException = true;
            System.err.println(e.getMessage());
        }
        junit.framework.Assert.assertTrue((boolean)isGrantOptionException);
        roleName = roles[4];
        grantor = users[2];
        TSentryPrivilege privilege5 = new TSentryPrivilege();
        privilege5.setPrivilegeScope("TABLE");
        privilege5.setServerName(server);
        privilege5.setDbName(db);
        privilege5.setTableName(table);
        privilege5.setAction("insert");
        privilege5.setCreateTime(System.currentTimeMillis());
        privilege5.setGrantOption(TSentryGrantOption.FALSE);
        isGrantOptionException = false;
        try {
            sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName, privilege5);
        }
        catch (SentryGrantDeniedException e) {
            isGrantOptionException = true;
            System.err.println(e.getMessage());
        }
        junit.framework.Assert.assertTrue((boolean)isGrantOptionException);
    }

    @Test
    public void testRevokeCheckWithGrantOption() throws Exception {
        String grantor = "g1";
        String[] users = new String[]{"user0", "user1", "user2"};
        String[] roles = new String[]{"role0", "role1", "role2"};
        String[] groups = new String[]{"group0", "group1", "group2"};
        for (int i = 0; i < users.length; ++i) {
            TestSentryStore.addGroupsToUser(users[i], groups[i]);
            sentryStore.createSentryRole(roles[i]);
            HashSet tGroups = Sets.newHashSet();
            TSentryGroup tGroup = new TSentryGroup(groups[i]);
            tGroups.add(tGroup);
            sentryStore.alterSentryRoleAddGroups(grantor, roles[i], (Set)tGroups);
        }
        TestSentryStore.writePolicyFile();
        String server = "server1";
        String db = "db1";
        String table = "tbl1";
        String roleName = roles[0];
        grantor = "g1";
        TSentryPrivilege privilege1 = new TSentryPrivilege();
        privilege1.setPrivilegeScope("DATABASE");
        privilege1.setServerName(server);
        privilege1.setDbName(db);
        privilege1.setAction("select");
        privilege1.setCreateTime(System.currentTimeMillis());
        privilege1.setGrantOption(TSentryGrantOption.TRUE);
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName, privilege1);
        MSentryRole role = sentryStore.getMSentryRoleByName(roleName);
        Set privileges = role.getPrivileges();
        junit.framework.Assert.assertEquals((String)privileges.toString(), (int)1, (int)privileges.size());
        roleName = roles[1];
        grantor = "g1";
        TSentryPrivilege privilege2 = new TSentryPrivilege();
        privilege2.setPrivilegeScope("TABLE");
        privilege2.setServerName(server);
        privilege2.setDbName(db);
        privilege2.setTableName(table);
        privilege2.setAction("*");
        privilege2.setCreateTime(System.currentTimeMillis());
        privilege2.setGrantOption(TSentryGrantOption.FALSE);
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName, privilege2);
        roleName = roles[2];
        grantor = "g1";
        TSentryPrivilege privilege3 = new TSentryPrivilege();
        privilege3.setPrivilegeScope("TABLE");
        privilege3.setServerName(server);
        privilege3.setDbName(db);
        privilege3.setTableName(table);
        privilege3.setAction("select");
        privilege3.setCreateTime(System.currentTimeMillis());
        privilege3.setGrantOption(TSentryGrantOption.FALSE);
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName, privilege3);
        roleName = roles[2];
        grantor = users[1];
        boolean isGrantOptionException = false;
        try {
            sentryStore.alterSentryRoleRevokePrivilege(grantor, roleName, privilege3);
        }
        catch (SentryGrantDeniedException e) {
            isGrantOptionException = true;
            System.err.println(e.getMessage());
        }
        junit.framework.Assert.assertTrue((boolean)isGrantOptionException);
        roleName = roles[1];
        grantor = users[0];
        try {
            sentryStore.alterSentryRoleRevokePrivilege(grantor, roleName, privilege2);
        }
        catch (SentryGrantDeniedException e) {
            isGrantOptionException = true;
            System.err.println(e.getMessage());
        }
        junit.framework.Assert.assertTrue((boolean)isGrantOptionException);
        roleName = roles[2];
        grantor = users[0];
        sentryStore.alterSentryRoleRevokePrivilege(grantor, roleName, privilege3);
        role = sentryStore.getMSentryRoleByName(roleName);
        privileges = role.getPrivileges();
        junit.framework.Assert.assertEquals((int)0, (int)privileges.size());
    }

    @Test
    public void testRevokeAllGrantOption() throws Exception {
        String grantor = "g1";
        String[] users = new String[]{"user0"};
        String[] roles = new String[]{"role0"};
        String[] groups = new String[]{"group0"};
        for (int i = 0; i < users.length; ++i) {
            TestSentryStore.addGroupsToUser(users[i], groups[i]);
            sentryStore.createSentryRole(roles[i]);
            HashSet tGroups = Sets.newHashSet();
            TSentryGroup tGroup = new TSentryGroup(groups[i]);
            tGroups.add(tGroup);
            sentryStore.alterSentryRoleAddGroups(grantor, roles[i], (Set)tGroups);
        }
        TestSentryStore.writePolicyFile();
        String server = "server1";
        String db = "db1";
        String table = "tbl1";
        String roleName = roles[0];
        grantor = "g1";
        TSentryPrivilege privilege = new TSentryPrivilege();
        privilege.setPrivilegeScope("TABLE");
        privilege.setServerName(server);
        privilege.setDbName(db);
        privilege.setTableName(table);
        privilege.setAction("select");
        privilege.setCreateTime(System.currentTimeMillis());
        privilege.setGrantOption(TSentryGrantOption.TRUE);
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName, privilege);
        roleName = roles[0];
        grantor = "g1";
        privilege.setGrantOption(TSentryGrantOption.FALSE);
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName, privilege);
        roleName = roles[0];
        grantor = "g1";
        privilege.setGrantOption(TSentryGrantOption.UNSET);
        sentryStore.alterSentryRoleRevokePrivilege(grantor, roleName, privilege);
        MSentryRole role = sentryStore.getMSentryRoleByName(roleName);
        Set privileges = role.getPrivileges();
        junit.framework.Assert.assertEquals((String)privileges.toString(), (int)0, (int)privileges.size());
    }

    @Test
    public void testGrantCheckWithColumn() throws Exception {
        String grantor = "g1";
        String[] users = new String[]{"user0", "user1"};
        String[] roles = new String[]{"role0", "role1"};
        String[] groups = new String[]{"group0", "group1"};
        for (int i = 0; i < users.length; ++i) {
            TestSentryStore.addGroupsToUser(users[i], groups[i]);
            sentryStore.createSentryRole(roles[i]);
            HashSet tGroups = Sets.newHashSet();
            TSentryGroup tGroup = new TSentryGroup(groups[i]);
            tGroups.add(tGroup);
            sentryStore.alterSentryRoleAddGroups(grantor, roles[i], (Set)tGroups);
        }
        TestSentryStore.writePolicyFile();
        String server = "server1";
        String db = "db1";
        String table = "tbl1";
        String roleName = roles[0];
        grantor = "g1";
        TSentryPrivilege privilege1 = new TSentryPrivilege();
        privilege1.setPrivilegeScope("TABLE");
        privilege1.setServerName(server);
        privilege1.setDbName(db);
        privilege1.setTableName(table);
        privilege1.setAction("select");
        privilege1.setCreateTime(System.currentTimeMillis());
        privilege1.setGrantOption(TSentryGrantOption.TRUE);
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName, privilege1);
        MSentryRole role = sentryStore.getMSentryRoleByName(roleName);
        Set privileges = role.getPrivileges();
        junit.framework.Assert.assertEquals((String)privileges.toString(), (int)1, (int)privileges.size());
        roleName = roles[1];
        grantor = users[0];
        String column = "c1";
        TSentryPrivilege privilege2 = new TSentryPrivilege();
        privilege2.setPrivilegeScope("COLUMN");
        privilege2.setServerName(server);
        privilege2.setDbName(db);
        privilege2.setTableName(table);
        privilege2.setColumnName(column);
        privilege2.setAction("select");
        privilege2.setCreateTime(System.currentTimeMillis());
        privilege2.setGrantOption(TSentryGrantOption.TRUE);
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName, privilege2);
        roleName = roles[0];
        grantor = users[1];
        boolean isGrantOptionException = false;
        try {
            sentryStore.alterSentryRoleRevokePrivilege(grantor, roleName, privilege1);
        }
        catch (SentryGrantDeniedException e) {
            isGrantOptionException = true;
            System.err.println(e.getMessage());
        }
        junit.framework.Assert.assertTrue((boolean)isGrantOptionException);
        roleName = roles[1];
        grantor = users[0];
        sentryStore.alterSentryRoleRevokePrivilege(grantor, roleName, privilege2);
        role = sentryStore.getMSentryRoleByName(roleName);
        privileges = role.getPrivileges();
        junit.framework.Assert.assertEquals((int)0, (int)privileges.size());
    }

    @Test
    public void testGrantDuplicatePrivilege() throws Exception {
        String roleName = "test-privilege";
        String grantor = "g1";
        String server = "server1";
        String db = "db1";
        String table = "tbl1";
        long seqId = sentryStore.createSentryRole(roleName).getSequenceId();
        TSentryPrivilege privilege = new TSentryPrivilege();
        privilege.setPrivilegeScope("TABLE");
        privilege.setServerName(server);
        privilege.setDbName(db);
        privilege.setTableName(table);
        privilege.setAction("*");
        privilege.setCreateTime(System.currentTimeMillis());
        junit.framework.Assert.assertEquals((long)(seqId + 1L), (long)sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName, privilege).getSequenceId());
        junit.framework.Assert.assertEquals((long)(seqId + 2L), (long)sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName, privilege).getSequenceId());
        privilege.setServerName("Server1");
        privilege.setDbName("DB1");
        privilege.setTableName("TBL1");
        junit.framework.Assert.assertEquals((long)(seqId + 3L), (long)sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName, privilege).getSequenceId());
        MSentryRole role = sentryStore.getMSentryRoleByName(roleName);
        Set privileges = role.getPrivileges();
        junit.framework.Assert.assertEquals((String)privileges.toString(), (int)1, (int)privileges.size());
    }

    @Test
    public void testListSentryPrivilegesForProvider() throws Exception {
        String roleName1 = "list-privs-r1";
        String roleName2 = "list-privs-r2";
        String groupName1 = "list-privs-g1";
        String groupName2 = "list-privs-g2";
        String grantor = "g1";
        long seqId = sentryStore.createSentryRole(roleName1).getSequenceId();
        junit.framework.Assert.assertEquals((long)(seqId + 1L), (long)sentryStore.createSentryRole(roleName2).getSequenceId());
        TSentryPrivilege privilege1 = new TSentryPrivilege();
        privilege1.setPrivilegeScope("TABLE");
        privilege1.setServerName("server1");
        privilege1.setDbName("db1");
        privilege1.setTableName("tbl1");
        privilege1.setAction("SELECT");
        privilege1.setCreateTime(System.currentTimeMillis());
        junit.framework.Assert.assertEquals((long)(seqId + 2L), (long)sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName1, privilege1).getSequenceId());
        junit.framework.Assert.assertEquals((long)(seqId + 3L), (long)sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName2, privilege1).getSequenceId());
        TSentryPrivilege privilege2 = new TSentryPrivilege();
        privilege2.setPrivilegeScope("SERVER");
        privilege2.setServerName("server1");
        privilege2.setCreateTime(System.currentTimeMillis());
        junit.framework.Assert.assertEquals((long)(seqId + 4L), (long)sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName2, privilege2).getSequenceId());
        HashSet groups = Sets.newHashSet();
        TSentryGroup group = new TSentryGroup();
        group.setGroupName(groupName1);
        groups.add(group);
        junit.framework.Assert.assertEquals((long)(seqId + 5L), (long)sentryStore.alterSentryRoleAddGroups(grantor, roleName1, (Set)groups).getSequenceId());
        groups.clear();
        group = new TSentryGroup();
        group.setGroupName(groupName2);
        groups.add(group);
        junit.framework.Assert.assertEquals((long)(seqId + 6L), (long)sentryStore.alterSentryRoleAddGroups(grantor, roleName1, (Set)groups).getSequenceId());
        junit.framework.Assert.assertEquals((long)(seqId + 7L), (long)sentryStore.alterSentryRoleAddGroups(grantor, roleName2, (Set)groups).getSequenceId());
        junit.framework.Assert.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"server=server1->db=db1->table=tbl1->action=select"}), (Object)SentryStore.toTrimedLower((Set)sentryStore.listAllSentryPrivilegesForProvider((Set)Sets.newHashSet((Object[])new String[]{groupName1}), new TSentryActiveRoleSet(true, new HashSet()))));
        junit.framework.Assert.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"server=server1->db=db1->table=tbl1->action=select"}), (Object)SentryStore.toTrimedLower((Set)sentryStore.listAllSentryPrivilegesForProvider((Set)Sets.newHashSet((Object[])new String[]{groupName1}), new TSentryActiveRoleSet(false, (Set)Sets.newHashSet((Object[])new String[]{roleName1})))));
        junit.framework.Assert.assertEquals((Object)Sets.newHashSet(), (Object)SentryStore.toTrimedLower((Set)sentryStore.listAllSentryPrivilegesForProvider((Set)Sets.newHashSet((Object[])new String[]{groupName1}), new TSentryActiveRoleSet(false, (Set)Sets.newHashSet((Object[])new String[]{"not a role"})))));
        junit.framework.Assert.assertEquals((Object)Sets.newHashSet(), (Object)SentryStore.toTrimedLower((Set)sentryStore.listAllSentryPrivilegesForProvider((Set)Sets.newHashSet((Object[])new String[]{groupName1}), new TSentryActiveRoleSet(false, new HashSet()))));
        junit.framework.Assert.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"server=server1->db=db1->table=tbl1->action=select", "server=server1"}), (Object)SentryStore.toTrimedLower((Set)sentryStore.listAllSentryPrivilegesForProvider((Set)Sets.newHashSet((Object[])new String[]{groupName2}), new TSentryActiveRoleSet(true, new HashSet()))));
        junit.framework.Assert.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"server=server1->db=db1->table=tbl1->action=select"}), (Object)SentryStore.toTrimedLower((Set)sentryStore.listAllSentryPrivilegesForProvider((Set)Sets.newHashSet((Object[])new String[]{groupName2}), new TSentryActiveRoleSet(false, (Set)Sets.newHashSet((Object[])new String[]{roleName1})))));
        junit.framework.Assert.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"server=server1->db=db1->table=tbl1->action=select", "server=server1"}), (Object)SentryStore.toTrimedLower((Set)sentryStore.listAllSentryPrivilegesForProvider((Set)Sets.newHashSet((Object[])new String[]{groupName2}), new TSentryActiveRoleSet(false, (Set)Sets.newHashSet((Object[])new String[]{roleName2})))));
        junit.framework.Assert.assertEquals((Object)Sets.newHashSet(), (Object)SentryStore.toTrimedLower((Set)sentryStore.listAllSentryPrivilegesForProvider((Set)Sets.newHashSet((Object[])new String[]{groupName2}), new TSentryActiveRoleSet(false, (Set)Sets.newHashSet((Object[])new String[]{"not a role"})))));
        junit.framework.Assert.assertEquals((Object)Sets.newHashSet(), (Object)SentryStore.toTrimedLower((Set)sentryStore.listAllSentryPrivilegesForProvider((Set)Sets.newHashSet((Object[])new String[]{groupName2}), new TSentryActiveRoleSet(false, new HashSet()))));
        junit.framework.Assert.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"server=server1->db=db1->table=tbl1->action=select", "server=server1"}), (Object)SentryStore.toTrimedLower((Set)sentryStore.listAllSentryPrivilegesForProvider((Set)Sets.newHashSet((Object[])new String[]{groupName1, groupName2}), new TSentryActiveRoleSet(true, new HashSet()))));
        junit.framework.Assert.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"server=server1->db=db1->table=tbl1->action=select"}), (Object)SentryStore.toTrimedLower((Set)sentryStore.listAllSentryPrivilegesForProvider((Set)Sets.newHashSet((Object[])new String[]{groupName1, groupName2}), new TSentryActiveRoleSet(false, (Set)Sets.newHashSet((Object[])new String[]{roleName1})))));
        junit.framework.Assert.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"server=server1->db=db1->table=tbl1->action=select", "server=server1"}), (Object)SentryStore.toTrimedLower((Set)sentryStore.listAllSentryPrivilegesForProvider((Set)Sets.newHashSet((Object[])new String[]{groupName1, groupName2}), new TSentryActiveRoleSet(false, (Set)Sets.newHashSet((Object[])new String[]{roleName2})))));
        junit.framework.Assert.assertEquals((Object)Sets.newHashSet(), (Object)SentryStore.toTrimedLower((Set)sentryStore.listAllSentryPrivilegesForProvider((Set)Sets.newHashSet((Object[])new String[]{groupName1, groupName2}), new TSentryActiveRoleSet(false, (Set)Sets.newHashSet((Object[])new String[]{"not a role"})))));
        junit.framework.Assert.assertEquals((Object)Sets.newHashSet(), (Object)SentryStore.toTrimedLower((Set)sentryStore.listAllSentryPrivilegesForProvider((Set)Sets.newHashSet((Object[])new String[]{groupName1, groupName2}), new TSentryActiveRoleSet(false, new HashSet()))));
    }

    @Test
    public void testListRole() throws Exception {
        String roleName1 = "role1";
        String roleName2 = "role2";
        String roleName3 = "role3";
        String group1 = "group1";
        String group2 = "group2";
        String grantor = "g1";
        sentryStore.createSentryRole(roleName1);
        sentryStore.createSentryRole(roleName2);
        sentryStore.createSentryRole(roleName3);
        sentryStore.alterSentryRoleAddGroups(grantor, roleName1, (Set)Sets.newHashSet((Object[])new TSentryGroup[]{new TSentryGroup(group1)}));
        sentryStore.alterSentryRoleAddGroups(grantor, roleName2, (Set)Sets.newHashSet((Object[])new TSentryGroup[]{new TSentryGroup(group2)}));
        sentryStore.alterSentryRoleAddGroups(grantor, roleName3, (Set)Sets.newHashSet((Object[])new TSentryGroup[]{new TSentryGroup(group1), new TSentryGroup(group2)}));
        junit.framework.Assert.assertEquals((int)2, (int)sentryStore.getTSentryRolesByGroupName((Set)Sets.newHashSet((Object[])new String[]{group1}), false).size());
        junit.framework.Assert.assertEquals((int)2, (int)sentryStore.getTSentryRolesByGroupName((Set)Sets.newHashSet((Object[])new String[]{group2}), false).size());
        junit.framework.Assert.assertEquals((int)3, (int)sentryStore.getTSentryRolesByGroupName((Set)Sets.newHashSet((Object[])new String[]{group1, group2}), false).size());
        junit.framework.Assert.assertEquals((int)0, (int)sentryStore.getTSentryRolesByGroupName((Set)Sets.newHashSet((Object[])new String[]{"foo"}), true).size());
    }

    @Test
    public void testDropDbObject() throws Exception {
        String roleName1 = "list-privs-r1";
        String roleName2 = "list-privs-r2";
        String roleName3 = "list-privs-r3";
        String grantor = "g1";
        sentryStore.createSentryRole(roleName1);
        sentryStore.createSentryRole(roleName2);
        sentryStore.createSentryRole(roleName3);
        TSentryPrivilege privilege_tbl1 = new TSentryPrivilege();
        privilege_tbl1.setPrivilegeScope("TABLE");
        privilege_tbl1.setServerName("server1");
        privilege_tbl1.setDbName("db1");
        privilege_tbl1.setTableName("tbl1");
        privilege_tbl1.setCreateTime(System.currentTimeMillis());
        TSentryPrivilege privilege1 = new TSentryPrivilege(privilege_tbl1);
        privilege1.setAction("SELECT");
        TSentryPrivilege privilege2_1 = new TSentryPrivilege(privilege_tbl1);
        privilege2_1.setAction("INSERT");
        TSentryPrivilege privilege3_1 = new TSentryPrivilege(privilege_tbl1);
        privilege3_1.setAction("*");
        TSentryPrivilege privilege_server = new TSentryPrivilege();
        privilege_server.setPrivilegeScope("SERVER");
        privilege_server.setServerName("server1");
        privilege_server.setCreateTime(System.currentTimeMillis());
        TSentryPrivilege privilege_tbl2 = new TSentryPrivilege();
        privilege_tbl2.setPrivilegeScope("TABLE");
        privilege_tbl2.setServerName("server1");
        privilege_tbl2.setDbName("db1");
        privilege_tbl2.setTableName("tbl2");
        privilege_tbl2.setCreateTime(System.currentTimeMillis());
        TSentryPrivilege privilege2_3 = new TSentryPrivilege(privilege_tbl2);
        privilege2_3.setAction("SELECT");
        TSentryPrivilege privilege3_2 = new TSentryPrivilege(privilege_tbl2);
        privilege3_2.setAction("INSERT");
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName1, privilege1);
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName2, privilege2_1);
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName2, privilege_server);
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName2, privilege2_3);
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName3, privilege3_1);
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName3, privilege3_2);
        sentryStore.dropPrivilege(this.toTSentryAuthorizable(privilege_tbl1));
        junit.framework.Assert.assertEquals((int)0, (int)sentryStore.getAllTSentryPrivilegesByRoleName(roleName1).size());
        junit.framework.Assert.assertEquals((int)2, (int)sentryStore.getAllTSentryPrivilegesByRoleName(roleName2).size());
        junit.framework.Assert.assertEquals((int)1, (int)sentryStore.getAllTSentryPrivilegesByRoleName(roleName3).size());
        sentryStore.dropPrivilege(this.toTSentryAuthorizable(privilege_tbl2));
        junit.framework.Assert.assertEquals((int)0, (int)sentryStore.getAllTSentryPrivilegesByRoleName(roleName1).size());
        junit.framework.Assert.assertEquals((int)1, (int)sentryStore.getAllTSentryPrivilegesByRoleName(roleName2).size());
        junit.framework.Assert.assertEquals((int)0, (int)sentryStore.getAllTSentryPrivilegesByRoleName(roleName3).size());
    }

    @Test
    public void testDropTableWithMultiAction() throws Exception {
        String roleName1 = "role1";
        String grantor = "g1";
        sentryStore.createSentryRole(roleName1);
        TSentryPrivilege privilege_tbl1 = new TSentryPrivilege();
        privilege_tbl1.setPrivilegeScope("TABLE");
        privilege_tbl1.setServerName("server1");
        privilege_tbl1.setDbName("db1");
        privilege_tbl1.setTableName("tbl1");
        privilege_tbl1.setCreateTime(System.currentTimeMillis());
        TSentryPrivilege privilege_tbl1_insert = new TSentryPrivilege(privilege_tbl1);
        privilege_tbl1_insert.setAction("insert");
        TSentryPrivilege privilege_tbl1_select = new TSentryPrivilege(privilege_tbl1);
        privilege_tbl1_select.setAction("select");
        TSentryPrivilege privilege_tbl1_alter = new TSentryPrivilege(privilege_tbl1);
        privilege_tbl1_alter.setAction("alter");
        TSentryPrivilege privilege_tbl1_drop = new TSentryPrivilege(privilege_tbl1);
        privilege_tbl1_drop.setAction("drop");
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName1, privilege_tbl1_insert);
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName1, privilege_tbl1_select);
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName1, privilege_tbl1_alter);
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName1, privilege_tbl1_drop);
        junit.framework.Assert.assertEquals((int)4, (int)sentryStore.getAllTSentryPrivilegesByRoleName(roleName1).size());
        sentryStore.dropPrivilege(this.toTSentryAuthorizable(privilege_tbl1));
        junit.framework.Assert.assertEquals((int)0, (int)sentryStore.getAllTSentryPrivilegesByRoleName(roleName1).size());
    }

    @Test
    public void testDropTableWithColumn() throws Exception {
        String roleName1 = "role1";
        String roleName2 = "role2";
        String grantor = "g1";
        String table1 = "tbl1";
        sentryStore.createSentryRole(roleName1);
        sentryStore.createSentryRole(roleName2);
        TSentryPrivilege privilege_tbl1 = new TSentryPrivilege();
        privilege_tbl1.setPrivilegeScope("TABLE");
        privilege_tbl1.setServerName("server1");
        privilege_tbl1.setDbName("db1");
        privilege_tbl1.setTableName(table1);
        privilege_tbl1.setAction("select");
        privilege_tbl1.setCreateTime(System.currentTimeMillis());
        TSentryPrivilege privilege_tbl1_c1 = new TSentryPrivilege(privilege_tbl1);
        privilege_tbl1_c1.setPrivilegeScope("COLUMN");
        privilege_tbl1_c1.setColumnName("c1");
        privilege_tbl1_c1.setCreateTime(System.currentTimeMillis());
        TSentryPrivilege privilege_tbl1_c2 = new TSentryPrivilege(privilege_tbl1);
        privilege_tbl1_c2.setPrivilegeScope("COLUMN");
        privilege_tbl1_c2.setColumnName("c2");
        privilege_tbl1_c2.setCreateTime(System.currentTimeMillis());
        TSentryPrivilege privilege_tbl1_c3 = new TSentryPrivilege(privilege_tbl1);
        privilege_tbl1_c3.setPrivilegeScope("COLUMN");
        privilege_tbl1_c3.setColumnName("c3");
        privilege_tbl1_c3.setCreateTime(System.currentTimeMillis());
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName1, privilege_tbl1_c1);
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName1, privilege_tbl1_c2);
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName2, privilege_tbl1_c3);
        Set privilegeSet = sentryStore.getAllTSentryPrivilegesByRoleName(roleName1);
        junit.framework.Assert.assertEquals((int)2, (int)privilegeSet.size());
        privilegeSet = sentryStore.getAllTSentryPrivilegesByRoleName(roleName2);
        junit.framework.Assert.assertEquals((int)1, (int)privilegeSet.size());
        TSentryAuthorizable tableAuthorizable = this.toTSentryAuthorizable(privilege_tbl1);
        sentryStore.dropPrivilege(tableAuthorizable);
        privilegeSet = sentryStore.getAllTSentryPrivilegesByRoleName(roleName1);
        junit.framework.Assert.assertEquals((int)0, (int)privilegeSet.size());
        privilegeSet = sentryStore.getAllTSentryPrivilegesByRoleName(roleName2);
        junit.framework.Assert.assertEquals((int)0, (int)privilegeSet.size());
    }

    @Test
    public void testDropOverlappedPrivileges() throws Exception {
        String roleName1 = "list-privs-r1";
        String grantor = "g1";
        sentryStore.createSentryRole(roleName1);
        TSentryPrivilege privilege_tbl1 = new TSentryPrivilege();
        privilege_tbl1.setPrivilegeScope("TABLE");
        privilege_tbl1.setServerName("server1");
        privilege_tbl1.setDbName("db1");
        privilege_tbl1.setTableName("tbl1");
        privilege_tbl1.setCreateTime(System.currentTimeMillis());
        TSentryPrivilege privilege_tbl1_insert = new TSentryPrivilege(privilege_tbl1);
        privilege_tbl1_insert.setAction("INSERT");
        TSentryPrivilege privilege_tbl1_all = new TSentryPrivilege(privilege_tbl1);
        privilege_tbl1_all.setAction("*");
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName1, privilege_tbl1_insert);
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName1, privilege_tbl1_all);
        sentryStore.dropPrivilege(this.toTSentryAuthorizable(privilege_tbl1));
        junit.framework.Assert.assertEquals((int)0, (int)sentryStore.getAllTSentryPrivilegesByRoleName(roleName1).size());
    }

    private TSentryAuthorizable toTSentryAuthorizable(TSentryPrivilege tSentryPrivilege) {
        TSentryAuthorizable tSentryAuthorizable = new TSentryAuthorizable();
        tSentryAuthorizable.setServer(tSentryPrivilege.getServerName());
        tSentryAuthorizable.setDb(tSentryPrivilege.getDbName());
        tSentryAuthorizable.setTable(tSentryPrivilege.getTableName());
        tSentryAuthorizable.setUri(tSentryPrivilege.getURI());
        return tSentryAuthorizable;
    }

    @Test
    public void testRenameTable() throws Exception {
        String roleName1 = "role1";
        String roleName2 = "role2";
        String roleName3 = "role3";
        String grantor = "g1";
        String table1 = "tbl1";
        String table2 = "tbl2";
        sentryStore.createSentryRole(roleName1);
        sentryStore.createSentryRole(roleName2);
        sentryStore.createSentryRole(roleName3);
        TSentryPrivilege privilege_tbl1 = new TSentryPrivilege();
        privilege_tbl1.setPrivilegeScope("TABLE");
        privilege_tbl1.setServerName("server1");
        privilege_tbl1.setDbName("db1");
        privilege_tbl1.setTableName(table1);
        privilege_tbl1.setCreateTime(System.currentTimeMillis());
        TSentryPrivilege privilege_tbl1_insert = new TSentryPrivilege(privilege_tbl1);
        privilege_tbl1_insert.setAction("insert");
        TSentryPrivilege privilege_tbl1_select = new TSentryPrivilege(privilege_tbl1);
        privilege_tbl1_select.setAction("select");
        TSentryPrivilege privilege_tbl1_all = new TSentryPrivilege(privilege_tbl1);
        privilege_tbl1_all.setAction("*");
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName1, privilege_tbl1_insert);
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName2, privilege_tbl1_select);
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName3, privilege_tbl1_all);
        TSentryAuthorizable oldTable = this.toTSentryAuthorizable(privilege_tbl1);
        TSentryAuthorizable newTable = this.toTSentryAuthorizable(privilege_tbl1);
        newTable.setTable(table2);
        sentryStore.renamePrivilege(oldTable, newTable);
        for (String roleName : Sets.newHashSet((Object[])new String[]{roleName1, roleName2, roleName3})) {
            Set privilegeSet = sentryStore.getAllTSentryPrivilegesByRoleName(roleName);
            junit.framework.Assert.assertEquals((int)1, (int)privilegeSet.size());
            for (TSentryPrivilege privilege : privilegeSet) {
                junit.framework.Assert.assertTrue((boolean)table2.equalsIgnoreCase(privilege.getTableName()));
            }
        }
    }

    @Test
    public void testRenameTableWithMultiAction() throws Exception {
        String roleName1 = "role1";
        String grantor = "g1";
        String table1 = "tbl1";
        String table2 = "tbl2";
        sentryStore.createSentryRole(roleName1);
        TSentryPrivilege privilege_tbl1 = new TSentryPrivilege();
        privilege_tbl1.setPrivilegeScope("TABLE");
        privilege_tbl1.setServerName("server1");
        privilege_tbl1.setDbName("db1");
        privilege_tbl1.setTableName(table1);
        privilege_tbl1.setCreateTime(System.currentTimeMillis());
        TSentryPrivilege privilege_tbl1_insert = new TSentryPrivilege(privilege_tbl1);
        privilege_tbl1_insert.setAction("insert");
        TSentryPrivilege privilege_tbl1_select = new TSentryPrivilege(privilege_tbl1);
        privilege_tbl1_select.setAction("select");
        TSentryPrivilege privilege_tbl1_alter = new TSentryPrivilege(privilege_tbl1);
        privilege_tbl1_alter.setAction("alter");
        TSentryPrivilege privilege_tbl1_drop = new TSentryPrivilege(privilege_tbl1);
        privilege_tbl1_drop.setAction("drop");
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName1, privilege_tbl1_insert);
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName1, privilege_tbl1_select);
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName1, privilege_tbl1_alter);
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName1, privilege_tbl1_drop);
        TSentryAuthorizable oldTable = this.toTSentryAuthorizable(privilege_tbl1);
        TSentryAuthorizable newTable = this.toTSentryAuthorizable(privilege_tbl1);
        newTable.setTable(table2);
        sentryStore.renamePrivilege(oldTable, newTable);
        Set privilegeSet = sentryStore.getAllTSentryPrivilegesByRoleName(roleName1);
        junit.framework.Assert.assertEquals((int)4, (int)privilegeSet.size());
        for (TSentryPrivilege privilege : privilegeSet) {
            junit.framework.Assert.assertTrue((boolean)table2.equalsIgnoreCase(privilege.getTableName()));
        }
    }

    @Test
    public void testSentryRoleSize() throws Exception {
        for (long i = 0L; i < 5L; ++i) {
            junit.framework.Assert.assertEquals((Object)i, (Object)sentryStore.getRoleCountGauge().getValue());
            sentryStore.createSentryRole("role" + i);
        }
    }

    @Test
    public void testSentryPrivilegeSize() throws Exception {
        String role1 = "role1";
        String role2 = "role2";
        sentryStore.createSentryRole(role1);
        sentryStore.createSentryRole(role2);
        TSentryPrivilege privilege = new TSentryPrivilege();
        privilege.setPrivilegeScope("TABLE");
        privilege.setServerName("server1");
        privilege.setDbName("db1");
        privilege.setTableName("tb1");
        privilege.setCreateTime(System.currentTimeMillis());
        String grantor = "g1";
        junit.framework.Assert.assertEquals((Object)new Long(0L), (Object)sentryStore.getPrivilegeCountGauge().getValue());
        sentryStore.alterSentryRoleGrantPrivilege(grantor, role1, privilege);
        junit.framework.Assert.assertEquals((Object)new Long(1L), (Object)sentryStore.getPrivilegeCountGauge().getValue());
        sentryStore.alterSentryRoleGrantPrivilege(grantor, role2, privilege);
        junit.framework.Assert.assertEquals((Object)new Long(1L), (Object)sentryStore.getPrivilegeCountGauge().getValue());
        privilege.setTableName("tb2");
        sentryStore.alterSentryRoleGrantPrivilege(grantor, role2, privilege);
        junit.framework.Assert.assertEquals((Object)new Long(2L), (Object)sentryStore.getPrivilegeCountGauge().getValue());
    }

    @Test
    public void testSentryGroupsSize() throws Exception {
        String role1 = "role1";
        String role2 = "role2";
        sentryStore.createSentryRole(role1);
        sentryStore.createSentryRole(role2);
        HashSet groups = Sets.newHashSet();
        TSentryGroup group = new TSentryGroup();
        group.setGroupName("group1");
        groups.add(group);
        String grantor = "g1";
        sentryStore.alterSentryRoleAddGroups(grantor, role1, (Set)groups);
        junit.framework.Assert.assertEquals((Object)new Long(1L), (Object)sentryStore.getGroupCountGauge().getValue());
        sentryStore.alterSentryRoleAddGroups(grantor, role2, (Set)groups);
        junit.framework.Assert.assertEquals((Object)new Long(1L), (Object)sentryStore.getGroupCountGauge().getValue());
        groups.add(new TSentryGroup("group2"));
        sentryStore.alterSentryRoleAddGroups(grantor, role2, (Set)groups);
        junit.framework.Assert.assertEquals((Object)new Long(2L), (Object)sentryStore.getGroupCountGauge().getValue());
    }

    @Test
    public void testRenameTableWithColumn() throws Exception {
        String roleName1 = "role1";
        String roleName2 = "role2";
        String grantor = "g1";
        String table1 = "tbl1";
        String table2 = "tbl2";
        sentryStore.createSentryRole(roleName1);
        sentryStore.createSentryRole(roleName2);
        TSentryPrivilege privilege_tbl1 = new TSentryPrivilege();
        privilege_tbl1.setPrivilegeScope("TABLE");
        privilege_tbl1.setServerName("server1");
        privilege_tbl1.setDbName("db1");
        privilege_tbl1.setTableName(table1);
        privilege_tbl1.setAction("select");
        privilege_tbl1.setCreateTime(System.currentTimeMillis());
        TSentryPrivilege privilege_tbl1_c1 = new TSentryPrivilege(privilege_tbl1);
        privilege_tbl1_c1.setPrivilegeScope("COLUMN");
        privilege_tbl1_c1.setColumnName("c1");
        privilege_tbl1_c1.setCreateTime(System.currentTimeMillis());
        TSentryPrivilege privilege_tbl1_c2 = new TSentryPrivilege(privilege_tbl1);
        privilege_tbl1_c2.setPrivilegeScope("COLUMN");
        privilege_tbl1_c2.setColumnName("c2");
        privilege_tbl1_c2.setCreateTime(System.currentTimeMillis());
        TSentryPrivilege privilege_tbl1_c3 = new TSentryPrivilege(privilege_tbl1);
        privilege_tbl1_c3.setPrivilegeScope("COLUMN");
        privilege_tbl1_c3.setColumnName("c3");
        privilege_tbl1_c3.setCreateTime(System.currentTimeMillis());
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName1, privilege_tbl1_c1);
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName1, privilege_tbl1_c2);
        sentryStore.alterSentryRoleGrantPrivilege(grantor, roleName2, privilege_tbl1_c3);
        Set privilegeSet = sentryStore.getAllTSentryPrivilegesByRoleName(roleName1);
        junit.framework.Assert.assertEquals((int)2, (int)privilegeSet.size());
        privilegeSet = sentryStore.getAllTSentryPrivilegesByRoleName(roleName2);
        junit.framework.Assert.assertEquals((int)1, (int)privilegeSet.size());
        TSentryAuthorizable oldTable = this.toTSentryAuthorizable(privilege_tbl1);
        TSentryAuthorizable newTable = this.toTSentryAuthorizable(privilege_tbl1);
        newTable.setTable(table2);
        sentryStore.renamePrivilege(oldTable, newTable);
        privilegeSet = sentryStore.getAllTSentryPrivilegesByRoleName(roleName1);
        junit.framework.Assert.assertEquals((int)2, (int)privilegeSet.size());
        for (TSentryPrivilege privilege : privilegeSet) {
            junit.framework.Assert.assertTrue((boolean)table2.equalsIgnoreCase(privilege.getTableName()));
        }
        privilegeSet = sentryStore.getAllTSentryPrivilegesByRoleName(roleName2);
        junit.framework.Assert.assertEquals((int)1, (int)privilegeSet.size());
    }

    protected static void addGroupsToUser(String user, String ... groupNames) {
        policyFile.addGroupsToUser(user, groupNames);
    }

    protected static void writePolicyFile() throws Exception {
        policyFile.write(policyFilePath);
    }

    static {
        adminGroups = new String[]{"adminGroup1"};
        conf = null;
        passwd = new char[]{'1', '2', '3'};
    }
}

