/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.service.persistent;

import java.io.IOException;
import java.util.HashMap;
import junit.framework.Assert;
import org.apache.curator.test.TestingServer;
import org.apache.curator.x.discovery.ServiceInstance;
import org.apache.hadoop.conf.Configuration;
import org.apache.sentry.provider.db.service.persistent.HAContext;
import org.apache.sentry.provider.db.service.persistent.ServiceManager;
import org.apache.sentry.provider.db.service.persistent.ServiceRegister;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestSentryServiceDiscovery {
    private HAContext haContext;
    private TestingServer server;

    @Before
    public void setup() throws Exception {
        this.server = new TestingServer();
        Configuration conf = new Configuration(false);
        conf.set("sentry.ha.enabled", "true");
        conf.set("sentry.ha.zookeeper.namespace", "sentry-test");
        conf.set("sentry.ha.zookeeper.quorum", this.server.getConnectString());
        this.haContext = HAContext.getHAContext((Configuration)conf);
    }

    @After
    public void teardown() {
        HAContext.clearServerContext();
        if (this.server != null) {
            try {
                this.server.stop();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testRegisterOneService() throws Exception {
        String hostname = "localhost1";
        Integer port = 123;
        ServiceRegister register = new ServiceRegister(this.haContext);
        register.regService("localhost1", port.intValue());
        ServiceManager manager = new ServiceManager(this.haContext);
        ServiceInstance instance = manager.getServiceInstance();
        Assert.assertEquals((String)"'hostname' doesn't match.", (String)"localhost1", (String)instance.getAddress());
        Assert.assertEquals((String)"'port' doesn't match.", (Object)port, (Object)instance.getPort());
    }

    @Test
    public void testRegisterMultiService() throws Exception {
        String hostname1 = "localhost1";
        Integer port1 = 123;
        String hostname2 = "localhost2";
        Integer port2 = 456;
        String hostname3 = "localhost3";
        Integer port3 = 789;
        HashMap<String, Integer> servicesMap = new HashMap<String, Integer>();
        servicesMap.put("localhost1", port1);
        servicesMap.put("localhost2", port2);
        servicesMap.put("localhost3", port3);
        ServiceRegister register1 = new ServiceRegister(this.haContext);
        register1.regService("localhost1", port1.intValue());
        ServiceRegister register2 = new ServiceRegister(this.haContext);
        register2.regService("localhost2", port2.intValue());
        ServiceRegister register3 = new ServiceRegister(this.haContext);
        register3.regService("localhost3", port3.intValue());
        ServiceManager manager = new ServiceManager(this.haContext);
        ServiceInstance instance = manager.getServiceInstance();
        Assert.assertEquals((String)"'instance' doesn't match.", (Object)instance.getPort(), servicesMap.get(instance.getAddress()));
        instance = manager.getServiceInstance();
        Assert.assertEquals((String)"'instance' doesn't match.", (Object)instance.getPort(), servicesMap.get(instance.getAddress()));
        instance = manager.getServiceInstance();
        Assert.assertEquals((String)"'instance' doesn't match.", (Object)instance.getPort(), servicesMap.get(instance.getAddress()));
    }

    @Test
    public void testReportError() throws Exception {
        String hostname1 = "localhost1";
        Integer port1 = 123;
        ServiceRegister register1 = new ServiceRegister(this.haContext);
        register1.regService("localhost1", port1.intValue());
        ServiceManager manager = new ServiceManager(this.haContext);
        ServiceInstance instance = manager.getServiceInstance();
        manager.reportError(instance);
        instance = manager.getServiceInstance();
        manager.reportError(instance);
        instance = manager.getServiceInstance();
        Assert.assertEquals((String)"'instance' should be null.", null, (Object)instance);
    }
}

