/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.service.persistent;

import junit.framework.Assert;
import org.apache.sentry.provider.db.service.model.MSentryPrivilege;
import org.junit.Test;

public class TestSentryPrivilege {
    @Test
    public void testImpliesPrivilegePositive() throws Exception {
        MSentryPrivilege my = new MSentryPrivilege();
        MSentryPrivilege your = new MSentryPrivilege();
        my.setServerName("server1");
        my.setDbName("db1");
        my.setTableName("tb1");
        my.setAction("select");
        your.setServerName("server1");
        your.setDbName("db1");
        your.setTableName("tb1");
        your.setAction("select");
        Assert.assertTrue((boolean)my.implies(your));
        my.setAction("*");
        Assert.assertTrue((boolean)my.implies(your));
        my.setTableName("");
        Assert.assertTrue((boolean)my.implies(your));
        my.setDbName("");
        Assert.assertTrue((boolean)my.implies(your));
        my.setAction("ALL");
        Assert.assertTrue((boolean)my.implies(your));
        my.setTableName("");
        Assert.assertTrue((boolean)my.implies(your));
        my.setDbName("");
        Assert.assertTrue((boolean)my.implies(your));
        String[][] actionMap = new String[][]{{"*", "*"}, {"*", "ALL"}, {"ALL", "*"}, {"ALL", "ALL"}};
        for (int actions = 0; actions < actionMap.length; ++actions) {
            my = new MSentryPrivilege();
            your = new MSentryPrivilege();
            my.setServerName("server1");
            my.setAction(actionMap[actions][0]);
            your.setServerName("server1");
            your.setAction(actionMap[actions][1]);
            my.setURI("hdfs://namenode:9000/path");
            your.setURI("hdfs://namenode:9000/path");
            Assert.assertTrue((boolean)my.implies(your));
            my.setURI("hdfs://namenode:9000/path");
            your.setURI("hdfs://namenode:9000/path/to/some/dir");
            Assert.assertTrue((boolean)my.implies(your));
            my.setURI("file:///path");
            your.setURI("file:///path");
            Assert.assertTrue((boolean)my.implies(your));
            my.setURI("file:///path");
            your.setURI("file:///path/to/some/dir");
            Assert.assertTrue((boolean)my.implies(your));
            my.setURI("");
            your.setURI("file:///path");
            Assert.assertTrue((boolean)my.implies(your));
        }
    }

    @Test
    public void testImpliesPrivilegeNegative() throws Exception {
        MSentryPrivilege my = new MSentryPrivilege();
        MSentryPrivilege your = new MSentryPrivilege();
        my.setServerName("server1");
        my.setDbName("db1");
        my.setTableName("tb1");
        my.setAction("select");
        your.setServerName("server1");
        your.setDbName("db1");
        your.setTableName("tb1");
        your.setAction("insert");
        Assert.assertFalse((boolean)my.implies(your));
        your.setAction("*");
        Assert.assertFalse((boolean)my.implies(your));
        your.setTableName("tb2");
        Assert.assertFalse((boolean)my.implies(your));
        your.setTableName("tb1");
        your.setDbName("db2");
        Assert.assertFalse((boolean)my.implies(your));
        your.setTableName("tb1");
        your.setDbName("db1");
        your.setServerName("server2");
        Assert.assertFalse((boolean)my.implies(your));
        my = new MSentryPrivilege();
        your = new MSentryPrivilege();
        my.setServerName("server1");
        my.setAction("*");
        your.setServerName("server2");
        your.setAction("*");
        my.setURI("hdfs://namenode:9000/path");
        your.setURI("hdfs://namenode:9000/path/to/../../other");
        Assert.assertFalse((boolean)my.implies(your));
        my.setURI("file:///path");
        your.setURI("file:///path/to/../../other");
        Assert.assertFalse((boolean)my.implies(your));
        my.setURI("blah");
        your.setURI("hdfs://namenode:9000/path/to/some/dir");
        Assert.assertFalse((boolean)my.implies(your));
        my.setURI("hdfs://namenode:9000/path/to/some/dir");
        your.setURI("blah");
        Assert.assertFalse((boolean)my.implies(your));
        my.setURI("hdfs://namenode:9000/path");
        your.setURI("file:///path/to/some/dir");
        Assert.assertFalse((boolean)my.implies(your));
        my.setURI("hdfs://namenode:9000/path");
        your.setURI("file://namenode:9000/path/to/some/dir");
        Assert.assertFalse((boolean)my.implies(your));
        my.setURI("hdfs://namenode1:9000/path");
        your.setURI("hdfs://namenode2:9000/path");
        Assert.assertFalse((boolean)my.implies(your));
        my.setURI("hdfs://namenode:9000/path");
        your.setURI("hdfs://namenode:9001/path");
        Assert.assertFalse((boolean)my.implies(your));
        my.setURI("hdfs://namenode:9000/path1");
        your.setURI("hdfs://namenode:9000/path2");
        Assert.assertFalse((boolean)my.implies(your));
        my.setURI("file:///path1");
        your.setURI("file:///path2");
        Assert.assertFalse((boolean)my.implies(your));
        your.setServerName("server2");
        my.setURI("hdfs://namenode:9000/path1");
        your.setURI("hdfs://namenode:9000/path1");
        Assert.assertFalse((boolean)my.implies(your));
        my.setServerName("server1");
        my.setURI("hdfs://namenode:9000/path1");
        your.setServerName("server1");
        your.setURI("");
        Assert.assertFalse((boolean)my.implies(your));
    }

    @Test
    public void testImpliesPrivilegePositiveWithColumn() throws Exception {
        MSentryPrivilege my = new MSentryPrivilege();
        MSentryPrivilege your = new MSentryPrivilege();
        my.setServerName("server1");
        my.setAction("select");
        your.setServerName("server1");
        your.setDbName("db1");
        your.setTableName("tb1");
        your.setColumnName("c1");
        your.setAction("select");
        Assert.assertTrue((boolean)my.implies(your));
        my.setDbName("db1");
        Assert.assertTrue((boolean)my.implies(your));
        my.setTableName("tb1");
        Assert.assertTrue((boolean)my.implies(your));
        my.setColumnName("c1");
        Assert.assertTrue((boolean)my.implies(your));
    }

    @Test
    public void testImpliesPrivilegeNegativeWithColumn() throws Exception {
        MSentryPrivilege my = new MSentryPrivilege();
        MSentryPrivilege your = new MSentryPrivilege();
        my.setServerName("server1");
        my.setDbName("db1");
        my.setTableName("tb1");
        my.setColumnName("c1");
        my.setAction("select");
        your.setServerName("server1");
        your.setDbName("db1");
        your.setTableName("tb1");
        your.setColumnName("c2");
        your.setAction("select");
        Assert.assertFalse((boolean)my.implies(your));
        your.setColumnName("");
        Assert.assertFalse((boolean)my.implies(your));
    }
}

