/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.log.util;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import junit.framework.TestCase;
import org.apache.sentry.provider.db.log.util.CommandUtil;
import org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleAddGroupsRequest;
import org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleDeleteGroupsRequest;
import org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleGrantPrivilegeRequest;
import org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleRevokePrivilegeRequest;
import org.apache.sentry.provider.db.service.thrift.TSentryGrantOption;
import org.apache.sentry.provider.db.service.thrift.TSentryGroup;
import org.apache.sentry.provider.db.service.thrift.TSentryPrivilege;
import org.apache.sentry.service.thrift.ServiceConstants;
import org.junit.Test;

public class TestCommandUtil
extends TestCase {
    @Test
    public void testCreateCmdForCreateOrDropRole() {
        String roleName = "testRole";
        String createRoleCmdResult = CommandUtil.createCmdForCreateOrDropRole((String)roleName, (boolean)true);
        String dropRoleCmdResult = CommandUtil.createCmdForCreateOrDropRole((String)roleName, (boolean)false);
        String createRoleCmdExcepted = "CREATE ROLE testRole";
        String dropRoleCmdExcepted = "DROP ROLE testRole";
        TestCommandUtil.assertEquals((String)createRoleCmdExcepted, (String)createRoleCmdResult);
        TestCommandUtil.assertEquals((String)dropRoleCmdResult, (String)dropRoleCmdExcepted);
    }

    @Test
    public void testCreateCmdForRoleAddOrDeleteGroup1() {
        TAlterSentryRoleAddGroupsRequest requestAdd = this.getRoleAddGroupsRequest();
        TAlterSentryRoleDeleteGroupsRequest requestDelete = this.getRoleDeleteGroupsRequest();
        Set<TSentryGroup> groups = this.getGroups(1);
        requestAdd.setGroups(groups);
        requestDelete.setGroups(groups);
        String createRoleAddGroupCmdResult = CommandUtil.createCmdForRoleAddGroup((TAlterSentryRoleAddGroupsRequest)requestAdd);
        String createRoleAddGroupCmdExcepted = "GRANT ROLE testRole TO GROUP testGroup1";
        String createRoleDeleteGroupCmdResult = CommandUtil.createCmdForRoleDeleteGroup((TAlterSentryRoleDeleteGroupsRequest)requestDelete);
        String createRoleDeleteGroupCmdExcepted = "REVOKE ROLE testRole FROM GROUP testGroup1";
        TestCommandUtil.assertEquals((String)createRoleAddGroupCmdExcepted, (String)createRoleAddGroupCmdResult);
        TestCommandUtil.assertEquals((String)createRoleDeleteGroupCmdExcepted, (String)createRoleDeleteGroupCmdResult);
    }

    @Test
    public void testCreateCmdForRoleAddOrDeleteGroup2() {
        TAlterSentryRoleAddGroupsRequest requestAdd = this.getRoleAddGroupsRequest();
        TAlterSentryRoleDeleteGroupsRequest requestDelete = this.getRoleDeleteGroupsRequest();
        Set<TSentryGroup> groups = this.getGroups(3);
        requestAdd.setGroups(groups);
        requestDelete.setGroups(groups);
        String createRoleAddGroupCmdResult = CommandUtil.createCmdForRoleAddGroup((TAlterSentryRoleAddGroupsRequest)requestAdd);
        String createRoleAddGroupCmdExcepted = "GRANT ROLE testRole TO GROUP testGroup1, testGroup2, testGroup3";
        String createRoleDeleteGroupCmdResult = CommandUtil.createCmdForRoleDeleteGroup((TAlterSentryRoleDeleteGroupsRequest)requestDelete);
        String createRoleDeleteGroupCmdExcepted = "REVOKE ROLE testRole FROM GROUP testGroup1, testGroup2, testGroup3";
        TestCommandUtil.assertEquals((String)createRoleAddGroupCmdExcepted, (String)createRoleAddGroupCmdResult);
        TestCommandUtil.assertEquals((String)createRoleDeleteGroupCmdExcepted, (String)createRoleDeleteGroupCmdResult);
    }

    @Test
    public void testCreateCmdForGrantOrRevokePrivilege1() {
        TAlterSentryRoleGrantPrivilegeRequest grantRequest = this.getGrantPrivilegeRequest();
        TAlterSentryRoleRevokePrivilegeRequest revokeRequest = this.getRevokePrivilegeRequest();
        TSentryPrivilege privilege = this.getPrivilege("*", ServiceConstants.PrivilegeScope.DATABASE.name(), "dbTest", "tableTest", "serverTest", "hdfs://namenode:port/path/to/dir");
        HashSet privileges = Sets.newHashSet();
        privileges.add(privilege);
        grantRequest.setPrivileges((Set)privileges);
        revokeRequest.setPrivileges((Set)privileges);
        String createGrantPrivilegeCmdResult = CommandUtil.createCmdForGrantPrivilege((TAlterSentryRoleGrantPrivilegeRequest)grantRequest);
        String createGrantPrivilegeCmdExcepted = "GRANT ALL ON DATABASE dbTest TO ROLE testRole";
        String createRevokePrivilegeCmdResult = CommandUtil.createCmdForRevokePrivilege((TAlterSentryRoleRevokePrivilegeRequest)revokeRequest);
        String createRevokePrivilegeCmdExcepted = "REVOKE ALL ON DATABASE dbTest FROM ROLE testRole";
        TestCommandUtil.assertEquals((String)createGrantPrivilegeCmdExcepted, (String)createGrantPrivilegeCmdResult);
        TestCommandUtil.assertEquals((String)createRevokePrivilegeCmdExcepted, (String)createRevokePrivilegeCmdResult);
    }

    @Test
    public void testCreateCmdForGrantOrRevokePrivilege2() {
        TAlterSentryRoleGrantPrivilegeRequest grantRequest = this.getGrantPrivilegeRequest();
        TAlterSentryRoleRevokePrivilegeRequest revokeRequest = this.getRevokePrivilegeRequest();
        TSentryPrivilege privilege = this.getPrivilege("insert", ServiceConstants.PrivilegeScope.DATABASE.name(), "dbTest", "tableTest", "serverTest", "hdfs://namenode:port/path/to/dir");
        HashSet privileges = Sets.newHashSet();
        privileges.add(privilege);
        grantRequest.setPrivileges((Set)privileges);
        revokeRequest.setPrivileges((Set)privileges);
        String createGrantPrivilegeCmdResult = CommandUtil.createCmdForGrantPrivilege((TAlterSentryRoleGrantPrivilegeRequest)grantRequest);
        String createGrantPrivilegeCmdExcepted = "GRANT INSERT ON DATABASE dbTest TO ROLE testRole";
        String createRevokePrivilegeCmdResult = CommandUtil.createCmdForRevokePrivilege((TAlterSentryRoleRevokePrivilegeRequest)revokeRequest);
        String createRevokePrivilegeCmdExcepted = "REVOKE INSERT ON DATABASE dbTest FROM ROLE testRole";
        TestCommandUtil.assertEquals((String)createGrantPrivilegeCmdExcepted, (String)createGrantPrivilegeCmdResult);
        TestCommandUtil.assertEquals((String)createRevokePrivilegeCmdExcepted, (String)createRevokePrivilegeCmdResult);
    }

    @Test
    public void testCreateCmdForGrantOrRevokePrivilege3() {
        TAlterSentryRoleGrantPrivilegeRequest grantRequest = this.getGrantPrivilegeRequest();
        TAlterSentryRoleRevokePrivilegeRequest revokeRequest = this.getRevokePrivilegeRequest();
        TSentryPrivilege privilege = this.getPrivilege("select", ServiceConstants.PrivilegeScope.DATABASE.name(), "dbTest", "tableTest", "serverTest", "hdfs://namenode:port/path/to/dir");
        HashSet privileges = Sets.newHashSet();
        privileges.add(privilege);
        grantRequest.setPrivileges((Set)privileges);
        revokeRequest.setPrivileges((Set)privileges);
        String createGrantPrivilegeCmdResult = CommandUtil.createCmdForGrantPrivilege((TAlterSentryRoleGrantPrivilegeRequest)grantRequest);
        String createGrantPrivilegeCmdExcepted = "GRANT SELECT ON DATABASE dbTest TO ROLE testRole";
        String createRevokePrivilegeCmdResult = CommandUtil.createCmdForRevokePrivilege((TAlterSentryRoleRevokePrivilegeRequest)revokeRequest);
        String createRevokePrivilegeCmdExcepted = "REVOKE SELECT ON DATABASE dbTest FROM ROLE testRole";
        TestCommandUtil.assertEquals((String)createGrantPrivilegeCmdExcepted, (String)createGrantPrivilegeCmdResult);
        TestCommandUtil.assertEquals((String)createRevokePrivilegeCmdExcepted, (String)createRevokePrivilegeCmdResult);
    }

    @Test
    public void testCreateCmdForGrantOrRevokePrivilege4() {
        TAlterSentryRoleGrantPrivilegeRequest grantRequest = this.getGrantPrivilegeRequest();
        TAlterSentryRoleRevokePrivilegeRequest revokeRequest = this.getRevokePrivilegeRequest();
        TSentryPrivilege privilege = this.getPrivilege(null, ServiceConstants.PrivilegeScope.DATABASE.name(), "dbTest", "tableTest", "serverTest", "hdfs://namenode:port/path/to/dir");
        HashSet privileges = Sets.newHashSet();
        privileges.add(privilege);
        grantRequest.setPrivileges((Set)privileges);
        revokeRequest.setPrivileges((Set)privileges);
        String createGrantPrivilegeCmdResult = CommandUtil.createCmdForGrantPrivilege((TAlterSentryRoleGrantPrivilegeRequest)grantRequest);
        String createGrantPrivilegeCmdExcepted = "GRANT null ON DATABASE dbTest TO ROLE testRole";
        String createRevokePrivilegeCmdResult = CommandUtil.createCmdForRevokePrivilege((TAlterSentryRoleRevokePrivilegeRequest)revokeRequest);
        String createRevokePrivilegeCmdExcepted = "REVOKE null ON DATABASE dbTest FROM ROLE testRole";
        TestCommandUtil.assertEquals((String)createGrantPrivilegeCmdExcepted, (String)createGrantPrivilegeCmdResult);
        TestCommandUtil.assertEquals((String)createRevokePrivilegeCmdExcepted, (String)createRevokePrivilegeCmdResult);
    }

    @Test
    public void testCreateCmdForGrantOrRevokePrivilege5() {
        TAlterSentryRoleGrantPrivilegeRequest grantRequest = this.getGrantPrivilegeRequest();
        TAlterSentryRoleRevokePrivilegeRequest revokeRequest = this.getRevokePrivilegeRequest();
        TSentryPrivilege privilege = this.getPrivilege("select", ServiceConstants.PrivilegeScope.TABLE.name(), "dbTest", "tableTest", "serverTest", "hdfs://namenode:port/path/to/dir");
        HashSet privileges = Sets.newHashSet();
        privileges.add(privilege);
        grantRequest.setPrivileges((Set)privileges);
        revokeRequest.setPrivileges((Set)privileges);
        String createGrantPrivilegeCmdResult = CommandUtil.createCmdForGrantPrivilege((TAlterSentryRoleGrantPrivilegeRequest)grantRequest);
        String createGrantPrivilegeCmdExcepted = "GRANT SELECT ON TABLE tableTest TO ROLE testRole";
        String createRevokePrivilegeCmdResult = CommandUtil.createCmdForRevokePrivilege((TAlterSentryRoleRevokePrivilegeRequest)revokeRequest);
        String createRevokePrivilegeCmdExcepted = "REVOKE SELECT ON TABLE tableTest FROM ROLE testRole";
        TestCommandUtil.assertEquals((String)createGrantPrivilegeCmdExcepted, (String)createGrantPrivilegeCmdResult);
        TestCommandUtil.assertEquals((String)createRevokePrivilegeCmdExcepted, (String)createRevokePrivilegeCmdResult);
    }

    @Test
    public void testCreateCmdForGrantOrRevokePrivilege6() {
        TAlterSentryRoleGrantPrivilegeRequest grantRequest = this.getGrantPrivilegeRequest();
        TAlterSentryRoleRevokePrivilegeRequest revokeRequest = this.getRevokePrivilegeRequest();
        TSentryPrivilege privilege = this.getPrivilege("select", ServiceConstants.PrivilegeScope.SERVER.name(), "dbTest", "tableTest", "serverTest", "hdfs://namenode:port/path/to/dir");
        HashSet privileges = Sets.newHashSet();
        privileges.add(privilege);
        grantRequest.setPrivileges((Set)privileges);
        revokeRequest.setPrivileges((Set)privileges);
        String createGrantPrivilegeCmdResult = CommandUtil.createCmdForGrantPrivilege((TAlterSentryRoleGrantPrivilegeRequest)grantRequest);
        String createGrantPrivilegeCmdExcepted = "GRANT SELECT ON SERVER serverTest TO ROLE testRole";
        String createRevokePrivilegeCmdResult = CommandUtil.createCmdForRevokePrivilege((TAlterSentryRoleRevokePrivilegeRequest)revokeRequest);
        String createRevokePrivilegeCmdExcepted = "REVOKE SELECT ON SERVER serverTest FROM ROLE testRole";
        TestCommandUtil.assertEquals((String)createGrantPrivilegeCmdExcepted, (String)createGrantPrivilegeCmdResult);
        TestCommandUtil.assertEquals((String)createRevokePrivilegeCmdExcepted, (String)createRevokePrivilegeCmdResult);
    }

    @Test
    public void testCreateCmdForGrantOrRevokePrivilege7() {
        TAlterSentryRoleGrantPrivilegeRequest grantRequest = this.getGrantPrivilegeRequest();
        TAlterSentryRoleRevokePrivilegeRequest revokeRequest = this.getRevokePrivilegeRequest();
        TSentryPrivilege privilege = this.getPrivilege("select", ServiceConstants.PrivilegeScope.URI.name(), "dbTest", "tableTest", "serverTest", "hdfs://namenode:port/path/to/dir");
        HashSet privileges = Sets.newHashSet();
        privileges.add(privilege);
        grantRequest.setPrivileges((Set)privileges);
        revokeRequest.setPrivileges((Set)privileges);
        String createGrantPrivilegeCmdResult = CommandUtil.createCmdForGrantPrivilege((TAlterSentryRoleGrantPrivilegeRequest)grantRequest);
        String createGrantPrivilegeCmdExcepted = "GRANT SELECT ON URI hdfs://namenode:port/path/to/dir TO ROLE testRole";
        String createRevokePrivilegeCmdResult = CommandUtil.createCmdForRevokePrivilege((TAlterSentryRoleRevokePrivilegeRequest)revokeRequest);
        String createRevokePrivilegeCmdExcepted = "REVOKE SELECT ON URI hdfs://namenode:port/path/to/dir FROM ROLE testRole";
        TestCommandUtil.assertEquals((String)createGrantPrivilegeCmdExcepted, (String)createGrantPrivilegeCmdResult);
        TestCommandUtil.assertEquals((String)createRevokePrivilegeCmdExcepted, (String)createRevokePrivilegeCmdResult);
    }

    @Test
    public void testCreateCmdForGrantOrRevokePrivilege8() {
        TAlterSentryRoleGrantPrivilegeRequest grantRequest = this.getGrantPrivilegeRequest();
        TAlterSentryRoleRevokePrivilegeRequest revokeRequest = this.getRevokePrivilegeRequest();
        TSentryPrivilege privilege = this.getPrivilege("select", ServiceConstants.PrivilegeScope.SERVER.name(), "dbTest", "tableTest", "serverTest", "hdfs://namenode:port/path/to/dir");
        privilege.setGrantOption(TSentryGrantOption.TRUE);
        HashSet privileges = Sets.newHashSet();
        privileges.add(privilege);
        grantRequest.setPrivileges((Set)privileges);
        revokeRequest.setPrivileges((Set)privileges);
        String createGrantPrivilegeCmdResult = CommandUtil.createCmdForGrantPrivilege((TAlterSentryRoleGrantPrivilegeRequest)grantRequest);
        String createGrantPrivilegeCmdExcepted = "GRANT SELECT ON SERVER serverTest TO ROLE testRole WITH GRANT OPTION";
        String createRevokePrivilegeCmdResult = CommandUtil.createCmdForRevokePrivilege((TAlterSentryRoleRevokePrivilegeRequest)revokeRequest);
        String createRevokePrivilegeCmdExcepted = "REVOKE SELECT ON SERVER serverTest FROM ROLE testRole WITH GRANT OPTION";
        TestCommandUtil.assertEquals((String)createGrantPrivilegeCmdExcepted, (String)createGrantPrivilegeCmdResult);
        TestCommandUtil.assertEquals((String)createRevokePrivilegeCmdExcepted, (String)createRevokePrivilegeCmdResult);
    }

    private TAlterSentryRoleAddGroupsRequest getRoleAddGroupsRequest() {
        TAlterSentryRoleAddGroupsRequest request = new TAlterSentryRoleAddGroupsRequest();
        request.setRoleName("testRole");
        return request;
    }

    private TAlterSentryRoleDeleteGroupsRequest getRoleDeleteGroupsRequest() {
        TAlterSentryRoleDeleteGroupsRequest request = new TAlterSentryRoleDeleteGroupsRequest();
        request.setRoleName("testRole");
        return request;
    }

    private Set<TSentryGroup> getGroups(int num) {
        LinkedHashSet<TSentryGroup> groups = new LinkedHashSet<TSentryGroup>();
        for (int i = 0; i < num; ++i) {
            TSentryGroup group = new TSentryGroup();
            group.setGroupName("testGroup" + (i + 1));
            groups.add(group);
        }
        return groups;
    }

    private TAlterSentryRoleGrantPrivilegeRequest getGrantPrivilegeRequest() {
        TAlterSentryRoleGrantPrivilegeRequest request = new TAlterSentryRoleGrantPrivilegeRequest();
        request.setRoleName("testRole");
        return request;
    }

    private TAlterSentryRoleRevokePrivilegeRequest getRevokePrivilegeRequest() {
        TAlterSentryRoleRevokePrivilegeRequest request = new TAlterSentryRoleRevokePrivilegeRequest();
        request.setRoleName("testRole");
        return request;
    }

    private TSentryPrivilege getPrivilege(String action, String privilegeScope, String dbName, String tableName, String serverName, String URI2) {
        TSentryPrivilege privilege = new TSentryPrivilege();
        privilege.setAction(action);
        privilege.setPrivilegeScope(privilegeScope);
        privilege.setDbName(dbName);
        privilege.setTableName(tableName);
        privilege.setServerName(serverName);
        privilege.setURI(URI2);
        return privilege;
    }
}

