/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.log.entity;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import junit.framework.Assert;
import org.apache.hadoop.conf.Configuration;
import org.apache.log4j.Logger;
import org.apache.sentry.provider.db.log.entity.AuditMetadataLogEntity;
import org.apache.sentry.provider.db.log.entity.JsonLogEntity;
import org.apache.sentry.provider.db.log.entity.JsonLogEntityFactory;
import org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleAddGroupsRequest;
import org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleAddGroupsResponse;
import org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleDeleteGroupsRequest;
import org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleDeleteGroupsResponse;
import org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleGrantPrivilegeRequest;
import org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleGrantPrivilegeResponse;
import org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleRevokePrivilegeRequest;
import org.apache.sentry.provider.db.service.thrift.TAlterSentryRoleRevokePrivilegeResponse;
import org.apache.sentry.provider.db.service.thrift.TCreateSentryRoleRequest;
import org.apache.sentry.provider.db.service.thrift.TCreateSentryRoleResponse;
import org.apache.sentry.provider.db.service.thrift.TDropSentryRoleRequest;
import org.apache.sentry.provider.db.service.thrift.TDropSentryRoleResponse;
import org.apache.sentry.provider.db.service.thrift.TSentryGroup;
import org.apache.sentry.provider.db.service.thrift.TSentryPrivilege;
import org.apache.sentry.provider.db.service.thrift.ThriftUtil;
import org.apache.sentry.service.thrift.ServiceConstants;
import org.apache.sentry.service.thrift.Status;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestJsonLogEntityFactory {
    private static Configuration conf;
    private Logger sentryLogger = Logger.getRootLogger();
    private static String TEST_IP;
    private static String TEST_IMPERSONATOR;
    private static String TEST_ROLE_NAME;
    private static String TEST_USER_NAME;
    private static String TEST_DATABASE_NAME;
    private static String TEST_TABLE_NAME;
    private static String TEST_GROUP;

    @BeforeClass
    public static void init() {
        conf = new Configuration();
        conf.set("sentry.service.name", "Sentry-Service");
        ThriftUtil.setIpAddress((String)TEST_IP);
        ThriftUtil.setImpersonator((String)TEST_IMPERSONATOR);
    }

    @Test
    public void testCreateRole() {
        TCreateSentryRoleRequest request = new TCreateSentryRoleRequest();
        TCreateSentryRoleResponse response = new TCreateSentryRoleResponse();
        request.setRequestorUserName(TEST_USER_NAME);
        request.setRoleName(TEST_ROLE_NAME);
        response.setStatus(Status.OK());
        AuditMetadataLogEntity amle = (AuditMetadataLogEntity)JsonLogEntityFactory.getInstance().createJsonLogEntity(request, response, conf);
        this.assertCommon(amle, "true", "CREATE_ROLE", "CREATE ROLE testRole", null, null, null, "ROLE");
        this.sentryLogger.debug((Object)amle.toJsonFormatLog());
        response.setStatus(Status.InvalidInput((String)"", null));
        amle = (AuditMetadataLogEntity)JsonLogEntityFactory.getInstance().createJsonLogEntity(request, response, conf);
        this.assertCommon(amle, "false", "CREATE_ROLE", "CREATE ROLE testRole", null, null, null, "ROLE");
        this.sentryLogger.debug((Object)amle.toJsonFormatLog());
    }

    @Test
    public void testDropRole() {
        TDropSentryRoleRequest request = new TDropSentryRoleRequest();
        TDropSentryRoleResponse response = new TDropSentryRoleResponse();
        request.setRequestorUserName(TEST_USER_NAME);
        request.setRoleName(TEST_ROLE_NAME);
        response.setStatus(Status.OK());
        AuditMetadataLogEntity amle = (AuditMetadataLogEntity)JsonLogEntityFactory.getInstance().createJsonLogEntity(request, response, conf);
        this.assertCommon(amle, "true", "DROP_ROLE", "DROP ROLE testRole", null, null, null, "ROLE");
        this.sentryLogger.debug((Object)amle.toJsonFormatLog());
        response.setStatus(Status.InvalidInput((String)"", null));
        amle = (AuditMetadataLogEntity)JsonLogEntityFactory.getInstance().createJsonLogEntity(request, response, conf);
        this.assertCommon(amle, "false", "DROP_ROLE", "DROP ROLE testRole", null, null, null, "ROLE");
        this.sentryLogger.debug((Object)amle.toJsonFormatLog());
    }

    @Test
    public void testGrantRole() {
        JsonLogEntity amle1;
        TAlterSentryRoleGrantPrivilegeRequest request = new TAlterSentryRoleGrantPrivilegeRequest();
        request.setRequestorUserName(TEST_USER_NAME);
        request.setRoleName(TEST_ROLE_NAME);
        TAlterSentryRoleGrantPrivilegeResponse response = new TAlterSentryRoleGrantPrivilegeResponse();
        TSentryPrivilege privilege = this.getPrivilege("*", ServiceConstants.PrivilegeScope.DATABASE.name(), TEST_DATABASE_NAME, null, null, null);
        HashSet privileges = Sets.newHashSet();
        privileges.add(privilege);
        request.setPrivileges((Set)privileges);
        response.setStatus(Status.OK());
        AuditMetadataLogEntity amle = new AuditMetadataLogEntity();
        Set amles = JsonLogEntityFactory.getInstance().createJsonLogEntitys(request, response, conf);
        Assert.assertEquals((int)amles.size(), (int)1);
        Iterator i$ = amles.iterator();
        if (i$.hasNext()) {
            amle1 = (JsonLogEntity)i$.next();
            amle = (AuditMetadataLogEntity)amle1;
        }
        this.assertCommon(amle, "true", "GRANT_PRIVILEGE", "GRANT ALL ON DATABASE testDB TO ROLE testRole", TEST_DATABASE_NAME, null, null, "PRINCIPAL");
        this.sentryLogger.debug((Object)amle.toJsonFormatLog());
        privilege = this.getPrivilege("*", ServiceConstants.PrivilegeScope.TABLE.name(), null, TEST_TABLE_NAME, null, null);
        privileges = Sets.newHashSet();
        privileges.add(privilege);
        request.setPrivileges((Set)privileges);
        response.setStatus(Status.InvalidInput((String)"", null));
        amles = JsonLogEntityFactory.getInstance().createJsonLogEntitys(request, response, conf);
        Assert.assertEquals((int)amles.size(), (int)1);
        i$ = amles.iterator();
        if (i$.hasNext()) {
            amle1 = (JsonLogEntity)i$.next();
            amle = (AuditMetadataLogEntity)amle1;
        }
        this.assertCommon(amle, "false", "GRANT_PRIVILEGE", "GRANT ALL ON TABLE testTable TO ROLE testRole", null, TEST_TABLE_NAME, null, "PRINCIPAL");
        this.sentryLogger.debug((Object)amle.toJsonFormatLog());
    }

    @Test
    public void testRevokeRole() {
        JsonLogEntity amle1;
        TAlterSentryRoleRevokePrivilegeRequest request = new TAlterSentryRoleRevokePrivilegeRequest();
        TAlterSentryRoleRevokePrivilegeResponse response = new TAlterSentryRoleRevokePrivilegeResponse();
        request.setRequestorUserName(TEST_USER_NAME);
        request.setRoleName(TEST_ROLE_NAME);
        TSentryPrivilege privilege = this.getPrivilege("*", ServiceConstants.PrivilegeScope.DATABASE.name(), TEST_DATABASE_NAME, null, null, null);
        HashSet privileges = Sets.newHashSet();
        privileges.add(privilege);
        request.setPrivileges((Set)privileges);
        response.setStatus(Status.OK());
        AuditMetadataLogEntity amle = new AuditMetadataLogEntity();
        Set amles = JsonLogEntityFactory.getInstance().createJsonLogEntitys(request, response, conf);
        Assert.assertEquals((int)amles.size(), (int)1);
        Iterator i$ = amles.iterator();
        if (i$.hasNext()) {
            amle1 = (JsonLogEntity)i$.next();
            amle = (AuditMetadataLogEntity)amle1;
        }
        this.assertCommon(amle, "true", "REVOKE_PRIVILEGE", "REVOKE ALL ON DATABASE testDB FROM ROLE testRole", TEST_DATABASE_NAME, null, null, "PRINCIPAL");
        this.sentryLogger.debug((Object)amle.toJsonFormatLog());
        privilege = this.getPrivilege("*", ServiceConstants.PrivilegeScope.TABLE.name(), null, TEST_TABLE_NAME, null, null);
        privileges = Sets.newHashSet();
        privileges.add(privilege);
        request.setPrivileges((Set)privileges);
        response.setStatus(Status.InvalidInput((String)"", null));
        amles = JsonLogEntityFactory.getInstance().createJsonLogEntitys(request, response, conf);
        Assert.assertEquals((int)amles.size(), (int)1);
        i$ = amles.iterator();
        if (i$.hasNext()) {
            amle1 = (JsonLogEntity)i$.next();
            amle = (AuditMetadataLogEntity)amle1;
        }
        this.assertCommon(amle, "false", "REVOKE_PRIVILEGE", "REVOKE ALL ON TABLE testTable FROM ROLE testRole", null, TEST_TABLE_NAME, null, "PRINCIPAL");
        this.sentryLogger.debug((Object)amle.toJsonFormatLog());
    }

    @Test
    public void testAddRole() {
        TAlterSentryRoleAddGroupsRequest request = new TAlterSentryRoleAddGroupsRequest();
        TAlterSentryRoleAddGroupsResponse response = new TAlterSentryRoleAddGroupsResponse();
        request.setRequestorUserName(TEST_USER_NAME);
        request.setRoleName(TEST_ROLE_NAME);
        request.setGroups(this.getGroups());
        response.setStatus(Status.OK());
        AuditMetadataLogEntity amle = (AuditMetadataLogEntity)JsonLogEntityFactory.getInstance().createJsonLogEntity(request, response, conf);
        this.assertCommon(amle, "true", "ADD_ROLE_TO_GROUP", "GRANT ROLE testRole TO GROUP testGroup", null, null, null, "ROLE");
        this.sentryLogger.debug((Object)amle.toJsonFormatLog());
        response.setStatus(Status.InvalidInput((String)"", null));
        amle = (AuditMetadataLogEntity)JsonLogEntityFactory.getInstance().createJsonLogEntity(request, response, conf);
        this.assertCommon(amle, "false", "ADD_ROLE_TO_GROUP", "GRANT ROLE testRole TO GROUP testGroup", null, null, null, "ROLE");
        this.sentryLogger.debug((Object)amle.toJsonFormatLog());
    }

    @Test
    public void testDeleteRole() {
        TAlterSentryRoleDeleteGroupsRequest request = new TAlterSentryRoleDeleteGroupsRequest();
        TAlterSentryRoleDeleteGroupsResponse response = new TAlterSentryRoleDeleteGroupsResponse();
        request.setRequestorUserName(TEST_USER_NAME);
        request.setRoleName(TEST_ROLE_NAME);
        request.setGroups(this.getGroups());
        response.setStatus(Status.OK());
        AuditMetadataLogEntity amle = (AuditMetadataLogEntity)JsonLogEntityFactory.getInstance().createJsonLogEntity(request, response, conf);
        this.assertCommon(amle, "true", "DELETE_ROLE_FROM_GROUP", "REVOKE ROLE testRole FROM GROUP testGroup", null, null, null, "ROLE");
        this.sentryLogger.debug((Object)amle.toJsonFormatLog());
        response.setStatus(Status.InvalidInput((String)"", null));
        amle = (AuditMetadataLogEntity)JsonLogEntityFactory.getInstance().createJsonLogEntity(request, response, conf);
        this.assertCommon(amle, "false", "DELETE_ROLE_FROM_GROUP", "REVOKE ROLE testRole FROM GROUP testGroup", null, null, null, "ROLE");
        this.sentryLogger.debug((Object)amle.toJsonFormatLog());
    }

    private void assertCommon(AuditMetadataLogEntity amle, String allowedExcepted, String operationExcepted, String operationTextExcepted, String databaseNameExcepted, String tableNameExcepted, String resourcePathExcepted, String objectTypeExcepted) {
        Assert.assertEquals((String)"Sentry-Service", (String)amle.getServiceName());
        Assert.assertEquals((String)TEST_IP, (String)amle.getIpAddress());
        Assert.assertEquals((String)TEST_USER_NAME, (String)amle.getUserName());
        Assert.assertEquals((String)TEST_IMPERSONATOR, (String)amle.getImpersonator());
        Assert.assertEquals((String)allowedExcepted, (String)amle.getAllowed());
        Assert.assertEquals((String)operationExcepted, (String)amle.getOperation());
        Assert.assertEquals((String)operationTextExcepted, (String)amle.getOperationText());
        Assert.assertEquals((String)tableNameExcepted, (String)amle.getTableName());
        Assert.assertEquals((String)databaseNameExcepted, (String)amle.getDatabaseName());
        Assert.assertEquals((String)resourcePathExcepted, (String)amle.getResourcePath());
        Assert.assertEquals((String)objectTypeExcepted, (String)amle.getObjectType());
    }

    private TSentryPrivilege getPrivilege(String action, String privilegeScope, String dbName, String tableName, String serverName, String URI2) {
        TSentryPrivilege privilege = new TSentryPrivilege();
        privilege.setAction(action);
        privilege.setPrivilegeScope(privilegeScope);
        privilege.setDbName(dbName);
        privilege.setTableName(tableName);
        privilege.setServerName(serverName);
        privilege.setURI(URI2);
        return privilege;
    }

    private Set<TSentryGroup> getGroups() {
        LinkedHashSet<TSentryGroup> groups = new LinkedHashSet<TSentryGroup>();
        TSentryGroup group = new TSentryGroup();
        group.setGroupName(TEST_GROUP);
        groups.add(group);
        return groups;
    }

    static {
        TEST_IP = "localhost/127.0.0.1";
        TEST_IMPERSONATOR = "impersonator";
        TEST_ROLE_NAME = "testRole";
        TEST_USER_NAME = "requestUser";
        TEST_DATABASE_NAME = "testDB";
        TEST_TABLE_NAME = "testTable";
        TEST_GROUP = "testGroup";
    }
}

