/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.log.entity;

import junit.framework.TestCase;
import org.apache.sentry.provider.db.log.entity.AuditMetadataLogEntity;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ContainerNode;
import org.junit.Test;

public class TestAuditMetadataLogEntity
extends TestCase {
    @Test
    public void testToJsonFormatLog() throws Throwable {
        AuditMetadataLogEntity amle = new AuditMetadataLogEntity("serviceName", "userName", "impersonator", "ipAddress", "operation", "eventTime", "operationText", "allowed", "databaseName", "tableName", "columnName", "resourcePath", "objectType");
        String jsonAuditLog = amle.toJsonFormatLog();
        ContainerNode rootNode = AuditMetadataLogEntity.parse((String)jsonAuditLog);
        this.assertEntryEquals(rootNode, "serviceName", "serviceName");
        this.assertEntryEquals(rootNode, "userName", "userName");
        this.assertEntryEquals(rootNode, "impersonator", "impersonator");
        this.assertEntryEquals(rootNode, "ipAddress", "ipAddress");
        this.assertEntryEquals(rootNode, "operation", "operation");
        this.assertEntryEquals(rootNode, "eventTime", "eventTime");
        this.assertEntryEquals(rootNode, "operationText", "operationText");
        this.assertEntryEquals(rootNode, "allowed", "allowed");
        this.assertEntryEquals(rootNode, "databaseName", "databaseName");
        this.assertEntryEquals(rootNode, "tableName", "tableName");
        this.assertEntryEquals(rootNode, "column", "columnName");
        this.assertEntryEquals(rootNode, "resourcePath", "resourcePath");
        this.assertEntryEquals(rootNode, "objectType", "objectType");
    }

    void assertEntryEquals(ContainerNode rootNode, String key, String value) {
        JsonNode node = this.assertNodeContains(rootNode, key);
        TestAuditMetadataLogEntity.assertEquals((String)value, (String)node.getTextValue());
    }

    private JsonNode assertNodeContains(ContainerNode rootNode, String key) {
        JsonNode node = rootNode.get(key);
        if (node == null) {
            TestAuditMetadataLogEntity.fail((String)("No entry of name \"" + key + "\" found in " + rootNode.toString()));
        }
        return node;
    }
}

