/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.generic.service.thrift;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.hadoop.conf.Configuration;
import org.apache.sentry.SentryUserException;
import org.apache.sentry.core.common.ActiveRoleSet;
import org.apache.sentry.core.common.Authorizable;
import org.apache.sentry.core.model.search.Collection;
import org.apache.sentry.core.model.search.Field;
import org.apache.sentry.provider.db.generic.service.thrift.SentryGenericServiceClient;
import org.apache.sentry.provider.db.generic.service.thrift.SentryGenericServiceClientFactory;
import org.apache.sentry.provider.db.generic.service.thrift.TAuthorizable;
import org.apache.sentry.provider.db.generic.service.thrift.TSentryGrantOption;
import org.apache.sentry.provider.db.generic.service.thrift.TSentryPrivilege;
import org.apache.sentry.provider.db.generic.service.thrift.TSentryRole;
import org.apache.sentry.service.thrift.SentryServiceIntegrationBase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestSentryGenericServiceIntegration
extends SentryServiceIntegrationBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(SentryServiceIntegrationBase.class);
    private static final String SOLR = "SOLR";
    private SentryGenericServiceClient client;

    @Override
    public void connectToSentryService() throws Exception {
        this.client = kerberos ? Subject.doAs(clientSubject, new PrivilegedExceptionAction<SentryGenericServiceClient>(){

            @Override
            public SentryGenericServiceClient run() throws Exception {
                return SentryGenericServiceClientFactory.create((Configuration)conf);
            }
        }) : SentryGenericServiceClientFactory.create((Configuration)conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @After
    public void after() {
        try {
            this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

                @Override
                public void runTestAsSubject() throws Exception {
                    Set tRoles = TestSentryGenericServiceIntegration.this.client.listAllRoles("admin_user", TestSentryGenericServiceIntegration.SOLR);
                    for (TSentryRole tRole : tRoles) {
                        TestSentryGenericServiceIntegration.this.client.dropRole("admin_user", tRole.getRoleName(), TestSentryGenericServiceIntegration.SOLR);
                    }
                    if (TestSentryGenericServiceIntegration.this.client != null) {
                        TestSentryGenericServiceIntegration.this.client.close();
                    }
                }
            });
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        finally {
            this.policyFilePath.delete();
        }
    }

    @Test
    public void testCreateDropShowRole() throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            @Override
            public void runTestAsSubject() throws Exception {
                String requestorUserName = "admin_user";
                HashSet requestorUserGroupNames = Sets.newHashSet((Object[])new String[]{"admin_group"});
                String roleName = "admin_r";
                TestSentryGenericServiceIntegration.this.setLocalGroupMapping(requestorUserName, requestorUserGroupNames);
                TestSentryGenericServiceIntegration.this.writePolicyFile();
                TestSentryGenericServiceIntegration.this.client.dropRoleIfExists(requestorUserName, roleName, TestSentryGenericServiceIntegration.SOLR);
                TestSentryGenericServiceIntegration.this.client.createRole(requestorUserName, roleName, TestSentryGenericServiceIntegration.SOLR);
                TestSentryGenericServiceIntegration.this.client.addRoleToGroups(requestorUserName, roleName, TestSentryGenericServiceIntegration.SOLR, (Set)Sets.newHashSet((Iterable)requestorUserGroupNames));
                Set roles = TestSentryGenericServiceIntegration.this.client.listUserRoles(requestorUserName, TestSentryGenericServiceIntegration.SOLR);
                junit.framework.Assert.assertEquals((String)"Incorrect number of roles", (int)1, (int)roles.size());
                for (TSentryRole role : roles) {
                    Assert.assertTrue((String)role.getRoleName(), (boolean)role.getRoleName().equalsIgnoreCase(roleName));
                }
                TestSentryGenericServiceIntegration.this.client.dropRole(requestorUserName, roleName, TestSentryGenericServiceIntegration.SOLR);
            }
        });
    }

    @Test
    public void testAddDeleteRoleToGroup() throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            @Override
            public void runTestAsSubject() throws Exception {
                String requestorUserName = "admin_user";
                HashSet requestorUserGroupNames = Sets.newHashSet((Object[])new String[]{"admin_group"});
                String testGroupName = "g1";
                String roleName = "admin_r";
                TestSentryGenericServiceIntegration.this.setLocalGroupMapping(requestorUserName, requestorUserGroupNames);
                TestSentryGenericServiceIntegration.this.setLocalGroupMapping(requestorUserName, Sets.newHashSet((Object[])new String[]{testGroupName}));
                TestSentryGenericServiceIntegration.this.writePolicyFile();
                TestSentryGenericServiceIntegration.this.client.dropRoleIfExists(requestorUserName, roleName, TestSentryGenericServiceIntegration.SOLR);
                TestSentryGenericServiceIntegration.this.client.createRole(requestorUserName, roleName, TestSentryGenericServiceIntegration.SOLR);
                TestSentryGenericServiceIntegration.this.client.addRoleToGroups(requestorUserName, roleName, TestSentryGenericServiceIntegration.SOLR, (Set)Sets.newHashSet((Object[])new String[]{testGroupName}));
                Set roles = TestSentryGenericServiceIntegration.this.client.listUserRoles(requestorUserName, TestSentryGenericServiceIntegration.SOLR);
                junit.framework.Assert.assertEquals((String)"Incorrect number of roles", (int)1, (int)roles.size());
                for (TSentryRole role : roles) {
                    Assert.assertTrue((String)role.getRoleName(), (boolean)role.getRoleName().equalsIgnoreCase(roleName));
                    Assert.assertTrue((role.getGroups().size() == 1 ? 1 : 0) != 0);
                    for (String group : role.getGroups()) {
                        junit.framework.Assert.assertEquals((String)testGroupName, (String)group);
                    }
                }
                TestSentryGenericServiceIntegration.this.client.deleteRoleToGroups(requestorUserName, roleName, TestSentryGenericServiceIntegration.SOLR, (Set)Sets.newHashSet((Object[])new String[]{testGroupName}));
                roles = TestSentryGenericServiceIntegration.this.client.listUserRoles(requestorUserName, TestSentryGenericServiceIntegration.SOLR);
                junit.framework.Assert.assertEquals((String)"Incorrect number of roles", (int)0, (int)roles.size());
                TestSentryGenericServiceIntegration.this.client.dropRole(requestorUserName, roleName, TestSentryGenericServiceIntegration.SOLR);
            }
        });
    }

    @Test
    public void testGranRevokePrivilege() throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            @Override
            public void runTestAsSubject() throws Exception {
                String requestorUserName = "admin_user";
                HashSet requestorUserGroupNames = Sets.newHashSet((Object[])new String[]{"admin_group"});
                TestSentryGenericServiceIntegration.this.setLocalGroupMapping(requestorUserName, requestorUserGroupNames);
                TestSentryGenericServiceIntegration.this.writePolicyFile();
                String roleName1 = "admin_r1";
                String roleName2 = "admin_r2";
                TestSentryGenericServiceIntegration.this.client.dropRoleIfExists(requestorUserName, roleName1, TestSentryGenericServiceIntegration.SOLR);
                TestSentryGenericServiceIntegration.this.client.createRole(requestorUserName, roleName1, TestSentryGenericServiceIntegration.SOLR);
                TestSentryGenericServiceIntegration.this.client.dropRoleIfExists(requestorUserName, roleName2, TestSentryGenericServiceIntegration.SOLR);
                TestSentryGenericServiceIntegration.this.client.createRole(requestorUserName, roleName2, TestSentryGenericServiceIntegration.SOLR);
                TSentryPrivilege queryPrivilege = new TSentryPrivilege(TestSentryGenericServiceIntegration.SOLR, "service1", TestSentryGenericServiceIntegration.this.fromAuthorizable(Arrays.asList(new Collection("c1"), new Field("f1"))), "query");
                TSentryPrivilege updatePrivilege = new TSentryPrivilege(TestSentryGenericServiceIntegration.SOLR, "service1", TestSentryGenericServiceIntegration.this.fromAuthorizable(Arrays.asList(new Collection("c1"), new Field("f1"))), "update");
                TestSentryGenericServiceIntegration.this.client.grantPrivilege(requestorUserName, roleName1, TestSentryGenericServiceIntegration.SOLR, queryPrivilege);
                TestSentryGenericServiceIntegration.this.client.grantPrivilege(requestorUserName, roleName2, TestSentryGenericServiceIntegration.SOLR, updatePrivilege);
                TestSentryGenericServiceIntegration.this.client.revokePrivilege(requestorUserName, roleName1, TestSentryGenericServiceIntegration.SOLR, queryPrivilege);
                TestSentryGenericServiceIntegration.this.client.revokePrivilege(requestorUserName, roleName2, TestSentryGenericServiceIntegration.SOLR, updatePrivilege);
            }
        });
    }

    @Test
    public void testMultipleRolesSamePrivilege() throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            @Override
            public void runTestAsSubject() throws Exception {
                String requestorUserName = "admin_user";
                HashSet requestorUserGroupNames = Sets.newHashSet((Object[])new String[]{"admin_group"});
                TestSentryGenericServiceIntegration.this.setLocalGroupMapping(requestorUserName, requestorUserGroupNames);
                TestSentryGenericServiceIntegration.this.writePolicyFile();
                String roleName1 = "admin_r1";
                String roleName2 = "admin_r2";
                TestSentryGenericServiceIntegration.this.client.dropRoleIfExists(requestorUserName, roleName1, TestSentryGenericServiceIntegration.SOLR);
                TestSentryGenericServiceIntegration.this.client.createRole(requestorUserName, roleName1, TestSentryGenericServiceIntegration.SOLR);
                TestSentryGenericServiceIntegration.this.client.dropRoleIfExists(requestorUserName, roleName2, TestSentryGenericServiceIntegration.SOLR);
                TestSentryGenericServiceIntegration.this.client.createRole(requestorUserName, roleName2, TestSentryGenericServiceIntegration.SOLR);
                TSentryPrivilege queryPrivilege = new TSentryPrivilege(TestSentryGenericServiceIntegration.SOLR, "service1", TestSentryGenericServiceIntegration.this.fromAuthorizable(Arrays.asList(new Collection("c1"), new Field("f1"))), "query");
                TestSentryGenericServiceIntegration.this.client.grantPrivilege(requestorUserName, roleName1, TestSentryGenericServiceIntegration.SOLR, queryPrivilege);
                Set listPrivilegesByRoleName = TestSentryGenericServiceIntegration.this.client.listPrivilegesByRoleName(requestorUserName, roleName1, TestSentryGenericServiceIntegration.SOLR, "service1");
                Assert.assertTrue((String)"Privilege not assigned to role1 !!", (listPrivilegesByRoleName.size() == 1 ? 1 : 0) != 0);
                TestSentryGenericServiceIntegration.this.client.grantPrivilege(requestorUserName, roleName2, TestSentryGenericServiceIntegration.SOLR, queryPrivilege);
                listPrivilegesByRoleName = TestSentryGenericServiceIntegration.this.client.listPrivilegesByRoleName(requestorUserName, roleName2, TestSentryGenericServiceIntegration.SOLR, "service1");
                Assert.assertTrue((String)"Privilege not assigned to role2 !!", (listPrivilegesByRoleName.size() == 1 ? 1 : 0) != 0);
            }
        });
    }

    @Test
    public void testShowRoleGrant() throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            @Override
            public void runTestAsSubject() throws Exception {
                String requestorUserName = "admin_user";
                HashSet requestorUserGroupNames = Sets.newHashSet((Object[])new String[]{"admin_group"});
                String roleName = "admin_r1";
                String groupName = "group1";
                TestSentryGenericServiceIntegration.this.setLocalGroupMapping(requestorUserName, requestorUserGroupNames);
                TestSentryGenericServiceIntegration.this.setLocalGroupMapping(requestorUserName, Sets.newHashSet((Object[])new String[]{groupName}));
                TestSentryGenericServiceIntegration.this.writePolicyFile();
                TestSentryGenericServiceIntegration.this.client.dropRoleIfExists(requestorUserName, roleName, TestSentryGenericServiceIntegration.SOLR);
                TestSentryGenericServiceIntegration.this.client.createRole(requestorUserName, roleName, TestSentryGenericServiceIntegration.SOLR);
                TestSentryGenericServiceIntegration.this.client.addRoleToGroups(requestorUserName, roleName, TestSentryGenericServiceIntegration.SOLR, (Set)Sets.newHashSet((Object[])new String[]{groupName}));
                Set groupRoles = TestSentryGenericServiceIntegration.this.client.listRolesByGroupName(requestorUserName, groupName, TestSentryGenericServiceIntegration.SOLR);
                Assert.assertTrue((groupRoles.size() == 1 ? 1 : 0) != 0);
                for (TSentryRole role : groupRoles) {
                    Assert.assertTrue((String)role.getRoleName(), (boolean)role.getRoleName().equalsIgnoreCase(roleName));
                    Assert.assertTrue((role.getGroups().size() == 1 ? 1 : 0) != 0);
                    for (String group : role.getGroups()) {
                        junit.framework.Assert.assertEquals((String)groupName, (String)group);
                    }
                }
                TestSentryGenericServiceIntegration.this.client.dropRole(requestorUserName, roleName, TestSentryGenericServiceIntegration.SOLR);
            }
        });
    }

    @Test
    public void testShowGrant() throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            @Override
            public void runTestAsSubject() throws Exception {
                String requestorUserName = "admin_user";
                HashSet requestorUserGroupNames = Sets.newHashSet((Object[])new String[]{"admin_group"});
                String roleName = "admin_r1";
                TestSentryGenericServiceIntegration.this.setLocalGroupMapping(requestorUserName, requestorUserGroupNames);
                TestSentryGenericServiceIntegration.this.writePolicyFile();
                TestSentryGenericServiceIntegration.this.client.dropRoleIfExists(requestorUserName, roleName, TestSentryGenericServiceIntegration.SOLR);
                TestSentryGenericServiceIntegration.this.client.createRole(requestorUserName, roleName, TestSentryGenericServiceIntegration.SOLR);
                TSentryPrivilege queryPrivilege = new TSentryPrivilege(TestSentryGenericServiceIntegration.SOLR, "service1", TestSentryGenericServiceIntegration.this.fromAuthorizable(Arrays.asList(new Collection("c1"), new Field("f1"))), "query");
                TSentryPrivilege updatePrivilege = new TSentryPrivilege(TestSentryGenericServiceIntegration.SOLR, "service1", TestSentryGenericServiceIntegration.this.fromAuthorizable(Arrays.asList(new Collection("c1"), new Field("f1"))), "update");
                TestSentryGenericServiceIntegration.this.client.grantPrivilege(requestorUserName, roleName, TestSentryGenericServiceIntegration.SOLR, updatePrivilege);
                TestSentryGenericServiceIntegration.this.client.grantPrivilege(requestorUserName, roleName, TestSentryGenericServiceIntegration.SOLR, queryPrivilege);
                Set privileges = TestSentryGenericServiceIntegration.this.client.listPrivilegesByRoleName(requestorUserName, roleName, TestSentryGenericServiceIntegration.SOLR, "service1");
                Assert.assertTrue((privileges.size() == 2 ? 1 : 0) != 0);
                TestSentryGenericServiceIntegration.this.client.revokePrivilege(requestorUserName, roleName, TestSentryGenericServiceIntegration.SOLR, updatePrivilege);
                privileges = TestSentryGenericServiceIntegration.this.client.listPrivilegesByRoleName(requestorUserName, roleName, TestSentryGenericServiceIntegration.SOLR, "service1");
                Assert.assertTrue((privileges.size() == 1 ? 1 : 0) != 0);
            }
        });
    }

    @Test
    public void testSameGrantTwice() throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            @Override
            public void runTestAsSubject() throws Exception {
                String requestorUserName = "admin_user";
                HashSet requestorUserGroupNames = Sets.newHashSet((Object[])new String[]{"admin_group"});
                TestSentryGenericServiceIntegration.this.setLocalGroupMapping(requestorUserName, requestorUserGroupNames);
                TestSentryGenericServiceIntegration.this.writePolicyFile();
                String roleName = "admin_r1";
                TestSentryGenericServiceIntegration.this.client.createRole(requestorUserName, roleName, TestSentryGenericServiceIntegration.SOLR);
                TSentryPrivilege queryPrivilege = new TSentryPrivilege(TestSentryGenericServiceIntegration.SOLR, "service1", TestSentryGenericServiceIntegration.this.fromAuthorizable(Arrays.asList(new Collection("c1"), new Field("f1"))), "query");
                TestSentryGenericServiceIntegration.this.client.grantPrivilege(requestorUserName, roleName, TestSentryGenericServiceIntegration.SOLR, queryPrivilege);
                junit.framework.Assert.assertEquals((int)1, (int)TestSentryGenericServiceIntegration.this.client.listPrivilegesByRoleName(requestorUserName, roleName, TestSentryGenericServiceIntegration.SOLR, "service1").size());
            }
        });
    }

    @Test
    public void testGrantRevokeWithGrantOption() throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            @Override
            public void runTestAsSubject() throws Exception {
                String adminUser = "admin_user";
                HashSet adminGroup = Sets.newHashSet((Object[])new String[]{"admin_group"});
                String grantOptionUser = "user1";
                HashSet grantOptionGroup = Sets.newHashSet((Object[])new String[]{"group1"});
                String noGrantOptionUser = "user2";
                HashSet noGrantOptionGroup = Sets.newHashSet((Object[])new String[]{"group2"});
                TestSentryGenericServiceIntegration.this.setLocalGroupMapping(adminUser, adminGroup);
                TestSentryGenericServiceIntegration.this.setLocalGroupMapping(grantOptionUser, grantOptionGroup);
                TestSentryGenericServiceIntegration.this.setLocalGroupMapping(noGrantOptionUser, noGrantOptionGroup);
                TestSentryGenericServiceIntegration.this.writePolicyFile();
                String grantRole = "grant_r";
                String noGrantRole = "no_grant_r";
                String testRole = "test_role";
                TestSentryGenericServiceIntegration.this.client.createRole(adminUser, grantRole, TestSentryGenericServiceIntegration.SOLR);
                TestSentryGenericServiceIntegration.this.client.createRole(adminUser, noGrantRole, TestSentryGenericServiceIntegration.SOLR);
                TestSentryGenericServiceIntegration.this.client.createRole(adminUser, testRole, TestSentryGenericServiceIntegration.SOLR);
                TSentryPrivilege grantPrivilege = new TSentryPrivilege(TestSentryGenericServiceIntegration.SOLR, "service1", TestSentryGenericServiceIntegration.this.fromAuthorizable(Arrays.asList(new Collection("c1"))), "query");
                grantPrivilege.setGrantOption(TSentryGrantOption.TRUE);
                TSentryPrivilege noGrantPrivilege = new TSentryPrivilege(TestSentryGenericServiceIntegration.SOLR, "service1", TestSentryGenericServiceIntegration.this.fromAuthorizable(Arrays.asList(new Collection("c1"))), "query");
                noGrantPrivilege.setGrantOption(TSentryGrantOption.FALSE);
                TSentryPrivilege testPrivilege = new TSentryPrivilege(TestSentryGenericServiceIntegration.SOLR, "service1", TestSentryGenericServiceIntegration.this.fromAuthorizable(Arrays.asList(new Collection("c1"), new Field("f1"))), "query");
                testPrivilege.setGrantOption(TSentryGrantOption.FALSE);
                TestSentryGenericServiceIntegration.this.client.grantPrivilege(adminUser, grantRole, TestSentryGenericServiceIntegration.SOLR, grantPrivilege);
                TestSentryGenericServiceIntegration.this.client.grantPrivilege(adminUser, noGrantRole, TestSentryGenericServiceIntegration.SOLR, noGrantPrivilege);
                TestSentryGenericServiceIntegration.this.client.addRoleToGroups(adminUser, grantRole, TestSentryGenericServiceIntegration.SOLR, (Set)grantOptionGroup);
                TestSentryGenericServiceIntegration.this.client.addRoleToGroups(adminUser, noGrantRole, TestSentryGenericServiceIntegration.SOLR, (Set)noGrantOptionGroup);
                try {
                    TestSentryGenericServiceIntegration.this.client.grantPrivilege(grantOptionUser, testRole, TestSentryGenericServiceIntegration.SOLR, testPrivilege);
                }
                catch (SentryUserException e) {
                    Assert.fail((String)"grantOptionUser failed grant privilege to user");
                }
                try {
                    TestSentryGenericServiceIntegration.this.client.grantPrivilege(noGrantOptionUser, testRole, TestSentryGenericServiceIntegration.SOLR, testPrivilege);
                    Assert.fail((String)"noGrantOptionUser can't grant privilege to user");
                }
                catch (SentryUserException e) {
                    // empty catch block
                }
                try {
                    TestSentryGenericServiceIntegration.this.client.revokePrivilege(grantOptionUser, testRole, TestSentryGenericServiceIntegration.SOLR, testPrivilege);
                }
                catch (SentryUserException e) {
                    Assert.fail((String)"grantOptionUser failed revoke privilege to user");
                }
                try {
                    TestSentryGenericServiceIntegration.this.client.revokePrivilege(noGrantOptionUser, testRole, TestSentryGenericServiceIntegration.SOLR, testPrivilege);
                    Assert.fail((String)"noGrantOptionUser can't revoke privilege to user");
                }
                catch (SentryUserException e) {
                    // empty catch block
                }
            }
        });
    }

    @Test
    public void testGetPrivilegeByHierarchy() throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            @Override
            public void runTestAsSubject() throws Exception {
                String adminUser = "admin_user";
                HashSet adminGroup = Sets.newHashSet((Object[])new String[]{"admin_group"});
                String testRole = "role1";
                HashSet testGroup = Sets.newHashSet((Object[])new String[]{"group1"});
                String testUser = "user1";
                TestSentryGenericServiceIntegration.this.setLocalGroupMapping(adminUser, adminGroup);
                TestSentryGenericServiceIntegration.this.setLocalGroupMapping(testUser, testGroup);
                TestSentryGenericServiceIntegration.this.writePolicyFile();
                TestSentryGenericServiceIntegration.this.client.createRole(adminUser, testRole, TestSentryGenericServiceIntegration.SOLR);
                TestSentryGenericServiceIntegration.this.client.addRoleToGroups(adminUser, testRole, TestSentryGenericServiceIntegration.SOLR, (Set)testGroup);
                TSentryPrivilege queryPrivilege = new TSentryPrivilege(TestSentryGenericServiceIntegration.SOLR, "service1", TestSentryGenericServiceIntegration.this.fromAuthorizable(Arrays.asList(new Collection("c1"), new Field("f1"))), "query");
                TSentryPrivilege updatePrivilege = new TSentryPrivilege(TestSentryGenericServiceIntegration.SOLR, "service1", TestSentryGenericServiceIntegration.this.fromAuthorizable(Arrays.asList(new Collection("c2"), new Field("f2"))), "update");
                TestSentryGenericServiceIntegration.this.client.grantPrivilege(adminUser, testRole, TestSentryGenericServiceIntegration.SOLR, queryPrivilege);
                TestSentryGenericServiceIntegration.this.client.grantPrivilege(adminUser, testRole, TestSentryGenericServiceIntegration.SOLR, updatePrivilege);
                junit.framework.Assert.assertEquals((int)2, (int)TestSentryGenericServiceIntegration.this.client.listPrivilegesByRoleName(testUser, testRole, TestSentryGenericServiceIntegration.SOLR, "service1").size());
                junit.framework.Assert.assertEquals((int)1, (int)TestSentryGenericServiceIntegration.this.client.listPrivilegesByRoleName(testUser, testRole, TestSentryGenericServiceIntegration.SOLR, "service1", Arrays.asList(new Collection("c1"))).size());
                junit.framework.Assert.assertEquals((int)1, (int)TestSentryGenericServiceIntegration.this.client.listPrivilegesByRoleName(testUser, testRole, TestSentryGenericServiceIntegration.SOLR, "service1", Arrays.asList(new Collection("c2"))).size());
                junit.framework.Assert.assertEquals((int)1, (int)TestSentryGenericServiceIntegration.this.client.listPrivilegesByRoleName(testUser, testRole, TestSentryGenericServiceIntegration.SOLR, "service1", Arrays.asList(new Collection("c1"), new Field("f1"))).size());
                junit.framework.Assert.assertEquals((int)1, (int)TestSentryGenericServiceIntegration.this.client.listPrivilegesByRoleName(testUser, testRole, TestSentryGenericServiceIntegration.SOLR, "service1", Arrays.asList(new Collection("c2"), new Field("f2"))).size());
                ActiveRoleSet roleSet = ActiveRoleSet.ALL;
                junit.framework.Assert.assertEquals((int)1, (int)TestSentryGenericServiceIntegration.this.client.listPrivilegesForProvider(TestSentryGenericServiceIntegration.SOLR, "service1", roleSet, (Set)testGroup, Arrays.asList(new Collection("c1"))).size());
                junit.framework.Assert.assertEquals((int)1, (int)TestSentryGenericServiceIntegration.this.client.listPrivilegesForProvider(TestSentryGenericServiceIntegration.SOLR, "service1", roleSet, (Set)testGroup, Arrays.asList(new Collection("c2"))).size());
                junit.framework.Assert.assertEquals((int)1, (int)TestSentryGenericServiceIntegration.this.client.listPrivilegesForProvider(TestSentryGenericServiceIntegration.SOLR, "service1", roleSet, (Set)testGroup, Arrays.asList(new Collection("c1"), new Field("f1"))).size());
                junit.framework.Assert.assertEquals((int)1, (int)TestSentryGenericServiceIntegration.this.client.listPrivilegesForProvider(TestSentryGenericServiceIntegration.SOLR, "service1", roleSet, (Set)testGroup, Arrays.asList(new Collection("c2"), new Field("f2"))).size());
            }
        });
    }

    @Test
    public void testDropAndRenamePrivilege() throws Exception {
        this.runTestAsSubject(new SentryServiceIntegrationBase.TestOperation(){

            @Override
            public void runTestAsSubject() throws Exception {
                String requestorUserName = "admin_user";
                HashSet requestorUserGroupNames = Sets.newHashSet((Object[])new String[]{"admin_group"});
                TestSentryGenericServiceIntegration.this.setLocalGroupMapping(requestorUserName, requestorUserGroupNames);
                TestSentryGenericServiceIntegration.this.writePolicyFile();
                String roleName = "admin_r1";
                TestSentryGenericServiceIntegration.this.client.createRole(requestorUserName, roleName, TestSentryGenericServiceIntegration.SOLR);
                TSentryPrivilege queryPrivilege = new TSentryPrivilege(TestSentryGenericServiceIntegration.SOLR, "service1", TestSentryGenericServiceIntegration.this.fromAuthorizable(Arrays.asList(new Collection("c1"), new Field("f1"))), "query");
                TestSentryGenericServiceIntegration.this.client.grantPrivilege(requestorUserName, roleName, TestSentryGenericServiceIntegration.SOLR, queryPrivilege);
                junit.framework.Assert.assertEquals((int)1, (int)TestSentryGenericServiceIntegration.this.client.listPrivilegesByRoleName(requestorUserName, roleName, TestSentryGenericServiceIntegration.SOLR, "service1", Arrays.asList(new Collection("c1"), new Field("f1"))).size());
                junit.framework.Assert.assertEquals((int)0, (int)TestSentryGenericServiceIntegration.this.client.listPrivilegesByRoleName(requestorUserName, roleName, TestSentryGenericServiceIntegration.SOLR, "service1", Arrays.asList(new Collection("c2"), new Field("f2"))).size());
                TestSentryGenericServiceIntegration.this.client.renamePrivilege(requestorUserName, TestSentryGenericServiceIntegration.SOLR, "service1", Arrays.asList(new Collection("c1"), new Field("f1")), Arrays.asList(new Collection("c2"), new Field("f2")));
                junit.framework.Assert.assertEquals((int)0, (int)TestSentryGenericServiceIntegration.this.client.listPrivilegesByRoleName(requestorUserName, roleName, TestSentryGenericServiceIntegration.SOLR, "service1", Arrays.asList(new Collection("c1"), new Field("f1"))).size());
                junit.framework.Assert.assertEquals((int)1, (int)TestSentryGenericServiceIntegration.this.client.listPrivilegesByRoleName(requestorUserName, roleName, TestSentryGenericServiceIntegration.SOLR, "service1", Arrays.asList(new Collection("c2"), new Field("f2"))).size());
                TSentryPrivilege dropPrivilege = new TSentryPrivilege(TestSentryGenericServiceIntegration.SOLR, "service1", TestSentryGenericServiceIntegration.this.fromAuthorizable(Arrays.asList(new Collection("c2"), new Field("f2"))), "query");
                TestSentryGenericServiceIntegration.this.client.dropPrivilege(requestorUserName, TestSentryGenericServiceIntegration.SOLR, dropPrivilege);
                junit.framework.Assert.assertEquals((int)0, (int)TestSentryGenericServiceIntegration.this.client.listPrivilegesByRoleName(requestorUserName, roleName, TestSentryGenericServiceIntegration.SOLR, "service1", Arrays.asList(new Collection("c2"), new Field("f2"))).size());
            }
        });
    }

    private List<TAuthorizable> fromAuthorizable(List<? extends Authorizable> authorizables) {
        ArrayList tAuthorizables = Lists.newArrayList();
        for (Authorizable authorizable : authorizables) {
            tAuthorizables.add(new TAuthorizable(authorizable.getTypeName(), authorizable.getName()));
        }
        return tAuthorizables;
    }
}

