/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.generic.service.thrift;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import java.util.UUID;
import junit.framework.Assert;
import org.apache.hadoop.conf.Configuration;
import org.apache.sentry.core.common.Authorizable;
import org.apache.sentry.core.model.search.Collection;
import org.apache.sentry.core.model.search.Field;
import org.apache.sentry.provider.common.GroupMappingService;
import org.apache.sentry.provider.db.SentryAlreadyExistsException;
import org.apache.sentry.provider.db.SentryGrantDeniedException;
import org.apache.sentry.provider.db.SentryInvalidInputException;
import org.apache.sentry.provider.db.SentryNoSuchObjectException;
import org.apache.sentry.provider.db.generic.service.persistent.PrivilegeObject;
import org.apache.sentry.provider.db.generic.service.persistent.SentryStoreLayer;
import org.apache.sentry.provider.db.generic.service.thrift.SentryGenericPolicyProcessor;
import org.apache.sentry.provider.db.generic.service.thrift.TAlterSentryRoleAddGroupsRequest;
import org.apache.sentry.provider.db.generic.service.thrift.TAlterSentryRoleDeleteGroupsRequest;
import org.apache.sentry.provider.db.generic.service.thrift.TAlterSentryRoleGrantPrivilegeRequest;
import org.apache.sentry.provider.db.generic.service.thrift.TAlterSentryRoleRevokePrivilegeRequest;
import org.apache.sentry.provider.db.generic.service.thrift.TCreateSentryRoleRequest;
import org.apache.sentry.provider.db.generic.service.thrift.TDropPrivilegesRequest;
import org.apache.sentry.provider.db.generic.service.thrift.TDropSentryRoleRequest;
import org.apache.sentry.provider.db.generic.service.thrift.TListSentryPrivilegesForProviderRequest;
import org.apache.sentry.provider.db.generic.service.thrift.TListSentryPrivilegesForProviderResponse;
import org.apache.sentry.provider.db.generic.service.thrift.TListSentryPrivilegesRequest;
import org.apache.sentry.provider.db.generic.service.thrift.TListSentryPrivilegesResponse;
import org.apache.sentry.provider.db.generic.service.thrift.TListSentryRolesRequest;
import org.apache.sentry.provider.db.generic.service.thrift.TListSentryRolesResponse;
import org.apache.sentry.provider.db.generic.service.thrift.TRenamePrivilegesRequest;
import org.apache.sentry.provider.db.generic.service.thrift.TSentryActiveRoleSet;
import org.apache.sentry.provider.db.generic.service.thrift.TSentryGrantOption;
import org.apache.sentry.provider.db.generic.service.thrift.TSentryPrivilege;
import org.apache.sentry.provider.db.service.persistent.CommitContext;
import org.apache.sentry.provider.db.service.thrift.SentryConfigurationException;
import org.apache.sentry.service.thrift.Status;
import org.apache.sentry.service.thrift.TSentryResponseStatus;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class TestSentryGenericPolicyProcessor {
    private static final String ADMIN_GROUP = "admin_group";
    private static final String ADMIN_USER = "admin_user";
    private static final UUID SERVER_UUID = UUID.randomUUID();
    private static final long SEQ_ID = 10000L;
    private SentryStoreLayer mockStore = (SentryStoreLayer)Mockito.mock(SentryStoreLayer.class);
    private SentryGenericPolicyProcessor processor;

    @Before
    public void setup() throws Exception {
        Configuration conf = new Configuration();
        conf.set("sentry.service.admin.group", ADMIN_GROUP);
        conf.set("sentry.store.group.mapping", MockGroupMapping.class.getName());
        this.processor = new SentryGenericPolicyProcessor(conf, this.mockStore);
    }

    @Test
    public void testNotAdminOperation() throws Exception {
        String requestUser = "not_admin_user";
        Status validateStatus = Status.ACCESS_DENIED;
        this.testOperation(requestUser, validateStatus);
    }

    private void testOperation(String requestUser, Status validateStatus) throws Exception {
        TCreateSentryRoleRequest createrequest = new TCreateSentryRoleRequest();
        createrequest.setRequestorUserName(requestUser);
        createrequest.setRoleName("r1");
        Assert.assertEquals((Object)validateStatus, (Object)this.fromTSentryStatus(this.processor.create_sentry_role(createrequest).getStatus()));
        TDropSentryRoleRequest dropRequest = new TDropSentryRoleRequest();
        dropRequest.setRequestorUserName(requestUser);
        dropRequest.setRoleName("r1");
        Assert.assertEquals((Object)validateStatus, (Object)this.fromTSentryStatus(this.processor.drop_sentry_role(dropRequest).getStatus()));
        TAlterSentryRoleAddGroupsRequest addRequest = new TAlterSentryRoleAddGroupsRequest();
        addRequest.setRequestorUserName(requestUser);
        addRequest.setRoleName("r1");
        addRequest.setGroups((Set)Sets.newHashSet((Object[])new String[]{"g1"}));
        Assert.assertEquals((Object)validateStatus, (Object)this.fromTSentryStatus(this.processor.alter_sentry_role_add_groups(addRequest).getStatus()));
        TAlterSentryRoleDeleteGroupsRequest delRequest = new TAlterSentryRoleDeleteGroupsRequest();
        delRequest.setRequestorUserName(requestUser);
        delRequest.setRoleName("r1");
        delRequest.setGroups((Set)Sets.newHashSet((Object[])new String[]{"g1"}));
        Assert.assertEquals((Object)validateStatus, (Object)this.fromTSentryStatus(this.processor.alter_sentry_role_delete_groups(delRequest).getStatus()));
        TDropPrivilegesRequest dropPrivRequest = new TDropPrivilegesRequest();
        dropPrivRequest.setRequestorUserName(requestUser);
        dropPrivRequest.setPrivilege(new TSentryPrivilege("test", "test", new ArrayList(), "test"));
        Assert.assertEquals((Object)validateStatus, (Object)this.fromTSentryStatus(this.processor.drop_sentry_privilege(dropPrivRequest).getStatus()));
        TRenamePrivilegesRequest renameRequest = new TRenamePrivilegesRequest();
        renameRequest.setRequestorUserName(requestUser);
        Assert.assertEquals((Object)validateStatus, (Object)this.fromTSentryStatus(this.processor.rename_sentry_privilege(renameRequest).getStatus()));
    }

    private Status fromTSentryStatus(TSentryResponseStatus status) {
        return Status.fromCode((int)status.getValue());
    }

    @Test
    public void testAdminOperation() throws Exception {
        Mockito.when((Object)this.mockStore.createRole(Matchers.anyString(), Matchers.anyString(), Matchers.anyString())).thenReturn((Object)new CommitContext(SERVER_UUID, 10000L));
        Mockito.when((Object)this.mockStore.dropRole(Matchers.anyString(), Matchers.anyString(), Matchers.anyString())).thenReturn((Object)new CommitContext(SERVER_UUID, 10001L));
        Mockito.when((Object)this.mockStore.alterRoleAddGroups(Matchers.anyString(), Matchers.anyString(), Matchers.anySetOf(String.class), Matchers.anyString())).thenReturn((Object)new CommitContext(SERVER_UUID, 10002L));
        Mockito.when((Object)this.mockStore.alterRoleDeleteGroups(Matchers.anyString(), Matchers.anyString(), Matchers.anySetOf(String.class), Matchers.anyString())).thenReturn((Object)new CommitContext(SERVER_UUID, 10003L));
        Mockito.when((Object)this.mockStore.dropPrivilege(Matchers.anyString(), (PrivilegeObject)Matchers.any(PrivilegeObject.class), Matchers.anyString())).thenReturn((Object)new CommitContext(SERVER_UUID, 10004L));
        Mockito.when((Object)this.mockStore.renamePrivilege(Matchers.anyString(), Matchers.anyString(), Matchers.anyListOf(Authorizable.class), Matchers.anyListOf(Authorizable.class), Matchers.anyString())).thenReturn((Object)new CommitContext(SERVER_UUID, 10005L));
        this.testOperation(ADMIN_USER, Status.OK);
    }

    @Test
    public void testGrantAndRevokePrivilege() throws Exception {
        Mockito.when((Object)this.mockStore.alterRoleGrantPrivilege(Matchers.anyString(), Matchers.anyString(), (PrivilegeObject)Matchers.any(PrivilegeObject.class), Matchers.anyString())).thenReturn((Object)new CommitContext(SERVER_UUID, 10006L));
        Mockito.when((Object)this.mockStore.alterRoleRevokePrivilege(Matchers.anyString(), Matchers.anyString(), (PrivilegeObject)Matchers.any(PrivilegeObject.class), Matchers.anyString())).thenReturn((Object)new CommitContext(SERVER_UUID, 10007L));
        this.setup();
        TSentryPrivilege tprivilege = new TSentryPrivilege("test", "test", new ArrayList(), "test");
        tprivilege.setGrantOption(TSentryGrantOption.UNSET);
        TAlterSentryRoleGrantPrivilegeRequest grantRequest = new TAlterSentryRoleGrantPrivilegeRequest();
        grantRequest.setRequestorUserName(ADMIN_USER);
        grantRequest.setRoleName("r1");
        grantRequest.setPrivilege(tprivilege);
        Assert.assertEquals((Object)Status.OK, (Object)this.fromTSentryStatus(this.processor.alter_sentry_role_grant_privilege(grantRequest).getStatus()));
        TAlterSentryRoleRevokePrivilegeRequest revokeRequest = new TAlterSentryRoleRevokePrivilegeRequest();
        revokeRequest.setRequestorUserName(ADMIN_USER);
        revokeRequest.setRoleName("r1");
        revokeRequest.setPrivilege(tprivilege);
        Assert.assertEquals((Object)Status.OK, (Object)this.fromTSentryStatus(this.processor.alter_sentry_role_revoke_privilege(revokeRequest).getStatus()));
    }

    @Test
    public void testOperationWithException() throws Exception {
        Mockito.when((Object)this.mockStore.createRole(Matchers.anyString(), Matchers.anyString(), Matchers.anyString())).thenThrow(new Throwable[]{new SentryAlreadyExistsException("role already exists")});
        Mockito.when((Object)this.mockStore.dropRole(Matchers.anyString(), Matchers.anyString(), Matchers.anyString())).thenThrow(new Throwable[]{new SentryNoSuchObjectException("role isn't exist")});
        Mockito.when((Object)this.mockStore.alterRoleAddGroups(Matchers.anyString(), Matchers.anyString(), Matchers.anySetOf(String.class), Matchers.anyString())).thenThrow(new Throwable[]{new SentryNoSuchObjectException("role isn't exist")});
        Mockito.when((Object)this.mockStore.alterRoleDeleteGroups(Matchers.anyString(), Matchers.anyString(), Matchers.anySetOf(String.class), Matchers.anyString())).thenThrow(new Throwable[]{new SentryNoSuchObjectException("role isn't exist")});
        Mockito.when((Object)this.mockStore.alterRoleGrantPrivilege(Matchers.anyString(), Matchers.anyString(), (PrivilegeObject)Matchers.any(PrivilegeObject.class), Matchers.anyString())).thenThrow(new Throwable[]{new SentryGrantDeniedException("has no grant")});
        Mockito.when((Object)this.mockStore.alterRoleRevokePrivilege(Matchers.anyString(), Matchers.anyString(), (PrivilegeObject)Matchers.any(PrivilegeObject.class), Matchers.anyString())).thenThrow(new Throwable[]{new SentryGrantDeniedException("has no grant")});
        Mockito.when((Object)this.mockStore.dropPrivilege(Matchers.anyString(), (PrivilegeObject)Matchers.any(PrivilegeObject.class), Matchers.anyString())).thenThrow(new Throwable[]{new SentryInvalidInputException("nvalid input privilege object")});
        Mockito.when((Object)this.mockStore.renamePrivilege(Matchers.anyString(), Matchers.anyString(), Matchers.anyListOf(Authorizable.class), Matchers.anyListOf(Authorizable.class), Matchers.anyString())).thenThrow(new Throwable[]{new RuntimeException("Unknown error")});
        this.setup();
        TCreateSentryRoleRequest createrequest = new TCreateSentryRoleRequest();
        createrequest.setRequestorUserName(ADMIN_USER);
        createrequest.setRoleName("r1");
        Assert.assertEquals((Object)Status.ALREADY_EXISTS, (Object)this.fromTSentryStatus(this.processor.create_sentry_role(createrequest).getStatus()));
        TDropSentryRoleRequest dropRequest = new TDropSentryRoleRequest();
        dropRequest.setRequestorUserName(ADMIN_USER);
        dropRequest.setRoleName("r1");
        Assert.assertEquals((Object)Status.NO_SUCH_OBJECT, (Object)this.fromTSentryStatus(this.processor.drop_sentry_role(dropRequest).getStatus()));
        TAlterSentryRoleAddGroupsRequest addRequest = new TAlterSentryRoleAddGroupsRequest();
        addRequest.setRequestorUserName(ADMIN_USER);
        addRequest.setRoleName("r1");
        addRequest.setGroups((Set)Sets.newHashSet((Object[])new String[]{"g1"}));
        Assert.assertEquals((Object)Status.NO_SUCH_OBJECT, (Object)this.fromTSentryStatus(this.processor.alter_sentry_role_add_groups(addRequest).getStatus()));
        TAlterSentryRoleDeleteGroupsRequest delRequest = new TAlterSentryRoleDeleteGroupsRequest();
        delRequest.setRequestorUserName(ADMIN_USER);
        delRequest.setRoleName("r1");
        delRequest.setGroups((Set)Sets.newHashSet((Object[])new String[]{"g1"}));
        Assert.assertEquals((Object)Status.NO_SUCH_OBJECT, (Object)this.fromTSentryStatus(this.processor.alter_sentry_role_delete_groups(delRequest).getStatus()));
        TDropPrivilegesRequest dropPrivRequest = new TDropPrivilegesRequest();
        dropPrivRequest.setRequestorUserName(ADMIN_USER);
        dropPrivRequest.setPrivilege(new TSentryPrivilege("test", "test", new ArrayList(), "test"));
        Assert.assertEquals((Object)Status.INVALID_INPUT, (Object)this.fromTSentryStatus(this.processor.drop_sentry_privilege(dropPrivRequest).getStatus()));
        TRenamePrivilegesRequest renameRequest = new TRenamePrivilegesRequest();
        renameRequest.setRequestorUserName(ADMIN_USER);
        Assert.assertEquals((Object)Status.RUNTIME_ERROR, (Object)this.fromTSentryStatus(this.processor.rename_sentry_privilege(renameRequest).getStatus()));
        TSentryPrivilege tprivilege = new TSentryPrivilege("test", "test", new ArrayList(), "test");
        tprivilege.setGrantOption(TSentryGrantOption.UNSET);
        TAlterSentryRoleGrantPrivilegeRequest grantRequest = new TAlterSentryRoleGrantPrivilegeRequest();
        grantRequest.setRequestorUserName(ADMIN_USER);
        grantRequest.setRoleName("r1");
        grantRequest.setPrivilege(tprivilege);
        Assert.assertEquals((Object)Status.ACCESS_DENIED, (Object)this.fromTSentryStatus(this.processor.alter_sentry_role_grant_privilege(grantRequest).getStatus()));
        TAlterSentryRoleRevokePrivilegeRequest revokeRequest = new TAlterSentryRoleRevokePrivilegeRequest();
        revokeRequest.setRequestorUserName(ADMIN_USER);
        revokeRequest.setRoleName("r1");
        revokeRequest.setPrivilege(tprivilege);
        Assert.assertEquals((Object)Status.ACCESS_DENIED, (Object)this.fromTSentryStatus(this.processor.alter_sentry_role_revoke_privilege(revokeRequest).getStatus()));
    }

    @Test
    public void testGetRolesAndPrivileges() throws Exception {
        String roleName = "r1";
        String groupName = "g1";
        PrivilegeObject queryPrivilege = new PrivilegeObject.Builder().setComponent("SOLR").setAction("query").setService("service1").setAuthorizables(Arrays.asList(new Collection("c1"), new Field("f1"))).build();
        PrivilegeObject updatePrivilege = new PrivilegeObject.Builder(queryPrivilege).setAction("update").build();
        Mockito.when((Object)this.mockStore.getRolesByGroups(Matchers.anyString(), Matchers.anySetOf(String.class))).thenReturn((Object)Sets.newHashSet((Object[])new String[]{roleName}));
        Mockito.when((Object)this.mockStore.getPrivilegesByProvider(Matchers.anyString(), Matchers.anyString(), Matchers.anySetOf(String.class), Matchers.anySetOf(String.class), Matchers.anyListOf(Authorizable.class))).thenReturn((Object)Sets.newHashSet((Object[])new PrivilegeObject[]{queryPrivilege, updatePrivilege}));
        Mockito.when((Object)this.mockStore.getGroupsByRoles(Matchers.anyString(), Matchers.anySetOf(String.class))).thenReturn((Object)Sets.newHashSet((Object[])new String[]{groupName}));
        TListSentryPrivilegesRequest request1 = new TListSentryPrivilegesRequest();
        request1.setRoleName(roleName);
        request1.setRequestorUserName(ADMIN_USER);
        TListSentryPrivilegesResponse response1 = this.processor.list_sentry_privileges_by_role(request1);
        Assert.assertEquals((Object)Status.OK, (Object)this.fromTSentryStatus(response1.getStatus()));
        Assert.assertEquals((int)2, (int)response1.getPrivileges().size());
        TListSentryRolesRequest request2 = new TListSentryRolesRequest();
        request2.setRequestorUserName(ADMIN_USER);
        request2.setGroupName(groupName);
        TListSentryRolesResponse response2 = this.processor.list_sentry_roles_by_group(request2);
        Assert.assertEquals((Object)Status.OK, (Object)this.fromTSentryStatus(response2.getStatus()));
        Assert.assertEquals((int)1, (int)response2.getRoles().size());
        TListSentryPrivilegesForProviderRequest request3 = new TListSentryPrivilegesForProviderRequest();
        request3.setGroups((Set)Sets.newHashSet((Object[])new String[]{groupName}));
        request3.setRoleSet(new TSentryActiveRoleSet(true, null));
        TListSentryPrivilegesForProviderResponse response3 = this.processor.list_sentry_privileges_for_provider(request3);
        Assert.assertEquals((Object)Status.OK, (Object)this.fromTSentryStatus(response3.getStatus()));
        Assert.assertEquals((int)2, (int)response3.getPrivileges().size());
    }

    @Test(expected=SentryConfigurationException.class)
    public void testConfigCannotCreateNotificationHandler() throws Exception {
        Configuration conf = new Configuration();
        conf.set("sentry.generic.policy.notification", "junk");
        SentryGenericPolicyProcessor.createHandlers((Configuration)conf);
    }

    @Test(expected=SentryConfigurationException.class)
    public void testConfigCannotCreateSentryStore() throws Exception {
        Configuration conf = new Configuration();
        conf.set("sentry.generic.policy.store", "junk");
        SentryGenericPolicyProcessor.createStore((Configuration)conf);
    }

    public static class MockGroupMapping
    implements GroupMappingService {
        public MockGroupMapping(Configuration conf, String resource) {
        }

        public Set<String> getGroups(String user) {
            if (user.equalsIgnoreCase(TestSentryGenericPolicyProcessor.ADMIN_USER)) {
                return Sets.newHashSet((Object[])new String[]{TestSentryGenericPolicyProcessor.ADMIN_GROUP});
            }
            return Sets.newHashSet((Object[])new String[]{"notadmin_group"});
        }
    }
}

