/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.generic.service.persistent;

import com.google.common.base.Preconditions;
import com.google.common.io.Files;
import java.io.File;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.Query;
import javax.jdo.Transaction;
import junit.framework.Assert;
import org.apache.commons.io.FileUtils;
import org.apache.sentry.core.model.search.Collection;
import org.apache.sentry.provider.db.service.model.MSentryGMPrivilege;
import org.apache.sentry.provider.db.service.model.MSentryPrivilege;
import org.apache.sentry.provider.db.service.model.MSentryRole;
import org.apache.sentry.provider.db.service.persistent.SentryStore;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestSentryRole {
    private static PersistenceManagerFactory pmf;
    private static File dataDir;

    @Before
    public void setup() throws Exception {
        dataDir = new File(Files.createTempDir(), "sentry_policy_db");
        Properties prop = new Properties();
        prop.setProperty("javax.jdo.option.ConnectionURL", "jdbc:derby:;databaseName=" + dataDir.getPath() + ";create=true");
        prop.setProperty("javax.jdo.option.ConnectionUserName", "Sentry");
        prop.setProperty("javax.jdo.option.ConnectionPassword", "Sentry");
        prop.setProperty("javax.jdo.option.ConnectionDriverName", "org.apache.derby.jdbc.EmbeddedDriver");
        prop.setProperty("datanucleus.autoCreateSchema", "true");
        prop.setProperty("datanucleus.fixedDatastore", "false");
        prop.setProperty("datanucleus.NontransactionalRead", "false");
        prop.setProperty("datanucleus.NontransactionalWrite", "false");
        pmf = JDOHelper.getPersistenceManagerFactory((Map)prop);
    }

    @After
    public void tearDown() throws Exception {
        pmf.close();
        FileUtils.deleteQuietly((File)dataDir);
    }

    @Test
    public void grantMixedPrivilegeTest() throws Exception {
        String roleName = "r1";
        MSentryPrivilege hivePrivilege = new MSentryPrivilege();
        hivePrivilege.setServerName("hive.server1");
        hivePrivilege.setDbName("db1");
        hivePrivilege.setTableName("tb1");
        hivePrivilege.setPrivilegeScope("table");
        hivePrivilege.setAction("select");
        hivePrivilege.setGrantOption(Boolean.valueOf(true));
        MSentryGMPrivilege solrPrivilege = new MSentryGMPrivilege();
        solrPrivilege.setComponentName("solr");
        solrPrivilege.setServiceName("solr.server1");
        solrPrivilege.setAuthorizables(Arrays.asList(new Collection("c1")));
        solrPrivilege.setAction("query");
        solrPrivilege.setGrantOption(Boolean.valueOf(true));
        PersistenceManager pm = null;
        pm = this.openTransaction();
        pm.makePersistent((Object)new MSentryRole(roleName, System.currentTimeMillis()));
        this.commitTransaction(pm);
        pm = this.openTransaction();
        MSentryRole role = this.getMSentryRole(pm, roleName);
        hivePrivilege.appendRole(role);
        pm.makePersistent((Object)hivePrivilege);
        this.commitTransaction(pm);
        pm = this.openTransaction();
        role = this.getMSentryRole(pm, roleName);
        pm.retrieve((Object)role);
        Assert.assertEquals((int)1, (int)role.getPrivileges().size());
        Assert.assertEquals((int)0, (int)role.getGmPrivileges().size());
        this.commitTransaction(pm);
        pm = this.openTransaction();
        role = this.getMSentryRole(pm, roleName);
        pm.retrieve((Object)role);
        solrPrivilege.appendRole(role);
        pm.makePersistent((Object)solrPrivilege);
        this.commitTransaction(pm);
        pm = this.openTransaction();
        role = this.getMSentryRole(pm, roleName);
        pm.retrieve((Object)role);
        Assert.assertEquals((int)1, (int)role.getPrivileges().size());
        Assert.assertEquals((int)1, (int)role.getGmPrivileges().size());
        this.commitTransaction(pm);
    }

    @Test
    public void testWantGrantPrivilegeTwice() throws Exception {
        String roleName = "r1";
        MSentryPrivilege hivePrivilege = new MSentryPrivilege();
        hivePrivilege.setServerName("hive.server1");
        hivePrivilege.setDbName("db1");
        hivePrivilege.setTableName("tb1");
        hivePrivilege.setPrivilegeScope("table");
        hivePrivilege.setAction("select");
        hivePrivilege.setURI(SentryStore.NULL_COL);
        hivePrivilege.setColumnName(SentryStore.NULL_COL);
        hivePrivilege.setGrantOption(Boolean.valueOf(true));
        MSentryPrivilege hivePrivilege2 = new MSentryPrivilege(hivePrivilege);
        MSentryGMPrivilege solrPrivilege = new MSentryGMPrivilege();
        solrPrivilege.setComponentName("solr");
        solrPrivilege.setServiceName("solr.server1");
        solrPrivilege.setAuthorizables(Arrays.asList(new Collection("c1")));
        solrPrivilege.setAction("query");
        solrPrivilege.setGrantOption(Boolean.valueOf(true));
        MSentryGMPrivilege solrPrivilege2 = new MSentryGMPrivilege(solrPrivilege);
        PersistenceManager pm = null;
        pm = this.openTransaction();
        pm.makePersistent((Object)new MSentryRole(roleName, System.currentTimeMillis()));
        this.commitTransaction(pm);
        pm = this.openTransaction();
        MSentryRole role = this.getMSentryRole(pm, roleName);
        solrPrivilege.appendRole(role);
        hivePrivilege.appendRole(role);
        pm.makePersistent((Object)solrPrivilege);
        pm.makePersistent((Object)hivePrivilege);
        this.commitTransaction(pm);
        pm = this.openTransaction();
        role = this.getMSentryRole(pm, roleName);
        pm.retrieve((Object)role);
        Assert.assertEquals((int)1, (int)role.getPrivileges().size());
        Assert.assertEquals((int)1, (int)role.getGmPrivileges().size());
        this.commitTransaction(pm);
        pm = this.openTransaction();
        role = this.getMSentryRole(pm, roleName);
        pm.retrieve((Object)role);
        if (!role.getGmPrivileges().contains(solrPrivilege2)) {
            Assert.fail((String)("unexpect happend: the MSentryGMPrivilege:" + solrPrivilege2 + " already be granted"));
        }
        if (!role.getPrivileges().contains(hivePrivilege2)) {
            Assert.fail((String)("unexpect happend: the MSentryPrivilege:" + hivePrivilege2 + " already be granted"));
        }
        this.commitTransaction(pm);
    }

    @Test
    public void testMixedRevokePrivilege() throws Exception {
        String roleName = "r1";
        MSentryPrivilege hivePrivilege = new MSentryPrivilege();
        hivePrivilege.setServerName("hive.server1");
        hivePrivilege.setDbName("db1");
        hivePrivilege.setTableName("tb1");
        hivePrivilege.setPrivilegeScope("table");
        hivePrivilege.setAction("select");
        hivePrivilege.setURI(SentryStore.NULL_COL);
        hivePrivilege.setColumnName(SentryStore.NULL_COL);
        hivePrivilege.setGrantOption(Boolean.valueOf(true));
        MSentryGMPrivilege solrPrivilege = new MSentryGMPrivilege();
        solrPrivilege.setComponentName("solr");
        solrPrivilege.setServiceName("solr.server1");
        solrPrivilege.setAuthorizables(Arrays.asList(new Collection("c1")));
        solrPrivilege.setAction("query");
        solrPrivilege.setGrantOption(Boolean.valueOf(true));
        PersistenceManager pm = null;
        pm = this.openTransaction();
        pm.makePersistent((Object)new MSentryRole(roleName, System.currentTimeMillis()));
        this.commitTransaction(pm);
        pm = this.openTransaction();
        MSentryRole role = this.getMSentryRole(pm, roleName);
        hivePrivilege.appendRole(role);
        solrPrivilege.appendRole(role);
        pm.makePersistent((Object)hivePrivilege);
        pm.makePersistent((Object)solrPrivilege);
        this.commitTransaction(pm);
        pm = this.openTransaction();
        role = this.getMSentryRole(pm, roleName);
        pm.retrieve((Object)role);
        Assert.assertEquals((int)1, (int)role.getPrivileges().size());
        Assert.assertEquals((int)1, (int)role.getGmPrivileges().size());
        this.commitTransaction(pm);
        pm = this.openTransaction();
        role = this.getMSentryRole(pm, roleName);
        solrPrivilege = (MSentryGMPrivilege)role.getGmPrivileges().toArray()[0];
        solrPrivilege.removeRole(role);
        pm.makePersistent((Object)solrPrivilege);
        this.commitTransaction(pm);
        pm = this.openTransaction();
        role = this.getMSentryRole(pm, roleName);
        pm.retrieve((Object)role);
        Assert.assertEquals((int)1, (int)role.getPrivileges().size());
        Assert.assertEquals((int)0, (int)role.getGmPrivileges().size());
        this.commitTransaction(pm);
        pm = this.openTransaction();
        role = this.getMSentryRole(pm, roleName);
        pm.retrieve((Object)role);
        hivePrivilege = (MSentryPrivilege)role.getPrivileges().toArray()[0];
        hivePrivilege.removeRole(role);
        pm.makePersistent((Object)hivePrivilege);
        this.commitTransaction(pm);
        pm = this.openTransaction();
        role = this.getMSentryRole(pm, roleName);
        pm.retrieve((Object)role);
        Assert.assertEquals((int)0, (int)role.getPrivileges().size());
        Assert.assertEquals((int)0, (int)role.getGmPrivileges().size());
        this.commitTransaction(pm);
    }

    @Test
    public void testDeletePrivilegeAndRole() throws Exception {
        String roleName = "r1";
        MSentryPrivilege hivePrivilege = new MSentryPrivilege();
        hivePrivilege.setServerName("hive.server1");
        hivePrivilege.setDbName("db1");
        hivePrivilege.setTableName("tb1");
        hivePrivilege.setPrivilegeScope("table");
        hivePrivilege.setAction("select");
        hivePrivilege.setURI(SentryStore.NULL_COL);
        hivePrivilege.setColumnName(SentryStore.NULL_COL);
        hivePrivilege.setGrantOption(Boolean.valueOf(true));
        MSentryGMPrivilege solrPrivilege = new MSentryGMPrivilege();
        solrPrivilege.setComponentName("solr");
        solrPrivilege.setServiceName("solr.server1");
        solrPrivilege.setAuthorizables(Arrays.asList(new Collection("c1")));
        solrPrivilege.setAction("query");
        solrPrivilege.setGrantOption(Boolean.valueOf(true));
        PersistenceManager pm = null;
        pm = this.openTransaction();
        pm.makePersistent((Object)new MSentryRole(roleName, System.currentTimeMillis()));
        this.commitTransaction(pm);
        pm = this.openTransaction();
        MSentryRole role = this.getMSentryRole(pm, roleName);
        hivePrivilege.appendRole(role);
        solrPrivilege.appendRole(role);
        pm.makePersistent((Object)hivePrivilege);
        pm.makePersistent((Object)solrPrivilege);
        this.commitTransaction(pm);
        pm = this.openTransaction();
        role = this.getMSentryRole(pm, roleName);
        pm.retrieve((Object)role);
        Assert.assertEquals((int)1, (int)role.getPrivileges().size());
        Assert.assertEquals((int)1, (int)role.getGmPrivileges().size());
        this.commitTransaction(pm);
        pm = this.openTransaction();
        role = this.getMSentryRole(pm, roleName);
        role.removeGMPrivileges();
        role.removePrivileges();
        pm.makePersistent((Object)role);
        this.commitTransaction(pm);
        pm = this.openTransaction();
        role = this.getMSentryRole(pm, roleName);
        pm.retrieve((Object)role);
        Assert.assertEquals((int)0, (int)role.getPrivileges().size());
        Assert.assertEquals((int)0, (int)role.getGmPrivileges().size());
        this.commitTransaction(pm);
        pm = this.openTransaction();
        role = this.getMSentryRole(pm, roleName);
        pm.deletePersistent((Object)role);
        this.commitTransaction(pm);
        pm = this.openTransaction();
        role = this.getMSentryRole(pm, roleName);
        Assert.assertTrue((role == null ? 1 : 0) != 0);
        this.commitTransaction(pm);
    }

    private PersistenceManager openTransaction() {
        PersistenceManager pm = pmf.getPersistenceManager();
        Transaction currentTransaction = pm.currentTransaction();
        currentTransaction.begin();
        return pm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitTransaction(PersistenceManager pm) {
        Transaction currentTransaction = pm.currentTransaction();
        try {
            Preconditions.checkState((boolean)currentTransaction.isActive(), (Object)"Transaction is not active");
            currentTransaction.commit();
        }
        finally {
            pm.close();
        }
    }

    private MSentryRole getMSentryRole(PersistenceManager pm, String roleName) {
        Query query = pm.newQuery(MSentryRole.class);
        query.setFilter("this.roleName == t");
        query.declareParameters("java.lang.String t");
        query.setUnique(true);
        MSentryRole sentryRole = (MSentryRole)query.execute((Object)roleName);
        return sentryRole;
    }
}

