/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.generic.service.persistent;

import java.util.Arrays;
import junit.framework.Assert;
import org.apache.sentry.core.model.search.Collection;
import org.apache.sentry.core.model.search.Field;
import org.apache.sentry.provider.db.service.model.MSentryGMPrivilege;
import org.junit.Test;

public class TestSentryGMPrivilege {
    @Test
    public void testValidateAuthorizables() throws Exception {
        MSentryGMPrivilege fieldPrivilege;
        try {
            fieldPrivilege = new MSentryGMPrivilege("solr", "service1", Arrays.asList(new Collection("c1"), new Field("f1")), "query", Boolean.valueOf(false));
        }
        catch (IllegalStateException e) {
            Assert.fail((String)"unexpect happend: it is a validated privilege");
        }
        try {
            MSentryGMPrivilege collectionPrivilege = new MSentryGMPrivilege("solr", "service1", Arrays.asList(new Collection(""), new Field("f1")), "query", Boolean.valueOf(false));
            Assert.fail((String)"unexpect happend: it is not a validated privilege, The empty name of authorizable can't be empty");
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        try {
            fieldPrivilege = new MSentryGMPrivilege("solr", "service1", Arrays.asList(null, new Field("f1")), "query", Boolean.valueOf(false));
            Assert.fail((String)"unexpect happend: it is not a validated privilege, The authorizable can't be null");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testImpliesWithServerScope() throws Exception {
        MSentryGMPrivilege serverPrivilege = new MSentryGMPrivilege("solr", "service1", null, "query", Boolean.valueOf(false));
        MSentryGMPrivilege collectionPrivilege = new MSentryGMPrivilege("solr", "service1", Arrays.asList(new Collection("c1")), "query", Boolean.valueOf(false));
        Assert.assertTrue((boolean)serverPrivilege.implies(collectionPrivilege));
        MSentryGMPrivilege fieldPrivilege = new MSentryGMPrivilege("solr", "service1", Arrays.asList(new Collection("c1"), new Field("f1")), "query", Boolean.valueOf(false));
        Assert.assertTrue((boolean)serverPrivilege.implies(fieldPrivilege));
        Assert.assertTrue((boolean)collectionPrivilege.implies(fieldPrivilege));
        serverPrivilege.setAction("update");
        Assert.assertFalse((boolean)serverPrivilege.implies(collectionPrivilege));
        Assert.assertFalse((boolean)serverPrivilege.implies(fieldPrivilege));
        serverPrivilege.setAction("*");
        Assert.assertTrue((boolean)serverPrivilege.implies(collectionPrivilege));
        Assert.assertTrue((boolean)serverPrivilege.implies(fieldPrivilege));
    }

    @Test
    public void testImpliesDifferentAuthorizable() throws Exception {
        MSentryGMPrivilege serverPrivilege = new MSentryGMPrivilege("solr", "service1", null, "query", Boolean.valueOf(false));
        MSentryGMPrivilege collectionPrivilege = new MSentryGMPrivilege("solr", "service1", Arrays.asList(new Collection("c1")), "query", Boolean.valueOf(false));
        MSentryGMPrivilege fieldPrivilege = new MSentryGMPrivilege("solr", "service1", Arrays.asList(new Collection("c1"), new Field("f1")), "query", Boolean.valueOf(false));
        Assert.assertTrue((boolean)serverPrivilege.implies(collectionPrivilege));
        Assert.assertTrue((boolean)serverPrivilege.implies(fieldPrivilege));
        Assert.assertTrue((boolean)collectionPrivilege.implies(fieldPrivilege));
        Assert.assertFalse((boolean)fieldPrivilege.implies(collectionPrivilege));
        Assert.assertFalse((boolean)fieldPrivilege.implies(serverPrivilege));
        Assert.assertFalse((boolean)collectionPrivilege.implies(serverPrivilege));
        MSentryGMPrivilege fieldAllPrivilege = new MSentryGMPrivilege("solr", "service1", Arrays.asList(new Collection("c1"), new Field("*")), "query", Boolean.valueOf(false));
        Assert.assertTrue((boolean)fieldAllPrivilege.implies(collectionPrivilege));
        MSentryGMPrivilege fieldPrivilege1 = new MSentryGMPrivilege("solr", "service1", Arrays.asList(new Collection("c1"), new Field("f1")), "query", Boolean.valueOf(false));
        MSentryGMPrivilege fieldPrivilege2 = new MSentryGMPrivilege("solr", "service1", Arrays.asList(new Collection("c2"), new Field("f2")), "query", Boolean.valueOf(false));
        Assert.assertFalse((boolean)fieldPrivilege1.implies(fieldPrivilege2));
    }

    @Test
    public void testSearchImpliesEqualAuthorizable() throws Exception {
        MSentryGMPrivilege serverPrivilege1 = new MSentryGMPrivilege("solr", "service1", null, "query", Boolean.valueOf(false));
        MSentryGMPrivilege serverPrivilege2 = new MSentryGMPrivilege("solr", "service2", null, "query", Boolean.valueOf(false));
        Assert.assertFalse((boolean)serverPrivilege1.implies(serverPrivilege2));
        MSentryGMPrivilege collectionPrivilege1 = new MSentryGMPrivilege("solr", "service1", Arrays.asList(new Collection("c1")), "query", Boolean.valueOf(false));
        MSentryGMPrivilege collectionPrivilege2 = new MSentryGMPrivilege("solr", "service1", Arrays.asList(new Collection("c2")), "query", Boolean.valueOf(false));
        Assert.assertFalse((boolean)collectionPrivilege1.implies(collectionPrivilege2));
        MSentryGMPrivilege fieldPrivilege1 = new MSentryGMPrivilege("solr", "service1", Arrays.asList(new Collection("c1"), new Field("f1")), "query", Boolean.valueOf(false));
        MSentryGMPrivilege fieldPrivilege2 = new MSentryGMPrivilege("solr", "service1", Arrays.asList(new Collection("c1"), new Field("f2")), "query", Boolean.valueOf(false));
        Assert.assertFalse((boolean)fieldPrivilege1.implies(fieldPrivilege2));
        collectionPrivilege2.setAuthorizables(Arrays.asList(new Collection("*")));
        collectionPrivilege2.implies(collectionPrivilege1);
        fieldPrivilege2.setAuthorizables(Arrays.asList(new Collection("c1"), new Field("*")));
        fieldPrivilege2.implies(fieldPrivilege1);
    }

    @Test
    public void testSearchImpliesAction() throws Exception {
        MSentryGMPrivilege fieldPrivilege1 = new MSentryGMPrivilege("solr", "service1", Arrays.asList(new Collection("c1"), new Field("f2")), "query", Boolean.valueOf(false));
        MSentryGMPrivilege fieldPrivilege2 = new MSentryGMPrivilege("solr", "service1", Arrays.asList(new Collection("c1"), new Field("f2")), "query", Boolean.valueOf(false));
        Assert.assertTrue((boolean)fieldPrivilege1.implies(fieldPrivilege2));
        fieldPrivilege2.setAction("update");
        Assert.assertFalse((boolean)fieldPrivilege1.implies(fieldPrivilege2));
        fieldPrivilege1.setAction("*");
        Assert.assertTrue((boolean)fieldPrivilege1.implies(fieldPrivilege2));
    }
}

