/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.generic.service.persistent;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import junit.framework.Assert;
import org.apache.sentry.core.model.search.Collection;
import org.apache.sentry.core.model.search.Field;
import org.apache.sentry.core.model.search.SearchModelAuthorizable;
import org.apache.sentry.provider.db.SentryGrantDeniedException;
import org.apache.sentry.provider.db.generic.service.persistent.PrivilegeObject;
import org.apache.sentry.provider.db.generic.service.persistent.SentryStoreIntegrationBase;
import org.apache.sentry.provider.file.PolicyFile;
import org.junit.Before;
import org.junit.Test;

public class TestPrivilegeOperatePersistence
extends SentryStoreIntegrationBase {
    private static final String SEARCH = "solr";
    private static final String ADMIN_USER = "solr";
    private static final String GRANT_OPTION_USER = "user_grant_option";
    private static final String[] GRANT_OPTION_GROUP = new String[]{"group_grant_option"};
    private static final String NO_GRANT_OPTION_USER = "user_no_grant_option";
    private static final String[] NO_GRANT_OPTION_GROUP = new String[]{"group_no_grant_option"};
    private static final String SERVICE = "service";
    private static final String COLLECTION_NAME = "collection1";
    private static final String NOT_COLLECTION_NAME = "not_collection1";
    private static final String FIELD_NAME = "field1";
    private static final String NOT_FIELD_NAME = "not_field1";

    @Before
    public void configure() throws Exception {
        policyFile = new PolicyFile();
        TestPrivilegeOperatePersistence.addGroupsToUser("solr", this.getAdminGroups());
        TestPrivilegeOperatePersistence.writePolicyFile();
    }

    @Test
    public void testGrantPrivilege() throws Exception {
        String roleName = "r1";
        String grantor = "solr";
        PrivilegeObject queryPrivilege = new PrivilegeObject.Builder().setComponent("solr").setAction("query").setService(SERVICE).setAuthorizables(Arrays.asList(new Collection(COLLECTION_NAME))).withGrantOption(null).build();
        sentryStore.createRole("solr", roleName, grantor);
        sentryStore.alterRoleGrantPrivilege("solr", roleName, queryPrivilege, grantor);
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new PrivilegeObject[]{queryPrivilege}), (Object)sentryStore.getPrivilegesByRole("solr", (Set)Sets.newHashSet((Object[])new String[]{roleName})));
        PrivilegeObject queryPrivilegeWithOption = new PrivilegeObject.Builder().setComponent("solr").setAction("query").setService(SERVICE).setAuthorizables(Arrays.asList(new Collection(COLLECTION_NAME))).withGrantOption(Boolean.valueOf(true)).build();
        sentryStore.alterRoleGrantPrivilege("solr", roleName, queryPrivilegeWithOption, grantor);
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new PrivilegeObject[]{queryPrivilege, queryPrivilegeWithOption}), (Object)sentryStore.getPrivilegesByRole("solr", (Set)Sets.newHashSet((Object[])new String[]{roleName})));
        PrivilegeObject queryPrivilegeWithNoOption = new PrivilegeObject.Builder().setComponent("solr").setAction("query").setService(SERVICE).setAuthorizables(Arrays.asList(new Collection(COLLECTION_NAME))).withGrantOption(Boolean.valueOf(false)).build();
        sentryStore.alterRoleGrantPrivilege("solr", roleName, queryPrivilegeWithNoOption, grantor);
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new PrivilegeObject[]{queryPrivilege, queryPrivilegeWithOption, queryPrivilegeWithNoOption}), (Object)sentryStore.getPrivilegesByRole("solr", (Set)Sets.newHashSet((Object[])new String[]{roleName})));
    }

    @Test
    public void testGrantPrivilegeTwice() throws Exception {
        String roleName = "r1";
        String grantor = "solr";
        sentryStore.createRole("solr", roleName, grantor);
        PrivilegeObject queryPrivilegeWithOption = new PrivilegeObject.Builder().setComponent("solr").setAction("query").setService(SERVICE).setAuthorizables(Arrays.asList(new Collection(COLLECTION_NAME))).withGrantOption(Boolean.valueOf(true)).build();
        sentryStore.alterRoleGrantPrivilege("solr", roleName, queryPrivilegeWithOption, grantor);
        Assert.assertEquals((int)1, (int)sentryStore.getPrivilegesByRole("solr", (Set)Sets.newHashSet((Object[])new String[]{roleName})).size());
        sentryStore.alterRoleGrantPrivilege("solr", roleName, queryPrivilegeWithOption, grantor);
        Assert.assertEquals((int)1, (int)sentryStore.getPrivilegesByRole("solr", (Set)Sets.newHashSet((Object[])new String[]{roleName})).size());
        PrivilegeObject queryPrivilegeWithNoOption = new PrivilegeObject.Builder().setComponent("solr").setAction("query").setService(SERVICE).setAuthorizables(Arrays.asList(new Collection(COLLECTION_NAME))).withGrantOption(Boolean.valueOf(false)).build();
        sentryStore.alterRoleGrantPrivilege("solr", roleName, queryPrivilegeWithNoOption, grantor);
        Assert.assertEquals((int)2, (int)sentryStore.getPrivilegesByRole("solr", (Set)Sets.newHashSet((Object[])new String[]{roleName})).size());
        sentryStore.alterRoleGrantPrivilege("solr", roleName, queryPrivilegeWithNoOption, grantor);
        Assert.assertEquals((int)2, (int)sentryStore.getPrivilegesByRole("solr", (Set)Sets.newHashSet((Object[])new String[]{roleName})).size());
        PrivilegeObject queryPrivilegeWithNullGrant = new PrivilegeObject.Builder().setComponent("solr").setAction("query").setService(SERVICE).setAuthorizables(Arrays.asList(new Collection(COLLECTION_NAME))).withGrantOption(null).build();
        sentryStore.alterRoleGrantPrivilege("solr", roleName, queryPrivilegeWithNullGrant, grantor);
        Assert.assertEquals((int)3, (int)sentryStore.getPrivilegesByRole("solr", (Set)Sets.newHashSet((Object[])new String[]{roleName})).size());
        sentryStore.alterRoleGrantPrivilege("solr", roleName, queryPrivilegeWithNullGrant, grantor);
        Assert.assertEquals((int)3, (int)sentryStore.getPrivilegesByRole("solr", (Set)Sets.newHashSet((Object[])new String[]{roleName})).size());
    }

    @Test
    public void testGrantPrivilegeWithAllPrivilegeExist() throws Exception {
        String roleName = "r1";
        String grantor = "solr";
        PrivilegeObject allPrivilege = new PrivilegeObject.Builder().setComponent("solr").setAction("*").setService(SERVICE).setAuthorizables(Arrays.asList(new Collection(COLLECTION_NAME))).build();
        sentryStore.createRole("solr", roleName, grantor);
        sentryStore.alterRoleGrantPrivilege("solr", roleName, allPrivilege, grantor);
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new PrivilegeObject[]{allPrivilege}), (Object)sentryStore.getPrivilegesByRole("solr", (Set)Sets.newHashSet((Object[])new String[]{roleName})));
        PrivilegeObject queryPrivilege = new PrivilegeObject.Builder(allPrivilege).setAction("query").build();
        sentryStore.alterRoleGrantPrivilege("solr", roleName, queryPrivilege, grantor);
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new PrivilegeObject[]{allPrivilege}), (Object)sentryStore.getPrivilegesByRole("solr", (Set)Sets.newHashSet((Object[])new String[]{roleName})));
    }

    @Test
    public void testGrantALLPrivilegeWithOtherPrivilegesExist() throws Exception {
        String roleName1 = "r1";
        String roleName2 = "r2";
        String grantor = "solr";
        PrivilegeObject queryPrivilege = new PrivilegeObject.Builder().setComponent("solr").setAction("query").setService(SERVICE).setAuthorizables(Arrays.asList(new Collection(COLLECTION_NAME))).build();
        PrivilegeObject updatePrivilege = new PrivilegeObject.Builder(queryPrivilege).setAction("update").build();
        sentryStore.createRole("solr", roleName1, grantor);
        sentryStore.createRole("solr", roleName2, grantor);
        sentryStore.alterRoleGrantPrivilege("solr", roleName1, queryPrivilege, grantor);
        sentryStore.alterRoleGrantPrivilege("solr", roleName1, updatePrivilege, grantor);
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new PrivilegeObject[]{queryPrivilege, updatePrivilege}), (Object)sentryStore.getPrivilegesByRole("solr", (Set)Sets.newHashSet((Object[])new String[]{roleName1})));
        sentryStore.alterRoleGrantPrivilege("solr", roleName2, queryPrivilege, grantor);
        sentryStore.alterRoleGrantPrivilege("solr", roleName2, updatePrivilege, grantor);
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new PrivilegeObject[]{queryPrivilege, updatePrivilege}), (Object)sentryStore.getPrivilegesByRole("solr", (Set)Sets.newHashSet((Object[])new String[]{roleName2})));
        PrivilegeObject allPrivilege = new PrivilegeObject.Builder(queryPrivilege).setAction("*").build();
        sentryStore.alterRoleGrantPrivilege("solr", roleName1, allPrivilege, grantor);
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new PrivilegeObject[]{allPrivilege}), (Object)sentryStore.getPrivilegesByRole("solr", (Set)Sets.newHashSet((Object[])new String[]{roleName1})));
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new PrivilegeObject[]{queryPrivilege, updatePrivilege}), (Object)sentryStore.getPrivilegesByRole("solr", (Set)Sets.newHashSet((Object[])new String[]{roleName2})));
    }

    @Test
    public void testGrantRevokeCheckWithGrantOption() throws Exception {
        TestPrivilegeOperatePersistence.addGroupsToUser(GRANT_OPTION_USER, GRANT_OPTION_GROUP);
        TestPrivilegeOperatePersistence.addGroupsToUser(NO_GRANT_OPTION_USER, NO_GRANT_OPTION_GROUP);
        TestPrivilegeOperatePersistence.writePolicyFile();
        String roleName1 = "r1";
        String roleName2 = "r2";
        String grantor = "g1";
        sentryStore.createRole("solr", roleName1, grantor);
        sentryStore.createRole("solr", roleName2, grantor);
        PrivilegeObject queryPrivilege1 = new PrivilegeObject.Builder().setComponent("solr").setAction("query").setService(SERVICE).setAuthorizables(Arrays.asList(new Collection(COLLECTION_NAME))).withGrantOption(Boolean.valueOf(true)).build();
        sentryStore.alterRoleGrantPrivilege("solr", roleName1, queryPrivilege1, "solr");
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new PrivilegeObject[]{queryPrivilege1}), (Object)sentryStore.getPrivilegesByRole("solr", (Set)Sets.newHashSet((Object[])new String[]{roleName1})));
        PrivilegeObject queryPrivilege2 = new PrivilegeObject.Builder().setComponent("solr").setAction("query").setService(SERVICE).setAuthorizables(Arrays.asList(new Collection(COLLECTION_NAME))).withGrantOption(Boolean.valueOf(false)).build();
        sentryStore.alterRoleGrantPrivilege("solr", roleName2, queryPrivilege2, "solr");
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new PrivilegeObject[]{queryPrivilege2}), (Object)sentryStore.getPrivilegesByRole("solr", (Set)Sets.newHashSet((Object[])new String[]{roleName2})));
        sentryStore.alterRoleAddGroups("solr", roleName1, (Set)Sets.newHashSet((Object[])GRANT_OPTION_GROUP), grantor);
        sentryStore.alterRoleAddGroups("solr", roleName2, (Set)Sets.newHashSet((Object[])NO_GRANT_OPTION_GROUP), grantor);
        String roleName3 = "r3";
        sentryStore.createRole("solr", roleName3, grantor);
        try {
            sentryStore.alterRoleGrantPrivilege("solr", roleName3, queryPrivilege1, GRANT_OPTION_USER);
        }
        catch (SentryGrantDeniedException e) {
            Assert.fail((String)"SentryGrantDeniedException shouldn't have been thrown");
        }
        try {
            sentryStore.alterRoleRevokePrivilege("solr", roleName3, queryPrivilege1, GRANT_OPTION_USER);
        }
        catch (SentryGrantDeniedException e) {
            Assert.fail((String)"SentryGrantDeniedException shouldn't have been thrown");
        }
        try {
            sentryStore.alterRoleGrantPrivilege("solr", roleName3, queryPrivilege2, NO_GRANT_OPTION_USER);
            Assert.fail((String)"SentryGrantDeniedException should have been thrown");
        }
        catch (SentryGrantDeniedException e) {
            // empty catch block
        }
        try {
            sentryStore.alterRoleGrantPrivilege("solr", roleName3, queryPrivilege2, NO_GRANT_OPTION_USER);
            Assert.fail((String)"SentryGrantDeniedException should have been thrown");
        }
        catch (SentryGrantDeniedException e) {
            // empty catch block
        }
    }

    @Test
    public void testGrantWithGrantOption() throws Exception {
        TestPrivilegeOperatePersistence.addGroupsToUser(GRANT_OPTION_USER, GRANT_OPTION_GROUP);
        TestPrivilegeOperatePersistence.addGroupsToUser(NO_GRANT_OPTION_USER, NO_GRANT_OPTION_GROUP);
        TestPrivilegeOperatePersistence.writePolicyFile();
        String roleName1 = "r1";
        String grantor = "g1";
        sentryStore.createRole("solr", roleName1, grantor);
        PrivilegeObject queryPrivilege = new PrivilegeObject.Builder().setComponent("solr").setAction("query").setService(SERVICE).setAuthorizables(Arrays.asList(new Collection(COLLECTION_NAME))).withGrantOption(Boolean.valueOf(true)).build();
        sentryStore.alterRoleGrantPrivilege("solr", roleName1, queryPrivilege, "solr");
        sentryStore.alterRoleAddGroups("solr", roleName1, (Set)Sets.newHashSet((Object[])GRANT_OPTION_GROUP), grantor);
        String roleName2 = "r2";
        sentryStore.createRole("solr", roleName2, grantor);
        sentryStore.alterRoleGrantPrivilege("solr", roleName2, queryPrivilege, GRANT_OPTION_USER);
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new PrivilegeObject[]{queryPrivilege}), (Object)sentryStore.getPrivilegesByRole("solr", (Set)Sets.newHashSet((Object[])new String[]{roleName2})));
    }

    @Test
    public void testRevokePrivilege() throws Exception {
        String roleName = "r1";
        String grantor = "solr";
        PrivilegeObject queryPrivilege = new PrivilegeObject.Builder().setComponent("solr").setAction("query").setService(SERVICE).setAuthorizables(Arrays.asList(new Collection(COLLECTION_NAME), new Field(FIELD_NAME))).build();
        PrivilegeObject updatePrivilege = new PrivilegeObject.Builder(queryPrivilege).setAction("update").build();
        sentryStore.createRole("solr", roleName, grantor);
        sentryStore.alterRoleGrantPrivilege("solr", roleName, queryPrivilege, grantor);
        sentryStore.alterRoleGrantPrivilege("solr", roleName, updatePrivilege, grantor);
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new PrivilegeObject[]{queryPrivilege, updatePrivilege}), (Object)sentryStore.getPrivilegesByRole("solr", (Set)Sets.newHashSet((Object[])new String[]{roleName})));
        sentryStore.alterRoleRevokePrivilege("solr", roleName, queryPrivilege, grantor);
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new PrivilegeObject[]{updatePrivilege}), (Object)sentryStore.getPrivilegesByRole("solr", (Set)Sets.newHashSet((Object[])new String[]{roleName})));
    }

    @Test
    public void testRevokeAllPrivilege() throws Exception {
        String roleName = "r1";
        String grantor = "solr";
        PrivilegeObject queryPrivilege = new PrivilegeObject.Builder().setComponent("solr").setAction("query").setService(SERVICE).setAuthorizables(Arrays.asList(new Collection(COLLECTION_NAME), new Field(FIELD_NAME))).build();
        PrivilegeObject updatePrivilege = new PrivilegeObject.Builder(queryPrivilege).setAction("update").build();
        sentryStore.createRole("solr", roleName, grantor);
        sentryStore.alterRoleGrantPrivilege("solr", roleName, queryPrivilege, grantor);
        sentryStore.alterRoleGrantPrivilege("solr", roleName, updatePrivilege, grantor);
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new PrivilegeObject[]{queryPrivilege, updatePrivilege}), (Object)sentryStore.getPrivilegesByRole("solr", (Set)Sets.newHashSet((Object[])new String[]{roleName})));
        PrivilegeObject allPrivilege = new PrivilegeObject.Builder(queryPrivilege).setAction("*").build();
        sentryStore.alterRoleRevokePrivilege("solr", roleName, allPrivilege, grantor);
        Assert.assertEquals((Object)Sets.newHashSet(), (Object)sentryStore.getPrivilegesByRole("solr", (Set)Sets.newHashSet((Object[])new String[]{roleName})));
    }

    @Test
    public void testRevokePrivilegeWithAllPrivilegeExist() throws Exception {
        String roleName = "r1";
        String grantor = "solr";
        PrivilegeObject allPrivilege = new PrivilegeObject.Builder().setComponent("solr").setAction("*").setService(SERVICE).setAuthorizables(Arrays.asList(new Collection(COLLECTION_NAME), new Field(FIELD_NAME))).build();
        sentryStore.createRole("solr", roleName, grantor);
        sentryStore.alterRoleGrantPrivilege("solr", roleName, allPrivilege, grantor);
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new PrivilegeObject[]{allPrivilege}), (Object)sentryStore.getPrivilegesByRole("solr", (Set)Sets.newHashSet((Object[])new String[]{roleName})));
        PrivilegeObject updatePrivilege = new PrivilegeObject.Builder(allPrivilege).setAction("update").build();
        PrivilegeObject queryPrivilege = new PrivilegeObject.Builder(allPrivilege).setAction("query").build();
        sentryStore.alterRoleRevokePrivilege("solr", roleName, updatePrivilege, grantor);
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new PrivilegeObject[]{queryPrivilege}), (Object)sentryStore.getPrivilegesByRole("solr", (Set)Sets.newHashSet((Object[])new String[]{roleName})));
    }

    @Test
    public void testRevokePrivilegeWithAllPrivilegesGranted() throws Exception {
        String roleName = "r1";
        String grantor = "solr";
        PrivilegeObject allPrivilege = new PrivilegeObject.Builder().setComponent("solr").setAction("*").setService(SERVICE).setAuthorizables(Arrays.asList(new Collection(COLLECTION_NAME), new Field(FIELD_NAME))).build();
        PrivilegeObject updatePrivilege = new PrivilegeObject.Builder(allPrivilege).setAction("update").build();
        PrivilegeObject queryPrivilege = new PrivilegeObject.Builder(allPrivilege).setAction("query").build();
        sentryStore.createRole("solr", roleName, grantor);
        sentryStore.alterRoleGrantPrivilege("solr", roleName, queryPrivilege, grantor);
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new PrivilegeObject[]{queryPrivilege}), (Object)sentryStore.getPrivilegesByRole("solr", (Set)Sets.newHashSet((Object[])new String[]{roleName})));
        sentryStore.alterRoleGrantPrivilege("solr", roleName, updatePrivilege, grantor);
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new PrivilegeObject[]{queryPrivilege, updatePrivilege}), (Object)sentryStore.getPrivilegesByRole("solr", (Set)Sets.newHashSet((Object[])new String[]{roleName})));
        sentryStore.alterRoleGrantPrivilege("solr", roleName, allPrivilege, grantor);
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new PrivilegeObject[]{allPrivilege}), (Object)sentryStore.getPrivilegesByRole("solr", (Set)Sets.newHashSet((Object[])new String[]{roleName})));
        sentryStore.alterRoleRevokePrivilege("solr", roleName, updatePrivilege, grantor);
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new PrivilegeObject[]{queryPrivilege}), (Object)sentryStore.getPrivilegesByRole("solr", (Set)Sets.newHashSet((Object[])new String[]{roleName})));
    }

    @Test
    public void testRevokeParentPrivilegeWithChildsExist() throws Exception {
        String roleName = "r1";
        String grantor = "solr";
        PrivilegeObject updatePrivilege1 = new PrivilegeObject.Builder().setComponent("solr").setAction("update").setService(SERVICE).setAuthorizables(Arrays.asList(new Collection(COLLECTION_NAME), new Field(FIELD_NAME))).build();
        PrivilegeObject queryPrivilege1 = new PrivilegeObject.Builder().setComponent("solr").setAction("query").setService(SERVICE).setAuthorizables(Arrays.asList(new Collection(COLLECTION_NAME), new Field(FIELD_NAME))).build();
        PrivilegeObject queryPrivilege2 = new PrivilegeObject.Builder().setComponent("solr").setAction("query").setService(SERVICE).setAuthorizables(Arrays.asList(new Collection(NOT_COLLECTION_NAME))).build();
        sentryStore.createRole("solr", roleName, grantor);
        sentryStore.alterRoleGrantPrivilege("solr", roleName, updatePrivilege1, grantor);
        sentryStore.alterRoleGrantPrivilege("solr", roleName, queryPrivilege1, grantor);
        sentryStore.alterRoleGrantPrivilege("solr", roleName, queryPrivilege2, grantor);
        PrivilegeObject allPrivilege = new PrivilegeObject.Builder().setComponent("solr").setAction("*").setService(SERVICE).setAuthorizables(Arrays.asList(new Collection(COLLECTION_NAME))).build();
        sentryStore.alterRoleRevokePrivilege("solr", roleName, allPrivilege, grantor);
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new PrivilegeObject[]{queryPrivilege2}), (Object)sentryStore.getPrivilegesByRole("solr", (Set)Sets.newHashSet((Object[])new String[]{roleName})));
    }

    @Test
    public void testRevokeWithGrantOption() throws Exception {
        TestPrivilegeOperatePersistence.addGroupsToUser(GRANT_OPTION_USER, GRANT_OPTION_GROUP);
        TestPrivilegeOperatePersistence.addGroupsToUser(NO_GRANT_OPTION_USER, NO_GRANT_OPTION_GROUP);
        TestPrivilegeOperatePersistence.writePolicyFile();
        String roleName1 = "r1";
        String grantor = "g1";
        sentryStore.createRole("solr", roleName1, grantor);
        PrivilegeObject queryPrivilege = new PrivilegeObject.Builder().setComponent("solr").setAction("query").setService(SERVICE).setAuthorizables(Arrays.asList(new Collection(COLLECTION_NAME))).withGrantOption(Boolean.valueOf(true)).build();
        sentryStore.alterRoleGrantPrivilege("solr", roleName1, queryPrivilege, "solr");
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new PrivilegeObject[]{queryPrivilege}), (Object)sentryStore.getPrivilegesByRole("solr", (Set)Sets.newHashSet((Object[])new String[]{roleName1})));
        sentryStore.alterRoleAddGroups("solr", roleName1, (Set)Sets.newHashSet((Object[])GRANT_OPTION_GROUP), grantor);
        String roleName2 = "r2";
        sentryStore.createRole("solr", roleName2, grantor);
        sentryStore.alterRoleGrantPrivilege("solr", roleName2, queryPrivilege, GRANT_OPTION_USER);
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new PrivilegeObject[]{queryPrivilege}), (Object)sentryStore.getPrivilegesByRole("solr", (Set)Sets.newHashSet((Object[])new String[]{roleName2})));
        sentryStore.alterRoleRevokePrivilege("solr", roleName2, queryPrivilege, GRANT_OPTION_USER);
        Assert.assertEquals((Object)Sets.newHashSet(), (Object)sentryStore.getPrivilegesByRole("solr", (Set)Sets.newHashSet((Object[])new String[]{roleName2})));
    }

    @Test
    public void testDropPrivilege() throws Exception {
        String roleName1 = "r1";
        String roleName2 = "r2";
        String grantor = "solr";
        PrivilegeObject queryPrivilege = new PrivilegeObject.Builder().setComponent("solr").setAction("query").setService(SERVICE).setAuthorizables(Arrays.asList(new Collection(COLLECTION_NAME), new Field(FIELD_NAME))).build();
        PrivilegeObject updatePrivilege = new PrivilegeObject.Builder(queryPrivilege).setAction("update").build();
        sentryStore.createRole("solr", roleName1, grantor);
        sentryStore.alterRoleGrantPrivilege("solr", roleName1, queryPrivilege, grantor);
        sentryStore.alterRoleGrantPrivilege("solr", roleName1, updatePrivilege, grantor);
        sentryStore.createRole("solr", roleName2, grantor);
        sentryStore.alterRoleGrantPrivilege("solr", roleName2, queryPrivilege, grantor);
        sentryStore.alterRoleGrantPrivilege("solr", roleName2, updatePrivilege, grantor);
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new PrivilegeObject[]{queryPrivilege, updatePrivilege}), (Object)sentryStore.getPrivilegesByRole("solr", (Set)Sets.newHashSet((Object[])new String[]{roleName1})));
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new PrivilegeObject[]{queryPrivilege, updatePrivilege}), (Object)sentryStore.getPrivilegesByRole("solr", (Set)Sets.newHashSet((Object[])new String[]{roleName2})));
        sentryStore.dropPrivilege("solr", queryPrivilege, grantor);
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new PrivilegeObject[]{updatePrivilege}), (Object)sentryStore.getPrivilegesByRole("solr", (Set)Sets.newHashSet((Object[])new String[]{roleName1})));
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new PrivilegeObject[]{updatePrivilege}), (Object)sentryStore.getPrivilegesByRole("solr", (Set)Sets.newHashSet((Object[])new String[]{roleName2})));
        PrivilegeObject allPrivilege = new PrivilegeObject.Builder(queryPrivilege).setAction("*").build();
        sentryStore.dropPrivilege("solr", allPrivilege, grantor);
        Assert.assertEquals((Object)Sets.newHashSet(), (Object)sentryStore.getPrivilegesByRole("solr", (Set)Sets.newHashSet((Object[])new String[]{roleName1})));
        Assert.assertEquals((Object)Sets.newHashSet(), (Object)sentryStore.getPrivilegesByRole("solr", (Set)Sets.newHashSet((Object[])new String[]{roleName2})));
        sentryStore.alterRoleGrantPrivilege("solr", roleName1, queryPrivilege, grantor);
        sentryStore.alterRoleGrantPrivilege("solr", roleName1, updatePrivilege, grantor);
        PrivilegeObject parentPrivilege = new PrivilegeObject.Builder().setComponent("solr").setAction("*").setService(SERVICE).setAuthorizables(Arrays.asList(new Collection(COLLECTION_NAME))).build();
        sentryStore.dropPrivilege("solr", parentPrivilege, grantor);
        Assert.assertEquals((Object)Sets.newHashSet(), (Object)sentryStore.getPrivilegesByRole("solr", (Set)Sets.newHashSet((Object[])new String[]{roleName1})));
    }

    @Test
    public void testRenamePrivilege() throws Exception {
        String roleName1 = "r1";
        String roleName2 = "r2";
        String grantor = "solr";
        List<SearchModelAuthorizable> oldAuthoriables = Arrays.asList(new Collection(COLLECTION_NAME), new Field(FIELD_NAME));
        List<SearchModelAuthorizable> newAuthoriables = Arrays.asList(new Collection(COLLECTION_NAME), new Field(NOT_FIELD_NAME));
        PrivilegeObject oldQueryPrivilege = new PrivilegeObject.Builder().setComponent("solr").setAction("query").setService(SERVICE).setAuthorizables(oldAuthoriables).build();
        PrivilegeObject oldUpdatePrivilege = new PrivilegeObject.Builder(oldQueryPrivilege).setAction("update").build();
        PrivilegeObject oldALLPrivilege = new PrivilegeObject.Builder(oldQueryPrivilege).setAction("*").build();
        PrivilegeObject newQueryPrivilege = new PrivilegeObject.Builder().setComponent("solr").setAction("query").setService(SERVICE).setAuthorizables(newAuthoriables).build();
        PrivilegeObject newUpdatePrivilege = new PrivilegeObject.Builder(newQueryPrivilege).setAction("update").build();
        PrivilegeObject newALLPrivilege = new PrivilegeObject.Builder(newQueryPrivilege).setAction("*").build();
        sentryStore.createRole("solr", roleName1, grantor);
        sentryStore.alterRoleGrantPrivilege("solr", roleName1, oldQueryPrivilege, grantor);
        sentryStore.alterRoleGrantPrivilege("solr", roleName1, oldUpdatePrivilege, grantor);
        sentryStore.createRole("solr", roleName2, grantor);
        sentryStore.alterRoleGrantPrivilege("solr", roleName2, oldALLPrivilege, grantor);
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new PrivilegeObject[]{oldQueryPrivilege, oldUpdatePrivilege}), (Object)sentryStore.getPrivilegesByRole("solr", (Set)Sets.newHashSet((Object[])new String[]{roleName1})));
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new PrivilegeObject[]{oldALLPrivilege}), (Object)sentryStore.getPrivilegesByRole("solr", (Set)Sets.newHashSet((Object[])new String[]{roleName2})));
        sentryStore.renamePrivilege("solr", SERVICE, oldAuthoriables, newAuthoriables, grantor);
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new PrivilegeObject[]{newQueryPrivilege, newUpdatePrivilege}), (Object)sentryStore.getPrivilegesByRole("solr", (Set)Sets.newHashSet((Object[])new String[]{roleName1})));
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new PrivilegeObject[]{newALLPrivilege}), (Object)sentryStore.getPrivilegesByRole("solr", (Set)Sets.newHashSet((Object[])new String[]{roleName2})));
        List<SearchModelAuthorizable> newAuthoriables1 = Arrays.asList(new Collection(NOT_COLLECTION_NAME), new Field(NOT_FIELD_NAME));
        PrivilegeObject newQueryPrivilege1 = new PrivilegeObject.Builder(newQueryPrivilege).setAuthorizables(newAuthoriables1).build();
        PrivilegeObject newUpdatePrivilege1 = new PrivilegeObject.Builder(newUpdatePrivilege).setAuthorizables(newAuthoriables1).build();
        PrivilegeObject newALLPrivilege1 = new PrivilegeObject.Builder(newALLPrivilege).setAuthorizables(newAuthoriables1).build();
        sentryStore.renamePrivilege("solr", SERVICE, Arrays.asList(new Collection(COLLECTION_NAME)), Arrays.asList(new Collection(NOT_COLLECTION_NAME)), grantor);
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new PrivilegeObject[]{newQueryPrivilege1, newUpdatePrivilege1}), (Object)sentryStore.getPrivilegesByRole("solr", (Set)Sets.newHashSet((Object[])new String[]{roleName1})));
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new PrivilegeObject[]{newALLPrivilege1}), (Object)sentryStore.getPrivilegesByRole("solr", (Set)Sets.newHashSet((Object[])new String[]{roleName2})));
    }

    @Test
    public void testGetPrivilegesByRoleName() throws Exception {
        String roleName1 = "r1";
        String roleName2 = "r2";
        String grantor = "g1";
        PrivilegeObject queryPrivilege = new PrivilegeObject.Builder().setComponent("solr").setAction("query").setService(SERVICE).setAuthorizables(Arrays.asList(new Collection(COLLECTION_NAME))).build();
        sentryStore.createRole("solr", roleName1, grantor);
        sentryStore.alterRoleGrantPrivilege("solr", roleName1, queryPrivilege, "solr");
        PrivilegeObject updatePrivilege = new PrivilegeObject.Builder().setComponent("solr").setAction("query").setService(SERVICE).setAuthorizables(Arrays.asList(new Collection(COLLECTION_NAME))).build();
        sentryStore.createRole("solr", roleName2, grantor);
        sentryStore.alterRoleGrantPrivilege("solr", roleName2, updatePrivilege, "solr");
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new PrivilegeObject[]{queryPrivilege, updatePrivilege}), (Object)sentryStore.getPrivilegesByRole("solr", (Set)Sets.newHashSet((Object[])new String[]{roleName1, roleName2})));
    }

    @Test
    public void testGetPrivilegesByProvider() throws Exception {
        String roleName1 = "r1";
        String roleName2 = "r2";
        String roleName3 = "r3";
        String group = "g3";
        String grantor = "solr";
        String service1 = "service1";
        PrivilegeObject queryPrivilege1 = new PrivilegeObject.Builder().setComponent("solr").setAction("query").setService(service1).setAuthorizables(Arrays.asList(new Collection(COLLECTION_NAME))).build();
        PrivilegeObject updatePrivilege1 = new PrivilegeObject.Builder().setComponent("solr").setAction("update").setService(service1).setAuthorizables(Arrays.asList(new Collection(COLLECTION_NAME), new Field(FIELD_NAME))).build();
        PrivilegeObject queryPrivilege2 = new PrivilegeObject.Builder().setComponent("solr").setAction("query").setService(service1).setAuthorizables(Arrays.asList(new Collection(COLLECTION_NAME))).build();
        PrivilegeObject updatePrivilege2 = new PrivilegeObject.Builder().setComponent("solr").setAction("update").setService(service1).setAuthorizables(Arrays.asList(new Collection(COLLECTION_NAME), new Field(FIELD_NAME))).build();
        sentryStore.createRole("solr", roleName1, grantor);
        sentryStore.createRole("solr", roleName2, grantor);
        sentryStore.createRole("solr", roleName3, grantor);
        sentryStore.alterRoleAddGroups("solr", roleName3, (Set)Sets.newHashSet((Object[])new String[]{group}), grantor);
        sentryStore.alterRoleGrantPrivilege("solr", roleName1, queryPrivilege1, grantor);
        sentryStore.alterRoleGrantPrivilege("solr", roleName1, updatePrivilege1, grantor);
        sentryStore.alterRoleGrantPrivilege("solr", roleName2, queryPrivilege2, grantor);
        sentryStore.alterRoleGrantPrivilege("solr", roleName3, updatePrivilege2, grantor);
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new PrivilegeObject[]{updatePrivilege1, queryPrivilege1}), (Object)sentryStore.getPrivilegesByProvider("solr", service1, (Set)Sets.newHashSet((Object[])new String[]{roleName1}), null, null));
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new PrivilegeObject[]{updatePrivilege1, queryPrivilege1, queryPrivilege2}), (Object)sentryStore.getPrivilegesByProvider("solr", service1, (Set)Sets.newHashSet((Object[])new String[]{roleName1, roleName2}), null, null));
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new PrivilegeObject[]{updatePrivilege1, queryPrivilege1, queryPrivilege2, updatePrivilege2}), (Object)sentryStore.getPrivilegesByProvider("solr", service1, (Set)Sets.newHashSet((Object[])new String[]{roleName1, roleName2}), (Set)Sets.newHashSet((Object[])new String[]{group}), null));
        List<SearchModelAuthorizable> authorizables = Arrays.asList(new Collection(COLLECTION_NAME), new Field(FIELD_NAME));
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new PrivilegeObject[]{updatePrivilege1, updatePrivilege2}), (Object)sentryStore.getPrivilegesByProvider("solr", service1, (Set)Sets.newHashSet((Object[])new String[]{roleName1, roleName2}), (Set)Sets.newHashSet((Object[])new String[]{group}), authorizables));
    }
}

