/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.generic.service.persistent;

import com.google.common.io.Files;
import java.io.File;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.sentry.provider.db.generic.service.persistent.DelegateSentryStore;
import org.apache.sentry.provider.file.PolicyFile;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.BeforeClass;

public abstract class SentryStoreIntegrationBase {
    protected static final String[] adminGroups = new String[]{"adminGroup"};
    private static File dataDir;
    private static File policyFilePath;
    private static Configuration conf;
    protected static DelegateSentryStore sentryStore;
    protected static PolicyFile policyFile;

    @BeforeClass
    public static void setup() throws Exception {
        conf = new Configuration(false);
        SentryStoreIntegrationBase.setup(conf);
        sentryStore = new DelegateSentryStore(conf);
    }

    private static void setup(Configuration conf) throws Exception {
        dataDir = new File(Files.createTempDir(), "sentry_policy_db");
        conf.set("sentry.verify.schema.version", "false");
        conf.set("sentry.store.jdbc.url", "jdbc:derby:;databaseName=" + dataDir.getPath() + ";create=true");
        conf.set("sentry.store.jdbc.password", "dummy");
        conf.setStrings("sentry.service.admin.group", adminGroups);
        conf.set("sentry.store.group.mapping", "org.apache.sentry.provider.file.LocalGroupMappingService");
        policyFilePath = new File(Files.createTempDir(), "local_policy_file.ini");
        conf.set("sentry.store.group.mapping.resource", policyFilePath.getPath());
    }

    @After
    public void clearData() {
        sentryStore.clearAllTables();
    }

    @AfterClass
    public static void teardown() {
        if (sentryStore != null) {
            sentryStore.close();
        }
        if (dataDir != null) {
            FileUtils.deleteQuietly((File)dataDir);
        }
        if (policyFilePath != null) {
            FileUtils.deleteQuietly((File)policyFilePath);
        }
    }

    public static void addGroupsToUser(String user, String ... groupNames) {
        policyFile.addGroupsToUser(user, groupNames);
    }

    public static void writePolicyFile() throws Exception {
        policyFile.write(policyFilePath);
    }

    public String[] getAdminGroups() {
        return adminGroups;
    }
}

