/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.service.persistent;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.sentry.SentryUserException;

public class SentryStoreSchemaInfo {
    private static String SQL_FILE_EXTENSION = ".sql";
    private static String UPGRADE_FILE_PREFIX = "upgrade-";
    private static String INIT_FILE_PREFIX = "sentry-";
    private static String VERSION_UPGRADE_LIST = "upgrade.order";
    private final String dbType;
    private final String[] sentrySchemaVersions;
    private final String sentryScriptDir;
    private static final String SENTRY_VERSION = "1.4.0";

    public SentryStoreSchemaInfo(String sentryScriptDir, String dbType) throws SentryUserException {
        this.sentryScriptDir = sentryScriptDir;
        this.dbType = dbType;
        ArrayList<String> upgradeOrderList = new ArrayList<String>();
        String upgradeListFile = this.getSentryStoreScriptDir() + File.separator + VERSION_UPGRADE_LIST + "." + dbType;
        try {
            String currSchemaVersion;
            BufferedReader bfReader = new BufferedReader(new FileReader(upgradeListFile));
            while ((currSchemaVersion = bfReader.readLine()) != null) {
                upgradeOrderList.add(currSchemaVersion.trim());
            }
        }
        catch (FileNotFoundException e) {
            throw new SentryUserException("File " + upgradeListFile + "not found ", (Throwable)e);
        }
        catch (IOException e) {
            throw new SentryUserException("Error reading " + upgradeListFile, (Throwable)e);
        }
        this.sentrySchemaVersions = upgradeOrderList.toArray(new String[0]);
    }

    public String getSentrySchemaVersion() {
        return SENTRY_VERSION;
    }

    public List<String> getUpgradeScripts(String fromSchemaVer) {
        return new ArrayList<String>();
    }

    public String generateInitFileName(String toVersion) throws SentryUserException {
        if (toVersion == null) {
            toVersion = SentryStoreSchemaInfo.getSentryVersion();
        }
        String initScriptName = INIT_FILE_PREFIX + this.dbType + "-" + toVersion + SQL_FILE_EXTENSION;
        if (!new File(this.getSentryStoreScriptDir() + File.separatorChar + initScriptName).exists()) {
            throw new SentryUserException("Unknown version specified for initialization: " + toVersion);
        }
        return initScriptName;
    }

    public String getSentryStoreScriptDir() {
        return this.sentryScriptDir;
    }

    private String generateUpgradeFileName(String fileVersion) {
        return UPGRADE_FILE_PREFIX + fileVersion + "." + this.dbType + SQL_FILE_EXTENSION;
    }

    public static String getSentryVersion() {
        return SENTRY_VERSION;
    }
}

