/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db.service.persistent;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import javax.jdo.JDODataStoreException;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.Query;
import javax.jdo.Transaction;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.sentry.core.model.db.DBModelAuthorizable;
import org.apache.sentry.provider.common.ProviderConstants;
import org.apache.sentry.provider.db.SentryAccessDeniedException;
import org.apache.sentry.provider.db.SentryAlreadyExistsException;
import org.apache.sentry.provider.db.SentryInvalidInputException;
import org.apache.sentry.provider.db.SentryNoSuchObjectException;
import org.apache.sentry.provider.db.service.model.MSentryGroup;
import org.apache.sentry.provider.db.service.model.MSentryPrivilege;
import org.apache.sentry.provider.db.service.model.MSentryRole;
import org.apache.sentry.provider.db.service.model.MSentryVersion;
import org.apache.sentry.provider.db.service.persistent.CommitContext;
import org.apache.sentry.provider.db.service.persistent.SentryStoreSchemaInfo;
import org.apache.sentry.provider.db.service.thrift.TSentryActiveRoleSet;
import org.apache.sentry.provider.db.service.thrift.TSentryAuthorizable;
import org.apache.sentry.provider.db.service.thrift.TSentryGroup;
import org.apache.sentry.provider.db.service.thrift.TSentryPrivilege;
import org.apache.sentry.provider.db.service.thrift.TSentryRole;
import org.apache.sentry.service.thrift.ServiceConstants;
import org.datanucleus.store.rdbms.exceptions.MissingTableException;

public class SentryStore {
    private static final UUID SERVER_UUID = UUID.randomUUID();
    static final String DEFAULT_DATA_DIR = "sentry_policy_db";
    private long commitSequenceId = 0L;
    private final PersistenceManagerFactory pmf;

    public SentryStore(Configuration conf) throws SentryNoSuchObjectException, SentryAccessDeniedException {
        Properties prop = new Properties();
        prop.putAll((Map<?, ?>)ServiceConstants.ServerConfig.SENTRY_STORE_DEFAULTS);
        String jdbcUrl = conf.get("sentry.store.jdbc.url", "").trim();
        Preconditions.checkArgument((!jdbcUrl.isEmpty() ? 1 : 0) != 0, (Object)"Required parameter sentry.store.jdbc.url missing");
        String user = conf.get("sentry.store.jdbc.user", "Sentry").trim();
        String pass = conf.get("sentry.store.jdbc.password", "Sentry").trim();
        String driverName = conf.get("sentry.store.jdbc.driver", "org.apache.derby.jdbc.EmbeddedDriver");
        prop.setProperty("javax.jdo.option.ConnectionURL", jdbcUrl);
        prop.setProperty("javax.jdo.option.ConnectionUserName", user);
        prop.setProperty("javax.jdo.option.ConnectionPassword", pass);
        prop.setProperty("javax.jdo.option.ConnectionDriverName", driverName);
        for (Map.Entry entry : conf) {
            String key = (String)entry.getKey();
            if (!key.startsWith("sentry.javax.jdo") && !key.startsWith("sentry.datanucleus")) continue;
            key = StringUtils.removeStart((String)key, (String)"sentry.");
            prop.setProperty(key, (String)entry.getValue());
        }
        boolean checkSchemaVersion = conf.get("sentry.verify.schema.version", "true").equalsIgnoreCase("true");
        if (!checkSchemaVersion) {
            prop.setProperty("datanucleus.autoCreateSchema", "true");
            prop.setProperty("datanucleus.fixedDatastore", "false");
        }
        this.pmf = JDOHelper.getPersistenceManagerFactory((Map)prop);
        this.verifySentryStoreSchema(conf, checkSchemaVersion);
    }

    private void verifySentryStoreSchema(Configuration serverConf, boolean checkVersion) throws SentryNoSuchObjectException, SentryAccessDeniedException {
        if (!checkVersion) {
            this.setSentryVersion(SentryStoreSchemaInfo.getSentryVersion(), "Schema version set implicitly");
        } else {
            String currentVersion = this.getSentryVersion();
            if (!SentryStoreSchemaInfo.getSentryVersion().equals(currentVersion)) {
                throw new SentryAccessDeniedException("The Sentry store schema version " + currentVersion + " is different from distribution version " + SentryStoreSchemaInfo.getSentryVersion());
            }
        }
    }

    public synchronized void stop() {
        if (this.pmf != null) {
            this.pmf.close();
        }
    }

    private synchronized PersistenceManager openTransaction() {
        PersistenceManager pm = this.pmf.getPersistenceManager();
        Transaction currentTransaction = pm.currentTransaction();
        currentTransaction.begin();
        return pm;
    }

    private synchronized CommitContext commitUpdateTransaction(PersistenceManager pm) {
        this.commitTransaction(pm);
        return new CommitContext(SERVER_UUID, this.incrementGetSequenceId());
    }

    private synchronized long incrementGetSequenceId() {
        return ++this.commitSequenceId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitTransaction(PersistenceManager pm) {
        Transaction currentTransaction = pm.currentTransaction();
        try {
            Preconditions.checkState((boolean)currentTransaction.isActive(), (Object)"Transaction is not active");
            currentTransaction.commit();
        }
        finally {
            pm.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rollbackTransaction(PersistenceManager pm) {
        if (pm == null || pm.isClosed()) {
            return;
        }
        Transaction currentTransaction = pm.currentTransaction();
        if (currentTransaction.isActive()) {
            try {
                currentTransaction.rollback();
            }
            finally {
                pm.close();
            }
        }
    }

    private MSentryRole getMSentryRole(PersistenceManager pm, String roleName) {
        Query query = pm.newQuery(MSentryRole.class);
        query.setFilter("this.roleName == t");
        query.declareParameters("java.lang.String t");
        query.setUnique(true);
        MSentryRole sentryRole = (MSentryRole)query.execute((Object)roleName);
        return sentryRole;
    }

    private String trimAndLower(String input) {
        return input.trim().toLowerCase();
    }

    public CommitContext createSentryRole(String roleName, String grantorPrincipal) throws SentryAlreadyExistsException {
        roleName = this.trimAndLower(roleName);
        boolean rollbackTransaction = true;
        PersistenceManager pm = null;
        try {
            pm = this.openTransaction();
            MSentryRole mSentryRole = this.getMSentryRole(pm, roleName);
            if (mSentryRole == null) {
                MSentryRole mRole = new MSentryRole(roleName, System.currentTimeMillis(), grantorPrincipal);
                pm.makePersistent((Object)mRole);
                CommitContext commit = this.commitUpdateTransaction(pm);
                rollbackTransaction = false;
                CommitContext commitContext = commit;
                return commitContext;
            }
            throw new SentryAlreadyExistsException("Role: " + roleName);
        }
        finally {
            if (rollbackTransaction) {
                this.rollbackTransaction(pm);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommitContext alterSentryRoleGrantPrivilege(String roleName, TSentryPrivilege privilege) throws SentryNoSuchObjectException, SentryInvalidInputException {
        boolean rollbackTransaction = true;
        PersistenceManager pm = null;
        roleName = this.trimAndLower(roleName);
        try {
            pm = this.openTransaction();
            this.alterSentryRoleGrantPrivilegeCore(pm, roleName, privilege);
            CommitContext commit = this.commitUpdateTransaction(pm);
            rollbackTransaction = false;
            CommitContext commitContext = commit;
            return commitContext;
        }
        finally {
            if (rollbackTransaction) {
                this.rollbackTransaction(pm);
            }
        }
    }

    private void alterSentryRoleGrantPrivilegeCore(PersistenceManager pm, String roleName, TSentryPrivilege privilege) throws SentryNoSuchObjectException, SentryInvalidInputException {
        MSentryPrivilege mPrivilege;
        MSentryRole mRole = this.getMSentryRole(pm, roleName);
        if (mRole == null) {
            throw new SentryNoSuchObjectException("Role: " + roleName);
        }
        if (privilege.getTableName() != null || privilege.getDbName() != null) {
            if (privilege.getAction().equalsIgnoreCase("*")) {
                TSentryPrivilege tNotAll = new TSentryPrivilege(privilege);
                tNotAll.setAction("select");
                MSentryPrivilege mSelect = this.getMSentryPrivilege(SentryStore.constructPrivilegeName(tNotAll), pm);
                tNotAll.setAction("insert");
                MSentryPrivilege mInsert = this.getMSentryPrivilege(SentryStore.constructPrivilegeName(tNotAll), pm);
                if (mSelect != null && mRole.getPrivileges().contains(mSelect)) {
                    mSelect.removeRole(mRole);
                    pm.makePersistent((Object)mSelect);
                }
                if (mInsert != null && mRole.getPrivileges().contains(mInsert)) {
                    mInsert.removeRole(mRole);
                    pm.makePersistent((Object)mInsert);
                }
            } else {
                TSentryPrivilege tAll = new TSentryPrivilege(privilege);
                tAll.setAction("*");
                MSentryPrivilege mAll = this.getMSentryPrivilege(SentryStore.constructPrivilegeName(tAll), pm);
                if (mAll != null && mRole.getPrivileges().contains(mAll)) {
                    return;
                }
            }
        }
        if ((mPrivilege = this.getMSentryPrivilege(SentryStore.constructPrivilegeName(privilege), pm)) == null) {
            mPrivilege = this.convertToMSentryPrivilege(privilege);
        }
        mPrivilege.appendRole(mRole);
        pm.makePersistent((Object)mRole);
        pm.makePersistent((Object)mPrivilege);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommitContext alterSentryRoleRevokePrivilege(String roleName, TSentryPrivilege tPrivilege) throws SentryNoSuchObjectException, SentryInvalidInputException {
        boolean rollbackTransaction = true;
        PersistenceManager pm = null;
        roleName = SentryStore.safeTrimLower(roleName);
        try {
            pm = this.openTransaction();
            this.alterSentryRoleRevokePrivilegeCore(pm, roleName, tPrivilege);
            CommitContext commit = this.commitUpdateTransaction(pm);
            rollbackTransaction = false;
            CommitContext commitContext = commit;
            return commitContext;
        }
        finally {
            if (rollbackTransaction) {
                this.rollbackTransaction(pm);
            }
        }
    }

    private void alterSentryRoleRevokePrivilegeCore(PersistenceManager pm, String roleName, TSentryPrivilege tPrivilege) throws SentryNoSuchObjectException, SentryInvalidInputException {
        Query query = pm.newQuery(MSentryRole.class);
        query.setFilter("this.roleName == t");
        query.declareParameters("java.lang.String t");
        query.setUnique(true);
        MSentryRole mRole = (MSentryRole)query.execute((Object)roleName);
        if (mRole == null) {
            throw new SentryNoSuchObjectException("Role: " + roleName);
        }
        query = pm.newQuery(MSentryPrivilege.class);
        MSentryPrivilege mPrivilege = this.getMSentryPrivilege(SentryStore.constructPrivilegeName(tPrivilege), pm);
        mPrivilege = mPrivilege == null ? this.convertToMSentryPrivilege(tPrivilege) : (MSentryPrivilege)pm.detachCopy((Object)mPrivilege);
        HashSet privilegeGraph = Sets.newHashSet((Object[])new MSentryPrivilege[]{mPrivilege});
        this.populateChildren(Sets.newHashSet((Object[])new String[]{roleName}), mPrivilege, privilegeGraph);
        for (MSentryPrivilege childPriv : privilegeGraph) {
            this.revokePartial(pm, tPrivilege, mRole, childPriv);
        }
        pm.makePersistent((Object)mRole);
    }

    private void revokePartial(PersistenceManager pm, TSentryPrivilege requestedPrivToRevoke, MSentryRole mRole, MSentryPrivilege currentPrivilege) throws SentryInvalidInputException {
        MSentryPrivilege persistedPriv = this.getMSentryPrivilege(SentryStore.constructPrivilegeName(this.convertToTSentryPrivilege(currentPrivilege)), pm);
        if (persistedPriv == null) {
            persistedPriv = this.convertToMSentryPrivilege(this.convertToTSentryPrivilege(currentPrivilege));
        }
        if (requestedPrivToRevoke.getAction().equalsIgnoreCase("ALL") || requestedPrivToRevoke.getAction().equalsIgnoreCase("*")) {
            persistedPriv.removeRole(mRole);
            pm.makePersistent((Object)persistedPriv);
        } else if (requestedPrivToRevoke.getAction().equalsIgnoreCase("select") && !currentPrivilege.getAction().equalsIgnoreCase("insert")) {
            this.revokeRolePartial(pm, mRole, currentPrivilege, persistedPriv, "insert");
        } else if (requestedPrivToRevoke.getAction().equalsIgnoreCase("insert") && !currentPrivilege.getAction().equalsIgnoreCase("select")) {
            this.revokeRolePartial(pm, mRole, currentPrivilege, persistedPriv, "select");
        }
    }

    private void revokeRolePartial(PersistenceManager pm, MSentryRole mRole, MSentryPrivilege currentPrivilege, MSentryPrivilege persistedPriv, String addAction) throws SentryInvalidInputException {
        persistedPriv.removeRole(mRole);
        pm.makePersistent((Object)persistedPriv);
        currentPrivilege.setAction("*");
        persistedPriv = this.getMSentryPrivilege(SentryStore.constructPrivilegeName(this.convertToTSentryPrivilege(currentPrivilege)), pm);
        if (persistedPriv != null && mRole.getPrivileges().contains(persistedPriv)) {
            persistedPriv.removeRole(mRole);
            pm.makePersistent((Object)persistedPriv);
            currentPrivilege.setAction(addAction);
            persistedPriv = this.getMSentryPrivilege(SentryStore.constructPrivilegeName(this.convertToTSentryPrivilege(currentPrivilege)), pm);
            if (persistedPriv == null) {
                persistedPriv = this.convertToMSentryPrivilege(this.convertToTSentryPrivilege(currentPrivilege));
                mRole.appendPrivilege(persistedPriv);
            }
            persistedPriv.appendRole(mRole);
            pm.makePersistent((Object)persistedPriv);
        }
    }

    private void populateChildren(Set<String> roleNames, MSentryPrivilege priv, Set<MSentryPrivilege> children) throws SentryInvalidInputException {
        if (priv.getServerName() != null || priv.getDbName() != null) {
            Set<MSentryPrivilege> childPrivs = this.getChildPrivileges(roleNames, priv);
            for (MSentryPrivilege childPriv : childPrivs) {
                if (childPriv.getDbName() != null && childPriv.getTableName() == null) {
                    this.populateChildren(roleNames, childPriv, children);
                }
                children.add(childPriv);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<MSentryPrivilege> getChildPrivileges(Set<String> roleNames, MSentryPrivilege parent) throws SentryInvalidInputException {
        if (parent.getTableName() != null || parent.getURI() != null) {
            return new HashSet<MSentryPrivilege>();
        }
        boolean rollbackTransaction = true;
        PersistenceManager pm = null;
        try {
            pm = this.openTransaction();
            Query query = pm.newQuery(MSentryPrivilege.class);
            query.declareVariables("org.apache.sentry.provider.db.service.model.MSentryRole role");
            LinkedList<String> rolesFiler = new LinkedList<String>();
            for (String rName : roleNames) {
                rolesFiler.add("role.roleName == \"" + rName.trim().toLowerCase() + "\"");
            }
            StringBuilder filters = new StringBuilder("roles.contains(role) && (" + Joiner.on((String)" || ").join(rolesFiler) + ")");
            filters.append(" && serverName == \"" + parent.getServerName() + "\"");
            if (parent.getDbName() != null) {
                filters.append(" && dbName == \"" + parent.getDbName() + "\"");
                filters.append(" && tableName != null");
            } else {
                filters.append(" && (dbName != null || URI != null)");
            }
            query.setFilter(filters.toString());
            query.setResult("privilegeScope, serverName, dbName, tableName, URI, action, grantorPrincipal");
            HashSet<MSentryPrivilege> privileges = new HashSet<MSentryPrivilege>();
            for (Object[] privObj : (List)query.execute()) {
                MSentryPrivilege priv = new MSentryPrivilege();
                priv.setPrivilegeScope((String)privObj[0]);
                priv.setServerName((String)privObj[1]);
                priv.setDbName((String)privObj[2]);
                priv.setTableName((String)privObj[3]);
                priv.setURI((String)privObj[4]);
                priv.setAction((String)privObj[5]);
                priv.setGrantorPrincipal((String)privObj[6]);
                priv.setPrivilegeName(SentryStore.constructPrivilegeName(this.convertToTSentryPrivilege(priv)));
                privileges.add(priv);
            }
            rollbackTransaction = false;
            this.commitTransaction(pm);
            HashSet<MSentryPrivilege> hashSet = privileges;
            return hashSet;
        }
        finally {
            if (rollbackTransaction) {
                this.rollbackTransaction(pm);
            }
        }
    }

    private MSentryPrivilege getMSentryPrivilege(String privilegeName, PersistenceManager pm) {
        Query query = pm.newQuery(MSentryPrivilege.class);
        query.setFilter("this.privilegeName == t");
        query.declareParameters("java.lang.String t");
        query.setUnique(true);
        Object obj = query.execute((Object)privilegeName);
        if (obj != null) {
            return (MSentryPrivilege)obj;
        }
        return null;
    }

    @VisibleForTesting
    public static String constructPrivilegeName(TSentryPrivilege privilege) throws SentryInvalidInputException {
        ServiceConstants.PrivilegeScope scope;
        StringBuilder privilegeName = new StringBuilder();
        String serverName = SentryStore.safeTrimLower(privilege.getServerName());
        String dbName = SentryStore.safeTrimLower(privilege.getDbName());
        String tableName = SentryStore.safeTrimLower(privilege.getTableName());
        String uri = privilege.getURI();
        String action = SentryStore.safeTrimLower(privilege.getAction());
        if (serverName == null) {
            throw new SentryInvalidInputException("Server name is null");
        }
        if (("select".equalsIgnoreCase(action) || "insert".equalsIgnoreCase(action)) && Strings.nullToEmpty((String)tableName).trim().isEmpty() && Strings.nullToEmpty((String)dbName).trim().isEmpty()) {
            throw new SentryInvalidInputException("Either Table name or Db name must be NON-NULL for SELECT/INSERT privilege");
        }
        if (action == null) {
            action = "*";
        }
        try {
            scope = Enum.valueOf(ServiceConstants.PrivilegeScope.class, privilege.getPrivilegeScope().toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new SentryInvalidInputException("Invalid Privilege scope: " + privilege.getPrivilegeScope());
        }
        if (ServiceConstants.PrivilegeScope.SERVER.equals((Object)scope)) {
            if (StringUtils.isNotEmpty((String)dbName) || StringUtils.isNotEmpty((String)tableName)) {
                throw new SentryInvalidInputException("DB and TABLE names should not be set for SERVER scope");
            }
        } else if (ServiceConstants.PrivilegeScope.DATABASE.equals((Object)scope)) {
            if (StringUtils.isEmpty((String)dbName)) {
                throw new SentryInvalidInputException("DB name not set for DB scope");
            }
            if (StringUtils.isNotEmpty((String)tableName)) {
                StringUtils.isNotEmpty((String)"TABLE names should not be set for DB scope");
            }
        } else if (ServiceConstants.PrivilegeScope.TABLE.equals((Object)scope)) {
            if (StringUtils.isEmpty((String)dbName) || StringUtils.isEmpty((String)tableName)) {
                throw new SentryInvalidInputException("TABLE or DB name not set for TABLE scope");
            }
        } else if (ServiceConstants.PrivilegeScope.URI.equals((Object)scope)) {
            if (StringUtils.isEmpty((String)uri)) {
                throw new SentryInvalidInputException("URI path not set for URI scope");
            }
            if (StringUtils.isNotEmpty((String)tableName)) {
                throw new SentryInvalidInputException("TABLE should not be set for URI scope");
            }
        } else {
            throw new SentryInvalidInputException("Unsupported operation scope: " + (Object)((Object)scope));
        }
        if (uri == null || uri.equals("")) {
            privilegeName.append(serverName);
            privilegeName.append("+");
            privilegeName.append(dbName);
            if (tableName != null && !tableName.equals("")) {
                privilegeName.append("+");
                privilegeName.append(tableName);
            }
            privilegeName.append("+");
            privilegeName.append(action);
        } else {
            privilegeName.append(serverName);
            privilegeName.append("+");
            privilegeName.append(uri);
        }
        return privilegeName.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommitContext dropSentryRole(String roleName) throws SentryNoSuchObjectException {
        boolean rollbackTransaction = true;
        PersistenceManager pm = null;
        roleName = roleName.trim().toLowerCase();
        try {
            pm = this.openTransaction();
            Query query = pm.newQuery(MSentryRole.class);
            query.setFilter("this.roleName == t");
            query.declareParameters("java.lang.String t");
            query.setUnique(true);
            MSentryRole sentryRole = (MSentryRole)query.execute((Object)roleName);
            if (sentryRole == null) {
                throw new SentryNoSuchObjectException("Role " + roleName);
            }
            pm.retrieve((Object)sentryRole);
            sentryRole.removePrivileges();
            pm.deletePersistent((Object)sentryRole);
            CommitContext commit = this.commitUpdateTransaction(pm);
            rollbackTransaction = false;
            CommitContext commitContext = commit;
            return commitContext;
        }
        finally {
            if (rollbackTransaction) {
                this.rollbackTransaction(pm);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommitContext alterSentryRoleAddGroups(String grantorPrincipal, String roleName, Set<TSentryGroup> groupNames) throws SentryNoSuchObjectException {
        boolean rollbackTransaction = true;
        PersistenceManager pm = null;
        roleName = roleName.trim().toLowerCase();
        try {
            pm = this.openTransaction();
            Query query = pm.newQuery(MSentryRole.class);
            query.setFilter("this.roleName == t");
            query.declareParameters("java.lang.String t");
            query.setUnique(true);
            MSentryRole role = (MSentryRole)query.execute((Object)roleName);
            if (role == null) {
                throw new SentryNoSuchObjectException("Role: " + roleName);
            }
            query = pm.newQuery(MSentryGroup.class);
            query.setFilter("this.groupName == t");
            query.declareParameters("java.lang.String t");
            query.setUnique(true);
            ArrayList groups = Lists.newArrayList();
            for (TSentryGroup tGroup : groupNames) {
                String groupName = tGroup.getGroupName().trim();
                MSentryGroup group = (MSentryGroup)query.execute((Object)groupName);
                if (group == null) {
                    group = new MSentryGroup(groupName, System.currentTimeMillis(), grantorPrincipal, Sets.newHashSet((Object[])new MSentryRole[]{role}));
                }
                group.appendRole(role);
                groups.add(group);
            }
            pm.makePersistentAll((Collection)groups);
            CommitContext commit = this.commitUpdateTransaction(pm);
            rollbackTransaction = false;
            CommitContext commitContext = commit;
            return commitContext;
        }
        finally {
            if (rollbackTransaction) {
                this.rollbackTransaction(pm);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommitContext alterSentryRoleDeleteGroups(String roleName, Set<TSentryGroup> groupNames) throws SentryNoSuchObjectException {
        boolean rollbackTransaction = true;
        PersistenceManager pm = null;
        roleName = roleName.trim().toLowerCase();
        try {
            pm = this.openTransaction();
            Query query = pm.newQuery(MSentryRole.class);
            query.setFilter("this.roleName == t");
            query.declareParameters("java.lang.String t");
            query.setUnique(true);
            MSentryRole role = (MSentryRole)query.execute((Object)roleName);
            if (role == null) {
                throw new SentryNoSuchObjectException("Role: " + roleName);
            }
            query = pm.newQuery(MSentryGroup.class);
            query.setFilter("this.groupName == t");
            query.declareParameters("java.lang.String t");
            query.setUnique(true);
            ArrayList groups = Lists.newArrayList();
            for (TSentryGroup tGroup : groupNames) {
                String groupName = tGroup.getGroupName().trim();
                MSentryGroup group = (MSentryGroup)query.execute((Object)groupName);
                if (group == null) continue;
                group.removeRole(role);
                groups.add(group);
            }
            pm.makePersistentAll((Collection)groups);
            CommitContext commit = this.commitUpdateTransaction(pm);
            rollbackTransaction = false;
            CommitContext commitContext = commit;
            return commitContext;
        }
        finally {
            if (rollbackTransaction) {
                this.rollbackTransaction(pm);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    MSentryRole getMSentryRoleByName(String roleName) throws SentryNoSuchObjectException {
        boolean rollbackTransaction = true;
        PersistenceManager pm = null;
        roleName = roleName.trim().toLowerCase();
        try {
            pm = this.openTransaction();
            Query query = pm.newQuery(MSentryRole.class);
            query.setFilter("this.roleName == t");
            query.declareParameters("java.lang.String t");
            query.setUnique(true);
            MSentryRole sentryRole = (MSentryRole)query.execute((Object)roleName);
            if (sentryRole == null) {
                throw new SentryNoSuchObjectException("Role " + roleName);
            }
            pm.retrieve((Object)sentryRole);
            rollbackTransaction = false;
            this.commitTransaction(pm);
            MSentryRole mSentryRole = sentryRole;
            return mSentryRole;
        }
        finally {
            if (rollbackTransaction) {
                this.rollbackTransaction(pm);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasAnyServerPrivileges(Set<String> roleNames, String serverName) {
        if (roleNames.size() == 0 || roleNames == null) {
            return false;
        }
        boolean rollbackTransaction = true;
        PersistenceManager pm = null;
        try {
            pm = this.openTransaction();
            Query query = pm.newQuery(MSentryPrivilege.class);
            query.declareVariables("org.apache.sentry.provider.db.service.model.MSentryRole role");
            LinkedList<String> rolesFiler = new LinkedList<String>();
            for (String rName : roleNames) {
                rolesFiler.add("role.roleName == \"" + rName.trim().toLowerCase() + "\"");
            }
            StringBuilder filters = new StringBuilder("roles.contains(role) && (" + Joiner.on((String)" || ").join(rolesFiler) + ") ");
            filters.append("&& serverName == \"" + serverName + "\"");
            query.setFilter(filters.toString());
            query.setResult("count(this)");
            Long numPrivs = (Long)query.execute();
            rollbackTransaction = false;
            this.commitTransaction(pm);
            boolean bl = numPrivs > 0L;
            return bl;
        }
        finally {
            if (rollbackTransaction) {
                this.rollbackTransaction(pm);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<MSentryPrivilege> getMSentryPrivileges(Set<String> roleNames, TSentryAuthorizable authHierarchy) {
        if (roleNames.size() == 0 || roleNames == null) {
            return new ArrayList<MSentryPrivilege>();
        }
        boolean rollbackTransaction = true;
        PersistenceManager pm = null;
        try {
            pm = this.openTransaction();
            Query query = pm.newQuery(MSentryPrivilege.class);
            query.declareVariables("org.apache.sentry.provider.db.service.model.MSentryRole role");
            LinkedList<String> rolesFiler = new LinkedList<String>();
            for (String rName : roleNames) {
                rolesFiler.add("role.roleName == \"" + rName.trim().toLowerCase() + "\"");
            }
            StringBuilder filters = new StringBuilder("roles.contains(role) && (" + Joiner.on((String)" || ").join(rolesFiler) + ") ");
            if (authHierarchy != null && authHierarchy.getServer() != null) {
                filters.append("&& serverName == \"" + authHierarchy.getServer().toLowerCase() + "\"");
                if (authHierarchy.getDb() != null) {
                    filters.append(" && ((dbName == \"" + authHierarchy.getDb().toLowerCase() + "\") || (dbName == null)) && (URI == null)");
                    if (authHierarchy.getTable() != null && !"*".equalsIgnoreCase(authHierarchy.getTable())) {
                        filters.append(" && ((tableName == \"" + authHierarchy.getTable().toLowerCase() + "\") || (tableName == null)) && (URI == null)");
                    }
                }
                if (authHierarchy.getUri() != null) {
                    filters.append(" && ((\"" + authHierarchy.getUri() + "\".startsWith(URI)) || (URI == null)) && (dbName == null)");
                }
            }
            query.setFilter(filters.toString());
            List privileges = (List)query.execute();
            rollbackTransaction = false;
            this.commitTransaction(pm);
            List list = privileges;
            return list;
        }
        finally {
            if (rollbackTransaction) {
                this.rollbackTransaction(pm);
            }
        }
    }

    private Set<MSentryPrivilege> getMSentryPrivilegesByRoleName(String roleName) throws SentryNoSuchObjectException {
        MSentryRole mSentryRole = this.getMSentryRoleByName(roleName);
        return mSentryRole.getPrivileges();
    }

    public Set<TSentryPrivilege> getAllTSentryPrivilegesByRoleName(String roleName) throws SentryNoSuchObjectException {
        return this.convertToTSentryPrivileges(this.getMSentryPrivilegesByRoleName(roleName));
    }

    public Set<TSentryPrivilege> getTSentryPrivileges(Set<String> roleNames, TSentryAuthorizable authHierarchy) throws SentryInvalidInputException {
        if (authHierarchy.getServer() == null) {
            throw new SentryInvalidInputException("serverName cannot be null !!");
        }
        if (authHierarchy.getTable() != null && authHierarchy.getDb() == null) {
            throw new SentryInvalidInputException("dbName cannot be null when tableName is present !!");
        }
        if (authHierarchy.getUri() == null && authHierarchy.getDb() == null) {
            throw new SentryInvalidInputException("One of uri or dbName must not be null !!");
        }
        return this.convertToTSentryPrivileges(this.getMSentryPrivileges(roleNames, authHierarchy));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<MSentryRole> getMSentryRolesByGroupName(String groupName) throws SentryNoSuchObjectException {
        boolean rollbackTransaction = true;
        PersistenceManager pm = null;
        try {
            Set<MSentryRole> roles;
            Query query;
            pm = this.openTransaction();
            if (groupName == null) {
                query = pm.newQuery(MSentryRole.class);
                roles = new HashSet<MSentryRole>((List)query.execute());
            } else {
                query = pm.newQuery(MSentryGroup.class);
                groupName = groupName.trim();
                query.setFilter("this.groupName == t");
                query.declareParameters("java.lang.String t");
                query.setUnique(true);
                MSentryGroup sentryGroup = (MSentryGroup)query.execute((Object)groupName);
                if (sentryGroup == null) {
                    throw new SentryNoSuchObjectException("Group " + groupName);
                }
                pm.retrieve((Object)sentryGroup);
                roles = sentryGroup.getRoles();
            }
            for (MSentryRole role : roles) {
                pm.retrieve((Object)role);
            }
            this.commitTransaction(pm);
            rollbackTransaction = false;
            HashSet<MSentryRole> hashSet = roles;
            return hashSet;
        }
        finally {
            if (rollbackTransaction) {
                this.rollbackTransaction(pm);
            }
        }
    }

    public Set<TSentryRole> getTSentryRolesByGroupName(Set<String> groupNames, boolean checkAllGroups) throws SentryNoSuchObjectException {
        HashSet roleSet = Sets.newHashSet();
        for (String groupName : groupNames) {
            try {
                roleSet.addAll(this.getMSentryRolesByGroupName(groupName));
            }
            catch (SentryNoSuchObjectException e) {
                if (checkAllGroups) continue;
                throw e;
            }
        }
        return this.convertToTSentryRoles(roleSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SetMultimap<String, String> getRoleToPrivilegeMap(Set<String> groups) {
        HashMultimap result = HashMultimap.create();
        boolean rollbackTransaction = true;
        PersistenceManager pm = null;
        try {
            pm = this.openTransaction();
            Query query = pm.newQuery(MSentryGroup.class);
            query.setFilter("this.groupName == t");
            query.declareParameters("java.lang.String t");
            query.setUnique(true);
            for (String group : groups) {
                MSentryGroup sentryGroup = (MSentryGroup)query.execute((Object)group.trim());
                if (sentryGroup == null) continue;
                for (MSentryRole role : sentryGroup.getRoles()) {
                    for (MSentryPrivilege privilege : role.getPrivileges()) {
                        result.put((Object)role.getRoleName(), (Object)SentryStore.toAuthorizable(privilege));
                    }
                }
            }
            rollbackTransaction = false;
            this.commitTransaction(pm);
            HashMultimap hashMultimap = result;
            return hashMultimap;
        }
        finally {
            if (rollbackTransaction) {
                this.rollbackTransaction(pm);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getRoleNamesForGroups(Set<String> groups) {
        HashSet<String> result = new HashSet<String>();
        boolean rollbackTransaction = true;
        PersistenceManager pm = null;
        try {
            pm = this.openTransaction();
            Query query = pm.newQuery(MSentryGroup.class);
            query.setFilter("this.groupName == t");
            query.declareParameters("java.lang.String t");
            query.setUnique(true);
            for (String group : groups) {
                MSentryGroup sentryGroup = (MSentryGroup)query.execute((Object)group.trim());
                if (sentryGroup == null) continue;
                for (MSentryRole role : sentryGroup.getRoles()) {
                    result.add(role.getRoleName());
                }
            }
            rollbackTransaction = false;
            this.commitTransaction(pm);
            HashSet<String> hashSet = result;
            return hashSet;
        }
        finally {
            if (rollbackTransaction) {
                this.rollbackTransaction(pm);
            }
        }
    }

    public Set<String> listAllSentryPrivilegesForProvider(Set<String> groups, TSentryActiveRoleSet roleSet) throws SentryInvalidInputException {
        return this.listSentryPrivilegesForProvider(groups, roleSet, null);
    }

    public Set<String> listSentryPrivilegesForProvider(Set<String> groups, TSentryActiveRoleSet roleSet, TSentryAuthorizable authHierarchy) throws SentryInvalidInputException {
        HashSet result = Sets.newHashSet();
        Set<String> rolesToQuery = this.getRolesToQuery(groups, roleSet);
        List<MSentryPrivilege> mSentryPrivileges = this.getMSentryPrivileges(rolesToQuery, authHierarchy);
        for (MSentryPrivilege priv : mSentryPrivileges) {
            result.add(SentryStore.toAuthorizable(priv));
        }
        return result;
    }

    public boolean hasAnyServerPrivileges(Set<String> groups, TSentryActiveRoleSet roleSet, String server) {
        Set<String> rolesToQuery = this.getRolesToQuery(groups, roleSet);
        return this.hasAnyServerPrivileges(rolesToQuery, server);
    }

    private Set<String> getRolesToQuery(Set<String> groups, TSentryActiveRoleSet roleSet) {
        Set<String> activeRoleNames = SentryStore.toTrimedLower(roleSet.getRoles());
        Sets.SetView roleNamesForGroups = SentryStore.toTrimedLower(this.getRoleNamesForGroups(groups));
        Sets.SetView rolesToQuery = roleSet.isAll() ? roleNamesForGroups : Sets.intersection(activeRoleNames, roleNamesForGroups);
        return rolesToQuery;
    }

    @VisibleForTesting
    static String toAuthorizable(MSentryPrivilege privilege) {
        ArrayList<String> authorizable = new ArrayList<String>(4);
        authorizable.add(ProviderConstants.KV_JOINER.join((Object)DBModelAuthorizable.AuthorizableType.Server.name().toLowerCase(), (Object)privilege.getServerName(), new Object[0]));
        if (Strings.nullToEmpty((String)privilege.getURI()).isEmpty()) {
            if (!Strings.nullToEmpty((String)privilege.getDbName()).isEmpty()) {
                authorizable.add(ProviderConstants.KV_JOINER.join((Object)DBModelAuthorizable.AuthorizableType.Db.name().toLowerCase(), (Object)privilege.getDbName(), new Object[0]));
                if (!Strings.nullToEmpty((String)privilege.getTableName()).isEmpty()) {
                    authorizable.add(ProviderConstants.KV_JOINER.join((Object)DBModelAuthorizable.AuthorizableType.Table.name().toLowerCase(), (Object)privilege.getTableName(), new Object[0]));
                }
            }
        } else {
            authorizable.add(ProviderConstants.KV_JOINER.join((Object)DBModelAuthorizable.AuthorizableType.URI.name().toLowerCase(), (Object)privilege.getURI(), new Object[0]));
        }
        if (!Strings.nullToEmpty((String)privilege.getAction()).isEmpty() && !privilege.getAction().equalsIgnoreCase("*")) {
            authorizable.add(ProviderConstants.KV_JOINER.join((Object)"action".toLowerCase(), (Object)privilege.getAction(), new Object[0]));
        }
        return ProviderConstants.AUTHORIZABLE_JOINER.join(authorizable);
    }

    @VisibleForTesting
    static Set<String> toTrimedLower(Set<String> s) {
        if (null == s) {
            return new HashSet<String>();
        }
        HashSet result = Sets.newHashSet();
        for (String v : s) {
            result.add(v.trim().toLowerCase());
        }
        return result;
    }

    private Set<TSentryPrivilege> convertToTSentryPrivileges(Collection<MSentryPrivilege> mSentryPrivileges) {
        HashSet<TSentryPrivilege> privileges = new HashSet<TSentryPrivilege>();
        for (MSentryPrivilege mSentryPrivilege : mSentryPrivileges) {
            privileges.add(this.convertToTSentryPrivilege(mSentryPrivilege));
        }
        return privileges;
    }

    private Set<TSentryRole> convertToTSentryRoles(Set<MSentryRole> mSentryRoles) {
        HashSet<TSentryRole> roles = new HashSet<TSentryRole>();
        for (MSentryRole mSentryRole : mSentryRoles) {
            roles.add(this.convertToTSentryRole(mSentryRole));
        }
        return roles;
    }

    private TSentryRole convertToTSentryRole(MSentryRole mSentryRole) {
        TSentryRole role = new TSentryRole();
        role.setRoleName(mSentryRole.getRoleName());
        role.setGrantorPrincipal(mSentryRole.getGrantorPrincipal());
        HashSet<TSentryGroup> sentryGroups = new HashSet<TSentryGroup>();
        for (MSentryGroup mSentryGroup : mSentryRole.getGroups()) {
            TSentryGroup group = this.convertToTSentryGroup(mSentryGroup);
            sentryGroups.add(group);
        }
        role.setGroups(sentryGroups);
        return role;
    }

    private TSentryGroup convertToTSentryGroup(MSentryGroup mSentryGroup) {
        TSentryGroup group = new TSentryGroup();
        group.setGroupName(mSentryGroup.getGroupName());
        return group;
    }

    private TSentryPrivilege convertToTSentryPrivilege(MSentryPrivilege mSentryPrivilege) {
        TSentryPrivilege privilege = new TSentryPrivilege();
        privilege.setCreateTime(mSentryPrivilege.getCreateTime());
        privilege.setPrivilegeName(mSentryPrivilege.getPrivilegeName());
        privilege.setAction(mSentryPrivilege.getAction());
        privilege.setPrivilegeScope(mSentryPrivilege.getPrivilegeScope());
        privilege.setServerName(mSentryPrivilege.getServerName());
        privilege.setDbName(mSentryPrivilege.getDbName());
        privilege.setTableName(mSentryPrivilege.getTableName());
        privilege.setURI(mSentryPrivilege.getURI());
        privilege.setGrantorPrincipal(mSentryPrivilege.getGrantorPrincipal());
        return privilege;
    }

    private MSentryPrivilege convertToMSentryPrivilege(TSentryPrivilege privilege) throws SentryInvalidInputException {
        MSentryPrivilege mSentryPrivilege = new MSentryPrivilege();
        mSentryPrivilege.setServerName(SentryStore.safeTrimLower(privilege.getServerName()));
        mSentryPrivilege.setDbName(SentryStore.safeTrimLower(privilege.getDbName()));
        mSentryPrivilege.setTableName(SentryStore.safeTrimLower(privilege.getTableName()));
        mSentryPrivilege.setPrivilegeScope(SentryStore.safeTrim(privilege.getPrivilegeScope()));
        mSentryPrivilege.setAction(SentryStore.safeTrim(privilege.getAction()));
        mSentryPrivilege.setCreateTime(System.currentTimeMillis());
        mSentryPrivilege.setGrantorPrincipal(SentryStore.safeTrim(privilege.getGrantorPrincipal()));
        mSentryPrivilege.setURI(SentryStore.safeTrim(privilege.getURI()));
        mSentryPrivilege.setPrivilegeName(SentryStore.constructPrivilegeName(privilege));
        return mSentryPrivilege;
    }

    private static String safeTrim(String s) {
        if (s == null) {
            return null;
        }
        return s.trim();
    }

    private static String safeTrimLower(String s) {
        if (s == null) {
            return null;
        }
        return s.trim().toLowerCase();
    }

    public String getSentryVersion() throws SentryNoSuchObjectException, SentryAccessDeniedException {
        MSentryVersion mVersion = this.getMSentryVersion();
        return mVersion.getSchemaVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSentryVersion(String newVersion, String verComment) throws SentryNoSuchObjectException, SentryAccessDeniedException {
        MSentryVersion mVersion;
        boolean rollbackTransaction = true;
        PersistenceManager pm = null;
        try {
            mVersion = this.getMSentryVersion();
            if (newVersion.equals(mVersion.getSchemaVersion())) {
                return;
            }
        }
        catch (SentryNoSuchObjectException e) {
            mVersion = new MSentryVersion();
        }
        mVersion.setSchemaVersion(newVersion);
        mVersion.setVersionComment(verComment);
        try {
            pm = this.openTransaction();
            pm.makePersistent((Object)mVersion);
            rollbackTransaction = false;
            this.commitTransaction(pm);
        }
        finally {
            if (rollbackTransaction) {
                this.rollbackTransaction(pm);
            }
        }
    }

    private MSentryVersion getMSentryVersion() throws SentryNoSuchObjectException, SentryAccessDeniedException {
        boolean rollbackTransaction = true;
        PersistenceManager pm = null;
        try {
            pm = this.openTransaction();
            Query query = pm.newQuery(MSentryVersion.class);
            List mSentryVersions = (List)query.execute();
            pm.retrieveAll((Collection)mSentryVersions);
            rollbackTransaction = false;
            this.commitTransaction(pm);
            if (mSentryVersions.isEmpty()) {
                throw new SentryNoSuchObjectException("No matching version found");
            }
            if (mSentryVersions.size() > 1) {
                throw new SentryAccessDeniedException("Metastore contains multiple versions");
            }
            MSentryVersion mSentryVersion = (MSentryVersion)mSentryVersions.get(0);
            return mSentryVersion;
        }
        catch (JDODataStoreException e) {
            if (e.getCause() instanceof MissingTableException) {
                throw new SentryAccessDeniedException("Version table not found. The sentry store is not set or corrupt ");
            }
            throw e;
        }
        finally {
            if (rollbackTransaction) {
                this.rollbackTransaction(pm);
            }
        }
    }

    public void dropPrivilege(TSentryAuthorizable tAuthorizable) throws SentryNoSuchObjectException, SentryInvalidInputException {
        PersistenceManager pm = null;
        boolean rollbackTransaction = true;
        TSentryPrivilege tPrivilege = this.toSentryPrivilege(tAuthorizable);
        try {
            pm = this.openTransaction();
            if (this.isMultiActionsSupported(tPrivilege)) {
                for (String privilegeAction : Sets.newHashSet((Object[])new String[]{"*", "select", "insert"})) {
                    tPrivilege.setAction(privilegeAction);
                    this.dropPrivilegeForAllRoles(pm, new TSentryPrivilege(tPrivilege));
                }
            } else {
                this.dropPrivilegeForAllRoles(pm, new TSentryPrivilege(tPrivilege));
            }
            rollbackTransaction = false;
            this.commitTransaction(pm);
        }
        catch (JDODataStoreException e) {
            throw new SentryInvalidInputException("Failed to get privileges: " + e.getMessage());
        }
        finally {
            if (rollbackTransaction) {
                this.rollbackTransaction(pm);
            }
        }
    }

    public void renamePrivilege(TSentryAuthorizable tAuthorizable, TSentryAuthorizable newTAuthorizable, String grantorPrincipal) throws SentryNoSuchObjectException, SentryInvalidInputException {
        PersistenceManager pm = null;
        boolean rollbackTransaction = true;
        TSentryPrivilege tPrivilege = this.toSentryPrivilege(tAuthorizable);
        TSentryPrivilege newPrivilege = this.toSentryPrivilege(newTAuthorizable, grantorPrincipal);
        try {
            pm = this.openTransaction();
            if (this.isMultiActionsSupported(tPrivilege)) {
                for (String privilegeAction : Sets.newHashSet((Object[])new String[]{"*", "select", "insert"})) {
                    tPrivilege.setAction(privilegeAction);
                    newPrivilege.setAction(privilegeAction);
                    this.renamePrivilegeForAllRoles(pm, tPrivilege, newPrivilege);
                }
            } else {
                this.renamePrivilegeForAllRoles(pm, tPrivilege, newPrivilege);
            }
            rollbackTransaction = false;
            this.commitTransaction(pm);
        }
        catch (JDODataStoreException e) {
            throw new SentryInvalidInputException("Failed to get privileges: " + e.getMessage());
        }
        finally {
            if (rollbackTransaction) {
                this.rollbackTransaction(pm);
            }
        }
    }

    private boolean isMultiActionsSupported(TSentryPrivilege tPrivilege) {
        return tPrivilege.getDbName() != null;
    }

    private void renamePrivilegeForAllRoles(PersistenceManager pm, TSentryPrivilege tPrivilege, TSentryPrivilege newPrivilege) throws SentryNoSuchObjectException, SentryInvalidInputException {
        this.dropOrRenamePrivilegeForAllRoles(pm, tPrivilege, newPrivilege);
    }

    private void dropPrivilegeForAllRoles(PersistenceManager pm, TSentryPrivilege tPrivilege) throws SentryNoSuchObjectException, SentryInvalidInputException {
        this.dropOrRenamePrivilegeForAllRoles(pm, tPrivilege, null);
    }

    private void dropOrRenamePrivilegeForAllRoles(PersistenceManager pm, TSentryPrivilege tPrivilege, TSentryPrivilege newTPrivilege) throws SentryNoSuchObjectException, SentryInvalidInputException {
        HashSet roleSet = Sets.newHashSet();
        tPrivilege.setPrivilegeName(SentryStore.constructPrivilegeName(tPrivilege));
        MSentryPrivilege mPrivilege = this.getMSentryPrivilege(tPrivilege.getPrivilegeName(), pm);
        if (mPrivilege != null) {
            roleSet.addAll(ImmutableSet.copyOf(mPrivilege.getRoles()));
        }
        for (MSentryRole role : roleSet) {
            this.alterSentryRoleRevokePrivilegeCore(pm, role.getRoleName(), tPrivilege);
            if (newTPrivilege == null) continue;
            this.alterSentryRoleGrantPrivilegeCore(pm, role.getRoleName(), newTPrivilege);
        }
    }

    private TSentryPrivilege toSentryPrivilege(TSentryAuthorizable tAuthorizable) throws SentryInvalidInputException {
        return this.toSentryPrivilege(tAuthorizable, null);
    }

    private TSentryPrivilege toSentryPrivilege(TSentryAuthorizable tAuthorizable, String grantorPrincipal) throws SentryInvalidInputException {
        TSentryPrivilege tSentryPrivilege = new TSentryPrivilege();
        tSentryPrivilege.setDbName(tAuthorizable.getDb());
        tSentryPrivilege.setServerName(tAuthorizable.getServer());
        tSentryPrivilege.setTableName(tAuthorizable.getTable());
        tSentryPrivilege.setURI(tAuthorizable.getUri());
        tSentryPrivilege.setGrantorPrincipal(grantorPrincipal);
        ServiceConstants.PrivilegeScope scope = tSentryPrivilege.getTableName() != null ? ServiceConstants.PrivilegeScope.TABLE : (tSentryPrivilege.getDbName() != null ? ServiceConstants.PrivilegeScope.DATABASE : (tSentryPrivilege.getURI() != null ? ServiceConstants.PrivilegeScope.URI : ServiceConstants.PrivilegeScope.SERVER));
        tSentryPrivilege.setPrivilegeScope(scope.name());
        tSentryPrivilege.setAction("*");
        return tSentryPrivilege;
    }
}

