/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.db;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.sentry.SentryUserException;
import org.apache.sentry.core.common.ActiveRoleSet;
import org.apache.sentry.core.common.Authorizable;
import org.apache.sentry.core.common.SentryConfigurationException;
import org.apache.sentry.provider.common.ProviderBackend;
import org.apache.sentry.provider.common.ProviderBackendContext;
import org.apache.sentry.provider.db.service.thrift.SentryPolicyServiceClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleDBProviderBackend
implements ProviderBackend {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleDBProviderBackend.class);
    private final SentryPolicyServiceClient policyServiceClient;
    private volatile boolean initialized = false;

    public SimpleDBProviderBackend(Configuration conf, String resourcePath) throws IOException {
        this(conf);
    }

    public SimpleDBProviderBackend(Configuration conf) throws IOException {
        this(new SentryPolicyServiceClient(conf));
    }

    @VisibleForTesting
    public SimpleDBProviderBackend(SentryPolicyServiceClient policyServiceClient) throws IOException {
        this.policyServiceClient = policyServiceClient;
    }

    public void initialize(ProviderBackendContext context) {
        if (this.initialized) {
            throw new IllegalStateException("Backend has already been initialized, cannot be initialized twice");
        }
        this.initialized = true;
    }

    public ImmutableSet<String> getPrivileges(Set<String> groups, ActiveRoleSet roleSet, Authorizable ... authorizableHierarchy) {
        if (!this.initialized) {
            throw new IllegalStateException("Backend has not been properly initialized");
        }
        try {
            return ImmutableSet.copyOf(this.policyServiceClient.listPrivilegesForProvider(groups, roleSet, authorizableHierarchy));
        }
        catch (SentryUserException e) {
            String msg = "Unable to obtain privileges from server: " + e.getMessage();
            LOGGER.error(msg, (Throwable)e);
            return ImmutableSet.of();
        }
    }

    public ImmutableSet<String> getRoles(Set<String> groups, ActiveRoleSet roleSet) {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    public void close() {
        if (this.policyServiceClient != null) {
            this.policyServiceClient.close();
        }
    }

    public void validatePolicy(boolean strictValidation) throws SentryConfigurationException {
        if (!this.initialized) {
            throw new IllegalStateException("Backend has not been properly initialized");
        }
    }
}

