/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.common;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.sentry.core.common.Action;
import org.apache.sentry.core.common.ActiveRoleSet;
import org.apache.sentry.core.common.Authorizable;
import org.apache.sentry.core.common.SentryConfigurationException;
import org.apache.sentry.core.common.Subject;
import org.apache.sentry.policy.common.PolicyEngine;
import org.apache.sentry.policy.common.Privilege;
import org.apache.sentry.policy.common.PrivilegeFactory;
import org.apache.sentry.provider.common.AuthorizationProvider;
import org.apache.sentry.provider.common.GroupMappingService;
import org.apache.sentry.provider.common.ProviderConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ResourceAuthorizationProvider
implements AuthorizationProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceAuthorizationProvider.class);
    private static final ThreadLocal<List<String>> lastFailedPrivileges = new ThreadLocal<List<String>>(){

        @Override
        protected List<String> initialValue() {
            return new ArrayList<String>();
        }
    };
    private final GroupMappingService groupService;
    private final PolicyEngine policy;
    private final PrivilegeFactory privilegeFactory;

    public ResourceAuthorizationProvider(PolicyEngine policy, GroupMappingService groupService) {
        this.policy = policy;
        this.groupService = groupService;
        this.privilegeFactory = policy.getPrivilegeFactory();
    }

    @Override
    public boolean hasAccess(Subject subject, List<? extends Authorizable> authorizableHierarchy, Set<? extends Action> actions, ActiveRoleSet roleSet) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Authorization Request for " + subject + " " + authorizableHierarchy + " and " + actions);
        }
        Preconditions.checkNotNull((Object)subject, (Object)"Subject cannot be null");
        Preconditions.checkNotNull(authorizableHierarchy, (Object)"Authorizable cannot be null");
        Preconditions.checkArgument((!authorizableHierarchy.isEmpty() ? 1 : 0) != 0, (Object)"Authorizable cannot be empty");
        Preconditions.checkNotNull(actions, (Object)"Actions cannot be null");
        Preconditions.checkArgument((!actions.isEmpty() ? 1 : 0) != 0, (Object)"Actions cannot be empty");
        Preconditions.checkNotNull((Object)roleSet, (Object)"ActiveRoleSet cannot be null");
        return this.doHasAccess(subject, authorizableHierarchy, actions, roleSet);
    }

    private boolean doHasAccess(Subject subject, List<? extends Authorizable> authorizables, Set<? extends Action> actions, ActiveRoleSet roleSet) {
        Set<String> groups = this.getGroups(subject);
        HashSet<String> hierarchy = new HashSet<String>();
        for (Authorizable authorizable : authorizables) {
            hierarchy.add(ProviderConstants.KV_JOINER.join((Object)authorizable.getTypeName(), (Object)authorizable.getName(), new Object[0]));
        }
        List<String> requestPrivileges = this.buildPermissions(authorizables, actions);
        Iterable<Privilege> iterable = this.getPrivileges(groups, roleSet, authorizables.toArray(new Authorizable[0]));
        lastFailedPrivileges.get().clear();
        for (String requestPrivilege : requestPrivileges) {
            for (Privilege permission : iterable) {
                boolean result = permission.implies(this.privilegeFactory.createPrivilege(requestPrivilege));
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("ProviderPrivilege {}, RequestPrivilege {}, RoleSet, {}, Result {}", new Object[]{permission, requestPrivilege, roleSet, result});
                }
                if (!result) continue;
                return true;
            }
        }
        lastFailedPrivileges.get().addAll(requestPrivileges);
        return false;
    }

    private Iterable<Privilege> getPrivileges(Set<String> groups, ActiveRoleSet roleSet, Authorizable[] authorizables) {
        return Iterables.transform(this.appendDefaultDBPriv((ImmutableSet<String>)this.policy.getPrivileges(groups, roleSet, authorizables), authorizables), (Function)new Function<String, Privilege>(){

            public Privilege apply(String privilege) {
                return ResourceAuthorizationProvider.this.privilegeFactory.createPrivilege(privilege);
            }
        });
    }

    private ImmutableSet<String> appendDefaultDBPriv(ImmutableSet<String> privileges, Authorizable[] authorizables) {
        if (authorizables != null && authorizables.length == 4 && authorizables[2].getName().equals("+") && privileges.size() == 1 && this.hasOnlyServerPrivilege((String)privileges.asList().get(0))) {
            String defaultPriv = "Server=" + authorizables[0].getName() + "->Db=default->Table=*->Column=*->action=select";
            HashSet newPrivs = Sets.newHashSet((Object[])new String[]{defaultPriv});
            return ImmutableSet.copyOf((Collection)newPrivs);
        }
        return privileges;
    }

    private boolean hasOnlyServerPrivilege(String priv) {
        ArrayList l = Lists.newArrayList((Iterable)ProviderConstants.AUTHORIZABLE_SPLITTER.split((CharSequence)priv));
        if (l.size() == 1 && ((String)l.get(0)).toLowerCase().startsWith("server")) {
            return ((String)l.get(0)).toLowerCase().split("=")[1].endsWith("+");
        }
        return false;
    }

    @Override
    public GroupMappingService getGroupMapping() {
        return this.groupService;
    }

    private Set<String> getGroups(Subject subject) {
        return this.groupService.getGroups(subject.getName());
    }

    @Override
    public void validateResource(boolean strictValidation) throws SentryConfigurationException {
        this.policy.validatePolicy(strictValidation);
    }

    @Override
    public Set<String> listPrivilegesForSubject(Subject subject) throws SentryConfigurationException {
        return this.policy.getPrivileges(this.getGroups(subject), ActiveRoleSet.ALL, null);
    }

    @Override
    public Set<String> listPrivilegesForGroup(String groupName) throws SentryConfigurationException {
        return this.policy.getPrivileges((Set)Sets.newHashSet((Object[])new String[]{groupName}), ActiveRoleSet.ALL, null);
    }

    @Override
    public List<String> getLastFailedPrivileges() {
        return lastFailedPrivileges.get();
    }

    @Override
    public void close() {
        if (this.policy != null) {
            this.policy.close();
        }
    }

    private List<String> buildPermissions(List<? extends Authorizable> authorizables, Set<? extends Action> actions) {
        ArrayList<String> hierarchy = new ArrayList<String>();
        ArrayList<String> requestedPermissions = new ArrayList<String>();
        for (Authorizable authorizable : authorizables) {
            hierarchy.add(ProviderConstants.KV_JOINER.join((Object)authorizable.getTypeName(), (Object)authorizable.getName(), new Object[0]));
        }
        for (Action action : actions) {
            String requestPermission = ProviderConstants.AUTHORIZABLE_JOINER.join(hierarchy);
            requestPermission = ProviderConstants.AUTHORIZABLE_JOINER.join((Object)requestPermission, (Object)ProviderConstants.KV_JOINER.join((Object)"action", (Object)action.getValue(), new Object[0]), new Object[0]);
            requestedPermissions.add(requestPermission);
        }
        return requestedPermissions;
    }
}

