/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.common;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.Groups;
import org.apache.sentry.policy.common.PolicyEngine;
import org.apache.sentry.provider.common.GroupMappingService;
import org.apache.sentry.provider.common.HadoopGroupMappingService;
import org.apache.sentry.provider.common.ResourceAuthorizationProvider;

public class HadoopGroupResourceAuthorizationProvider
extends ResourceAuthorizationProvider {
    public static final String CONF_PREFIX = HadoopGroupResourceAuthorizationProvider.class.getName();
    public static final String USE_NEW_GROUPS = CONF_PREFIX + ".useNewGroups";

    public HadoopGroupResourceAuthorizationProvider(String resource, PolicyEngine policy) throws IOException {
        this(new Configuration(), resource, policy);
    }

    public HadoopGroupResourceAuthorizationProvider(Configuration conf, String resource, PolicyEngine policy) throws IOException {
        this(policy, new HadoopGroupMappingService(HadoopGroupResourceAuthorizationProvider.getGroups(conf)));
    }

    @VisibleForTesting
    public HadoopGroupResourceAuthorizationProvider(PolicyEngine policy, GroupMappingService groupService) {
        super(policy, groupService);
    }

    private static Groups getGroups(Configuration conf) {
        if (conf.getBoolean(USE_NEW_GROUPS, false)) {
            return new Groups(conf);
        }
        return Groups.getUserToGroupsMappingService((Configuration)conf);
    }
}

