/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.common;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.Groups;
import org.apache.sentry.provider.common.GroupMappingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopGroupMappingService
implements GroupMappingService {
    private static final Logger LOGGER = LoggerFactory.getLogger(HadoopGroupMappingService.class);
    private static Configuration hadoopConf;
    private final Groups groups;

    public HadoopGroupMappingService(Groups groups) {
        this.groups = groups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public HadoopGroupMappingService(Configuration conf, String resource) {
        if (hadoopConf == null) {
            Class<HadoopGroupMappingService> clazz = HadoopGroupMappingService.class;
            // MONITORENTER : org.apache.sentry.provider.common.HadoopGroupMappingService.class
            if (hadoopConf == null) {
                hadoopConf = new Configuration();
                hadoopConf.addResource(conf);
                if (!StringUtils.isEmpty((String)resource)) {
                    hadoopConf.addResource(resource);
                }
            }
            // MONITOREXIT : clazz
        }
        this.groups = Groups.getUserToGroupsMappingService((Configuration)hadoopConf);
    }

    @Override
    public Set<String> getGroups(String user) {
        try {
            return new HashSet<String>(this.groups.getGroups(user));
        }
        catch (IOException e) {
            LOGGER.warn("Unable to obtain groups for " + user, (Throwable)e);
            return Collections.emptySet();
        }
    }
}

