/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.common;

import junit.framework.Assert;
import org.apache.sentry.provider.common.KeyValue;
import org.apache.sentry.provider.common.ProviderConstants;
import org.junit.Test;

public class TestKeyValue {
    @Test
    public void testWithSeparators() throws Exception {
        KeyValue kv = new KeyValue("URI=/u/h/w/t/partition=value/");
        Assert.assertEquals((String)"URI", (String)kv.getKey());
        Assert.assertEquals((String)"/u/h/w/t/partition=value/", (String)kv.getValue());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEmptyKey() throws Exception {
        new KeyValue(ProviderConstants.KV_JOINER.join((Object)"", (Object)"b", new Object[0]));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEmptyValue() throws Exception {
        new KeyValue(ProviderConstants.KV_JOINER.join((Object)"a", (Object)"", new Object[0]));
    }

    @Test
    public void testOneParameterConstructor() throws Exception {
        KeyValue kv1 = new KeyValue(ProviderConstants.KV_JOINER.join((Object)"k1", (Object)"v1", new Object[0]));
        KeyValue kv2 = new KeyValue(ProviderConstants.KV_JOINER.join((Object)"k1", (Object)"v1", new Object[0]));
        KeyValue kv3 = new KeyValue(ProviderConstants.KV_JOINER.join((Object)"k2", (Object)"v2", new Object[0]));
        this.doTest(kv1, kv2, kv3);
    }

    @Test
    public void testTwoParameterConstructor() throws Exception {
        KeyValue kv1 = new KeyValue("k1", "v1");
        KeyValue kv2 = new KeyValue("k1", "v1");
        KeyValue kv3 = new KeyValue("k2", "v2");
        this.doTest(kv1, kv2, kv3);
    }

    private void doTest(KeyValue kv1, KeyValue kv2, KeyValue kv3) {
        Assert.assertEquals((Object)kv1, (Object)kv2);
        Assert.assertFalse((boolean)kv1.equals((Object)kv3));
        Assert.assertEquals((String)kv1.toString(), (String)kv2.toString());
        Assert.assertFalse((boolean)kv1.toString().equals(kv3.toString()));
        Assert.assertEquals((int)kv1.hashCode(), (int)kv2.hashCode());
        Assert.assertFalse((kv1.hashCode() == kv3.hashCode() ? 1 : 0) != 0);
        Assert.assertEquals((String)kv1.getKey(), (String)kv2.getKey());
        Assert.assertFalse((boolean)kv1.getKey().equals(kv3.getKey()));
        Assert.assertEquals((String)kv1.getValue(), (String)kv2.getValue());
        Assert.assertFalse((boolean)kv1.getValue().equals(kv3.getValue()));
    }
}

