/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.common;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.Groups;
import org.apache.sentry.provider.common.GroupMappingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopGroupMappingService
implements GroupMappingService {
    private static final Logger LOGGER = LoggerFactory.getLogger(HadoopGroupMappingService.class);
    private final Groups groups;

    public HadoopGroupMappingService(Groups groups) {
        this.groups = groups;
    }

    public HadoopGroupMappingService(Configuration conf, String resource) {
        this(Groups.getUserToGroupsMappingService((Configuration)conf));
    }

    @Override
    public Set<String> getGroups(String user) {
        try {
            return new HashSet<String>(this.groups.getGroups(user));
        }
        catch (IOException e) {
            LOGGER.warn("Unable to obtain groups for " + user, (Throwable)e);
            return Collections.emptySet();
        }
    }
}

