/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.provider.cache;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.sentry.core.common.ActiveRoleSet;
import org.apache.sentry.core.common.Authorizable;
import org.apache.sentry.core.common.SentryConfigurationException;
import org.apache.sentry.provider.cache.PrivilegeCache;
import org.apache.sentry.provider.common.ProviderBackend;
import org.apache.sentry.provider.common.ProviderBackendContext;

public class SimpleCacheProviderBackend
implements ProviderBackend {
    private PrivilegeCache cacheHandle;
    private Configuration conf;
    private boolean isInitialized = false;

    public SimpleCacheProviderBackend(Configuration conf, String resourcePath) {
        this.conf = conf;
    }

    public void initialize(ProviderBackendContext context) {
        if (this.isInitialized) {
            return;
        }
        this.isInitialized = true;
        this.cacheHandle = (PrivilegeCache)context.getBindingHandle();
        assert (this.cacheHandle != null);
    }

    private boolean initialized() {
        return this.isInitialized;
    }

    public ImmutableSet<String> getPrivileges(Set<String> groups, ActiveRoleSet roleSet, Authorizable ... authorizationhierarchy) {
        if (!this.initialized()) {
            throw new IllegalStateException("Backend has not been properly initialized");
        }
        return ImmutableSet.copyOf(this.cacheHandle.listPrivileges(groups, roleSet));
    }

    public ImmutableSet<String> getRoles(Set<String> groups, ActiveRoleSet roleSet) {
        if (!this.initialized()) {
            throw new IllegalStateException("Backend has not been properly initialized");
        }
        throw new UnsupportedOperationException("getRoles() is not supported by Cache provider");
    }

    public void validatePolicy(boolean strictValidation) throws SentryConfigurationException {
        if (!this.initialized()) {
            throw new IllegalStateException("Backend has not been properly initialized");
        }
        throw new UnsupportedOperationException("validatePolicy() is not supported by Cache provider");
    }

    public void close() {
        this.cacheHandle.close();
    }
}

