/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.policy.sqoop;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.sentry.policy.common.Privilege;
import org.apache.sentry.policy.common.PrivilegeFactory;
import org.apache.sentry.provider.common.KeyValue;
import org.apache.sentry.provider.common.ProviderConstants;

public class SqoopWildcardPrivilege
implements Privilege {
    private final ImmutableList<KeyValue> parts;

    public SqoopWildcardPrivilege(String permission) {
        if (Strings.isNullOrEmpty((String)permission)) {
            throw new IllegalArgumentException("permission string cannot be null or empty.");
        }
        ArrayList parts = Lists.newArrayList();
        for (String authorizable : ProviderConstants.AUTHORIZABLE_SPLITTER.trimResults().split((CharSequence)permission.trim())) {
            if (authorizable.isEmpty()) {
                throw new IllegalArgumentException("Privilege '" + permission + "' has an empty section");
            }
            parts.add(new KeyValue(authorizable));
        }
        if (parts.isEmpty()) {
            throw new AssertionError((Object)("Should never occur: " + permission));
        }
        this.parts = ImmutableList.copyOf((Collection)parts);
    }

    public boolean implies(Privilege p) {
        if (!(p instanceof SqoopWildcardPrivilege)) {
            return false;
        }
        SqoopWildcardPrivilege wp = (SqoopWildcardPrivilege)p;
        ImmutableList<KeyValue> otherParts = wp.parts;
        if (this.equals(wp)) {
            return true;
        }
        int index = 0;
        for (KeyValue otherPart : otherParts) {
            if (this.parts.size() - 1 < index) {
                return true;
            }
            KeyValue part = (KeyValue)this.parts.get(index);
            if (part.getKey().equalsIgnoreCase("action") && !otherPart.getKey().equalsIgnoreCase("action")) continue;
            if (!part.getKey().equalsIgnoreCase(otherPart.getKey())) {
                return false;
            }
            if (!this.impliesKeyValue(part, otherPart)) {
                return false;
            }
            ++index;
        }
        while (index < this.parts.size()) {
            KeyValue part = (KeyValue)this.parts.get(index);
            if (!part.getValue().equals("*")) {
                return false;
            }
            ++index;
        }
        return true;
    }

    private boolean impliesKeyValue(KeyValue policyPart, KeyValue requestPart) {
        Preconditions.checkState((boolean)policyPart.getKey().equalsIgnoreCase(requestPart.getKey()), (Object)"Please report, this method should not be called with two different keys");
        if (policyPart.getValue().equalsIgnoreCase("*") || policyPart.getValue().equalsIgnoreCase("ALL") || policyPart.equals((Object)requestPart)) {
            return true;
        }
        return !"action".equalsIgnoreCase(policyPart.getKey()) && "*".equalsIgnoreCase(requestPart.getValue());
    }

    public static class Factory
    implements PrivilegeFactory {
        public Privilege createPrivilege(String permission) {
            return new SqoopWildcardPrivilege(permission);
        }
    }
}

