/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.policy.search;

import org.apache.sentry.core.model.search.Collection;
import org.apache.sentry.core.model.search.SearchModelAuthorizable;
import org.apache.sentry.provider.common.KeyValue;

public class SearchModelAuthorizables {
    public static SearchModelAuthorizable from(KeyValue keyValue) {
        String prefix = keyValue.getKey().toLowerCase();
        String name = keyValue.getValue().toLowerCase();
        for (SearchModelAuthorizable.AuthorizableType type : SearchModelAuthorizable.AuthorizableType.values()) {
            if (!prefix.equalsIgnoreCase(type.name())) continue;
            return SearchModelAuthorizables.from(type, name);
        }
        return null;
    }

    public static SearchModelAuthorizable from(String s) {
        return SearchModelAuthorizables.from(new KeyValue(s));
    }

    private static SearchModelAuthorizable from(SearchModelAuthorizable.AuthorizableType type, String name) {
        switch (type) {
            case Collection: {
                return new Collection(name);
            }
        }
        return null;
    }
}

