/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.policy.search;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.sentry.policy.common.Privilege;
import org.apache.sentry.policy.common.PrivilegeFactory;
import org.apache.sentry.provider.file.KeyValue;
import org.apache.sentry.provider.file.PolicyFileConstants;

public class SearchWildcardPrivilege
implements Privilege {
    private final ImmutableList<KeyValue> parts;

    public SearchWildcardPrivilege(String wildcardString) {
        wildcardString = Strings.nullToEmpty((String)wildcardString).trim();
        if (wildcardString.isEmpty()) {
            throw new IllegalArgumentException("Wildcard string cannot be null or empty.");
        }
        ArrayList parts = Lists.newArrayList();
        for (String authorizable : PolicyFileConstants.AUTHORIZABLE_SPLITTER.trimResults().split((CharSequence)wildcardString)) {
            if (authorizable.isEmpty()) {
                throw new IllegalArgumentException("Privilege '" + wildcardString + "' has an empty section");
            }
            parts.add(new KeyValue(authorizable));
        }
        if (parts.isEmpty()) {
            throw new AssertionError((Object)("Should never occur: " + wildcardString));
        }
        this.parts = ImmutableList.copyOf((Collection)parts);
    }

    public boolean implies(Privilege p) {
        if (!(p instanceof SearchWildcardPrivilege)) {
            return false;
        }
        SearchWildcardPrivilege wp = (SearchWildcardPrivilege)p;
        ImmutableList<KeyValue> otherParts = wp.parts;
        if (this.equals(wp)) {
            return true;
        }
        int index = 0;
        for (KeyValue otherPart : otherParts) {
            if (this.parts.size() - 1 < index) {
                return true;
            }
            KeyValue part = (KeyValue)this.parts.get(index);
            if (!part.getKey().equalsIgnoreCase(otherPart.getKey())) {
                return false;
            }
            if (!this.impliesKeyValue(part, otherPart)) {
                return false;
            }
            ++index;
        }
        while (index < this.parts.size()) {
            KeyValue part = (KeyValue)this.parts.get(index);
            if (!part.getValue().equals("*")) {
                return false;
            }
            ++index;
        }
        return true;
    }

    private boolean impliesKeyValue(KeyValue policyPart, KeyValue requestPart) {
        Preconditions.checkState((boolean)policyPart.getKey().equalsIgnoreCase(requestPart.getKey()), (Object)"Please report, this method should not be called with two different keys");
        if (policyPart.getValue().equals("*") || policyPart.equals((Object)requestPart)) {
            return true;
        }
        return !"action".equalsIgnoreCase(policyPart.getKey()) && "*".equalsIgnoreCase(requestPart.getValue());
    }

    public String toString() {
        return PolicyFileConstants.AUTHORIZABLE_JOINER.join(this.parts);
    }

    public boolean equals(Object o) {
        if (o instanceof SearchWildcardPrivilege) {
            SearchWildcardPrivilege wp = (SearchWildcardPrivilege)o;
            return this.parts.equals(wp.parts);
        }
        return false;
    }

    public int hashCode() {
        return this.parts.hashCode();
    }

    public static class SearchWildcardPrivilegeFactory
    implements PrivilegeFactory {
        public Privilege createPrivilege(String privilege) {
            return new SearchWildcardPrivilege(privilege);
        }
    }
}

