/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.policy.search;

import org.apache.sentry.core.common.SentryConfigurationException;
import org.apache.sentry.core.model.search.Collection;
import org.apache.sentry.core.model.search.SearchModelAuthorizable;
import org.apache.sentry.policy.common.PrivilegeValidatorContext;
import org.apache.sentry.policy.search.AbstractSearchPrivilegeValidator;

public class CollectionRequiredInPrivilege
extends AbstractSearchPrivilegeValidator {
    public void validate(PrivilegeValidatorContext context) throws SentryConfigurationException {
        String privilege = context.getPrivilege();
        Iterable<SearchModelAuthorizable> authorizables = CollectionRequiredInPrivilege.parsePrivilege(privilege);
        boolean foundCollectionInAuthorizables = false;
        for (SearchModelAuthorizable authorizable : authorizables) {
            if (!(authorizable instanceof Collection)) continue;
            foundCollectionInAuthorizables = true;
            break;
        }
        if (!foundCollectionInAuthorizables) {
            String msg = "Missing collection object in " + privilege;
            throw new SentryConfigurationException(msg);
        }
    }
}

