/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.policy.indexer;

import org.apache.sentry.core.model.indexer.Indexer;
import org.apache.sentry.core.model.indexer.IndexerModelAuthorizable;
import org.apache.sentry.provider.common.KeyValue;

public class IndexerModelAuthorizables {
    public static IndexerModelAuthorizable from(KeyValue keyValue) {
        String prefix = keyValue.getKey().toLowerCase();
        String name = keyValue.getValue().toLowerCase();
        for (IndexerModelAuthorizable.AuthorizableType type : IndexerModelAuthorizable.AuthorizableType.values()) {
            if (!prefix.equalsIgnoreCase(type.name())) continue;
            return IndexerModelAuthorizables.from(type, name);
        }
        return null;
    }

    public static IndexerModelAuthorizable from(String s) {
        return IndexerModelAuthorizables.from(new KeyValue(s));
    }

    private static IndexerModelAuthorizable from(IndexerModelAuthorizable.AuthorizableType type, String name) {
        switch (type) {
            case Indexer: {
                return new Indexer(name);
            }
        }
        return null;
    }
}

