/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sentry.policy.db;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.sentry.core.common.utils.PathUtils;
import org.apache.sentry.core.model.db.DBModelAuthorizable;
import org.apache.sentry.policy.common.Privilege;
import org.apache.sentry.policy.common.PrivilegeFactory;
import org.apache.sentry.provider.common.KeyValue;
import org.apache.sentry.provider.common.ProviderConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBWildcardPrivilege
implements Privilege {
    private static final Logger LOGGER = LoggerFactory.getLogger(DBWildcardPrivilege.class);
    private final ImmutableList<KeyValue> parts;

    public DBWildcardPrivilege(String wildcardString) {
        wildcardString = Strings.nullToEmpty((String)wildcardString).trim();
        if (wildcardString.isEmpty()) {
            throw new IllegalArgumentException("Wildcard string cannot be null or empty.");
        }
        ArrayList parts = Lists.newArrayList();
        for (String authorizable : ProviderConstants.AUTHORIZABLE_SPLITTER.trimResults().split((CharSequence)wildcardString)) {
            if (authorizable.isEmpty()) {
                throw new IllegalArgumentException("Privilege '" + wildcardString + "' has an empty section");
            }
            parts.add(new KeyValue(authorizable));
        }
        if (parts.isEmpty()) {
            throw new AssertionError((Object)("Should never occur: " + wildcardString));
        }
        this.parts = ImmutableList.copyOf((Collection)parts);
    }

    public boolean implies(Privilege p) {
        if (!(p instanceof DBWildcardPrivilege)) {
            return false;
        }
        DBWildcardPrivilege wp = (DBWildcardPrivilege)p;
        ImmutableList<KeyValue> otherParts = wp.parts;
        if (this.equals(wp)) {
            return true;
        }
        int index = 0;
        for (KeyValue otherPart : otherParts) {
            if (this.parts.size() - 1 < index) {
                return true;
            }
            KeyValue part = (KeyValue)this.parts.get(index);
            if (part.getKey().equalsIgnoreCase("action") && !otherPart.getKey().equalsIgnoreCase("action")) continue;
            if (!part.getKey().equalsIgnoreCase(otherPart.getKey())) {
                return false;
            }
            if (!this.impliesKeyValue(part, otherPart)) {
                return false;
            }
            ++index;
        }
        while (index < this.parts.size()) {
            KeyValue part = (KeyValue)this.parts.get(index);
            if (!part.getValue().equals("*")) {
                return false;
            }
            ++index;
        }
        return true;
    }

    private boolean impliesKeyValue(KeyValue policyPart, KeyValue requestPart) {
        Preconditions.checkState((boolean)policyPart.getKey().equalsIgnoreCase(requestPart.getKey()), (Object)"Please report, this method should not be called with two different keys");
        if (policyPart.getValue().equals("*") || policyPart.getValue().equalsIgnoreCase("ALL") || policyPart.equals((Object)requestPart)) {
            return true;
        }
        if (!"action".equalsIgnoreCase(policyPart.getKey()) && "*".equalsIgnoreCase(requestPart.getValue())) {
            return true;
        }
        if (!"action".equalsIgnoreCase(policyPart.getKey()) && "+".equalsIgnoreCase(requestPart.getValue())) {
            return true;
        }
        if (policyPart.getKey().equalsIgnoreCase(DBModelAuthorizable.AuthorizableType.URI.name())) {
            return DBWildcardPrivilege.impliesURI(policyPart.getValue(), requestPart.getValue());
        }
        return false;
    }

    @VisibleForTesting
    protected static boolean impliesURI(String privilege, String request) {
        return PathUtils.impliesURI((String)privilege, (String)request);
    }

    public String toString() {
        return ProviderConstants.AUTHORIZABLE_JOINER.join(this.parts);
    }

    public boolean equals(Object o) {
        if (o instanceof DBWildcardPrivilege) {
            DBWildcardPrivilege wp = (DBWildcardPrivilege)o;
            return this.parts.equals(wp.parts);
        }
        return false;
    }

    public int hashCode() {
        return this.parts.hashCode();
    }

    public static class DBWildcardPrivilegeFactory
    implements PrivilegeFactory {
        public Privilege createPrivilege(String privilege) {
            return new DBWildcardPrivilege(privilege);
        }
    }
}

