/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.sentry.policy.sqoop;

import java.util.Set;

import org.apache.sentry.provider.common.GroupMappingService;

import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;

public class MockGroupMappingServiceProvider implements GroupMappingService {
  private final Multimap<String, String> userToGroupMap;

  public MockGroupMappingServiceProvider(Multimap<String, String> userToGroupMap) {
    this.userToGroupMap = userToGroupMap;
  }
  @Override
  public Set<String> getGroups(String user) {
    return Sets.newHashSet(userToGroupMap.get(user));
  }

}
