/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.security;

import org.apache.sqoop.common.ErrorCode;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.security.AuthenticationHandler;
import org.apache.sqoop.security.AuthenticationProvider;
import org.apache.sqoop.security.AuthorizationAccessController;
import org.apache.sqoop.security.AuthorizationHandler;
import org.apache.sqoop.security.AuthorizationValidator;
import org.apache.sqoop.security.SecurityError;
import org.apache.sqoop.utils.ClassUtils;

public class SecurityFactory {
    public static AuthenticationHandler getAuthenticationHandler(String handler) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        AuthenticationHandler newHandler;
        Class handlerClass = ClassUtils.loadClass((String)handler);
        if (handlerClass == null) {
            throw new SqoopException((ErrorCode)SecurityError.AUTH_0004, "Authentication Handler Class is null: " + handler);
        }
        try {
            newHandler = (AuthenticationHandler)handlerClass.newInstance();
        }
        catch (Exception ex) {
            throw new SqoopException((ErrorCode)SecurityError.AUTH_0004, "Authentication Handler Class Exception: " + handler, (Throwable)ex);
        }
        return newHandler;
    }

    public static AuthorizationHandler getAuthorizationHandler(String handler) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        AuthorizationHandler newHandler;
        Class handlerClass = ClassUtils.loadClass((String)handler);
        if (handlerClass == null) {
            throw new SqoopException((ErrorCode)SecurityError.AUTH_0007, "Authorization Handler Class is null: " + handler);
        }
        try {
            newHandler = (AuthorizationHandler)handlerClass.newInstance();
        }
        catch (Exception ex) {
            throw new SqoopException((ErrorCode)SecurityError.AUTH_0007, "Authorization Handler Class Exception: " + handler, (Throwable)ex);
        }
        return newHandler;
    }

    public static AuthorizationAccessController getAuthorizationAccessController(String accessController) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        AuthorizationAccessController newAccessController;
        Class accessControllerClass = ClassUtils.loadClass((String)accessController);
        if (accessControllerClass == null) {
            throw new SqoopException((ErrorCode)SecurityError.AUTH_0008, "Authorization Access Controller Class is null: " + accessController);
        }
        try {
            newAccessController = (AuthorizationAccessController)accessControllerClass.newInstance();
        }
        catch (Exception ex) {
            throw new SqoopException((ErrorCode)SecurityError.AUTH_0008, "Authorization Access Controller Class Exception: " + accessController, (Throwable)ex);
        }
        return newAccessController;
    }

    public static AuthorizationValidator getAuthorizationValidator(String validator) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        AuthorizationValidator newValidator;
        Class validatorClass = ClassUtils.loadClass((String)validator);
        if (validatorClass == null) {
            throw new SqoopException((ErrorCode)SecurityError.AUTH_0009, "Authorization Validator Class is null: " + validator);
        }
        try {
            newValidator = (AuthorizationValidator)validatorClass.newInstance();
        }
        catch (Exception ex) {
            throw new SqoopException((ErrorCode)SecurityError.AUTH_0009, "Authorization Validator Class Exception: " + validator, (Throwable)ex);
        }
        return newValidator;
    }

    public static AuthenticationProvider getAuthenticationProvider(String provider) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        AuthenticationProvider newProvider;
        Class providerClass = ClassUtils.loadClass((String)provider);
        if (providerClass == null) {
            throw new SqoopException((ErrorCode)SecurityError.AUTH_0010, "Authentication Provider Class is null: " + provider);
        }
        try {
            newProvider = (AuthenticationProvider)providerClass.newInstance();
        }
        catch (Exception ex) {
            throw new SqoopException((ErrorCode)SecurityError.AUTH_0010, "Authentication Provider Class is null: " + provider, (Throwable)ex);
        }
        return newProvider;
    }
}

