/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.security;

import org.apache.log4j.Logger;
import org.apache.sqoop.core.Reconfigurable;
import org.apache.sqoop.core.SqoopConfiguration;
import org.apache.sqoop.security.AuthorizationHandler;
import org.apache.sqoop.security.SecurityFactory;

public class AuthorizationManager
implements Reconfigurable {
    private static final Logger LOG = Logger.getLogger(AuthorizationManager.class);
    public static final String DEFAULT_AUTHORIZATION_HANDLER = "org.apache.sqoop.security.authorization.DefaultAuthorizationHandler";
    public static final String DEFAULT_AUTHENTICATION_PROVIDER = "org.apache.sqoop.security.authorization.DefaultAuthenticationProvider";
    public static final String DEFAULT_SERVER_NAME = "SqoopServer1";
    protected static boolean DEFAULT_AUTO_UPGRADE = false;
    private static AuthorizationManager instance = new AuthorizationManager();
    private static AuthorizationHandler authorizationHandler;

    public static AuthorizationManager getInstance() {
        return instance;
    }

    public static void setInstance(AuthorizationManager newInstance) {
        instance = newInstance;
    }

    public static AuthorizationHandler getAuthorizationHandler() {
        return authorizationHandler;
    }

    public synchronized void initialize() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        LOG.trace((Object)"Begin authorization manager initialization");
        String handler = SqoopConfiguration.getInstance().getContext().getString("org.apache.sqoop.security.authorization.handler", DEFAULT_AUTHORIZATION_HANDLER).trim();
        authorizationHandler = SecurityFactory.getAuthorizationHandler(handler);
        String provider = SqoopConfiguration.getInstance().getContext().getString("org.apache.sqoop.security.authorization.authentication_provider", DEFAULT_AUTHENTICATION_PROVIDER).trim();
        String serverName = SqoopConfiguration.getInstance().getContext().getString("org.apache.sqoop.security.authorization.server_name", DEFAULT_SERVER_NAME).trim();
        authorizationHandler.doInitialize(SecurityFactory.getAuthenticationProvider(provider), serverName);
        LOG.info((Object)"Authorization loaded.");
    }

    public synchronized void destroy() {
        LOG.trace((Object)"Begin authorization manager destroy");
    }

    @Override
    public synchronized void configurationChanged() {
        LOG.info((Object)"Begin authorization manager reconfiguring");
        LOG.info((Object)"Authorization manager reconfigured");
    }
}

