/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.security;

import org.apache.log4j.Logger;
import org.apache.sqoop.core.Reconfigurable;
import org.apache.sqoop.core.SqoopConfiguration;
import org.apache.sqoop.security.AuthenticationHandler;
import org.apache.sqoop.security.SecurityFactory;

public class AuthenticationManager
implements Reconfigurable {
    private static final Logger LOG = Logger.getLogger(AuthenticationManager.class);
    public static final String DEFAULT_AUTHENTICATION_HANDLER = "org.apache.sqoop.security.authentication.SimpleAuthenticationHandler";
    protected static boolean DEFAULT_AUTO_UPGRADE = false;
    private static AuthenticationManager instance = new AuthenticationManager();
    private static AuthenticationHandler authenticationHandler;

    public static AuthenticationManager getInstance() {
        return instance;
    }

    public static void setInstance(AuthenticationManager newInstance) {
        instance = newInstance;
    }

    public static AuthenticationHandler getAuthenticationHandler() {
        return authenticationHandler;
    }

    public synchronized void initialize() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)"Begin authentication manager initialization");
        }
        String handler = SqoopConfiguration.getInstance().getContext().getString("org.apache.sqoop.security.authentication.handler", DEFAULT_AUTHENTICATION_HANDLER).trim();
        authenticationHandler = SecurityFactory.getAuthenticationHandler(handler);
        authenticationHandler.doInitialize();
        authenticationHandler.secureLogin();
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"Authentication loaded.");
        }
    }

    public synchronized void destroy() {
        LOG.trace((Object)"Begin authentication manager destroy");
    }

    @Override
    public synchronized void configurationChanged() {
        LOG.info((Object)"Begin authentication manager reconfiguring");
        LOG.info((Object)"Authentication manager reconfigured");
    }
}

