/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.repository;

import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.sqoop.common.ErrorCode;
import org.apache.sqoop.common.MapContext;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.core.Reconfigurable;
import org.apache.sqoop.core.SqoopConfiguration;
import org.apache.sqoop.repository.Repository;
import org.apache.sqoop.repository.RepositoryError;
import org.apache.sqoop.repository.RepositoryProvider;
import org.apache.sqoop.utils.ClassUtils;

public class RepositoryManager
implements Reconfigurable {
    private static final Logger LOG = Logger.getLogger(RepositoryManager.class);
    private static RepositoryManager instance = new RepositoryManager();
    private RepositoryProvider provider;

    public static RepositoryManager getInstance() {
        return instance;
    }

    public static void setInstance(RepositoryManager newInstance) {
        instance = newInstance;
    }

    public synchronized void initialize() {
        this.initialize(SqoopConfiguration.getInstance().getContext().getBoolean("org.apache.sqoop.repository.schema.immutable", true));
    }

    public synchronized void initialize(boolean immutableRepository) {
        Class repoProviderClass;
        MapContext context = SqoopConfiguration.getInstance().getContext();
        Map repoSysProps = context.getNestedProperties("org.apache.sqoop.repository.sysprop.");
        LOG.info((Object)("Setting system properties: " + repoSysProps));
        for (Map.Entry entry : repoSysProps.entrySet()) {
            System.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        String repoProviderClassName = context.getString("org.apache.sqoop.repository.provider");
        if (repoProviderClassName == null || repoProviderClassName.trim().length() == 0) {
            throw new SqoopException((ErrorCode)RepositoryError.REPO_0001, "org.apache.sqoop.repository.provider");
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Repository provider: " + repoProviderClassName));
        }
        if ((repoProviderClass = ClassUtils.loadClass((String)repoProviderClassName)) == null) {
            throw new SqoopException((ErrorCode)RepositoryError.REPO_0001, repoProviderClassName);
        }
        try {
            this.provider = (RepositoryProvider)repoProviderClass.newInstance();
        }
        catch (Exception ex) {
            throw new SqoopException((ErrorCode)RepositoryError.REPO_0001, repoProviderClassName, (Throwable)ex);
        }
        this.provider.initialize(context);
        if (!immutableRepository) {
            LOG.info((Object)"Creating or updating respository at bootup");
            this.provider.getRepository().createOrUpgradeRepository();
        }
        if (!this.provider.getRepository().isRepositorySuitableForUse()) {
            throw new SqoopException((ErrorCode)RepositoryError.REPO_0002);
        }
        SqoopConfiguration.getInstance().getProvider().registerListener(new SqoopConfiguration.CoreConfigurationListener(this));
        LOG.info((Object)"Repository Manager initialized: OK");
    }

    public synchronized void destroy() {
        try {
            this.provider.destroy();
        }
        catch (Exception ex) {
            LOG.error((Object)"Failed to shutdown repository provider", (Throwable)ex);
        }
    }

    public synchronized Repository getRepository() {
        return this.provider.getRepository();
    }

    @Override
    public synchronized void configurationChanged() {
        LOG.info((Object)"Begin repository manager reconfiguring");
        MapContext newContext = SqoopConfiguration.getInstance().getContext();
        MapContext oldContext = SqoopConfiguration.getInstance().getOldContext();
        String newProviderClassName = newContext.getString("org.apache.sqoop.repository.provider");
        if (newProviderClassName == null || newProviderClassName.trim().length() == 0) {
            throw new SqoopException((ErrorCode)RepositoryError.REPO_0001, "org.apache.sqoop.repository.provider");
        }
        String oldProviderClassName = oldContext.getString("org.apache.sqoop.repository.provider");
        if (!newProviderClassName.equals(oldProviderClassName)) {
            LOG.warn((Object)"Repository provider cannot be replaced at the runtime. You might need to restart the server.");
        }
        this.provider.configurationChanged();
        LOG.info((Object)"Repository manager reconfigured.");
    }
}

