/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.repository;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.sqoop.common.Direction;
import org.apache.sqoop.common.ErrorCode;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.connector.ConnectorManager;
import org.apache.sqoop.connector.spi.ConnectorConfigurableUpgrader;
import org.apache.sqoop.connector.spi.SqoopConnector;
import org.apache.sqoop.driver.Driver;
import org.apache.sqoop.driver.DriverUpgrader;
import org.apache.sqoop.model.ConfigUtils;
import org.apache.sqoop.model.MConfig;
import org.apache.sqoop.model.MConfigUpdateEntityType;
import org.apache.sqoop.model.MConnector;
import org.apache.sqoop.model.MDriver;
import org.apache.sqoop.model.MDriverConfig;
import org.apache.sqoop.model.MFromConfig;
import org.apache.sqoop.model.MJob;
import org.apache.sqoop.model.MLink;
import org.apache.sqoop.model.MLinkConfig;
import org.apache.sqoop.model.MPersistableEntity;
import org.apache.sqoop.model.MSubmission;
import org.apache.sqoop.model.MToConfig;
import org.apache.sqoop.repository.RepositoryError;
import org.apache.sqoop.repository.RepositoryTransaction;
import org.apache.sqoop.validation.ConfigValidationResult;

public abstract class Repository {
    private static final Logger LOG = Logger.getLogger(Repository.class);

    public abstract RepositoryTransaction getTransaction();

    public abstract void createOrUpgradeRepository();

    public abstract boolean isRepositorySuitableForUse();

    public abstract MConnector registerConnector(MConnector var1, boolean var2);

    public abstract MDriver registerDriver(MDriver var1, boolean var2);

    public abstract MConnector findConnector(String var1);

    public abstract List<MConnector> findConnectors();

    public abstract MDriver findDriver(String var1);

    public abstract void createLink(MLink var1);

    public abstract void updateLink(MLink var1);

    public abstract void updateLink(MLink var1, RepositoryTransaction var2);

    public abstract void enableLink(long var1, boolean var3);

    public abstract void deleteLink(long var1);

    public abstract MLink findLink(long var1);

    public abstract MLink findLink(String var1);

    public abstract List<MLink> findLinksForConnector(long var1);

    public abstract List<MLink> findLinks();

    public abstract void createJob(MJob var1);

    public abstract void updateJob(MJob var1);

    public abstract void updateJob(MJob var1, RepositoryTransaction var2);

    public abstract void enableJob(long var1, boolean var3);

    public abstract void deleteJob(long var1);

    public abstract MJob findJob(long var1);

    public abstract MJob findJob(String var1);

    public abstract List<MJob> findJobs();

    public abstract List<MJob> findJobsForConnector(long var1);

    public abstract void createSubmission(MSubmission var1);

    public abstract void updateSubmission(MSubmission var1);

    public abstract void purgeSubmissions(Date var1);

    public abstract List<MSubmission> findUnfinishedSubmissions();

    public abstract List<MSubmission> findSubmissions();

    public abstract List<MSubmission> findSubmissionsForJob(long var1);

    public abstract MSubmission findLastSubmissionForJob(long var1);

    public abstract MConfig findFromJobConfig(long var1, String var3);

    public abstract MConfig findToJobConfig(long var1, String var3);

    public abstract MConfig findDriverJobConfig(long var1, String var3);

    public abstract MConfig findLinkConfig(long var1, String var3);

    public abstract void updateJobConfig(long var1, MConfig var3, MConfigUpdateEntityType var4);

    public abstract void updateJobConfig(long var1, MConfig var3, MConfigUpdateEntityType var4, RepositoryTransaction var5);

    public abstract void updateLinkConfig(long var1, MConfig var3, MConfigUpdateEntityType var4);

    public abstract void updateLinkConfig(long var1, MConfig var3, MConfigUpdateEntityType var4, RepositoryTransaction var5);

    protected abstract void upgradeConnectorAndConfigs(MConnector var1, RepositoryTransaction var2);

    protected abstract void upgradeDriverAndConfigs(MDriver var1, RepositoryTransaction var2);

    protected abstract void deleteJobInputs(long var1, RepositoryTransaction var3);

    protected abstract void deleteLinkInputs(long var1, RepositoryTransaction var3);

    private void deletelinksAndJobInputs(List<MLink> links, List<MJob> jobs, RepositoryTransaction tx) {
        for (MJob job : jobs) {
            this.deleteJobInputs(job.getPersistenceId(), tx);
        }
        for (MLink link : links) {
            this.deleteLinkInputs(link.getPersistenceId(), tx);
        }
    }

    private void deleteJobInputsOnly(List<MJob> jobs, RepositoryTransaction tx) {
        for (MJob job : jobs) {
            this.deleteJobInputs(job.getPersistenceId(), tx);
        }
    }

    public final void upgradeConnector(MConnector oldConnector, MConnector newConnector) {
        block20: {
            LOG.info((Object)("Upgrading connector: " + oldConnector.getUniqueName()));
            long connectorId = oldConnector.getPersistenceId();
            String connectorName = oldConnector.getUniqueName();
            newConnector.setPersistenceId(connectorId);
            RepositoryTransaction tx = null;
            try {
                SqoopConnector connector = ConnectorManager.getInstance().getSqoopConnector(newConnector.getUniqueName());
                boolean upgradeSuccessful = true;
                ConnectorConfigurableUpgrader upgrader = connector.getConfigurableUpgrader();
                List<MLink> existingLinksByConnector = this.findLinksForConnector(connectorId);
                List<MJob> existingJobsByConnector = this.findJobsForConnector(connectorId);
                tx = this.getTransaction();
                tx.begin();
                this.deletelinksAndJobInputs(existingLinksByConnector, existingJobsByConnector, tx);
                this.upgradeConnectorAndConfigs(newConnector, tx);
                if (existingLinksByConnector != null) {
                    for (MLink link : existingLinksByConnector) {
                        LOG.info((Object)(" Link upgrade for link:" + link.getName() + " for connector:" + connectorName));
                        List linkConfig = newConnector.getLinkConfig().clone(false).getConfigs();
                        MLinkConfig newLinkConfig = new MLinkConfig(linkConfig);
                        MLinkConfig oldLinkConfig = link.getConnectorLinkConfig();
                        upgrader.upgradeLinkConfig(oldLinkConfig, newLinkConfig);
                        MLink newlink = new MLink(link, newLinkConfig);
                        ConfigValidationResult validationResult = ConfigUtils.validateConfigs((List)newlink.getConnectorLinkConfig().getConfigs(), (Class)connector.getLinkConfigurationClass());
                        if (validationResult.getStatus().canProceed()) {
                            this.updateLink(newlink, tx);
                            continue;
                        }
                        this.logInvalidModelObject("link", (MPersistableEntity)newlink, validationResult);
                        upgradeSuccessful = false;
                        LOG.info((Object)(" LINK config upgrade FAILED for link: " + link.getName() + " for connector:" + connectorName));
                    }
                }
                LOG.info((Object)" All Link and configs for this connector processed");
                if (existingJobsByConnector != null) {
                    for (MJob job : existingJobsByConnector) {
                        ConfigValidationResult validationResult;
                        MJob newJob;
                        LOG.info((Object)(" Job upgrade for job:" + job.getName() + " for connector:" + connectorName));
                        if (newConnector.getSupportedDirections().isDirectionSupported(Direction.FROM)) {
                            List fromConfig = newConnector.getFromConfig().clone(false).getConfigs();
                            if (job.getFromConnectorId() == newConnector.getPersistenceId()) {
                                MFromConfig newFromConfig = new MFromConfig(fromConfig);
                                MFromConfig oldFromConfig = job.getFromJobConfig();
                                upgrader.upgradeFromJobConfig(oldFromConfig, newFromConfig);
                                MToConfig oldToConfig = job.getToJobConfig();
                                newJob = new MJob(job, newFromConfig, oldToConfig, job.getDriverConfig());
                                validationResult = ConfigUtils.validateConfigs((List)newJob.getFromJobConfig().getConfigs(), (Class)connector.getJobConfigurationClass(Direction.FROM));
                                if (validationResult.getStatus().canProceed()) {
                                    this.updateJob(newJob, tx);
                                } else {
                                    this.logInvalidModelObject("fromJob", (MPersistableEntity)newJob, validationResult);
                                    upgradeSuccessful = false;
                                    LOG.error((Object)(" From JOB config upgrade FAILED for job: " + job.getName() + " for connector:" + connectorName));
                                }
                            }
                        }
                        if (!newConnector.getSupportedDirections().isDirectionSupported(Direction.TO)) continue;
                        List toConfig = newConnector.getToConfig().clone(false).getConfigs();
                        if (job.getToConnectorId() != newConnector.getPersistenceId()) continue;
                        MToConfig oldToConfig = job.getToJobConfig();
                        MToConfig newToConfig = new MToConfig(toConfig);
                        upgrader.upgradeToJobConfig(oldToConfig, newToConfig);
                        MFromConfig oldFromConfig = job.getFromJobConfig();
                        newJob = new MJob(job, oldFromConfig, newToConfig, job.getDriverConfig());
                        validationResult = ConfigUtils.validateConfigs((List)newJob.getToJobConfig().getConfigs(), (Class)connector.getJobConfigurationClass(Direction.TO));
                        if (validationResult.getStatus().canProceed()) {
                            this.updateJob(newJob, tx);
                            continue;
                        }
                        this.logInvalidModelObject("toJob", (MPersistableEntity)newJob, validationResult);
                        upgradeSuccessful = false;
                        LOG.error((Object)(" TO JOB config upgrade FAILED for job: " + job.getName() + " for connector:" + connectorName));
                    }
                }
                LOG.info((Object)" All Job and configs for this connector processed");
                if (upgradeSuccessful) {
                    tx.commit();
                    break block20;
                }
                throw new SqoopException((ErrorCode)RepositoryError.JDBCREPO_0027, " for connector:" + connectorName);
            }
            catch (SqoopException ex) {
                if (tx != null) {
                    tx.rollback();
                }
                throw ex;
            }
            catch (Exception ex) {
                if (tx != null) {
                    tx.rollback();
                }
                throw new SqoopException((ErrorCode)RepositoryError.JDBCREPO_0000, (Throwable)ex);
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
                LOG.info((Object)("Connector upgrade finished for: " + connectorName));
            }
        }
    }

    public final void upgradeDriver(MDriver driver) {
        block12: {
            LOG.info((Object)"Upgrading driver");
            RepositoryTransaction tx = null;
            try {
                DriverUpgrader upgrader = Driver.getInstance().getConfigurableUpgrader();
                List<MJob> existingJobs = this.findJobs();
                boolean upgradeSuccessful = true;
                tx = this.getTransaction();
                tx.begin();
                this.deleteJobInputsOnly(existingJobs, tx);
                this.upgradeDriverAndConfigs(driver, tx);
                for (MJob job : existingJobs) {
                    MDriverConfig driverConfig = driver.getDriverConfig().clone(false);
                    MDriver newDriver = new MDriver(driverConfig, "1");
                    upgrader.upgradeJobConfig(job.getDriverConfig(), newDriver.getDriverConfig());
                    MJob newJob = new MJob(job, job.getFromJobConfig(), job.getToJobConfig(), newDriver.getDriverConfig());
                    ConfigValidationResult validationResult = ConfigUtils.validateConfigs((List)newJob.getDriverConfig().getConfigs(), (Class)Driver.getInstance().getDriverJobConfigurationClass());
                    if (validationResult.getStatus().canProceed()) {
                        this.updateJob(newJob, tx);
                        continue;
                    }
                    this.logInvalidModelObject("job", (MPersistableEntity)newJob, validationResult);
                    upgradeSuccessful = false;
                }
                if (upgradeSuccessful) {
                    tx.commit();
                    break block12;
                }
                throw new SqoopException((ErrorCode)RepositoryError.JDBCREPO_0027, " Driver");
            }
            catch (SqoopException ex) {
                if (tx != null) {
                    tx.rollback();
                }
                throw ex;
            }
            catch (Exception ex) {
                if (tx != null) {
                    tx.rollback();
                }
                throw new SqoopException((ErrorCode)RepositoryError.JDBCREPO_0000, (Throwable)ex);
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
                LOG.info((Object)"Driver upgrade finished");
            }
        }
    }

    private void logInvalidModelObject(String objectType, MPersistableEntity entity, ConfigValidationResult validation) {
        LOG.error((Object)("Upgrader created invalid " + objectType + " with id " + entity.getPersistenceId()));
        LOG.error((Object)"Validation errors:");
        for (Map.Entry entry : validation.getMessages().entrySet()) {
            LOG.error((Object)("\t" + (String)entry.getKey() + ": " + StringUtils.join((Collection)((Collection)entry.getValue()), (String)",")));
        }
    }
}

