/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.repository;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import javax.sql.DataSource;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.sqoop.common.ErrorCode;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.repository.JdbcRepositoryTransactionFactory;
import org.apache.sqoop.repository.RepositoryError;
import org.apache.sqoop.repository.RepositoryTransaction;

public class JdbcRepositoryTransaction
implements RepositoryTransaction {
    private static final Logger LOG = LogManager.getLogger(JdbcRepositoryTransaction.class);
    private final DataSource dataSource;
    private Connection connection;
    private JdbcRepositoryTransactionFactory txFactory;
    private boolean active = true;
    private int count = 0;
    private boolean rollback = false;

    protected JdbcRepositoryTransaction(DataSource dataSource, JdbcRepositoryTransactionFactory factory) {
        this.dataSource = dataSource;
        this.txFactory = factory;
    }

    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public void begin() {
        if (!this.active) {
            throw new SqoopException((ErrorCode)RepositoryError.JDBCREPO_0006);
        }
        if (this.count == 0) {
            try {
                this.connection = this.dataSource.getConnection();
            }
            catch (SQLException ex) {
                throw new SqoopException((ErrorCode)RepositoryError.JDBCREPO_0007, (Throwable)ex);
            }
            try {
                this.connection.clearWarnings();
            }
            catch (SQLException ex) {
                LOG.error((Object)("Error while clearing warnings: " + ex.getErrorCode()), (Throwable)ex);
            }
        }
        ++this.count;
        LOG.debug((Object)("Tx count-begin: " + this.count + ", rollback: " + this.rollback));
    }

    @Override
    public void commit() {
        if (!this.active) {
            throw new SqoopException((ErrorCode)RepositoryError.JDBCREPO_0006);
        }
        if (this.rollback) {
            throw new SqoopException((ErrorCode)RepositoryError.JDBCREPO_0008);
        }
        LOG.debug((Object)("Tx count-commit: " + this.count + ", rollback: " + this.rollback));
    }

    @Override
    public void rollback() {
        if (!this.active) {
            throw new SqoopException((ErrorCode)RepositoryError.JDBCREPO_0006);
        }
        LOG.warn((Object)"Marking transaction for rollback");
        this.rollback = true;
        LOG.debug((Object)("Tx count-rollback: " + this.count + ", rollback: " + this.rollback));
    }

    @Override
    public void close() {
        if (!this.active) {
            throw new SqoopException((ErrorCode)RepositoryError.JDBCREPO_0006);
        }
        --this.count;
        LOG.debug((Object)("Tx count-close: " + this.count + ", rollback: " + this.rollback));
        if (this.count == 0) {
            this.active = false;
            try {
                if (this.rollback) {
                    LOG.info((Object)"Attempting transaction roll-back");
                    this.connection.rollback();
                } else {
                    LOG.info((Object)"Attempting transaction commit");
                    this.connection.commit();
                }
            }
            catch (SQLException ex) {
                throw new SqoopException((ErrorCode)RepositoryError.JDBCREPO_0009, (Throwable)ex);
            }
            finally {
                if (this.connection != null) {
                    try {
                        SQLWarning warning;
                        if (warning != null) {
                            StringBuilder sb = new StringBuilder("Connection warnigns: ");
                            boolean first = true;
                            for (warning = this.connection.getWarnings(); warning != null; warning = warning.getNextWarning()) {
                                if (first) {
                                    first = false;
                                } else {
                                    sb.append("; ");
                                }
                                sb.append("[").append(warning.getErrorCode()).append("] ");
                                sb.append(warning.getMessage());
                            }
                            LOG.warn((Object)sb.toString());
                        }
                    }
                    catch (SQLException ex) {
                        LOG.error((Object)("Error while retrieving warnigns: " + ex.getErrorCode()), (Throwable)ex);
                    }
                    try {
                        this.connection.close();
                    }
                    catch (SQLException ex) {
                        LOG.error((Object)("Unable to close connection: " + ex.getErrorCode()), (Throwable)ex);
                    }
                }
                this.txFactory.remove();
                this.connection = null;
                this.txFactory = null;
            }
        }
    }
}

