/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.repository;

import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DriverManagerConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDataSource;
import org.apache.commons.pool.KeyedObjectPoolFactory;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericKeyedObjectPoolFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.apache.log4j.Logger;
import org.apache.sqoop.common.ErrorCode;
import org.apache.sqoop.common.MapContext;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.core.SqoopConfiguration;
import org.apache.sqoop.repository.JdbcRepository;
import org.apache.sqoop.repository.JdbcRepositoryContext;
import org.apache.sqoop.repository.JdbcRepositoryHandler;
import org.apache.sqoop.repository.JdbcRepositoryTransactionFactory;
import org.apache.sqoop.repository.Repository;
import org.apache.sqoop.repository.RepositoryError;
import org.apache.sqoop.repository.RepositoryProvider;
import org.apache.sqoop.utils.ClassUtils;

public class JdbcRepositoryProvider
implements RepositoryProvider {
    private static final Logger LOG = Logger.getLogger(JdbcRepositoryProvider.class);
    private JdbcRepositoryContext repoContext;
    private Driver driver;
    private GenericObjectPool connectionPool;
    private KeyedObjectPoolFactory statementPool;
    private DataSource dataSource;
    private JdbcRepositoryHandler handler;
    private JdbcRepositoryTransactionFactory txFactory;
    private JdbcRepository repository;

    @Override
    public synchronized void initialize(MapContext context) {
        this.repoContext = new JdbcRepositoryContext(SqoopConfiguration.getInstance().getContext());
        this.initializeRepositoryHandler();
        LOG.info((Object)"JdbcRepository initialized.");
    }

    @Override
    public synchronized void destroy() {
        try {
            this.connectionPool.close();
        }
        catch (Exception ex) {
            LOG.error((Object)"Failed to shutdown connection pool", (Throwable)ex);
        }
        this.handler.shutdown();
        if (this.driver != null) {
            try {
                LOG.info((Object)"Deregistering JDBC driver");
                DriverManager.deregisterDriver(this.driver);
            }
            catch (SQLException ex) {
                LOG.error((Object)"Failed to deregister driver", (Throwable)ex);
            }
        }
        this.handler = null;
        this.driver = null;
        this.dataSource = null;
    }

    private void initializeRepositoryHandler() {
        String jdbcHandlerClassName = this.repoContext.getHandlerClassName();
        Class handlerClass = ClassUtils.loadClass((String)jdbcHandlerClassName);
        if (handlerClass == null) {
            throw new SqoopException((ErrorCode)RepositoryError.JDBCREPO_0001, jdbcHandlerClassName);
        }
        try {
            this.handler = (JdbcRepositoryHandler)handlerClass.newInstance();
        }
        catch (Exception ex) {
            throw new SqoopException((ErrorCode)RepositoryError.JDBCREPO_0001, jdbcHandlerClassName, (Throwable)ex);
        }
        String connectUrl = this.repoContext.getConnectionUrl();
        if (connectUrl == null || connectUrl.trim().length() == 0) {
            throw new SqoopException((ErrorCode)RepositoryError.JDBCREPO_0002);
        }
        String jdbcDriverClassName = this.repoContext.getDriverClass();
        if (jdbcDriverClassName == null || jdbcDriverClassName.trim().length() == 0) {
            throw new SqoopException((ErrorCode)RepositoryError.JDBCREPO_0003);
        }
        Class driverClass = ClassUtils.loadClass((String)jdbcDriverClassName);
        if (driverClass == null) {
            throw new SqoopException((ErrorCode)RepositoryError.JDBCREPO_0003, jdbcDriverClassName);
        }
        try {
            this.driver = (Driver)driverClass.newInstance();
        }
        catch (Exception ex) {
            throw new SqoopException((ErrorCode)RepositoryError.JDBCREPO_0003, jdbcDriverClassName, (Throwable)ex);
        }
        Properties jdbcProps = this.repoContext.getConnectionProperties();
        DriverManagerConnectionFactory connFactory = new DriverManagerConnectionFactory(connectUrl, jdbcProps);
        this.connectionPool = new GenericObjectPool();
        this.connectionPool.setMaxActive(this.repoContext.getMaximumConnections());
        this.statementPool = new GenericKeyedObjectPoolFactory(null);
        new PoolableConnectionFactory((ConnectionFactory)connFactory, (ObjectPool)this.connectionPool, this.statementPool, this.handler.validationQuery(), false, false, this.repoContext.getTransactionIsolation().getCode());
        this.dataSource = new PoolingDataSource((ObjectPool)this.connectionPool);
        this.txFactory = new JdbcRepositoryTransactionFactory(this.dataSource);
        this.repoContext.initialize(this.dataSource, this.txFactory);
        this.handler.initialize(this.repoContext);
        this.repository = new JdbcRepository(this.handler, this.repoContext);
        LOG.info((Object)"JdbcRepositoryProvider initialized");
    }

    @Override
    public synchronized Repository getRepository() {
        return this.repository;
    }

    @Override
    public void configurationChanged() {
        boolean connFactoryChanged;
        String newJdbcDriverClassName;
        LOG.info((Object)"Begin JdbcRepository reconfiguring.");
        JdbcRepositoryContext oldRepoContext = this.repoContext;
        this.repoContext = new JdbcRepositoryContext(SqoopConfiguration.getInstance().getContext());
        String newJdbcHandlerClassName = this.repoContext.getHandlerClassName();
        if (newJdbcHandlerClassName == null || newJdbcHandlerClassName.trim().length() == 0) {
            throw new SqoopException((ErrorCode)RepositoryError.JDBCREPO_0001, newJdbcHandlerClassName);
        }
        String oldJdbcHandlerClassName = oldRepoContext.getHandlerClassName();
        if (!newJdbcHandlerClassName.equals(oldJdbcHandlerClassName)) {
            LOG.warn((Object)"Repository JDBC handler cannot be replaced at the runtime. You might need to restart the server.");
        }
        if ((newJdbcDriverClassName = this.repoContext.getDriverClass()) == null || newJdbcDriverClassName.trim().length() == 0) {
            throw new SqoopException((ErrorCode)RepositoryError.JDBCREPO_0003, newJdbcDriverClassName);
        }
        String oldJdbcDriverClassName = oldRepoContext.getDriverClass();
        if (!newJdbcDriverClassName.equals(oldJdbcDriverClassName)) {
            LOG.warn((Object)"Repository JDBC driver cannot be replaced at the runtime. You might need to restart the server.");
        }
        this.connectionPool.setMaxActive(this.repoContext.getMaximumConnections());
        String connectUrl = this.repoContext.getConnectionUrl();
        String oldurl = oldRepoContext.getConnectionUrl();
        if (connectUrl != null && !connectUrl.equals(oldurl)) {
            LOG.warn((Object)"Repository URL cannot be replaced at the runtime. You might need to restart the server.");
        }
        if (!(connFactoryChanged = false)) {
            Properties oldProp = oldRepoContext.getConnectionProperties();
            Properties newProp = this.repoContext.getConnectionProperties();
            if (newProp.size() != oldProp.size()) {
                connFactoryChanged = true;
            } else {
                for (Object key : newProp.keySet()) {
                    if (newProp.getProperty((String)key).equals(oldProp.getProperty((String)key))) continue;
                    connFactoryChanged = true;
                    break;
                }
            }
        }
        if (!connFactoryChanged) {
            String oldTxOption = oldRepoContext.getTransactionIsolation().toString();
            String newTxOption = this.repoContext.getTransactionIsolation().toString();
            if (!newTxOption.equals(oldTxOption)) {
                connFactoryChanged = true;
            }
        }
        if (connFactoryChanged) {
            try {
                LOG.info((Object)"Reconfiguring Connection Factory.");
                Properties jdbcProps = this.repoContext.getConnectionProperties();
                DriverManagerConnectionFactory connFactory = new DriverManagerConnectionFactory(connectUrl, jdbcProps);
                new PoolableConnectionFactory((ConnectionFactory)connFactory, (ObjectPool)this.connectionPool, this.statementPool, this.handler.validationQuery(), false, false, this.repoContext.getTransactionIsolation().getCode());
            }
            catch (IllegalStateException ex) {
                LOG.warn((Object)"Repository connection cannot be reconfigured currently. You might need to restart the server.");
            }
        }
        LOG.info((Object)"JdbcRepository reconfigured.");
    }
}

