/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.repository;

import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.apache.sqoop.common.ErrorCode;
import org.apache.sqoop.common.MapContext;
import org.apache.sqoop.common.SqoopException;
import org.apache.sqoop.repository.JdbcRepositoryTransactionFactory;
import org.apache.sqoop.repository.JdbcTransactionIsolation;
import org.apache.sqoop.repository.RepositoryError;

public final class JdbcRepositoryContext {
    private static final Logger LOG = Logger.getLogger(JdbcRepositoryContext.class);
    private final MapContext context;
    private final String handlerClassName;
    private final String connectionUrl;
    private final String driverClassName;
    private final Properties connectionProperties;
    private final JdbcTransactionIsolation transactionIsolation;
    private final int maxConnections;
    private DataSource dataSource;
    private JdbcRepositoryTransactionFactory txFactory;

    public JdbcRepositoryContext(MapContext context) {
        String txIsolation;
        Object oldPassword;
        Object oldUser;
        this.context = context;
        this.handlerClassName = context.getString("org.apache.sqoop.repository.jdbc.handler");
        if (this.handlerClassName == null || this.handlerClassName.trim().length() == 0) {
            throw new SqoopException((ErrorCode)RepositoryError.JDBCREPO_0001, "org.apache.sqoop.repository.jdbc.handler");
        }
        this.connectionUrl = context.getString("org.apache.sqoop.repository.jdbc.url");
        this.driverClassName = context.getString("org.apache.sqoop.repository.jdbc.driver");
        String jdbcUserName = context.getString("org.apache.sqoop.repository.jdbc.user");
        String jdbcPassword = context.getString("org.apache.sqoop.repository.jdbc.password");
        this.connectionProperties = new Properties();
        Map params = context.getNestedProperties("org.apache.sqoop.repository.jdbc.properties.");
        for (Map.Entry entry : params.entrySet()) {
            this.connectionProperties.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        if (jdbcUserName != null && (oldUser = this.connectionProperties.put("user", jdbcUserName)) != null) {
            LOG.warn((Object)("Overriding user (" + oldUser + ") with explicitly specified user (" + jdbcUserName + ")"));
        }
        if (jdbcPassword != null && (oldPassword = this.connectionProperties.put("password", jdbcPassword)) != null) {
            LOG.warn((Object)"Overriding password from jdbc connection properties with explicitly specified password.");
        }
        if ((txIsolation = context.getString("org.apache.sqoop.repository.jdbc.transaction.isolation")) == null || txIsolation.trim().length() == 0) {
            throw new SqoopException((ErrorCode)RepositoryError.JDBCREPO_0004);
        }
        try {
            this.transactionIsolation = JdbcTransactionIsolation.getByName(txIsolation);
        }
        catch (IllegalArgumentException ex) {
            throw new SqoopException((ErrorCode)RepositoryError.JDBCREPO_0004, txIsolation, (Throwable)ex);
        }
        String maxConnStr = context.getString("org.apache.sqoop.repository.jdbc.maximum.connections");
        if (maxConnStr == null || maxConnStr.trim().length() == 0) {
            throw new SqoopException((ErrorCode)RepositoryError.JDBCREPO_0005, "org.apache.sqoop.repository.jdbc.maximum.connections");
        }
        int maxConnInt = 0;
        try {
            maxConnInt = Integer.parseInt(maxConnStr);
        }
        catch (NumberFormatException ex) {
            throw new SqoopException((ErrorCode)RepositoryError.JDBCREPO_0005, maxConnStr, (Throwable)ex);
        }
        if (maxConnInt <= 0) {
            throw new SqoopException((ErrorCode)RepositoryError.JDBCREPO_0005, maxConnStr);
        }
        this.maxConnections = maxConnInt;
        if (LOG.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder("[repo-ctx] ");
            sb.append("handler=").append(this.handlerClassName).append(", ");
            sb.append("conn-url=").append(this.connectionUrl).append(", ");
            sb.append("driver=").append(this.driverClassName).append(", ");
            sb.append("user=").append(jdbcUserName).append(", ");
            sb.append("password=").append("*****").append(", ");
            sb.append("jdbc-props={");
            boolean first = true;
            for (Map.Entry entry : params.entrySet()) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append((String)entry.getKey()).append("=");
                if (((String)entry.getKey()).equalsIgnoreCase("password")) {
                    sb.append("*****");
                    continue;
                }
                sb.append((String)entry.getValue());
            }
            sb.append("}").append(", ");
            sb.append("tx-isolation=").append((Object)this.transactionIsolation).append(", ");
            sb.append("max-conn=").append(this.maxConnections);
            LOG.info((Object)sb.toString());
        }
    }

    void initialize(DataSource source, JdbcRepositoryTransactionFactory factory) {
        if (this.dataSource != null || this.txFactory != null) {
            throw new SqoopException((ErrorCode)RepositoryError.JDBCREPO_0011);
        }
        this.dataSource = source;
        this.txFactory = factory;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public JdbcRepositoryTransactionFactory getTransactionFactory() {
        return this.txFactory;
    }

    public String getHandlerClassName() {
        return this.handlerClassName;
    }

    public String getConnectionUrl() {
        return this.connectionUrl;
    }

    public String getDriverClass() {
        return this.driverClassName;
    }

    public JdbcTransactionIsolation getTransactionIsolation() {
        return this.transactionIsolation;
    }

    public int getMaximumConnections() {
        return this.maxConnections;
    }

    public Properties getConnectionProperties() {
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.connectionProperties);
        return props;
    }

    public MapContext getContext() {
        return this.context;
    }
}

